      SUBROUTINE  do4flat(first,last)
c
c...MultiCPU Flatten For 4 Grabs
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            np = ncols*nrows
      LOGICAL*1
     *            r1(NP), r2(NP), r3(NP), r4(NP)
      REAL
     *            f(NP), b(NP), d(NP), dn
      INTEGER
     *            first, last, i
      EQUIVALENCE
     *            (r1(1),raw1(1,1)), (r2(1),raw2(1,1)),
     *            (r3(1),raw3(1,1)), (r4(1),raw4(1,1)),
     *            (f(1),flat(1,1)), (b(1),bias(1,1)),
     *            (d(1),data(1,1))
c
c...Processing Depends On FLATMODE
c
  100 IF (flatmode.gt.0) THEN
        DO i=first,last
          dn = ZEXT(r1(i)) + ZEXT(r2(i)) + ZEXT(r3(i)) + ZEXT(r4(i))
          d(i) = 0.25*dn
        ENDDO
      ELSEIF (flatmode.eq.0) THEN
        DO i=first,last
          dn = ZEXT(r1(i)) + ZEXT(r2(i)) + ZEXT(r3(i)) + ZEXT(r4(i))
          d(i) = 255.0 - f(i)*(dn-b(i))
        ENDDO
      ELSE
        DO i=first,last
          dn = ZEXT(r1(i)) + ZEXT(r2(i)) + ZEXT(r3(i)) + ZEXT(r4(i))
          d(i) = 255.0 - 0.25*dn
        ENDDO
      ENDIF
      RETURN
      END
