      SUBROUTINE  dzapply(nn)
c
c...Apply DeltaZ -> Scale Correction For This Frame
c
      INCLUDE
     *            '../global.inc'
      INTEGER
     *            i, i1, i2, j, nn
      DOUBLE PRECISION
     *            x, y, z, dv(10), xc(10), yc(10), xhat, yhat
c
c...Sanity Checking
c
  100 IF (dzdoit.eq.0) RETURN
      IF ((nn.lt.1).or.(nn.gt.nframe)) RETURN
      IF ((ndzcoef.le.0).or.(ndzxy.le.0)) RETURN
      i1 = frnsfrst(nn)
      i2 = frnslast(nn)
      IF ((i1.le.0).or.(i2.le.0).or.(i2.lt.i1)) RETURN
c
c...Compute Coefficients For This Value Of ZetaCur
c
      dv(1) = 1.0D00
      DO i=2,ndzxy
        dv(i) = dv(i-1)*zetacur
      ENDDO
      DO j=1,ndzcoef
        xc(j) = 0.0D00
        yc(j) = 0.0D00
        DO i=1,ndzxy
          xc(j) = xc(j) + dzxcoef(i,j)*dv(i)
          yc(j) = yc(j) + dzycoef(i,j)*dv(i)
        ENDDO
      ENDDO
c
c...Apply
c
      DO i=i1,i2
        x = xstar(i)
        y = ystar(i)
        xhat = 0.0D00
        yhat = 0.0D00
        dv( 1) = 1.0D00
        dv( 2) = x
        dv( 3) = y
        DO j=1,ndzcoef
          xhat = xhat + xc(j)*dv(j)
          yhat = yhat + yc(j)*dv(j)
        ENDDO
        xstar(i) = xhat
        ystar(i) = yhat
      ENDDO
      RETURN
      END
