      SUBROUTINE  framedump(c)
c
c...Dump Current Frame Data to disk file
c   Modified 3/18/93 AAH
c   Modified 4/19/93 DGM -- added a0,l0,t0 to ends of AAH's lines
c   Modified 9/8/93 DGM -- added exptick
c   Modified 16-Aug-93 DGM added FRC0
c   Modified 04-Oct-93 DGM added FRD0
c   Modified 18-Dec-93 DGM converts SCAPPLY integers to reals
c   Modified 24-Dec-93 DGM made X/Y storage so that FRAMEDUMP does
c		not interfere with ADUMPALL and BDUMPALL
c
      INCLUDE
     *            '../global.inc'
      CHARACTER*(*)
     *            c
      INTEGER
     *            i, nnam, i1, i2
      CHARACTER*64
     *            nam
      REAL
     *            avesky, x, y, xtmp(NSTMAX), ytmp(NSTMAX), m, s
      EQUIVALENCE
     *            (partmp(1,1),xtmp(1)), (partmp(1,2),ytmp(1))
c
 9005 FORMAT (i8, 4f10.2, 10i10)
c
c...The Sequencer Can Call This Routine With An Illegal Frame Number.
c	Just Ignore Such Calls
c
  100 IF (nframe.le.0) RETURN
      i1 = frnsfrst(nframe)
      i2 = frnslast(nframe)
      DO i=i1,i2
        xtmp(i) = xstar(i)
        ytmp(i) = ystar(i)
      ENDDO
      CALL apply(nframe)
c
c...Generate File Name And Open It
c
      CALL framename(c,nnam,nam)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=nam(1:nnam),
     *      status='unknown',
     *      unit=1
     *     )
      CALL x_fortwrite('Writing '//nam(1:nnam))
      WRITE (1,9001) nframe,frnsfrst(nframe),frnslast(nframe),
     *               frt0(nframe)
9001  FORMAT (' nframe= ',i8,' first_star#= ',i8,' last_star#= ',i8,
     *        ' t= ', f15.6)
      WRITE (1,9002) frdn1(nframe),frdn2(nframe),ialternate,parmagnify,
     *               frd0(nframe)
9002  FORMAT (' thresh= ',i8,' sat= ',i8,' ialternate= ',i8,
     *    ' parmagnify= ',i8, ' ND=', f4.2)
      WRITE (1,9003) frx0(nframe),fry0(nframe),frz0(nframe),
     *               fra0(nframe),frl0(nframe)
9003  FORMAT (' x0= ',f10.5,' y0= ',f10.5,' z0= ',f10.5,' a0= ',f10.5,
     *        ' l0= ',f10.5)
      avesky=0.0
      DO i=frnsfrst(nframe),frnslast(nframe)
        s = 0.1*MOD(iast(i)/10000,10000) - 100.0
        avesky = avesky+s
      ENDDO
      avesky=avesky/(frnslast(nframe)-frnsfrst(nframe)+1)
      WRITE (1,9004) wholeww,wholewp,parsigma,avesky,frexp(nframe),
     *               frc0(nframe)
9004  FORMAT (' fwhm= ',f10.2,' peak= ',f10.2,' sigma= ',f10.2,
     *  ' avesky= ',f10.4, ' e=', i3, ' c=', f4.1)
      DO i=i1,i2
        IF (scdoit.eq.0) THEN
          x = xstar(i)
          y = ystar(i)
        ELSE
          x = 0.01*ixst(i)
          y = 0.01*iyst(i)
        ENDIF
        m = 0.01*MOD(idst(i),10000)
        s = 0.1*MOD(iast(i)/10000,10000) - 100.0
        WRITE (1,9005) i,x,y,m,s,
     *  iast(i),ibst(i),icst(i),idst(i),iest(i),itst(i),
     *  ia1st(i),ie1st(i),it1st(i),imst(i)
      ENDDO
      CLOSE (1)
      DO i=i1,i2
        xstar(i) = xtmp(i)
        ystar(i) = ytmp(i)
      ENDDO
c
c...Sanity Checking.  If Frame Or Star Number Is Too Big, Reset It
c
c	(Not a good idea, but this routine is used for debugging dumps)
c
      IF (nstar.ge.(NSTMAX-5000)) THEN
        nstar = 0
      ENDIF
      IF (nframe.ge.NFRMAX) THEN
        nframe = 0
      ENDIF
      RETURN
c
  200 CALL x_fortwrite('Cannot Open '//nam(1:nnam))
      RETURN
      END
