      SUBROUTINE  marg(istar,numap,kill)
c
c...Default Astrometry Driver:  2-D Fermi Dirac
c	WARNING.  Leaves many things packed as integers.
c
c	Location	Low	-->	High		Where (MARGxxxxx)
c	-------------------------------------------------------
c
c	IAST		Amp	Sky	M00,M10,M01 Signs	PACK+MOMENT
c	IBST		Sigma	R0	M20,M11,M02 Signs	PACK+MOMENT
c	ICST		M00		GoodFit			GRAD
c	IDST		Mag			M9		MOMENT
c	IEST		(+x+y)	(-x+y)	(-x-y)	(+x-y) Signs	GRAD
c	IMST		Lump	MR+1	MR-1			MOMENT+EXTRA
c	ISST		Cluster Id And Depth			(FIND)
c	ITST		NinFit			NSat		COUNT
c	IXST		X					(SCAPPLY)
c	IYST		Y					(SCAPPLY)
c	IA1ST		Gradient	M10	M01		MOMENT
c	IE1ST		M20	M11	M02			MOMENT
c	IT1ST		Frame	CCD-X	CCD-Y			PACK
c
c	WARNING!  TOOBIG+NAPODIZE must not require more entries than
c			fit into NPLIMIT.  Current settings of 25+3
c			need 2561.  Current NPLIMIT==4000 will contain
c			(TOOBIG+NAPODIZE) < 36.
c
      INCLUDE
     *            '../global.inc'
      INTEGER
     *            istar, numap(*), kill, np, ni, xc, yc, x1, y1,
     *            x2, y2, rad, rsqr, i, x, xx, y, yy, tsave, npw
      REAL
     *            param(NFIT+2), px(NPLIMIT), py(NPLIMIT),
     *            pz(NPLIMIT), x0, y0, rr, psave(NFIT+2), fact,
     *            pr(NPLIMIT), pw(NPLIMIT)
c
c...Sanity Check And Different Fit For HUGE Stars
c
  100 IF (xstar(istar).eq.TAG) THEN
        RETURN
      ENDIF
      tsave = itst(istar)
      IF (numap(7).ge.toobig) THEN
        CALL marghuge(istar,numap,param,np,px,py,pz,pr)
c
c...Fit Reasonable Stars
c
      ELSE
        x0 = numap(1)
        y0 = numap(2)
        rr = numap(7)**2
c
c...First Guess Then Iterate
c
        CALL margguess(istar,numap,param,kill,np,px,py,pz,pw,npw)
        IF (kill.ne.0) GO TO 200
        DO i=1,NFIT
          psave(i) = param(i)
        ENDDO
        CALL margiter(param,kill,np,px,py,pz,pr,ni)
        IF (kill.lt.0) GO TO 200
c
c...Is The Star Too Big For Its Raster?
c
        IF (ni.ge.((9*np)/10)) THEN
          fact = NPLIMIT/np
          fact = MIN(1.4,SQRT(fact))
          numap(7) = fact*numap(7)
          rr = numap(7)**2
          DO i=1,NFIT
            param(i) = psave(i)
          ENDDO
          xc = numap(1)
          yc = numap(2)
          rad = numap(7)
          rsqr = rad*rad
          x1 = MAX(TRUEFC,xc-rad)
          x2 = MIN(TRUELC,xc+rad)
          y1 = MAX(TRUEFR,yc-rad)
          y2 = MIN(TRUELR,yc+rad)
          np = 0
          DO y=y1,y2
            yy = (y-yc)**2
            DO x=x1,x2
              xx = (x-xc)**2
              IF ((xx+yy).le.rsqr) THEN
                np = np+1
                px(np) = x
                py(np) = y
                pz(np) = data(x,y)
                IF (np.ge.NPLIMIT) GO TO 110
              ENDIF
            ENDDO
          ENDDO
  110     CALL margiter(param,kill,np,px,py,pz,pr,ni)
          IF (kill.lt.0) GO TO 200
        ENDIF
c
c...Final Test.  Did It Wander Too Far?
c
        IF (((param(1)-x0)**2 + (param(2)-y0)**2).ge.rr) THEN
          kill = 2
          GO TO 200
        ENDIF
      ENDIF
c
c...Must Be OK.  Compute Other Things Given Residuals, Etc.
c
      CALL margpack(istar,param)
      CALL margcount(istar,np,px,py,pz,pr)
      CALL marggrad(istar,param,np,px,py,pz,pr)
      CALL margmoment(istar,npw,px,py,pz,pr,pw)
      CALL margextra(istar,numap)
      isst(istar) = tsave
      IF (IAND(ialternate,SAVE_RESIDS).ne.0) THEN
        CALL margcurf(istar,np,px,py,pz)
      ENDIF
      kill = 0
      RETURN
c
c...Common Kill.  TAG is done by MULTIPROC
c
  200 CONTINUE
      RETURN
      END
