      SUBROUTINE  marggrad(istar,param,np,px,py,pz,pr)
c
c...Compute Maximum Image Gradient
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            drmax = 64,
     *            sigabove = 1.0
      INTEGER
     *            istar, np, i, high, low, dx, dy, m1, m2, p1, p2
      REAL
     *            param(*), px(*), py(*), pz(*), pr(*), x0, y0,
     *            pdiag(-DRMAX:DRMAX), mdiag(-DRMAX:DRMAX),
     *            xmpeak, xppeak, peak, test
c
c...Initialization
c
  100 x0 = param(1)
      y0 = param(2)
      DO i=-DRMAX,DRMAX
        pdiag(i) = TAG
        mdiag(i) = TAG
      ENDDO
c
c...Look For +/- Diagonal Pixels To Avoid Spikes
c
      DO i=1,np
        IF (pr(i).ne.TAG) THEN
          dx = 0.5 + px(i) - x0
          dy = 0.5 + py(i) - y0
          IF (dx.eq.dy) THEN
            IF (ABS(dx).le.DRMAX) THEN
              pdiag(dx) = pz(i)
            ENDIF
          ENDIF
          IF (dx.eq.(-dy)) THEN
            IF (ABS(dx).le.DRMAX) THEN
              mdiag(dx) = pz(i)
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Find The Peak From Adjacent Pixels
c
c	TESTING.  Seems That (-x) Gradient Is Shallower.
c
      xmpeak = 0.0
      DO i=-DRMAX,0
        IF ((pdiag(i).ne.TAG).and.(pdiag(i+1).ne.TAG)) THEN
          xmpeak = MAX(xmpeak,ABS(pdiag(i+1)-pdiag(i)))
        ENDIF
        IF ((mdiag(i).ne.TAG).and.(mdiag(i+1).ne.TAG)) THEN
          xmpeak = MAX(xmpeak,ABS(mdiag(i+1)-mdiag(i)))
        ENDIF
      ENDDO
      xppeak = 0.0
      DO i=0,DRMAX-1
        IF ((pdiag(i).ne.TAG).and.(pdiag(i+1).ne.TAG)) THEN
          xppeak = MAX(xppeak,ABS(pdiag(i+1)-pdiag(i)))
        ENDIF
        IF ((mdiag(i).ne.TAG).and.(mdiag(i+1).ne.TAG)) THEN
          xppeak = MAX(xppeak,ABS(mdiag(i+1)-mdiag(i)))
        ENDIF
      ENDDO
c
c...Select The Shallower One
c
      IF (xmpeak.gt.0) THEN
        peak = MIN(xmpeak,xppeak)
      ELSE
        peak = xppeak
      ENDIF
c
c...Pack This And Goodness Of Fit
c
      low = MAX(0.0,MIN(999.0,peak))
      ia1st(istar) = low
      high = 10.0*MAX(0.0,MIN(999.9,param(NFIT+2)))
      icst(istar) = 10000*high
c
c...As Long As We Have These Arrays, Look For Image Diameter
c
c	Test Is Fraction Sky
c
      test = sstar(istar) + SIGABOVE*wholeww
      IF  ((pdiag(0).eq.TAG).or.(mdiag(0).eq.TAG)
     * .or.(pdiag(0).lt.test).or.(mdiag(0).lt.test)) THEN
        p1 = -1
        p2 =  0
        m1 = -1
        m2 =  0
      ELSE
        DO p1=-1,-DRMAX,-1
          IF ((pdiag(p1).eq.TAG).or.(pdiag(p1).le.test)) GO TO 110
        ENDDO
        p1 = -DRMAX
  110   DO p2=1,DRMAX
          IF ((pdiag(p2).eq.TAG).or.(pdiag(p2).le.test)) GO TO 120
        ENDDO
        p2 = DRMAX
  120   DO m1=-1,-DRMAX,-1
          IF ((mdiag(m1).eq.TAG).or.(mdiag(m1).le.test)) GO TO 130
        ENDDO
        m1 = -DRMAX
  130   DO m2=1,DRMAX
          IF ((mdiag(m2).eq.TAG).or.(mdiag(m2).le.test)) GO TO 140
        ENDDO
        m2 = DRMAX
  140   CONTINUE
      ENDIF
c
c...Pack Radii Instead Of Diameters
c
      iest(istar) = 1000000*MAX(0,MIN(99, m2))
     *            +   10000*MAX(0,MIN(99,-p1))
     *            +     100*MAX(0,MIN(99,-m1))
     *            +         MAX(0,MIN(99, p2))
      RETURN
      END
