      SUBROUTINE  margiter(elemt,kill,np,px,py,pz,pr,ni)
c
c...Bevington's CURFIT
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            npmax = 3,
     *            itmax = 3,
     *            fraction = 0.250,
     *            nbfit = 5
      REAL
     *            chnew, chold, elnew(NFIT), array(NFIT,NFIT),
     *            alold(NFIT,NFIT), alnew(NFIT,NFIT), beold(NFIT),
     *            benew(NFIT), sgnew(NFIT), flamd, elold(NFIT),
     *            elemt(*), px(*), py(*), pz(*), pr(*),
     *            x0, y0, r0, sg, sk, rf, p, q, smin, smax, st, oldsky
      INTEGER
     *            iter, kill, j, k, npoor, miss, np, ni
c
c...Initialization
c
  100 iter = 0
      DO j=1,NFIT
        elnew(j) = elemt(j)
      ENDDO
      oldsky = elemt(6)
      flamd = 1.0
      CALL margdcalc(iter,elnew,alnew,benew,chnew,kill,np,px,py,pz,pr)
      npoor = 0
      IF (kill.ne.0) GO TO 210
c
c...Iteration Entry Point.  Save In Case Things Get Worse
c
  110 iter = iter+1
      chold = chnew
      DO j=1,NBFIT
        beold(j) = benew(j)
        elold(j) = elnew(j)
        DO k=1,NBFIT
          alold(j,k) = alnew(j,k)
        ENDDO
      ENDDO
c
c...Compute New Enhanced Matrix Elements, And Invert Matrix
c
      DO j=1,NBFIT
        DO k=1,NBFIT
          array(j,k) = alnew(j,k)/SQRT(alnew(j,j)*alnew(k,k))
        ENDDO
        array(j,j) = 1.0+flamd
      ENDDO
      CALL matinv46(NBFIT,array,miss)
      IF (miss.ne.0) THEN
        kill = -19
        GO TO 210
      ENDIF
c
c...Compute New Elements.  Impose Sanity On Fitting Parameters.
c
      DO j=1,NBFIT
        DO k=1,NBFIT
          elnew(j) = elnew(j)
     *             + benew(k)*array(j,k)/SQRT(alnew(j,j)*alnew(k,k))
        ENDDO
      ENDDO
      elnew(3) = MAX(0.1,elnew(3))
      elnew(4) = MAX(1.0,elnew(4))
      elnew(5) = MAX(0.0,elnew(5))
c
c...Get Current Chi-Squared And Next Set Of Arrays
c
      CALL margdcalc(iter,elnew,alnew,benew,chnew,kill,np,px,py,pz,pr)
      IF (iter.ge.ITMAX) GO TO 200
c
c...Process If Things Got Worse
c
      IF ((kill.ne.0).or.(chnew.gt.chold)) THEN
        chnew = chold
        DO j=1,NBFIT
          benew(j) = beold(j)
          elnew(j) = elold(j)
          DO k=1,NBFIT
            alnew(j,k) = alold(j,k)
          ENDDO
        ENDDO
        npoor = npoor+1
        IF (npoor.gt.NPMAX) THEN
          IF (flamd.lt.1.0) THEN
            GO TO 200
          ELSE
            kill = -12
            GO TO 210
          ENDIF
        ENDIF
        IF (flamd.lt.1.0) THEN
          flamd = 3.0*flamd
        ELSE
          flamd = 8.0*flamd
        ENDIF
        GO TO 110
      ENDIF
c
c...Things Must Have Gotten Better
c
      flamd = 0.1*flamd
      GO TO 110
c
c...All Done.  Also Pass Back Extra Information
c
  200 DO j=1,NBFIT
        elemt(j) = elnew(j)
      ENDDO
      elemt(NFIT+2) = chnew
c
c...Playing With Flux
c
      x0 = elemt(1)
      y0 = elemt(2)
      sg = elemt(3)
      r0 = elemt(5)
      smin = nomsky - wholeww/2.0
      smax = nomsky + wholeww/2.0
      sk = MAX(smin,MIN(smax,elemt(6)))
      st = sk+wholeww/2.0
      rf = r0 + sg*sg*LOG(1.0/FRACTION - 1.0)
      p = 0.0
      ni = 0
      DO j=1,np
        IF (((px(j)-x0)**2 + (py(j)-y0)**2).le.rf) THEN
          p = p + (pz(j)-oldsky)
          ni = ni+1
        ENDIF
      ENDDO
      elemt(NFIT+1) = p
      IF (flamd.lt.1.0) THEN
        kill = 0
      ELSE
        kill = 1
      ENDIF
      RETURN
c
c...Handle Errors
c
  210 kill = kill - 100*iter
      RETURN
      END
