      SUBROUTINE  margmoment(istar,np,px,py,pz,pr,pw)
c
c...Traditional Moment Analysis Of Image
c
      INCLUDE
     *            '../global.inc'
      INTEGER
     *            istar, np, i, low, high, iwrk(6), mid,
     *            ix, iy,  sign1, sign2, sign3
      REAL
     *            px(*), py(*), pz(*), pr(*), x0, y0, sk, m9, mm,
     *            sw, sx, sy, sxx, sxy, syy, x, y, w, z, wrk(6),
     *            sp, sm, r, pw(*)
c
c...Compute Image Moments
c
  100 x0 = xstar(istar)
      y0 = ystar(istar)
      mm = mstar(istar)
      sk = sstar(istar)
      sw = 0.0
      sx = 0.0
      sy = 0.0
      sxx = 0.0
      sxy = 0.0
      syy = 0.0
      sp = 0.0
      sm = 0.0
      DO i=1,np
        x = px(i)-x0
        y = py(i)-y0
        w = (pz(i)-sk)*pw(i)
        sx = sx + w*x
        sy = sy + w*y
        sw = sw + w
        sxx = sxx + w*x*x
        sxy = sxy + w*x*y
        syy = syy + w*y*y
        r = SQRT(x*x + y*y)
        sp = sp + w*r
        sm = sm + w/(r+1.0)
      ENDDO
c
c...Pack M00,M10,M01
c
      sign1 = 0
      IF (sw.ge.1.0) THEN
        z = LOG10(sw)
      ELSEIF (sw.le.-1.0) THEN
        sign1 = sign1+1
        z = LOG10(-sw)
      ELSE
        z = 0.0
      ENDIF
      low = MAX(0.0,MIN(9999.0,1000.0*z+0.5))
      IF (sx.ge.1.0) THEN
        z = LOG10(sx)
      ELSEIF (sx.le.-1.0) THEN
        sign1 = sign1+2
        z = LOG10(-sx)
      ELSE
        z = 0.0
      ENDIF
      mid = MAX(0.0,MIN(999.0,100.0*z+0.5))
      IF (sy.ge.1.0) THEN
        z = LOG10(sy)
      ELSEIF (sy.le.-1.0) THEN
        sign1 = sign1+4
        z = LOG10(-sy)
      ELSE
        z = 0.0
      ENDIF
      high = MAX(0.0,MIN(999.0,100.0*z+0.5))
      ia1st(istar) = ia1st(istar) + 1000000*high + 1000*mid
      icst(istar) = icst(istar) + low
c
c...Pack M20,M11,M02
c
      sign2 = 0
      IF (sxx.ge.1.0) THEN
        z = LOG10(sxx)
      ELSEIF (sxx.le.-1.0) THEN
        sign2 = sign2+1
        z = LOG10(-sxx)
      ELSE
        z = 0.0
      ENDIF
      low = MAX(0.0,MIN(999.0,100.0*z+0.5))
      IF (sxy.ge.1.0) THEN
        z = LOG10(sxy)
      ELSEIF (sxy.le.-1.0) THEN
        sign2 = sign2+2
        z = LOG10(-sxy)
      ELSE
        z = 0.0
      ENDIF
      mid = MAX(0.0,MIN(999.0,100.0*z+0.5))
      IF (syy.ge.1.0) THEN
        z = LOG10(syy)
      ELSEIF (syy.le.-1.0) THEN
        sign2 = sign2+4
        z = LOG10(-syy)
      ELSE
        z = 0.0
      ENDIF
      high = MAX(0.0,MIN(999.0,100.0*z+0.5))
      ie1st(istar) = 1000000*high + 1000*mid + low
c
c...Pack MRP, MRM.  Lowest part of IMST filled by EXTRA.
c
      sign3 = 0
      IF (sp.ge.1.0) THEN
        z = LOG10(sp)
      ELSEIF (sp.le.-1.0) THEN
        sign3 = sign3+1
        z = LOG10(-sp)
      ELSE
        z = 0.0
      ENDIF
      mid = MAX(0.0,MIN(999.0,100.0*z+0.5))
      IF (sm.ge.1.0) THEN
        z = LOG10(sm)
      ELSEIF (sm.le.-1.0) THEN
        sign3 = sign3+2
        z = LOG10(-sm)
      ELSE
        z = 0.0
      ENDIF
      high = MAX(0.0,MIN(999.0,100.0*z+0.5))
      imst(istar) = 1000*mid + 1000000*high
c
c...Compute M9 and MM
c
      m9 = 0.0
      ix = xstar(istar)+0.5
      iy = ystar(istar)+0.5
      m9 = data(ix-1,iy-1) + data(ix  ,iy-1) + data(ix+1,iy-1)
     *   + data(ix-1,iy  ) + data(ix  ,iy  ) + data(ix+1,iy  )
     *   + data(ix-1,iy+1) + data(ix  ,iy+1) + data(ix+1,iy+1)
     *   - 9.0*sstar(istar)
c
c...Pack Magnitudes
c
      IF (mm.ge.1.0) THEN
        z = magoffset + magslope*LOG10(mm)
      ELSEIF (mm.le.-1.0) THEN
        z = magoffset + magslope*LOG10(-mm) + 50.0
      ELSE
        z = 50.0
      ENDIF
      low = MAX(0.0,MIN(9999.0,100.0*z+0.5))
      IF (m9.ge.1.0) THEN
        z = magoffset + magslope*LOG10(m9)
      ELSEIF (m9.le.-1.0) THEN
        z = magoffset + magslope*LOG10(-m9) + 50.0
      ELSE
        z = 50.0
      ENDIF
      high = MAX(0.0,MIN(9999.0,100.0*z+0.5))
      idst(istar) = 10000*high + low
c
c...Prepend Moment SIGN Information On Fit Parameters
c
      iast(istar) = iast(istar) + 100000000*sign1
      ibst(istar) = ibst(istar) + 100000000*sign2
      iest(istar) = iest(istar) + 100000000*sign3
      RETURN
      END
