      SUBROUTINE  proccenscan(istar,numap,kill)
c
c...Examine Image To Get Extent In Various Directions.
c
c  In All Cases, Saturated Pixels Are Ignored.
c
c  Kill The Star If It Touches The Edge
c
c	OUTPUT:  NUMAP(*)
c
c  Impose A Minimum Aperture Size CENMINAP
c
      INCLUDE
     *            '../global.inc'
      INTEGER
     *            istar, numap(*), kill, r, rmax, ixc, iyc, rmin, rr(8),
     *            rsum, rbar
      REAL
     *            j, jsat, jsky
c
c...Initialization
c
  100 jsky = sstar(istar) + SIG_MULT*wholeww
      jsat = frdn2(nframe)
      ixc = xstar(istar)
      iyc = ystar(istar)
      DO r=1,8
        rr(r) = 0
      ENDDO
c
c...+DX,DY=0
c
      rmax = truelc-ixc
      DO r=1,rmax-1
        j = data(ixc+r,iyc  )
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc+r+1,iyc    ))) GO TO 110
        ENDIF
      ENDDO
      GO TO 200
  110 rr(1) = r
c
c...+DX,+DY
c
      rmax = MIN(truelc-ixc,truelr-iyc)
      DO r=1,rmax-1
        j = data(ixc+r,iyc+r)
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc+r+1,iyc+r+1))) GO TO 120
        ENDIF
      ENDDO
      GO TO 200
  120 rr(2) = r*1.414 + 0.5
c
c...DX=0,+DY
c
      rmax = truelr-iyc
      DO r=1,rmax-1
        j = data(ixc  ,iyc+r)
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc    ,iyc+r+1))) GO TO 130
        ENDIF
      ENDDO
      GO TO 200
  130 rr(3) = r
c
c...-DX,+DY
c
      rmax = MIN(ixc-truefc,truelr-iyc)
      DO r=1,rmax-1
        j = data(ixc-r,iyc+r)
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc-r-1,iyc+r+1))) GO TO 140
        ENDIF
      ENDDO
      GO TO 200
  140 rr(4) = r*1.414 + 0.5
c
c...-DX,DY=0
c
      rmax = ixc-truefc
      DO r=1,rmax-1
        j = data(ixc-r,iyc  )
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc-r-1,iyc     ))) GO TO 150
        ENDIF
      ENDDO
      GO TO 200
  150 rr(5) = r
c
c...-DX,-DY
c
      rmax = MIN(ixc-truefc,iyc-truefr)
      DO r=1,rmax-1
        j = data(ixc-r,iyc-r)
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc-r-1,iyc-r-1))) GO TO 160
        ENDIF
      ENDDO
      GO TO 200
  160 rr(6) = r*1.414 + 0.5
c
c...DX=0,-DY
c
      rmax = iyc-truefr
      DO r=1,rmax-1
        j = data(ixc  ,iyc-r)
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc    ,iyc-r-1))) GO TO 170
        ENDIF
      ENDDO
      GO TO 200
  170 rr(7) = r
c
c...+DX,-DY
c
      rmax = MIN(truelc-ixc,iyc-truefr)
      DO r=1,rmax-1
        j = data(ixc+r,iyc-r)
        IF (j.lt.jsat) THEN
          IF ((j.lt.jsky).or.(j.lt.data(ixc+r+1,iyc-r-1))) GO TO 180
        ENDIF
      ENDDO
      GO TO 200
  180 rr(8) = r*1.414 + 0.5
c
c...Any RR==0 Means Star Was Too Close To The Edge
c
      DO r=1,8
        IF (rr(r).le.0) GO TO 200
      ENDDO
c
c...Like The Olympics.  Reject Max/Min and average the rest
c
      rmin = rr(1)
      rmax = rr(1)
      rsum = rr(1)
      DO r=2,8
        rmin = MIN(rmin,rr(r))
        rmax = MAX(rmax,rr(r))
        rsum = rsum + rr(r)
      ENDDO
      rbar = ((rsum+3) - (rmax+rmin))/6
c
c...Impose Sanity Limits
c
      IF (rbar.le.1) GO TO 200
      rbar = MAX(rbar,cenminap)
c
c...Fill NUMAP
c
      numap(1) = ixc
      numap(2) = iyc
      numap(3) = rr(1)
      numap(4) = rr(3)
      numap(5) = rr(5)
      numap(6) = rr(7)
      numap(7) = rbar
      numap(9) = rr(2)
      numap(10) = rr(4)
      numap(11) = rr(6)
      numap(12) = rr(8)
      kill = 0
      RETURN
c
c...Too Close To Edge
c
  200 kill = 1
      RETURN
      END
