      SUBROUTINE  proccent0(istar)
c
c...Gets 0th Order Center...Even In Saturated Images
c
c	Called After FIND But Before PROC
c
c
c  SATURATED:
c
c	Do moment analysis on saturated area.
c
c  UNSATURATED:
c
c	Center is that pixel brighter than all neighbors
c
      INCLUDE
     *            '../global.inc'
      INTEGER
     *            istar, n, nlimit,
     *            ix, iy, ix1, ix2, iy1, iy2,
     *            ixc, iyc, jxc, jyc, r, xp, yp, xm, ym
      REAL
     *            jsat, j
      REAL
     *            x, y, z, zold
c
c...Preliminary Stuff
c
  100 ixc = xstar(istar) + 0.5
      iyc = ystar(istar) + 0.5
      IF ((ixc.le.truefc).or.(iyc.ge.truelc)) GO TO 200
      IF ((iyc.le.truefr).or.(iyc.ge.truelr)) GO TO 200
      jsat = frdn2(nframe)
      nlimit = 1.5*SQRT(mstar(istar)) + 0.5
c
c...Processing Depends On Saturation Of Center Pixel
c
      DO n=1,nlimit
  110   j = data(ixc,iyc)
        IF (j.ge.jsat) GO TO 120
c
c	*** Unsaturated Centering Code ***
c
c...Is This Pixel Brighter Than All Its Neighbors?  If So, Record.
c
        IF   ((data(ixc-1,iyc-1).le.j).and.(data(ixc  ,iyc-1).le.j)
     *   .and.(data(ixc+1,iyc-1).le.j).and.(data(ixc-1,iyc  ).le.j)
     *   .and.(data(ixc+1,iyc  ).le.j).and.(data(ixc-1,iyc+1).le.j)
     *   .and.(data(ixc  ,iyc+1).le.j).and.(data(ixc+1,iyc+1).le.j))
     *   GO TO 170
c
c...Look For Brightest Neighbor And Move Center Or Record
c
        ix1 = ixc - 1
        ix2 = ixc + 1
        iy1 = iyc - 1
        iy2 = iyc + 1
        IF ((ix1.lt.truefc).or.(ix2.gt.truelc)) GO TO 200
        IF ((iy1.lt.truefr).or.(iy2.gt.truelr)) GO TO 200
        jxc = ixc
        jyc = iyc
        DO iy=iy1,iy2
          DO ix=ix1,ix2
            IF (data(ix,iy).gt.j) THEN
              jxc = ix
              jyc = iy
              j = data(ix,iy)
            ENDIF
          ENDDO
        ENDDO
        IF ((ixc.eq.jxc).and.(iyc.eq.jyc)) THEN
          GO TO 170
        ELSE
          ixc = jxc
          iyc = jyc
          GO TO 110
        ENDIF
      ENDDO
      GO TO 170
c
c	*** Saturated Centering Code ***
c
c...Get Mean Of X and Y Given Current Center.  Old Version Blows Up For
c	Large, Saturated Regions
c
c...Iteration May Help A Bit
c
c...Modified to work on diagonals to avoid diffraction spikes
c
  120 DO n=1,2
        DO r=1,nlimit
          ix1 = ixc+r
          iy1 = iyc+r
          IF ((ix1.gt.truelc).or.(iy1.gt.truelr)) GO TO 200
          IF (data(ix1,iy1).lt.jsat) GO TO 130
        ENDDO
  130   DO r=1,nlimit
          ix2 = ixc-r
          iy2 = iyc-r
          IF ((ix2.lt.truefc).or.(iy2.lt.truefr)) GO TO 200
          IF (data(ix2,iy2).lt.jsat) GO TO 140
        ENDDO
  140   xp = (ix1+ix2+1)/2
        yp = (iy1+iy2+1)/2
        DO r=1,nlimit
          ix1 = ixc+r
          iy1 = iyc-r
          IF ((ix1.gt.truelc).or.(iy1.lt.truefr)) GO TO 200
          IF (data(ix1,iy1).lt.jsat) GO TO 150
        ENDDO
  150   DO r=1,nlimit
          ix2 = ixc-r
          iy2 = iyc+r
          IF ((ix2.lt.truefc).or.(iy2.gt.truelr)) GO TO 200
          IF (data(ix2,iy2).lt.jsat) GO TO 160
        ENDDO
  160   xm = (ix1+ix2+1)/2
        ym = (iy1+iy2+1)/2
        ixc = ((xm+xp) + (ym-yp) + 1)/2
        iyc = ((ym+yp) + (xm-xp) + 1)/2
      ENDDO
c
c...Update Center From Either Centering Scheme
c
  170 xstar(istar) = ixc
      ystar(istar) = iyc
      RETURN
c
c...Kill Stars That Touch Edge
c
  200 xstar(istar) = TAG
      ystar(istar) = TAG
      RETURN
      END
