      SUBROUTINE  procdoap(istar,numap,kill)
c
c...Given The Guessed Image Size, Compute Parameters Inside This
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            eps=0.0001
      INTEGER
     *            istar, isky, ixc, iyc, i, idn, kill, ix, iy, nap,
     *            numap(*)
      REAL
     *            dn, dd
      REAL
     *            sky, s0, s2, s3, s4, s5, s6, xx, yy, r,
     *            d20, d02, d11, t1, t2, a, b
c
c...Process Huge Objects Separately
c
  100 IF (numap(7).gt.naplim) THEN
        kill = 1
        RETURN
      ENDIF
c
c...Compute The Image Moments
c
      sky = sstar(istar)
      isky = sky + 0.5
      s0 = 0.0
      s2 = 0.0
      s3 = 0.0
      s4 = 0.0
      s5 = 0.0
      s6 = 0.0
      ixc = numap(1)
      iyc = numap(2)
      nap = listapr(numap(7))
c
c...Loop Over All Pixels In LISTAP And Compute Moments
c
      DO i=1,nap
        xx = listapx(i)
        yy = listapy(i)
        dn = data(ixc+listapx(i), iyc+listapy(i))
        r = dn-sky
        s0 = s0 + r
        s2 = s2 + r*xx
        s4 = s4 + r*xx*xx
        s5 = s5 + r*xx*yy
        s3 = s3 + r*yy
        s6 = s6 + r*yy*yy
      ENDDO
      IF (s0.eq.0) THEN
        s0 = EPS
      ENDIF
      xx  = s2/s0
      yy  = s3/s0
      d20 = s4/s0 - xx*xx
      d02 = s6/s0 - yy*yy
      d11 = s5/s0 - xx*yy
      t1 = 2.0*(d20+d02)
      t2 = 2.0*SQRT((d20-d02)**2 + 4.0*d11*d11)
      a = SQRT(t1 + t2)
      b = SQRT(t1 - t2)
c
c...Tally The Various Quantities
c
      astar(istar) = a
      bstar(istar) = s0/REAL(nap)
      IF (a.eq.0.0) THEN
        estar(istar) = 0.0
      ELSE
        estar(istar) = 1.0 - b/a
      ENDIF
      mstar(istar) = s0
      IF (d11.eq.0.0) THEN
        tstar(istar) = 0.0
      ELSE
        tstar(istar) = 0.5*ATAN2(d11+d11,d20-d02)
      ENDIF
      xstar(istar) = REAL(ixc) + xx
      ystar(istar) = REAL(iyc) + yy
c
c...Do The Image Gradient Parameter
c
      dd = 0
      DO iy=iyc-1,iyc+1
        DO ix=ixc-numap(7),ixc+numap(7)
          dd = MAX(dd, ABS(data(ix+1,iy)-data(ix,iy)))
        ENDDO
      ENDDO
      dstar(istar) = dd
c
c...Kill The Star If It Is Now On The Edge
c
      i = numap(7)
      ix = xstar(istar) + 0.5
      IF ((ix.le.(truefc+i)).or.(ix.ge.(truelc-i))) THEN
        xstar(istar) = tag
        kill = 1
        RETURN
      ENDIF
      iy = ystar(istar) + 0.5
      IF ((iy.le.(truefr+i)).or.(iy.ge.(truelr-i))) THEN
        xstar(istar) = tag
        kill = 1
        RETURN
      ENDIF
      numap(1) = ix
      numap(2) = iy
      kill = 0
      RETURN
      END
