      SUBROUTINE  procphot(istar,numap)
c
c...Radial Profile Examination For Better Sky And Magnitude
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            nextra = 7,
     *            iapmin = 6
      INTEGER
     *            istar, nrad(ncols), ixc, iyc, rmax, ir, i, i1,
     *            i2, ip, isum, numap(*)
      REAL
     *            brad(ncols), sky, bsat, x, dsky, bmax, rsum, r,
     *            ssum
c
 9001 FORMAT (' Too Big For PHOT...Was ', i6, '   Is Now ', i6)
c
c...Pass Arguments And Determine Radius To Be Examined
c
  100 ixc = numap(1)
      iyc = numap(2)
      rmax = MIN(ixc-truefc,
     *            truelc-ixc,
     *            iyc-truefr,
     *            truelr-iyc,
     *            numap(7) + nextra,
     *            naplim
     *           )
      DO ir=1,rmax
        nrad(ir) = 0
        brad(ir) = 0.0
      ENDDO
      sky = sstar(istar)
      bsat = frdn2(nframe) - sky
c
c...Collect Normalized Radial Profile (Signal Per Pixel)
c
      DO ir=1,rmax
        x = 0.0
        IF (ir.eq.1) THEN
          i1 = 1
        ELSE
          i1 = listapr(ir-1) + 1
        ENDIF
        i2 = listapr(ir)
        DO i=i1,i2
          x = x + data(ixc+listapx(i),iyc+listapy(i))
        ENDDO
        nrad(ir) = i2+1-i1
        brad(ir) = x/REAL(nrad(ir)) - sky
c
c...The Extent Of The Image Can Be Determined In A Variety Of Ways:
c
c...TEST Of First Inflection Point
c        IF  ((brad(ip-1).ge.brad(ip))
c     *  .and.(brad(ip+1).ge.brad(ip))) GO TO 110
c
c...TEST Of Upturn
c        IF  (brad(ip+1).ge.brad(ip)) GO TO 110
c
c...TEST Of Uniform Decrease
c        d1 = brad(ip  )-brad(ip-1)
c        d2 = brad(ip+1)-brad(ip  )
c        IF ((d2.lt.d1).or.(d2.ge.0.0)) GO TO 110
c
c...Once The Decision Is Made, Get Sky At Edge Of Aperture And Remove
c	It From Each Of The Radial Bins
c
c...WARNING -- Later On RMAX Must Be >= 3
c
c...WARNING -- Do Not Test If Image Is Saturated
c
        IF (ir.gt.iapmin) THEN
          ip = ir-1
          IF (brad(ip).lt.bsat) THEN
            IF  (brad(ip+1).ge.brad(ip)) GO TO 110
          ENDIF
        ENDIF
      ENDDO
c
c...Radial Profile Is Now Complete Out To (IP+1).  Loop is terminated
c	early if logic triggers.  Now remove residual sky.
c
      ip = rmax-1
  110 rmax = ip
      dsky = 0.5*(brad(rmax) + brad(rmax+1))
      bmax = brad(1)-dsky
      DO ir=1,rmax
        IF (nrad(ir).gt.0) THEN
          brad(ir) = brad(ir)-dsky
          bmax = MAX(bmax,brad(ir))
        ENDIF
      ENDDO
c
c...ReCompute Magnitude By Integrating Outwards
c
c...SAHA's Modificaton :-
c	The idea is that full weight is given to each pixel up to ir=3
c	from thereon, each ring is averaged and weighted by (nrad/ir)
c	irrespective of how many pixels the ring contains. This is a 1/r
c	weighting scheme.
c
c	Saha also allowed to terminate early if BRAD(IR+1) falls below
c	test.  Monet has temproarily removed this because it seemed to
c	stop too early
c
c...The Inner 3 Rings Are Always Taken At Full Weight
c
c...Monet's Warning:  Due to requests by R. Green, MSTAR(ISTAR) contains
c	the weighted magnitude while CSTAR(ISTAR) contains the unweighted
c	magnitude.  If (IAND(ialternate,COUNT_SAT).ne.0) in PROC THEN GETSAT is
c	called and updated CSTAR to hold the saturated pixel count. In all
c	cases, BSTAR(ISTAR) contains the measuring radii.
c
c
  200 isum = 0
      rsum = 0.0
      DO ir=1,3
        r = brad(ir)*REAL(nrad(ir))
        isum = isum + nrad(ir)
        rsum = rsum + r
      ENDDO
      ssum = rsum
      DO ir=4,rmax
        r = brad(ir)*REAL(nrad(ir))
        ssum = ssum + r
        r = r/REAL(ir)
        isum = isum + nrad(ir)
        rsum = rsum + r
      ENDDO
  210 CONTINUE
c
c...Update The Parameters
c
c
      bstar(istar) = 1000*numap(7) + rmax
      cstar(istar) = rsum
      mstar(istar) = ssum
      sstar(istar) = sstar(istar)+dsky
      RETURN
      END
