      SUBROUTINE  procunitap(istar,numap)
c
c...Unit Weight Version Of DOAP
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            eps=0.0001
      INTEGER
     *            istar, ixc, iyc, i, idn, ix, iy, nap, numap(*)
      REAL
     *            stest
      REAL
     *            s1, s2, s3, s4, s5, s6, xx, yy,
     *            d0, d20, d02, d11, t1, t2, a, b
c
c...Compute The Image Moments
c
  100 stest = sstar(istar) + unitsig*wholeww
      s1 = eps
      s2 = 0.0
      s3 = 0.0
      s4 = 0.0
      s5 = 0.0
      s6 = 0.0
      ixc = numap(1)
      iyc = numap(2)
      nap = listapr(numap(7))
c
c...Loop Over All Pixels In LISTAP And Compute Moments
c
      DO i=1,nap
        xx = listapx(i)
        yy = listapy(i)
        IF (data(ixc+listapx(i), iyc+listapy(i)).ge.stest) THEN
          s1 = s1 + 1.0
          s2 = s2 + xx
          s4 = s4 + xx*xx
          s5 = s5 + xx*yy
          s3 = s3 + yy
          s6 = s6 + yy*yy
        ENDIF
      ENDDO
      d0  = s1
      xx  = s2/d0
      yy  = s3/d0
      d20 = s4/d0 - xx*xx
      d02 = s6/d0 - yy*yy
      d11 = s5/d0 - xx*yy
      t1 = 2.0*(d20+d02)
      t2 = 2.0*SQRT((d20-d02)**2 + 4.0*d11*d11)
      a = SQRT(t1 + t2)
      b = SQRT(t1 - t2)
c
c...Tally The Various Quantities
c
      a1star(istar) = a
      IF (a.eq.0.0) THEN
        e1star(istar) = 0.0
      ELSE
        e1star(istar) = 1.0 - b/a
      ENDIF
      IF (d11.eq.0.0) THEN
        t1star(istar) = 0.0
      ELSE
        t1star(istar) = 0.5*ATAN2(d11+d11,d20-d02)
      ENDIF
      RETURN
      END
