      SUBROUTINE  starstat(x,y,im)
c
c...Simple Image Statistics At The Specified Location
c
c	Use Same Box Size As DNDUMP To Make Debugging Easier
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            WIDE = 7,
     *            NDIM = 2*WIDE+1
      INTEGER
     *            x, y, x1, x2, y1, y2, ix, iy, iz, buf(NDIM,NDIM),
     *            jx, jy, jz
      REAL
     *            sx, sy, sn, xc, yc, wx, wy, w, sky, xl, xu, yl, yu,
     *            test, zn, zd
      BYTE
     *            im(ncols,nrows)
c
 9001 FORMAT (' Box=', i2, '   Sky=', f5.1 /
     *        ' Brightest Pixel At (', i4, ',', i4, ') Is ', i3, ' DN' /
     *        ' Moments Yield X=', f5.1, ', Y=', f5.1 /
     *        ' X-Width=', f4.1, '   Y-Width=', f4.1)
c
c...Compute Limits
c
  100 x1 = x+1 - WIDE
      x2 = x+1 + WIDE
      y1 = y+1 - WIDE
      y2 = y+1 + WIDE
      IF (x1.lt.1) THEN
        x1 = 1
        x2 = x1 + 2*WIDE
      ENDIF
      IF (y1.lt.1) THEN
        y1 = 1
        y2 = y1 + 2*WIDE
      ENDIF
      IF (x.gt.NCOLS) THEN
        x2 = NCOLS
        x1 = x2 - 2*WIDE
      ENDIF
      IF (y.gt.NROWS) THEN
        y2 = NROWS
        y1 = y2 - 2*WIDE
      ENDIF
c
c...Extract The Box To Make Life Easier
c
      DO iy=y1,y2
        DO ix=x1,x2
          IF (im(ix,iy).lt.0) THEN
            buf(ix+1-x1,iy+1-y1) = im(ix,iy) + 256
          ELSE
            buf(ix+1-x1,iy+1-y1) = im(ix,iy)
          ENDIF
        ENDDO
      ENDDO
c
c...Process Things
c
      sky = 0.0
      sn = 0.0
      DO ix=1,NDIM
        sky = sky + buf(ix,1) + buf(ix,NDIM)
        sn = sn + 2.0
      ENDDO
      DO iy=2,NDIM-1
        sky = sky + buf(1,iy) + buf(NDIM,iy)
        sn = sn + 2.0
      ENDDO
      sky = sky/sn
      sx = 0.0
      sy = 0.0
      sn = 0.0
      DO iy=1,NDIM
        DO ix=1,NDIM
          w = buf(ix,iy) - sky
          sx = sx + ix*w
          sy = sy + iy*w
          sn = sn + w
        ENDDO
      ENDDO
      IF (sn.gt.0.0) THEN
        xc = sx/sn + x1 - 1
        yc = sy/sn + y1 - 1
      ELSE
        xc = -1.0
        yc = -1.0
      ENDIF
      jx = 1
      jy = 1
      jz = buf(jx,jy)
      DO iy=1,NDIM
        DO ix=1,NDIM
          IF (buf(ix,iy).gt.jz) THEN
            jx = ix
            jy = iy
            jz = buf(ix,iy)
          ENDIF
        ENDDO
      ENDDO
      test = sky + 0.5*(jz - sky)
      DO ix=jx,2,-1
        IF (buf(ix-1,jy).le.test) THEN
          zn = test - buf(ix,jy)
          zd = buf(ix-1,jy) - buf(ix,jy)
          IF (zd.eq.0.0) THEN
            xl = ix - 0.5
          ELSE
            xl = ix - zn/zd
          ENDIF
          GO TO 110
        ENDIF
      ENDDO
      xl = 1.0
  110 DO ix=jx,NDIM-1
        IF (buf(ix+1,jy).le.test) THEN
          zn = test - buf(ix,jy)
          zd = buf(ix+1,jy) - buf(ix,jy)
          IF (zd.eq.0.0) THEN
            xu = ix + 0.5
          ELSE
            xu = ix + zn/zd
          ENDIF
          GO TO 120
        ENDIF
      ENDDO
      xu = NDIM
  120 DO iy=jy,2,-1
        IF (buf(jx,iy-1).le.test) THEN
          zn = test - buf(jx,iy)
          zd = buf(jx,iy-1) - buf(jx,iy)
          IF (zd.eq.0.0) THEN
            yl = iy - 0.5
          ELSE
            yl = iy - zn/zd
          ENDIF
          GO TO 130
        ENDIF
      ENDDO
      yl = 1.0
  130 DO iy=jy,NDIM-1
        IF (buf(jx,iy+1).le.test) THEN
          zn = test - buf(jx,iy)
          zd = buf(jx,iy+1) - buf(jx,iy)
          IF (zd.eq.0.0) THEN
            yu = iy + 0.5
          ELSE
            yu = iy + zn/zd
          ENDIF
          GO TO 140
        ENDIF
      ENDDO
      yu = NDIM
  140 wx = xu - xl
      wy = yu - yl
      jx = jx + x1 - 1
      jy = jy + y1 - 1
c
c...Print The Result
c
      WRITE (*,9001) NDIM,sky,jx,jy,jz,xc,yc,wx,wy
      RETURN
      END
