#include	<sys/types.h>
#include	<sys/wait.h>
/*
 ****************************************************************************
 *
 *   c_callsys  --  Attempt to mimic a call to system() but we cannot
 *			use system() because of some trouble assocaited
 *			with X,Motif,PFA or someting that gives rise to
 *			the famous ": is not an identifier" message.
 *
 *			NOTE:  FORTRAN removed the leading > but it is
 *			up to us to figure out how to use execlp()
 */
c_callsys_(bb)
char bb[];
{
	pid_t pid, qid;
	int stat, opt;
	char cmd[64], arg[6][64], *p[6];
	int i, n;
/*
 *   Parse Line And Prepare Argument List
 */
	n = sscanf(bb, "%s %s %s %s %s %s %s", cmd,&arg[0][0],&arg[1][0],
		&arg[2][0],&arg[3][0],&arg[4][0],&arg[5][0]);
	if (n < 1) {
		i = -1;
		x_respond_(&i);
		return(-1);
	}
	for (i=1; i<n; i++)
		p[i-1] = &arg[i-1][0];
	for (i=n; i<7; i++)
		p[i-1] = NULL;
	if ((pid=fork()) == 0) {
/*
 *   We Are In Child.  Return From EXECLP() Is Bad News
 */
		execlp(cmd,cmd,p[0],p[1],p[2],p[3],p[4],p[5],NULL);
		exit(0);
	}
/*
 *   Wa Are In Parent.  PID <= 0 Is Bad News
 */
	if (pid <= 0) {
		i = -1;
		x_respond_(&i);
		return(pid);
	}
/*
 *   Wait For Our Child To Die
 */
	i = 1;
	x_respond_(&i);
	sprintf(cmd,"Waiting For ID=%d", pid);
	x_write1_(cmd);
	opt = 0;
	qid = waitpid(pid,&stat,opt);
	sprintf(cmd,"Wait Is Over");
	x_write1_(cmd);
	i = 0;
	x_respond_(&i);
	return(1);
}
