      FUNCTION  f_autoexp(tau)
c
c...Take The First Exposure Into RAW1
c
      INCLUDE
     *          '../global.inc'
      PARAMETER
     *          nitmax = 5
      INTEGER
     *          tau, f_autoexp, C_IDTEXP, i, low, high, F_TOASTED,
     *          small, ng
      REAL
     *          r, elow, ehigh, dlow, dhigh, z
      CHARACTER*15
     *          bb
c
 9001 FORMAT ('T=',i3, '   M=',f5.1)
c
c...If TAU Is Legal, Just Do What The User Wanted
c
  100 IF ((tau.ge.1).and.(tau.le.127)) THEN
        exptick = tau
        f_autoexp = C_IDTEXP(exptick,raw1)
        CALL getbnom(nomgrab)
        WRITE (bb,9001) exptick,nomgrab
        CALL x_fortwrite(bb)
        GO TO 210
      ENDIF
c
c...Check If Total Saturation
c
      IF (F_TOASTED(z).ne.0) THEN
        WRITE (bb,9001) exptick,nomgrab
        CALL x_fortwrite(bb)
        GO TO 210
      ENDIF
      IF (z.ge.0.05) THEN
        small = 2
      ELSE
        small = 8
      ENDIF
c
c...First Guess Is Last Value
c
      f_autoexp = C_IDTEXP(exptick,raw1)
      IF (f_autoexp.ne.1) GO TO 210
      CALL getbnom(nomgrab)
      WRITE (bb,9001) exptick,nomgrab
      CALL x_fortwrite(bb)
      IF (nomgrab.lt.DN_LOW) THEN
        IF (exptick.ge.E_MAX) GO TO 210
        exptick = MIN(E_MAX,exptick+small)
      ELSEIF (nomgrab.gt.DN_HIGH) THEN
        IF (exptick.le.E_MIN) GO TO 210
        exptick = MAX(E_MIN,exptick-small)
      ELSE
        GO TO 210
      ENDIF
c
c...Second Guess Is Close To Previous
c
      f_autoexp = C_IDTEXP(exptick,raw1)
      IF (f_autoexp.ne.1) GO TO 210
      CALL getbnom(nomgrab)
      WRITE (bb,9001) exptick,nomgrab
      CALL x_fortwrite(bb)
      IF (nomgrab.lt.DN_LOW) THEN
        IF (exptick.ge.E_MAX) GO TO 210
      ELSEIF (nomgrab.gt.DN_HIGH) THEN
        IF (exptick.le.E_MIN) GO TO 210
      ELSE
        GO TO 210
      ENDIF
c
c...Try A Second Guess Based On The First
c
      IF (nomgrab.lt.DN_LOW) THEN
        elow = exptick
        dlow = nomgrab
        exptick = E_MAX
        f_autoexp = C_IDTEXP(exptick,raw1)
        IF (f_autoexp.ne.1) GO TO 210
        CALL getbnom(nomgrab)
        WRITE (bb,9001) exptick,nomgrab
        CALL x_fortwrite(bb)
        IF (nomgrab.le.DN_HIGH) GO TO 210
        ehigh = exptick
        dhigh = nomgrab
      ELSE
        ehigh = exptick
        dhigh = nomgrab
        exptick = E_MIN
        f_autoexp = C_IDTEXP(exptick,raw1)
        IF (f_autoexp.ne.1) GO TO 210
        CALL getbnom(nomgrab)
        WRITE (bb,9001) exptick,nomgrab
        CALL x_fortwrite(bb)
        IF (nomgrab.ge.DN_LOW) GO TO 210
        elow = exptick
        dlow = nomgrab
      ENDIF
c
c...Iterate A Few Times
c
      DO i=2,NITMAX
        IF (dlow.gt.dhigh) GO TO 200
        IF (dhigh.ge.250.0) THEN
          exptick = 0.5*(elow+ehigh)
        ELSEIF (dlow.le.10.0) THEN
          exptick = 0.5*(elow+ehigh)
        ELSE
          r = (DN_TARG-dlow)/(dhigh-dlow)
          exptick = elow + r*(ehigh-elow) + 0.5
        ENDIF
        IF ((exptick.le.elow).or.(exptick.ge.ehigh)) GO TO 200
        f_autoexp = C_IDTEXP(exptick,raw1)
        IF (f_autoexp.ne.1) GO TO 210
        CALL getbnom(nomgrab)
        WRITE (bb,9001) exptick,nomgrab
        CALL x_fortwrite(bb)
        IF (nomgrab.lt.DN_LOW) THEN
          elow = exptick
          dlow = nomgrab
        ELSEIF (nomgrab.gt.DN_HIGH) THEN
          ehigh = exptick
          dhigh = nomgrab
        ELSE
          GO TO 210
        ENDIF
      ENDDO
c
c...Not Much More That We Can Do
c
  200 exptick = 0.5*(elow+ehigh)
c
c...Common Exit Updated Exposure Pieces Of Frame Archive
c
  210 IF ((nframe.gt.0).and.(nframe.le.NFRMAX)) THEN
        frexp(nframe) = exptick
        ng = MAX(0.0,MIN(9999.9,10.0*nomgrab))
        frflag(nframe) = noisy
     *                 + toastflag*2
     *                 + toastfract*512
     *                 + ng*65536
      ENDIF
      RETURN
      END
