      SUBROUTINE  mgo_flat
c
c...Contour The Entire RAW Image
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            reduce = 15,
     *            nx = ((truelc-truefc)/reduce+1),
     *            ny = ((truelr-truefr)/reduce+1),
     *            redsqr = reduce*reduce,
     *            halfred = (redsqr+1)/2,
     *            xc = (truefc+truelc+1)/2,
     *            yc = (truefr+truelr+1)/2,
     *            nc = (2*reduce+1)*(2*reduce+1)
      REAL
     *            array(NX*NY), ddx, ddy, rx, ry, rr, zmin, zmax,
     *            zinc, s, sbar
      INTEGER
     *            r, c, x, y, x1, x2, y1, y2, z, buf(20), ints,
     *            smin, smax
      CHARACTER*20
     *           lb
c
 9001 FORMAT ('Step=', i3, '%   Mean=', i3)
c
c...Get Normalization From Central Area
c
  100 s = 0.0
      DO y=YC-REDUCE,YC+REDUCE
        DO x=XC-REDUCE,XC+REDUCE
          s = s + ZEXT(raw1(x,y))
        ENDDO
      ENDDO
      IF (s.le.0.0) THEN
        sbar = 128.0
      ELSE
        sbar = s/NC
      ENDIF
c
c...Examine The Image.  Saved Values Are In Percent
c
      z = 0
      DO r=TRUEFR,TRUELR,REDUCE
        y1 = r
        y2 = r + REDUCE - 1
        DO c=TRUEFC,TRUELC,REDUCE
          x1 = c
          x2 = c + REDUCE - 1
          s = 0.0
          DO y=y1,y2
            DO x=x1,x2
              s = s + ZEXT(raw1(x,y))
            ENDDO
          ENDDO
          s = 100.0*(sbar - s/REDSQR)/sbar
          ints = s + 0.5
          IF (z.eq.0) THEN
            smin = ints
            smax = ints
          ELSE
            smin = MIN(ints,smin)
            smax = MAX(ints,smax)
          ENDIF
          z = z+1
          array(z) = s
        ENDDO
      ENDDO
c
c...Adjust Dimensions To Keep Square Pixels
c
      CALL x_export(buf)
      ddx = buf(14)
      ddy = buf(15)
      rx = ddx/NX
      ry = ddy/NY
      rr = MIN(rx,ry)
c
c...Adjust DN Mapping To Have No More Than 40 Levels
c
      zmin = smin
      zmax = smax
      z = (smax-smin)/40 + 1
      zinc = z
      c = sbar + 0.5
      WRITE (lb,9001) z,c
      CALL x_fortwrite(lb)
c
c...Generate Contour Diagram
c
c	WARNING!  Number Of Contour Levels Determined In XD_CONTOUR!
c
      CALL x_erase7
      CALL xd_contour(array,nx,nx,ny, zmin,zmax,zinc, rr)
      RETURN
      END
