#include	"subs.h"
/*
 **********************************************************************
 *
 *   spinwait  -- Wait For Requested Seconds Without Interrupts
 */
spinwait_(tau)
double *tau;
{
	struct itimerval itimer, z;
	volatile int tick;

	if ((tick = 100.0*(*tau)) <= 0)
		return;
/*
 *   Set timer for 1 second longer than the user requested
 */
	getitimer(ITIMER_REAL, &itimer);
	tick += 100;
	itimer.it_value.tv_sec  = tick/100;
	itimer.it_value.tv_usec = (tick%100)*10000;
	setitimer(ITIMER_REAL, &itimer, &z);
/*
 *   Infinite loop to read the clock and exit at 1.00 second to go
 */
	for (;;) {
		getitimer(ITIMER_REAL, &itimer);
		tick = itimer.it_value.tv_sec*100
		     + itimer.it_value.tv_usec/10000;
		if (tick <= 100)
			break;
	}
/*
 *   Reset the timer to avoid the interrupt
 */
	itimer.it_value.tv_sec = 0;
	itimer.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL, &itimer, &z);
}
