      SUBROUTINE  cc_anowait(err)
c
c...Make Sure The PMM Has Stopped.  Exit With Valid Current Position
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            eps = 0.0003D00,
     *            nmax = 10,
     *            warn = 2.0
      INTEGER
     *            err, i, n, nwarn, nold
      DOUBLE PRECISION
     *            lastpos(4), d(4), dmax
      REAL
     *            t0, t
c
 9001     format (/ i6, 5f10.4 /)
c
c...Initialization
c
  100 CALL cc_anogetxyza(err)
      IF (err.ne.0) THEN
        RETURN
      ENDIF
      DO i=1,4
        lastpos(i) = curpos(i)
      ENDDO
      n = 0
      t0 = SECNDS(0.0)
      nold = 0
c
c...Keep Reading PMM Until It Apprears To Be Stopped
c
  110 CALL cc_anogetxyza(err)
      IF (err.ne.0) RETURN
      DO i=1,4
        d(i) = ABS(curpos(i)-lastpos(i))
        lastpos(i) = curpos(i)
      ENDDO
      dmax = MAX(d(1),d(2),d(3),d(4))
      IF (dmax.gt.eps) THEN
        t = SECNDS(t0)
        nwarn = t/WARN
        IF (nwarn.ne.nold) THEN
          n = n+1
          WRITE (*,9001) n,(curpos(i),i=1,4),dmax
          nold = nwarn
        ENDIF
        IF (nwarn.gt.NMAX) THEN
          GO TO 120
        ENDIF
        CALL cc_sleep(0.1)
        GO TO 110
      ENDIF
c
c...Return With No Error Even If We Have Waited Too Long
c
  120 err = 0
      RETURN
      END
