      SUBROUTINE  cc_dozfit(nn,xx,yy,fn)
c
c...Spline Interpolation Of Z As A Function Of PMMX
c
c	NOTE:  Resample And Make Table For Linear Interpolation
c
      INCLUDE
     *            'c.inc'
      INTEGER
     *            nn, idx(NFITMAX), ntbl, i, j, ic, job, ier
      CHARACTER*(*)
     *            fn
      REAL
     *            xx(*), yy(*), tmp(NFITMAX), tbl(NTBLMAX,2)
      DOUBLE PRECISION
     *            x(NFITMAX), f(NFITMAX), df(NFITMAX), y(NFITMAX),
     *            c(NFITMAX-1,3), var, se(NFITMAX),
     *            wk(7*(NFITMAX+1)), xhat, dxhat, yhat, q
c
 9001 FORMAT (/ ' Too Few Points In DOZFIT' /)
 9002 FORMAT (i2)
 9003 FORMAT (2f10.4)
 9004 FORMAT (/ ' File Open Error In DOZFIT' /)
 9005 FORMAT (/ ' DOZFIT Spline Error=', i5 /)
c
c...Data Must Be In Increasing Order With No Degeneracies
c
  100 IF (nn.le.5) THEN
        WRITE (*,9001)
        RETURN
      ENDIF
      DO i=1,nn
        idx(i) = i
      ENDDO
      CALL cc_ruqsrt(nn,xx,idx)
      CALL cc_rreord(nn,idx,yy,tmp)
      j = 1
      DO i=2,nn
        IF (xx(i).gt.xx(i-1)) THEN
          j = j+1
          xx(j) = xx(i)
          yy(j) = yy(i)
        ENDIF
      ENDDO
      nn = j
c
c...Copy To Double Precision And Do The Spline Interpolation
c
      DO i=1,nn
        x(i) = xx(i)
        f(i) = yy(i)
        df(i) = 1.0D00
      ENDDO
      ic = NFITMAX-1
      var = -1.0D00
      job = 0
      CALL cubgcv(x,f,df,nn,y,c,ic,var,job,se,wk,ier)
      IF (ier.ne.0) THEN
        WRITE (*,9005) ier
        RETURN
      ENDIF
c
c...Resample To Fill The Table
c
      ntbl = NTBLMAX
      tbl(1,1) = x(1)
      tbl(1,2) = y(1)
      tbl(ntbl,1) = x(nn)
      tbl(ntbl,2) = y(nn)
      j = 1
      dxhat = (x(nn)-x(1))/(ntbl-1)
      DO i=2,ntbl-1
        xhat = x(1) + (i-1)*dxhat
  110   IF (xhat.gt.x(j+1)) THEN
          j = j+1
          GO TO 110
        ENDIF
        q = xhat-x(j)
        yhat = y(j)+q*(c(j,1)+q*(c(j,2)+q*c(j,3)))
        tbl(i,1) = xhat
        tbl(i,2) = yhat
      ENDDO
c
c...Save The Fit
c
      fn(11:14) = 'ZTBL'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=fn,
     *      status='unknown',
     *      unit=88
     *     )
      WRITE (88,9002) ntbl
      DO i=1,ntbl
        WRITE (88,9003) tbl(i,1),tbl(i,2)
      ENDDO
      CLOSE (88)
      RETURN
c
c...Cannot Open File.  Deep DooDoo
c
  200 WRITE (*,9004)
      RETURN
      END
