      SUBROUTINE  cc_tempsense(mode,err)
c
c...Sense The Temperature Every Once In A While (MODE==0)
c	Or Right Now (MODE==1)
c
c
c	WARNING:  Logic Assumes That DAEMON Is In SYS$BUSY Producing
c		A Continuous Log.  We Only Need To Read The Thermometers
c		If Something Is Wrong.
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            interval = 30
      INTEGER
     *            err, DEV_UTTRW, nbb, i, j, k, tsave, dt,
     *            chan, t0, mode, DEV_SLEEP, hms
      BYTE
     *            bb(20)
      CHARACTER*8
     *            tb
      REAL
     *            temp, sign, xtime(6)
      DATA
     *            tsave/-100/
c
 9001 FORMAT (i2, 1x, i2, 1x, i2)
 9002 FORMAT (3i2.2, 3a)
 9003 FORMAT (6f5.1, i6, 5i4, a)
 9006 FORMAT (6(1x, f6.2, 1x, f7.4))
 9007 FORMAT (/ ' Error Reading TEMP.LAST' /)
c
c...See If Now Is A Good Time
c
  100 CALL time(tb)
      READ (tb,9001) i,j,k
      hms = k + 60*j + 3600*i
      dt = hms - tsave
      IF (mode.eq.0) THEN
        IF ((dt.ge.0).and.(dt.le.INTERVAL)) RETURN
      ENDIF
c
c...Read TEMP.LAST File If DAEMON Is Alive.  Try A Few Times In Case
c	There Is A Collision
c
      IF (uttmode.eq.0) THEN
        DO i=1,3
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          err=120,
     *          form='formatted',
     *          name='TEMP.LAST',
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=88
     *         )
          READ (88,9006,err=110) (tempval(chan),xtime(chan),chan=1,6)
          CLOSE (88)
          GO TO 130
  110     CLOSE (88)
  120     err = DEV_SLEEP(0.5)
        ENDDO
        WRITE (*,9007)
        DO chan=1,6
          tempval(chan) = 0.0
          xtime(chan) = 0.0
        ENDDO
  130   temp = tempval(2)
        hms = xtime(2)*3600.0 + 0.5
c
c...Otherwise Get Bustle Data
c
      ELSE
        nbb = 20
        err = DEV_UTTRW(nbb,bb)
        IF (err.ne.0) RETURN
        IF (nbb.ne.12) THEN
          err = -nbb
          RETURN
        ENDIF
        i = bb(7)
        IF (IAND(8,i).ne.0) THEN
          sign = 1.0
        ELSE
          sign = -1.0
        ENDIF
        i = IAND(i,3)
        j = bb(8)
        k = bb(9)
        temp = sign*(10.0*i + IAND(j,15) + 0.1*IAND(k,15))
        i = bb(10)
        chan = 1+IAND(7,ISHFT(i,-1))
        tempval(chan) = MAX(-9.9,MIN(99.9,temp))
      ENDIF
c
c...Save Things Every Now And Then
c
      IF ((dt.lt.0).or.(dt.ge.INTERVAL)) THEN
        ntmp = MIN(ntmp+1,NTMPMAX)
        CALL idate(i,j,k)
        tmpymd(ntmp) = j + 100*i
        tmphms(ntmp) = hms
        tmpval(ntmp) = MAX(-9.9,MIN(99.9,temp))
        tsave = hms
      ENDIF
      RETURN
      END
