      SUBROUTINE  daemon_plot(nn,tim,tmp)
c
c...Plot To PY
c
      INCLUDE
     *            '[.io]devices.inc'
      PARAMETER
     *            x_wide = 1.0,
     *            y_mean = 20.0,
     *            y_wide = 6.0,
     *            nper = 10
      INTEGER
     *            nn, i, j, k, ix, iy, xpat(NPER,6), ypat(NPER,6),
     *            jx, jy
      REAL
     *            tim(NN), tmp(6,NN), x_off, x_scl, y_off, y_scl, x
      DATA
     *            xpat/ 6, 3, 0,-3,-6, 0, 0, 0, 0, 0,
     *                  4, 2, 0,-2,-4, 4, 2, 0,-2,-4,
     *                 -3,-1, 1, 3, 2, 1, 0,-1,-2, 0,
     *                 -3,-1, 1, 3, 2, 1, 0,-1,-2, 0,
     *                 -2,-2,-2, 0, 0, 0, 2, 2, 2, 0,
     *                 -2,-2,-1,-1, 0, 0, 1, 1, 2, 2/
      DATA
     *            ypat/ 0, 0, 0, 0, 0,-6,-3, 0, 3, 6,
     *                  4, 2, 0,-2,-4,-4,-2, 0, 2, 4,
     *                 -3,-3,-3,-3,-1, 1, 3, 1,-1, 0,
     *                  3, 3, 3, 3, 1,-1,-3,-1, 1, 0,
     *                 -2, 0, 2,-2, 0, 2,-2, 0, 2, 0,
     *                 -4, 4,-2, 2, 0, 0,-2, 2,-4, 4/
c
c...Initialization
c
c	X:	From (now-wide) to (now) Hours
c	Y:	From (mean-wide/2) to (mean+wide/2)
c
  100 x_off = tim(nn)-X_WIDE
      x_scl = 500.0/X_WIDE
      y_off = Y_MEAN - Y_WIDE/2.0
      y_scl = 480.0/Y_WIDE
      CALL py_0clear
c
c...Loop Over Points
c
      DO j=1,nn
        x = tim(j)-x_off
        IF (x.gt.12.0) THEN
          x = x-24.0
        ENDIF
        IF ((x.ge.0.0).and.(x.le.X_WIDE)) THEN
          ix = x*x_scl
          DO i=1,6
            iy = 480.0 - (tmp(i,j)-y_off)*y_scl
            DO k=1,NPER
              jx = ix + xpat(k,i)
              jy = iy - ypat(k,i)
              jx = MAX(1,MIN(512,jx))
              jy = MAX(1,MIN(480,jy))
              py_pic0(jx,jy) = -1
            ENDDO
          ENDDO
        ENDIF
      ENDDO
c
c...Put On Temperature Axes
c
      DO i=1,5
        iy = 480.0 - i*y_scl
        DO ix=1,512,4
          py_pic0(ix,iy) = 127
        ENDDO
      ENDDO
c
c...Tick Marks Every 5 Minutes On Center Line
c
      iy = 480.0 - (Y_MEAN-y_off)*y_scl
      ix = 12.0*x_off
      x = (ix-1)/12.0
      DO i=1,14
        x = x + (5.0/60.0)
        ix = (x-x_off)*x_scl
        IF ((ix.ge.1).and.(ix.le.512)) THEN
          DO j=-3,3
            py_pic0(ix,iy+j) = -1
          ENDDO
        ENDIF
      ENDDO
      RETURN
      END
