      PROGRAM  tempmon
c
c...StandAlone Temperature Sensing
c
      IMPLICIT
     *            NONE
      INTEGER
     *            err, DEV_UTTRW, nbb, i, j, k, tnow, dt,
     *            chan, t0, trel(6), valid, DEV_UTTOPEN, DEV_UTTCLOSE
      BYTE
     *            bb(20)
      CHARACTER*12
     *            eb
      CHARACTER*8
     *            tb
      REAL
     *            temp, sign, val(6), t, tx
      DATA
     *            valid/0/
c
 9001 FORMAT (i2, 1x, i2, 1x, i2)
 9002 FORMAT (3i2.2, 3a)
 9003 FORMAT (6f5.1, i6, 5i4, a)
 9004 FORMAT (' Cannot Open UTT...Err=', z8)
 9005 FORMAT (' UTT Length Error ', i10)
 9006 FORMAT (6f5.1, 3x, a)
 9007 FORMAT (' UTTRW Error=', z8)
c
c...Open The Device
c
  100 err = DEV_UTTOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9004) err
        CALL EXIT
      ENDIF
c
c...Infinite Loop Starts With Channel Settle Wait
c
  110 tx = SECNDS(0.0)
  120 t = SECNDS(tx)
      IF (t.lt.3.5) GO TO 120
      CALL time(tb)
c
c...Read Bustle
c
      nbb = 20
      err = DEV_UTTRW(nbb,bb)
      IF (err.ne.0) THEN
        WRITE (*,9007) err
        CALL EXIT
      ENDIF
      IF (nbb.ne.12) THEN
        err = -nbb
        WRITE (*,9005) nbb
        CALL EXIT
      ENDIF
      i = bb(7)
      IF (IAND(8,i).ne.0) THEN
        sign = 1.0
      ELSE
        sign = -1.0
      ENDIF
      i = IAND(i,3)
      j = bb(8)
      k = bb(9)
      temp = sign*(10.0*i + IAND(j,15) + 0.1*IAND(k,15))
      temp = 32.0 + 1.8*temp
      i = bb(10)
      chan = 1+IAND(7,ISHFT(i,-1))
      val(chan) = MAX(-9.9,MIN(99.9,temp))
c
c...Save Things For A While
c
      IF (chan.eq.1) THEN
        t0 = tnow
        CALL idate(i,j,k)
        WRITE (eb,9002) k,i,j,tb(1:2),tb(4:5),tb(7:8)
        valid = 1
      ELSE
        trel(chan) = MIN(999,tnow-t0)
      ENDIF
      IF ((valid.ne.0).and.(chan.eq.6)) THEN
        OPEN (
     *        access='append',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name='temp.log',
     *        status='unknown',
     *        unit=88
     *       )
        WRITE (88,9003) (val(i),i=1,6),t0,(trel(i),i=2,6),eb
        CLOSE (88)
        WRITE (*,9006) (val(i),i=1,6),eb
  200   CONTINUE
      ENDIF
      GO TO 110
      END
