      SUBROUTINE  boxproc(im)
c
c...Process Box Histogram Stuff
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            fc = 71,
     *            lc = 1382,
     *            nc = (lc+1-fc),
     *            fr = 6,
     *            lr = 1033,
     *            nr = (lr+1-fr)
      PARAMETER
     *            nperx = 125,
     *            npery = 125,
     *            nx = ((nc-1)/nperx) + 1,
     *            ny = ((nr-1)/npery) + 1,
     *            nz = nx*ny,
     *            nt = nperx*npery
      BYTE
     *            im(ncols,nrows)
      REAL
     *            z, zmax, zbuf(nx), z1, z2
      INTEGER
     *            bx(nt,nz), c1(nz), c2(nz), r1(nz), r2(nz), nn(nz),
     *            mm(nz), ix, iy, iz, i1, i2, ibuf(nx)
c
 9001 FORMAT (' ', 13f6.1)
 9002 FORMAT (' Reference DN=', i3)
 9003 FORMAT (' Norm=', f5.0, '   Min%=', f6.1, '   Max%=', f6.1,
     *        '   Range=', f6.1)
c
c...Fill Limit Arrays
c
  100 DO ix=1,nx
        i1 = fc + (ix-1)*nperx + 1
        i2 = MIN(lc,fc + ix*nperx)
        DO iy=1,ny
          iz = (iy-1)*nx + ix
          c1(iz) = i1
          c2(iz) = i2
        ENDDO
      ENDDO
      DO iy=1,ny
        i1 = fr + (iy-1)*npery + 1
        i2 = MIN(lr,fr + iy*npery)
        DO ix=1,nx
          iz = (iy-1)*nx + ix
          r1(iz) = i1
          r2(iz) = i2
        ENDDO
      ENDDO
c
c...Count Of Number Of Pixels In Each Box
c
c	Silliness for BX() To Fool PFA Compiler
c
      DO iz=1,nz
        nn(iz) = (c2(iz)+1-c1(iz))*(r2(iz)+1-r1(iz))
        bx(1,iz) = 0
      ENDDO
c
c...Fill Each Box
c
C$DOACROSS LOCAL (iz)
      DO iz=1,nz
        CALL boxfill(im,c1(iz),c2(iz),r1(iz),r2(iz),bx(1,iz))
      ENDDO
c
c...Process Each Box
c
C$DOACROSS LOCAL (iz)
      DO iz=1,nz
        CALL boxmed(bx(1,iz),nn(iz),mm(iz))
      ENDDO
c
c...Normalize To Center
c
      ix = nx/2+1
      iy = ny/2+1
      iz = (iy-1)*nx + ix
      zmax = MAX(mm(iz),1)
c
c...Display Results
c
      DO iy=1,ny
        DO ix=1,nx
          iz = (iy-1)*nx + ix
          z = 100.0*(mm(iz)-zmax)/zmax
          IF ((ix.eq.1).and.(iy.eq.1)) THEN
            z1 = z
            z2 = z
          ELSE
            z1 = MIN(z1,z)
            z2 = MAX(z2,z)
          ENDIF
          zbuf(ix) = MAX(-99.0,MIN(99.0,z))
        ENDDO
        WRITE (*,9001) (zbuf(ix),ix=1,nx)
      ENDDO
      z = z2-z1
      WRITE (*,9003) zmax,z1,z2,z
      RETURN
      END
