      SUBROUTINE  psarrange(nfind,ex,ey)
c
c...Clean Detections List
c
      INCLUDE
     *            'pscale.inc'
      CHARACTER*40
     *            lb
      INTEGER
     *            i, j, old, nfind, n, dummy(NFRMAX)
      DOUBLE PRECISION
     *            sx, sxx, sy, syy, x, y
      REAL
     *            ex, ey
c
 9001 FORMAT (' Arrange Error ', 2i10)
 9002 FORMAT ('Z=', f6.3, '  EX=', f6.2, '  EY=', f6.2, '  N=', i6)
c
c...Close Ranks According To Pair Number
c
  100 n = 0
      DO i=1,nstar
        IF (sindex(i).gt.0) THEN
          n = n+1
          sindex(n) = sindex(i)
          xhat(n) = xhat(i)
          yhat(n) = yhat(i)
          aidx(n) = n
        ENDIF
      ENDDO
c
c...Sort On SINDEX Because Stars May Overlap
c
      CALL psqsrt(n,sindex,aidx)
      CALL psreord(n,aidx,xhat,stemp)
      CALL psreord(n,aidx,yhat,stemp)
c
c...Fill Arrays With Starting And Ending Star Index Values
c
      j = 0
      old = -1
      DO i=1,n
        IF (sindex(i).ne.old) THEN
          IF (j.gt.0) THEN
            last(j) = i-1
          ENDIF
          j = j+1
          frst(j) = i
          old = sindex(i)
        ENDIF
      ENDDO
      last(j) = n
c
c...Compute The Mean Transformed Positions
c
      DO i=1,nfind
        sx = 0.0
        sy = 0.0
        sxx = 0.0
        syy = 0.0
        n = last(i)+1-frst(i)
        DO j=frst(i),last(i)
          x = xhat(j)
          sx = sx + x
          sxx = sxx + x*x
          y = yhat(j)
          sy = sy + y
          syy = syy + y*y
        ENDDO
        sx = sx/n
        sxx = SQRT(sxx/n - sx*sx)
        sy = sy/n
        syy = SQRT(syy/n - sy*sy)
        xerr(i) = sxx
        yerr(i) = syy
      ENDDO
c
c...Compute Median Error
c
      DO i=1,nfind
        aidx(i) = i
      ENDDO
      CALL psqsrt(nfind,xerr,aidx)
      CALL psqsrt(nfind,yerr,aidx)
      n = (nfind+1)/2
      ex = 0.01*xerr(n)
      ey = 0.01*yerr(n)
      IF (quiet.eq.0) THEN
        WRITE (lb,9002) zetacur,ex,ey,nfind
        CALL x_fortwrite(lb)
      ENDIF
      RETURN
      END
