      SUBROUTINE  psfind(radmicron,nmin,mmin,nfind)
c
c...Look For Blobs In Transformed Coordinates
c
      INCLUDE
     *            'pscale.inc'
      INTEGER
     *            test, low, high, i, nfind, nper, xl, xh, yl, yh,
     *            rad, f, nmin, nm
      REAL
     *            dx, dy, radmicron, rsqr, mmin, m, dr
c
c...Initialization
c
  100 DO i=1,nstar
        sindex(i) = 0
      ENDDO
      nfind = 0
      low = 1
      high = 1
      rad = 100.0*radmicron + 0.5
      rsqr = rad*rad
c
c...Outer Loop Is Over Test Star.  Do Not Test Stars Already Paired.
c
      test = 0
  110 test = test+1
      IF (test.ge.nstar) GO TO 200
      IF (sindex(test).ne.0) GO TO 110
      xl = xhat(test) - rad
      xh = xhat(test) + rad
      yl = yhat(test) - rad
      yh = yhat(test) + rad
c
c...Adjust LOW Index To Point To First Valid Entry
c
  120 IF (low.le.nstar) THEN
        IF (xhat(low).lt.xl) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (xhat(low).gt.xh) GO TO 110
c
c...Adjust HIGH Index To Point To Last Valid Entry
c
      high = MAX(high,low)
  130 IF (high.lt.nstar) THEN
        IF (xhat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Do The Test And Mark Stars That Might Be OK
c
      IF (high.le.low) GO TO 110
      DO i=1,nframe
        frnbrt(i) = 0
        frbrt(i) = 0.0
      ENDDO
      nper = 0
      DO i=low,high
        IF (sindex(i).eq.0) THEN
          dx = xhat(i)-xhat(test)
          dy = yhat(i)-yhat(test)
          dr = dx*dx + dy*dy
          IF (dr.le.rsqr) THEN
            f = pid(i)
            IF (frnbrt(f).le.0) THEN
              frnbrt(f) = i
              frbrt(f) = dr
              nper = nper+1
              sindex(i) = -1
            ELSE
              IF (dr.lt.frbrt(f)) THEN
                sindex(frnbrt(f)) = 0
                frnbrt(f) = i
                frbrt(f) = dr
                sindex(i) = -1
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Or Reset If This Blob Is Big Enough
c
      IF (nper.ge.nmin) THEN
        m = 0.0
        nm = 0
        DO i=low,high
          IF (sindex(i).lt.0) THEN
            m = m + mag(i)
            nm = nm+1
          ENDIF
        ENDDO
        m = 0.01*m/MAX(nm,1)
        IF (m.le.mmin) THEN
          nfind = nfind+1
          DO i=low,high
            IF (sindex(i).lt.0) THEN
              sindex(i) = nfind
            ENDIF
          ENDDO
        ELSE
          DO i=low,high
            IF (sindex(i).lt.0) THEN
              sindex(i) = 0
            ENDIF
          ENDDO
        ENDIF
      ELSE
        DO i=low,high
          IF (sindex(i).lt.0) THEN
            sindex(i) = 0
          ENDIF
        ENDDO
      ENDIF
c
c...Branch For Next Test
c
      GO TO 110
c
c...All Done
c
  200 CONTINUE
      RETURN
      END
