      SUBROUTINE  psloop(nmin,rad,minmag, err,ztest)
c
c...Find The Best Z Given These Control Parameters
c
c	Something has changed during the upgrade from the PC/XT to the PC/AT.
c	This routine used to work with FIRST_GUESS=0.0 but now it appears
c	to need a number like -0.500.  Totally unclear, but this seems to
c	bring the scale back to where it belongs.
c
      INCLUDE
     *            'pscale.inc'
      PARAMETER
     *            first_guess = 0.200,
     *            first_step = 0.05,
     *            nmax = 10,
     *            eok = 0.8,
     *            toofar = 0.4
      INTEGER
     *            nmin, nfind, n, err
      REAL
     *            rad, minmag, step, zmid, emid, ey, zhigh, ehigh,
     *            zlow, elow, ztest, etest, numer, denom
      CHARACTER*20
     *            lb
c
 9001 FORMAT ('N=', i2, '  R=', f4.1, '  M=', f4.1)
c
c...First Position
c
  100 step = FIRST_STEP
      WRITE (lb,9001) nmin,rad,minmag
      CALL x_fortwrite(lb)
      zmid = FIRST_GUESS
      CALL psxform(zmid)
      CALL psfind(rad,nmin,minmag,nfind)
      IF (nfind.lt.PSTOOFEW) GO TO 200
      CALL psarrange(nfind,emid,ey)
c
c...Try Increasing Z
c
      zhigh = zmid+step
      CALL psxform(zhigh)
      CALL psfind(rad,nmin,minmag,nfind)
      IF (nfind.lt.PSTOOFEW) GO TO 200
      CALL psarrange(nfind,ehigh,ey)
c
c...Dit It Get Better?
c
      IF (ehigh.lt.emid) THEN
        zlow = zmid
        elow = emid
        zmid = zhigh
        emid = ehigh
        zhigh = zmid+step
        CALL psxform(zhigh)
        CALL psfind(rad,nmin,minmag,nfind)
        IF (nfind.lt.PSTOOFEW) GO TO 200
        CALL psarrange(nfind,ehigh,ey)
c
c...Or Worse?
c
      ELSE
        zlow = zmid-step
        CALL psxform(zlow)
        CALL psfind(rad,nmin,minmag,nfind)
        IF (nfind.lt.PSTOOFEW) GO TO 200
        CALL psarrange(nfind,elow,ey)
      ENDIF
c
c...Move Up Or Down Until Local Minimum Is Found
c
      n = 0
  110 n = n+1
      IF (n.gt.NMAX) GO TO 210
      IF (elow.lt.emid) THEN
        IF (ehigh.lt.emid) THEN
          GO TO 220
        ELSE
          zhigh = zmid
          ehigh = emid
          zmid = zlow
          emid = elow
          zlow = zmid-step
          CALL psxform(zlow)
          CALL psfind(rad,nmin,minmag,nfind)
          IF (nfind.lt.PSTOOFEW) GO TO 200
          CALL psarrange(nfind,elow,ey)
          GO TO 110
        ENDIF
      ELSE
        IF (ehigh.lt.emid) THEN
          zlow = zmid
          elow = emid
          zmid = zhigh
          emid = ehigh
          zhigh = zmid+step
          CALL psxform(zhigh)
          CALL psfind(rad,nmin,minmag,nfind)
          IF (nfind.lt.PSTOOFEW) GO TO 200
          CALL psarrange(nfind,ehigh,ey)
          GO TO 110
        ELSE
          CONTINUE
        ENDIF
      ENDIF
c
c...Interval Is Bracketed.  Try A Half Step Low.
c
      ztest = 0.5*(zlow+zmid)
      CALL psxform(ztest)
      CALL psfind(rad,nmin,minmag,nfind)
      IF (nfind.lt.PSTOOFEW) GO TO 200
      CALL psarrange(nfind,etest,ey)
      IF (etest.lt.emid) THEN
        zhigh = zmid
        ehigh = emid
        zmid = ztest
        emid = etest
      ELSE
        ztest = 0.5*(zmid+zhigh)
        CALL psxform(ztest)
        CALL psfind(rad,nmin,minmag,nfind)
        IF (nfind.lt.PSTOOFEW) GO TO 200
        CALL psarrange(nfind,etest,ey)
        IF (etest.lt.emid) THEN
          zlow = zmid
          elow = emid
          zmid = ztest
          emid = etest
        ENDIF
      ENDIF
c
c...Use Parabolic Interpolation To Guess The "Best" Value
c
      numer = ehigh-emid
      denom = elow + ehigh - 2.0*emid
      IF (denom.eq.0.0) THEN
        ztest = zmid
        etest = emid
      ELSE
        ztest = zhigh - (zhigh-zmid)*(numer/denom + 0.5)
        IF (ztest.le.zlow) THEN
          ztest = zlow
          etest = elow
        ELSEIF (ztest.ge.zhigh) THEN
          ztest = zhigh
          etest = ehigh
        ELSE
          CALL psxform(ztest)
          CALL psfind(rad,nmin,minmag,nfind)
          IF (nfind.lt.PSTOOFEW) GO TO 200
          CALL psarrange(nfind,etest,ey)
          IF (etest.gt.emid) THEN
            ztest = zmid
            etest = emid
          ENDIF
        ENDIF
      ENDIF
c
c...Final Sanity Checks
c
      IF (etest.gt.EOK) THEN
        err = 1
      ELSEIF (ABS(ztest-FIRST_GUESS).gt.TOOFAR) THEN
        err = 2
      ELSE
        err = 0
      ENDIF
      RETURN
c
c...Return For Too Few Points
c
  200 err = 3
      RETURN
c
c...Return For Too Many Iterations
c
  210 err = 4
      RETURN
c
c...Return For Local Maximum
c
  220 err = 5
      RETURN
      END
