#include	"xpmm.h"
#define		TIMEOUT		3
/*
 ****************************************************************************
 *
 *   x_command  --  Listen For Instructions
 */
x_command()
{
	time_t t0, t1;
	int i, j, n;
	char c;
/*
 *   Fast Exit If Nothing To Do
 */
	c = 0;
	i = read(0, &c, 1);
	if ((i!=1) || (c==0))
		return(0);
/*
 *   Control Characters Treated Separately
 */
	if (c < 32) {
		if ((c==3) || (c==25) || (c==26))
			x_fatal("EOF");
		if (c == 13) {
			i = 0;
			x_respond_(&i);
		}
		return(0);
	}
/*
 *   A Real Character
 */
	write(1,&c,1);
	command[0] = c;
	command[1] = '\0';
	n = 1;
/*
 *   Loop Until CR Or TIMEOUT
 */
	t0 = time(0);
	for (;;) {
		c = 0;
		i = read(0, &c, 1);
		if ((i!=1) || (c==0)) {
			t1 = time(0);
			if ((t1-t0) >= TIMEOUT) {
				i = -1;
				x_respond_(&i);
				command[0] = '\0';
				return(0);
			}
		} else {
			if (c >= 32) {
				write(1,&c,1);
				command[n++] = c;
				command[n] = '\0';
			} else {
				if ((c==3) || (c==25) || (c==26))
					x_fatal("EOF");
				if (c == 13)
					break;
			}
		}
	}
/*
 *   Remove FLUSH Commands Here
 */
	for (i=0; i<n; i++) {
		if (command[i] == '@') {
			j = 2;
			x_respond_(&j);
			command[0] = '\0';
			return(0);
		}
	}
/*
 *   Return The Length
 */
	return(n);
}
