#include	"xpmm.h"
/*
 *****************************************************************************
 *
 *   c_docmap0  --  Fill CMAP With Our (Monochrome) Colors
 */
x_docmap0()
{
	double o, s, v;
	int i, dn;
/*
 * Simplest Possible Monochrome Map Between DN (0-255) And Color (0-NCOL_0)
 */
	o = 0.0;
	s = 256.0/(double)ncol_0;
	for (i=0; i<ncol_0; i++) {
		v = o + s*(double)i;
		if (v > 255.0)
			dn = 255;
		else {
			if (v < 0.0)
				dn = 0;
			else
				dn = v;
		}
		cmap0[i].red = 256*dn;
		cmap0[i].green = 256*dn;
		cmap0[i].blue = 256*dn;
		cmap0[i].flags = DoRed | DoGreen | DoBlue;
	}
/*
 *   White, Red, Green, Blue Are Last 4 Locations
 */
	i = ncol_0;
	cmap0[i].red = cmap0[i].green = cmap0[i].blue = 256*255;
	cmap0[i].flags = DoRed | DoGreen | DoBlue;
	i = ncol_0+1;
	cmap0[i].red = 256*255;
	cmap0[i].green = cmap0[i].blue = 256*0;
	cmap0[i].flags = DoRed | DoGreen | DoBlue;
	i = ncol_0+2;
	cmap0[i].green = 256*255;
	cmap0[i].red = cmap0[i].blue = 256*0;
	cmap0[i].flags = DoRed | DoGreen | DoBlue;
	i = ncol_0+3;
	cmap0[i].blue = 256*255;
	cmap0[i].red = cmap0[i].green = 256*0;
	cmap0[i].flags = DoRed | DoGreen | DoBlue;
/*
 *   Store Our Color Map
 */
	XStoreColors(dp_0, cm_0, cmap0, ncol_0+4);
}
