




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(657) = -(rxt(44)*y(2) + rxt(47)*y(3) + rxt(57)*y(15) + rxt(62)*y(12) &
                      + rxt(70)*y(13) + rxt(77)*y(5) + rxt(80)*y(6) + rxt(116)*y(23) &
                      + rxt(137)*y(35) + rxt(159)*y(55) + rxt(165)*y(56) + rxt(183) &
                      *y(52) + rxt(215)*y(65))
         mat(494) = -rxt(44)*y(1)
         mat(399) = -rxt(47)*y(1)
         mat(363) = -rxt(57)*y(1)
         mat(803) = -rxt(62)*y(1)
         mat(861) = -rxt(70)*y(1)
         mat(699) = -rxt(77)*y(1)
         mat(721) = -rxt(80)*y(1)
         mat(125) = -rxt(116)*y(1)
         mat(386) = -rxt(137)*y(1)
         mat(510) = -rxt(159)*y(1)
         mat(459) = -rxt(165)*y(1)
         mat(353) = -rxt(183)*y(1)
         mat(243) = -rxt(215)*y(1)

         mat(657) = mat(657) + .100_r8*rxt(183)*y(52) + .200_r8*rxt(159)*y(55) &
                      + .200_r8*rxt(165)*y(56)
         mat(861) = mat(861) + .250_r8*rxt(127)*y(33) + .250_r8*rxt(175)*y(59)
         mat(589) = .250_r8*rxt(127)*y(13)
         mat(353) = mat(353) + .100_r8*rxt(183)*y(1)
         mat(510) = mat(510) + .200_r8*rxt(159)*y(1)
         mat(459) = mat(459) + .200_r8*rxt(165)*y(1)
         mat(565) = .250_r8*rxt(175)*y(13)

         mat(492) = -(rxt(44)*y(1) + rxt(61)*y(12) + rxt(68)*y(11) + rxt(69)*y(13) &
                      + rxt(72)*y(14) + rxt(75)*y(5) + (rxt(78) + rxt(79)) * y(6) &
                      + rxt(86)*y(7) + rxt(97)*y(20))
         mat(650) = -rxt(44)*y(2)
         mat(796) = -rxt(61)*y(2)
         mat(259) = -rxt(68)*y(2)
         mat(854) = -rxt(69)*y(2)
         mat(83) = -rxt(72)*y(2)
         mat(692) = -rxt(75)*y(2)
         mat(717) = -(rxt(78) + rxt(79)) * y(2)
         mat(617) = -rxt(86)*y(2)
         mat(874) = -rxt(97)*y(2)

         mat(362) = rxt(60)*y(13)
         mat(796) = mat(796) + 2.000_r8*rxt(64)*y(12)
         mat(854) = mat(854) + rxt(60)*y(15)

         mat(397) = -(rxt(47)*y(1) + rxt(49)*y(11) + rxt(55)*y(86))
         mat(642) = -rxt(47)*y(3)
         mat(258) = -rxt(49)*y(3)
         mat(62) = -rxt(55)*y(3)

         mat(928) = -((rxt(93) + rxt(94)) * y(12))
         mat(810) = -(rxt(93) + rxt(94)) * y(17)

         mat(664) = .500_r8*rxt(116)*y(23) + .560_r8*rxt(137)*y(35) + .300_r8*rxt(183) &
                      *y(52) + .050_r8*rxt(159)*y(55) + .200_r8*rxt(165)*y(56)
         mat(501) = rxt(97)*y(20)
         mat(706) = .220_r8*rxt(166)*y(57) + .500_r8*rxt(201)*y(63)
         mat(631) = rxt(95)*y(20) + .220_r8*rxt(168)*y(57) + rxt(154)*y(62) &
                      + .500_r8*rxt(202)*y(63)
         mat(810) = mat(810) + rxt(96)*y(20) + rxt(153)*y(62) + rxt(132)*y(74) &
                      + .350_r8*rxt(109)*y(88)
         mat(916) = .110_r8*rxt(170)*y(57) + .200_r8*rxt(204)*y(63)
         mat(883) = rxt(97)*y(2) + rxt(95)*y(7) + rxt(96)*y(12)
         mat(129) = .500_r8*rxt(116)*y(1)
         mat(596) = .220_r8*rxt(171)*y(57) + .500_r8*rxt(205)*y(63)
         mat(393) = .560_r8*rxt(137)*y(1)
         mat(358) = .300_r8*rxt(183)*y(1)
         mat(517) = .050_r8*rxt(159)*y(1)
         mat(463) = .200_r8*rxt(165)*y(1)
         mat(535) = .220_r8*rxt(166)*y(5) + .220_r8*rxt(168)*y(7) + .110_r8*rxt(170) &
                      *y(18) + .220_r8*rxt(171)*y(33)
         mat(471) = rxt(154)*y(7) + rxt(153)*y(12)
         mat(487) = .500_r8*rxt(201)*y(5) + .500_r8*rxt(202)*y(7) + .200_r8*rxt(204) &
                      *y(18) + .500_r8*rxt(205)*y(33)
         mat(264) = rxt(132)*y(12)
         mat(56) = .350_r8*rxt(109)*y(12)

         mat(256) = -(rxt(49)*y(3) + rxt(66)*y(12) + rxt(68)*y(2))
         mat(395) = -rxt(49)*y(11)
         mat(773) = -rxt(66)*y(11)
         mat(489) = -rxt(68)*y(11)

         mat(359) = rxt(59)*y(13)
         mat(833) = rxt(59)*y(15)

         mat(61) = -(rxt(55)*y(3) + rxt(73)*y(12))
         mat(394) = -rxt(55)*y(86)
         mat(741) = -rxt(73)*y(86)

         mat(34) = -(rxt(74)*y(12))
         mat(735) = -rxt(74)*y(87)

         mat(360) = -(rxt(57)*y(1) + (rxt(58) + rxt(59) + rxt(60)) * y(13))
         mat(639) = -rxt(57)*y(15)
         mat(843) = -(rxt(58) + rxt(59) + rxt(60)) * y(15)

         mat(490) = rxt(68)*y(11) + rxt(61)*y(12)
         mat(396) = rxt(49)*y(11)
         mat(917) = rxt(93)*y(12)
         mat(257) = rxt(68)*y(2) + rxt(49)*y(3) + rxt(66)*y(12)
         mat(784) = rxt(61)*y(2) + rxt(93)*y(17) + rxt(66)*y(11) + rxt(96)*y(20)
         mat(872) = rxt(96)*y(12)

         mat(700) = -(rxt(75)*y(2) + rxt(76)*y(13) + rxt(77)*y(1) + rxt(85)*y(7) &
                      + rxt(99)*y(18) + rxt(107)*y(90) + rxt(112)*y(25) + rxt(118) &
                      *y(30) + rxt(125)*y(33) + rxt(139)*y(37) + rxt(144)*y(39) &
                      + rxt(148)*y(42) + rxt(157)*y(45) + rxt(161)*y(47) + (rxt(166) &
                      + rxt(167)) * y(57) + rxt(173)*y(59) + rxt(185)*y(53) + rxt(191) &
                      *y(78) + rxt(198)*y(50) + rxt(201)*y(63) + rxt(209)*y(70) &
                      + rxt(217)*y(66))
         mat(495) = -rxt(75)*y(5)
         mat(862) = -rxt(76)*y(5)
         mat(658) = -rxt(77)*y(5)
         mat(625) = -rxt(85)*y(5)
         mat(910) = -rxt(99)*y(5)
         mat(160) = -rxt(107)*y(5)
         mat(251) = -rxt(112)*y(5)
         mat(320) = -rxt(118)*y(5)
         mat(590) = -rxt(125)*y(5)
         mat(338) = -rxt(139)*y(5)
         mat(288) = -rxt(144)*y(5)
         mat(442) = -rxt(148)*y(5)
         mat(100) = -rxt(157)*y(5)
         mat(280) = -rxt(161)*y(5)
         mat(529) = -(rxt(166) + rxt(167)) * y(5)
         mat(566) = -rxt(173)*y(5)
         mat(550) = -rxt(185)*y(5)
         mat(430) = -rxt(191)*y(5)
         mat(309) = -rxt(198)*y(5)
         mat(481) = -rxt(201)*y(5)
         mat(212) = -rxt(209)*y(5)
         mat(373) = -rxt(217)*y(5)

         mat(495) = mat(495) + rxt(78)*y(6)
         mat(722) = rxt(78)*y(2)

         mat(723) = -((rxt(78) + rxt(79)) * y(2) + rxt(80)*y(1) + rxt(81)*y(7) + rxt(83) &
                      *y(12) + rxt(89)*y(13) + rxt(126)*y(33) + rxt(179)*y(59) + rxt(213) &
                      *y(72))
         mat(496) = -(rxt(78) + rxt(79)) * y(6)
         mat(659) = -rxt(80)*y(6)
         mat(626) = -rxt(81)*y(6)
         mat(805) = -rxt(83)*y(6)
         mat(863) = -rxt(89)*y(6)
         mat(591) = -rxt(126)*y(6)
         mat(567) = -rxt(179)*y(6)
         mat(59) = -rxt(213)*y(6)

         mat(659) = mat(659) + rxt(77)*y(5)
         mat(496) = mat(496) + rxt(75)*y(5) + rxt(86)*y(7)
         mat(701) = rxt(77)*y(1) + rxt(75)*y(2) + 2.000_r8*rxt(85)*y(7) + rxt(76) &
                      *y(13) + rxt(99)*y(18) + rxt(112)*y(25) + rxt(118)*y(30) &
                      + rxt(125)*y(33) + rxt(139)*y(37) + rxt(144)*y(39) + rxt(148) &
                      *y(42) + rxt(157)*y(45) + .900_r8*rxt(198)*y(50) + rxt(161) &
                      *y(47) + .920_r8*rxt(185)*y(53) + rxt(166)*y(57) + rxt(173) &
                      *y(59) + rxt(201)*y(63) + rxt(217)*y(66) + .900_r8*rxt(209) &
                      *y(70) + 1.206_r8*rxt(191)*y(78) + rxt(107)*y(90)
         mat(723) = mat(723) + .700_r8*rxt(213)*y(72)
         mat(626) = mat(626) + rxt(86)*y(2) + 2.000_r8*rxt(85)*y(5) + rxt(87)*y(12) &
                      + rxt(88)*y(13) + rxt(186)*y(53) + rxt(168)*y(57) + rxt(174) &
                      *y(59) + rxt(202)*y(63) + rxt(216)*y(65) + 1.206_r8*rxt(192) &
                      *y(78) + rxt(196)*y(79)
         mat(132) = rxt(90)*y(12)
         mat(805) = mat(805) + rxt(87)*y(7) + rxt(90)*y(9) + rxt(155)*y(76) &
                      + .400_r8*rxt(195)*y(79)
         mat(863) = mat(863) + rxt(76)*y(5) + rxt(88)*y(7) + .206_r8*rxt(193)*y(78)
         mat(911) = rxt(99)*y(5)
         mat(252) = rxt(112)*y(5)
         mat(321) = rxt(118)*y(5)
         mat(591) = mat(591) + rxt(125)*y(5)
         mat(339) = rxt(139)*y(5)
         mat(289) = rxt(144)*y(5)
         mat(443) = rxt(148)*y(5)
         mat(101) = rxt(157)*y(5)
         mat(310) = .900_r8*rxt(198)*y(5)
         mat(281) = rxt(161)*y(5)
         mat(551) = .920_r8*rxt(185)*y(5) + rxt(186)*y(7)
         mat(530) = rxt(166)*y(5) + rxt(168)*y(7)
         mat(567) = mat(567) + rxt(173)*y(5) + rxt(174)*y(7)
         mat(482) = rxt(201)*y(5) + rxt(202)*y(7)
         mat(244) = rxt(216)*y(7)
         mat(374) = rxt(217)*y(5)
         mat(213) = .900_r8*rxt(209)*y(5)
         mat(59) = mat(59) + .700_r8*rxt(213)*y(6)
         mat(156) = rxt(155)*y(12)
         mat(431) = 1.206_r8*rxt(191)*y(5) + 1.206_r8*rxt(192)*y(7) + .206_r8*rxt(193) &
                      *y(13)
         mat(418) = rxt(196)*y(7) + .400_r8*rxt(195)*y(12)
         mat(161) = rxt(107)*y(5)

         mat(623) = -(rxt(81)*y(6) + rxt(85)*y(5) + rxt(86)*y(2) + rxt(87)*y(12) &
                      + rxt(88)*y(13) + rxt(95)*y(20) + rxt(124)*y(32) + rxt(138) &
                      *y(35) + rxt(154)*y(62) + rxt(168)*y(57) + rxt(174)*y(59) &
                      + rxt(184)*y(52) + rxt(186)*y(53) + rxt(192)*y(78) + rxt(196) &
                      *y(79) + rxt(202)*y(63) + rxt(216)*y(65) + rxt(227)*y(81))
         mat(720) = -rxt(81)*y(7)
         mat(698) = -rxt(85)*y(7)
         mat(493) = -rxt(86)*y(7)
         mat(802) = -rxt(87)*y(7)
         mat(860) = -rxt(88)*y(7)
         mat(875) = -rxt(95)*y(7)
         mat(408) = -rxt(124)*y(7)
         mat(385) = -rxt(138)*y(7)
         mat(467) = -rxt(154)*y(7)
         mat(528) = -rxt(168)*y(7)
         mat(564) = -rxt(174)*y(7)
         mat(352) = -rxt(184)*y(7)
         mat(548) = -rxt(186)*y(7)
         mat(429) = -rxt(192)*y(7)
         mat(417) = -rxt(196)*y(7)
         mat(480) = -rxt(202)*y(7)
         mat(242) = -rxt(216)*y(7)
         mat(71) = -rxt(227)*y(7)

         mat(656) = rxt(80)*y(6)
         mat(493) = mat(493) + rxt(79)*y(6)
         mat(720) = mat(720) + rxt(80)*y(1) + rxt(79)*y(2)
         mat(193) = rxt(84)*y(12)
         mat(802) = mat(802) + rxt(84)*y(8) + rxt(135)*y(75) + .500_r8*rxt(181)*y(77)
         mat(187) = rxt(135)*y(12)
         mat(225) = .500_r8*rxt(181)*y(12)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(192) = -(rxt(84)*y(12))
         mat(764) = -rxt(84)*y(8)

         mat(711) = rxt(83)*y(12)
         mat(602) = rxt(95)*y(20) + rxt(124)*y(32) + rxt(154)*y(62) + rxt(227)*y(81)
         mat(764) = mat(764) + rxt(83)*y(6)
         mat(870) = rxt(95)*y(7)
         mat(405) = rxt(124)*y(7)
         mat(464) = rxt(154)*y(7)
         mat(70) = rxt(227)*y(7)

         mat(130) = -(rxt(90)*y(12))
         mat(753) = -rxt(90)*y(9)

         mat(709) = rxt(89)*y(13)
         mat(820) = rxt(89)*y(6)


         mat(708) = rxt(81)*y(7)
         mat(599) = rxt(81)*y(6)

         mat(806) = -(rxt(61)*y(2) + rxt(62)*y(1) + rxt(63)*y(13) + (4._r8*rxt(64) &
                      + 4._r8*rxt(65)) * y(12) + rxt(66)*y(11) + rxt(67)*y(14) + rxt(73) &
                      *y(86) + rxt(74)*y(87) + rxt(83)*y(6) + rxt(84)*y(8) + rxt(87) &
                      *y(7) + rxt(90)*y(9) + (rxt(93) + rxt(94)) * y(17) + rxt(96) &
                      *y(20) + rxt(103)*y(21) + rxt(104)*y(19) + rxt(105)*y(89) &
                      + rxt(109)*y(88) + rxt(110)*y(29) + rxt(111)*y(23) + rxt(117) &
                      *y(26) + rxt(122)*y(31) + rxt(123)*y(32) + rxt(130)*y(34) &
                      + rxt(131)*y(27) + rxt(132)*y(74) + rxt(133)*y(22) + rxt(135) &
                      *y(75) + rxt(136)*y(35) + rxt(142)*y(38) + rxt(143)*y(36) &
                      + rxt(146)*y(40) + rxt(147)*y(41) + rxt(151)*y(43) + rxt(152) &
                      *y(61) + rxt(153)*y(62) + rxt(155)*y(76) + rxt(156)*y(44) &
                      + rxt(158)*y(55) + rxt(160)*y(46) + rxt(163)*y(48) + rxt(164) &
                      *y(56) + rxt(172)*y(58) + rxt(181)*y(77) + rxt(182)*y(52) &
                      + rxt(188)*y(54) + rxt(194)*y(49) + rxt(195)*y(79) + rxt(197) &
                      *y(60) + rxt(200)*y(51) + rxt(206)*y(64) + rxt(208)*y(68) &
                      + rxt(211)*y(71) + rxt(212)*y(69) + rxt(214)*y(65) + rxt(219) &
                      *y(67) + rxt(224)*y(80) + (rxt(225) + rxt(226)) * y(81) + rxt(228) &
                      *y(82))
         mat(497) = -rxt(61)*y(12)
         mat(660) = -rxt(62)*y(12)
         mat(864) = -rxt(63)*y(12)
         mat(260) = -rxt(66)*y(12)
         mat(84) = -rxt(67)*y(12)
         mat(63) = -rxt(73)*y(12)
         mat(35) = -rxt(74)*y(12)
         mat(724) = -rxt(83)*y(12)
         mat(195) = -rxt(84)*y(12)
         mat(627) = -rxt(87)*y(12)
         mat(133) = -rxt(90)*y(12)
         mat(924) = -(rxt(93) + rxt(94)) * y(12)
         mat(879) = -rxt(96)*y(12)
         mat(204) = -rxt(103)*y(12)
         mat(142) = -rxt(104)*y(12)
         mat(120) = -rxt(105)*y(12)
         mat(54) = -rxt(109)*y(12)
         mat(24) = -rxt(110)*y(12)
         mat(126) = -rxt(111)*y(12)
         mat(176) = -rxt(117)*y(12)
         mat(117) = -rxt(122)*y(12)
         mat(410) = -rxt(123)*y(12)
         mat(172) = -rxt(130)*y(12)
         mat(328) = -rxt(131)*y(12)
         mat(262) = -rxt(132)*y(12)
         mat(76) = -rxt(133)*y(12)
         mat(189) = -rxt(135)*y(12)
         mat(389) = -rxt(136)*y(12)
         mat(138) = -rxt(142)*y(12)
         mat(27) = -rxt(143)*y(12)
         mat(200) = -rxt(146)*y(12)
         mat(296) = -rxt(147)*y(12)
         mat(95) = -rxt(151)*y(12)
         mat(451) = -rxt(152)*y(12)
         mat(469) = -rxt(153)*y(12)
         mat(157) = -rxt(155)*y(12)
         mat(30) = -rxt(156)*y(12)
         mat(513) = -rxt(158)*y(12)
         mat(169) = -rxt(160)*y(12)
         mat(108) = -rxt(163)*y(12)
         mat(460) = -rxt(164)*y(12)
         mat(112) = -rxt(172)*y(12)
         mat(227) = -rxt(181)*y(12)
         mat(354) = -rxt(182)*y(12)
         mat(235) = -rxt(188)*y(12)
         mat(33) = -rxt(194)*y(12)
         mat(419) = -rxt(195)*y(12)
         mat(147) = -rxt(197)*y(12)
         mat(273) = -rxt(200)*y(12)
         mat(67) = -rxt(206)*y(12)
         mat(46) = -rxt(208)*y(12)
         mat(153) = -rxt(211)*y(12)
         mat(50) = -rxt(212)*y(12)
         mat(245) = -rxt(214)*y(12)
         mat(183) = -rxt(219)*y(12)
         mat(39) = -rxt(224)*y(12)
         mat(72) = -(rxt(225) + rxt(226)) * y(12)
         mat(21) = -rxt(228)*y(12)

         mat(660) = mat(660) + rxt(57)*y(15) + rxt(70)*y(13) + .120_r8*rxt(116)*y(23) &
                      + .330_r8*rxt(137)*y(35) + .270_r8*rxt(183)*y(52) &
                      + .080_r8*rxt(159)*y(55) + .215_r8*rxt(165)*y(56) &
                      + .700_r8*rxt(215)*y(65)
         mat(497) = mat(497) + rxt(68)*y(11) + rxt(69)*y(13) + rxt(72)*y(14) + rxt(97) &
                      *y(20)
         mat(401) = rxt(49)*y(11) + rxt(55)*y(86)
         mat(260) = mat(260) + rxt(68)*y(2) + rxt(49)*y(3)
         mat(63) = mat(63) + rxt(55)*y(3)
         mat(364) = rxt(57)*y(1) + 2.000_r8*rxt(58)*y(13)
         mat(702) = rxt(76)*y(13)
         mat(627) = mat(627) + rxt(88)*y(13)
         mat(806) = mat(806) + .300_r8*rxt(104)*y(19) + .500_r8*rxt(122)*y(31) &
                      + .500_r8*rxt(146)*y(40) + .100_r8*rxt(172)*y(58) &
                      + .650_r8*rxt(109)*y(88)
         mat(864) = mat(864) + rxt(70)*y(1) + rxt(69)*y(2) + 2.000_r8*rxt(58)*y(15) &
                      + rxt(76)*y(5) + rxt(88)*y(7)
         mat(84) = mat(84) + rxt(72)*y(2)
         mat(142) = mat(142) + .300_r8*rxt(104)*y(12)
         mat(879) = mat(879) + rxt(97)*y(2)
         mat(126) = mat(126) + .120_r8*rxt(116)*y(1)
         mat(117) = mat(117) + .500_r8*rxt(122)*y(12)
         mat(389) = mat(389) + .330_r8*rxt(137)*y(1)
         mat(200) = mat(200) + .500_r8*rxt(146)*y(12)
         mat(354) = mat(354) + .270_r8*rxt(183)*y(1)
         mat(513) = mat(513) + .080_r8*rxt(159)*y(1)
         mat(460) = mat(460) + .215_r8*rxt(165)*y(1)
         mat(112) = mat(112) + .100_r8*rxt(172)*y(12)
         mat(245) = mat(245) + .700_r8*rxt(215)*y(1)
         mat(54) = mat(54) + .650_r8*rxt(109)*y(12)

         mat(865) = -((rxt(58) + rxt(59) + rxt(60)) * y(15) + rxt(63)*y(12) + rxt(69) &
                      *y(2) + rxt(70)*y(1) + 4._r8*rxt(71)*y(13) + rxt(76)*y(5) + rxt(88) &
                      *y(7) + rxt(89)*y(6) + rxt(98)*y(20) + rxt(100)*y(18) + rxt(108) &
                      *y(90) + rxt(113)*y(25) + rxt(119)*y(30) + rxt(127)*y(33) &
                      + rxt(140)*y(37) + rxt(145)*y(39) + rxt(149)*y(42) + rxt(162) &
                      *y(47) + rxt(169)*y(57) + rxt(175)*y(59) + rxt(187)*y(53) &
                      + rxt(193)*y(78) + rxt(199)*y(50) + rxt(203)*y(63) + rxt(210) &
                      *y(70) + rxt(218)*y(66))
         mat(365) = -(rxt(58) + rxt(59) + rxt(60)) * y(13)
         mat(807) = -rxt(63)*y(13)
         mat(498) = -rxt(69)*y(13)
         mat(661) = -rxt(70)*y(13)
         mat(703) = -rxt(76)*y(13)
         mat(628) = -rxt(88)*y(13)
         mat(725) = -rxt(89)*y(13)
         mat(880) = -rxt(98)*y(13)
         mat(913) = -rxt(100)*y(13)
         mat(163) = -rxt(108)*y(13)
         mat(254) = -rxt(113)*y(13)
         mat(323) = -rxt(119)*y(13)
         mat(593) = -rxt(127)*y(13)
         mat(341) = -rxt(140)*y(13)
         mat(291) = -rxt(145)*y(13)
         mat(445) = -rxt(149)*y(13)
         mat(283) = -rxt(162)*y(13)
         mat(532) = -rxt(169)*y(13)
         mat(569) = -rxt(175)*y(13)
         mat(553) = -rxt(187)*y(13)
         mat(433) = -rxt(193)*y(13)
         mat(312) = -rxt(199)*y(13)
         mat(484) = -rxt(203)*y(13)
         mat(215) = -rxt(210)*y(13)
         mat(376) = -rxt(218)*y(13)

         mat(661) = mat(661) + rxt(62)*y(12) + .120_r8*rxt(116)*y(23) &
                      + .190_r8*rxt(137)*y(35) + .060_r8*rxt(183)*y(52) &
                      + .060_r8*rxt(159)*y(55) + .275_r8*rxt(165)*y(56) + rxt(215) &
                      *y(65)
         mat(498) = mat(498) + rxt(72)*y(14) + rxt(97)*y(20)
         mat(925) = rxt(94)*y(12)
         mat(64) = rxt(73)*y(12)
         mat(36) = rxt(74)*y(12)
         mat(703) = mat(703) + rxt(99)*y(18) + .250_r8*rxt(112)*y(25) + rxt(118)*y(30) &
                      + rxt(139)*y(37) + rxt(144)*y(39) + rxt(157)*y(45) &
                      + .900_r8*rxt(198)*y(50) + rxt(185)*y(53) + .470_r8*rxt(166) &
                      *y(57) + rxt(201)*y(63) + rxt(217)*y(66) + .900_r8*rxt(209) &
                      *y(70) + .794_r8*rxt(191)*y(78) + rxt(107)*y(90)
         mat(725) = mat(725) + .700_r8*rxt(213)*y(72)
         mat(628) = mat(628) + rxt(87)*y(12) + rxt(95)*y(20) + rxt(186)*y(53) &
                      + .470_r8*rxt(168)*y(57) + rxt(202)*y(63) + .794_r8*rxt(192) &
                      *y(78) + rxt(196)*y(79)
         mat(807) = mat(807) + rxt(62)*y(1) + rxt(94)*y(17) + rxt(73)*y(86) + rxt(74) &
                      *y(87) + rxt(87)*y(7) + rxt(67)*y(14) + rxt(103)*y(21) &
                      + rxt(133)*y(22) + rxt(131)*y(27) + .200_r8*rxt(172)*y(58) &
                      + rxt(152)*y(61) + .250_r8*rxt(208)*y(68) + rxt(132)*y(74) &
                      + .500_r8*rxt(181)*y(77) + rxt(195)*y(79) + .500_r8*rxt(226) &
                      *y(81) + .350_r8*rxt(109)*y(88) + rxt(105)*y(89)
         mat(865) = mat(865) + .794_r8*rxt(193)*y(78)
         mat(85) = rxt(72)*y(2) + rxt(67)*y(12)
         mat(913) = mat(913) + rxt(99)*y(5) + 4.000_r8*rxt(101)*y(18) + rxt(120)*y(30) &
                      + .900_r8*rxt(128)*y(33) + rxt(141)*y(37) + .300_r8*rxt(150) &
                      *y(42) + rxt(189)*y(53) + .730_r8*rxt(170)*y(57) + rxt(176) &
                      *y(59) + .800_r8*rxt(204)*y(63)
         mat(880) = mat(880) + rxt(97)*y(2) + rxt(95)*y(7)
         mat(205) = rxt(103)*y(12)
         mat(77) = rxt(133)*y(12)
         mat(127) = .120_r8*rxt(116)*y(1)
         mat(254) = mat(254) + .250_r8*rxt(112)*y(5)
         mat(329) = rxt(131)*y(12)
         mat(323) = mat(323) + rxt(118)*y(5) + rxt(120)*y(18) + 2.400_r8*rxt(121) &
                      *y(30)
         mat(593) = mat(593) + .900_r8*rxt(128)*y(18) + rxt(190)*y(53) &
                      + .470_r8*rxt(171)*y(57) + rxt(205)*y(63)
         mat(390) = .190_r8*rxt(137)*y(1)
         mat(341) = mat(341) + rxt(139)*y(5) + rxt(141)*y(18)
         mat(291) = mat(291) + rxt(144)*y(5)
         mat(445) = mat(445) + .300_r8*rxt(150)*y(18)
         mat(102) = rxt(157)*y(5)
         mat(312) = mat(312) + .900_r8*rxt(198)*y(5)
         mat(355) = .060_r8*rxt(183)*y(1)
         mat(553) = mat(553) + rxt(185)*y(5) + rxt(186)*y(7) + rxt(189)*y(18) &
                      + rxt(190)*y(33)
         mat(514) = .060_r8*rxt(159)*y(1)
         mat(461) = .275_r8*rxt(165)*y(1)
         mat(532) = mat(532) + .470_r8*rxt(166)*y(5) + .470_r8*rxt(168)*y(7) &
                      + .730_r8*rxt(170)*y(18) + .470_r8*rxt(171)*y(33)
         mat(113) = .200_r8*rxt(172)*y(12)
         mat(569) = mat(569) + rxt(176)*y(18)
         mat(452) = rxt(152)*y(12)
         mat(484) = mat(484) + rxt(201)*y(5) + rxt(202)*y(7) + .800_r8*rxt(204)*y(18) &
                      + rxt(205)*y(33)
         mat(246) = rxt(215)*y(1)
         mat(376) = mat(376) + rxt(217)*y(5)
         mat(47) = .250_r8*rxt(208)*y(12)
         mat(215) = mat(215) + .900_r8*rxt(209)*y(5)
         mat(60) = .700_r8*rxt(213)*y(6)
         mat(263) = rxt(132)*y(12)
         mat(228) = .500_r8*rxt(181)*y(12)
         mat(433) = mat(433) + .794_r8*rxt(191)*y(5) + .794_r8*rxt(192)*y(7) &
                      + .794_r8*rxt(193)*y(13)
         mat(420) = rxt(196)*y(7) + rxt(195)*y(12)
         mat(73) = .500_r8*rxt(226)*y(12)
         mat(55) = .350_r8*rxt(109)*y(12)
         mat(121) = rxt(105)*y(12)
         mat(163) = mat(163) + rxt(107)*y(5)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(82) = -(rxt(67)*y(12) + rxt(72)*y(2))
         mat(745) = -rxt(67)*y(14)
         mat(488) = -rxt(72)*y(14)

         mat(745) = mat(745) + 2.000_r8*rxt(65)*y(12)
         mat(814) = 2.000_r8*rxt(71)*y(13)

         mat(915) = -(rxt(99)*y(5) + rxt(100)*y(13) + (4._r8*rxt(101) + 4._r8*rxt(102) &
                      ) * y(18) + rxt(120)*y(30) + rxt(128)*y(33) + rxt(141)*y(37) &
                      + rxt(150)*y(42) + rxt(170)*y(57) + rxt(176)*y(59) + rxt(189) &
                      *y(53) + rxt(204)*y(63))
         mat(705) = -rxt(99)*y(18)
         mat(867) = -rxt(100)*y(18)
         mat(325) = -rxt(120)*y(18)
         mat(595) = -rxt(128)*y(18)
         mat(343) = -rxt(141)*y(18)
         mat(447) = -rxt(150)*y(18)
         mat(534) = -rxt(170)*y(18)
         mat(571) = -rxt(176)*y(18)
         mat(555) = -rxt(189)*y(18)
         mat(486) = -rxt(204)*y(18)

         mat(663) = .310_r8*rxt(137)*y(35)
         mat(705) = mat(705) + rxt(125)*y(33)
         mat(809) = .700_r8*rxt(104)*y(19) + rxt(117)*y(26)
         mat(915) = mat(915) + .900_r8*rxt(128)*y(33)
         mat(144) = .700_r8*rxt(104)*y(12)
         mat(177) = rxt(117)*y(12)
         mat(595) = mat(595) + rxt(125)*y(5) + .900_r8*rxt(128)*y(18) &
                      + 4.000_r8*rxt(129)*y(33) + rxt(190)*y(53) + rxt(171)*y(57) &
                      + rxt(177)*y(59) + rxt(205)*y(63)
         mat(392) = .310_r8*rxt(137)*y(1)
         mat(555) = mat(555) + rxt(190)*y(33)
         mat(534) = mat(534) + rxt(171)*y(33)
         mat(571) = mat(571) + rxt(177)*y(33)
         mat(486) = mat(486) + rxt(205)*y(33)

         mat(140) = -(rxt(104)*y(12))
         mat(755) = -rxt(104)*y(19)

         mat(822) = rxt(100)*y(18)
         mat(885) = rxt(100)*y(13)

         mat(881) = -(rxt(95)*y(7) + rxt(96)*y(12) + rxt(97)*y(2) + rxt(98)*y(13))
         mat(629) = -rxt(95)*y(20)
         mat(808) = -rxt(96)*y(20)
         mat(499) = -rxt(97)*y(20)
         mat(866) = -rxt(98)*y(20)

         mat(662) = rxt(116)*y(23) + .540_r8*rxt(137)*y(35) + .600_r8*rxt(183)*y(52) &
                      + .800_r8*rxt(159)*y(55) + .700_r8*rxt(165)*y(56)
         mat(704) = rxt(99)*y(18) + .500_r8*rxt(112)*y(25) + rxt(144)*y(39) + rxt(148) &
                      *y(42) + .500_r8*rxt(157)*y(45) + .100_r8*rxt(198)*y(50) &
                      + .510_r8*rxt(185)*y(53) + .250_r8*rxt(166)*y(57) + rxt(173) &
                      *y(59) + .072_r8*rxt(191)*y(78)
         mat(629) = mat(629) + .600_r8*rxt(186)*y(53) + .250_r8*rxt(168)*y(57) &
                      + rxt(174)*y(59) + .072_r8*rxt(192)*y(78)
         mat(808) = mat(808) + .300_r8*rxt(104)*y(19) + rxt(103)*y(21) &
                      + .800_r8*rxt(131)*y(27) + .500_r8*rxt(130)*y(34) + rxt(135) &
                      *y(75) + .500_r8*rxt(181)*y(77)
         mat(866) = mat(866) + .008_r8*rxt(193)*y(78)
         mat(914) = rxt(99)*y(5) + (4.000_r8*rxt(101)+2.000_r8*rxt(102))*y(18) &
                      + .700_r8*rxt(120)*y(30) + rxt(128)*y(33) + rxt(141)*y(37) &
                      + .800_r8*rxt(150)*y(42) + 1.200_r8*rxt(189)*y(53) &
                      + .880_r8*rxt(170)*y(57) + 2.000_r8*rxt(176)*y(59) &
                      + .700_r8*rxt(204)*y(63)
         mat(143) = .300_r8*rxt(104)*y(12)
         mat(206) = rxt(103)*y(12)
         mat(128) = rxt(116)*y(1)
         mat(255) = .500_r8*rxt(112)*y(5)
         mat(330) = .800_r8*rxt(131)*y(12)
         mat(324) = .700_r8*rxt(120)*y(18)
         mat(594) = rxt(128)*y(18) + .600_r8*rxt(190)*y(53) + .250_r8*rxt(171)*y(57) &
                      + rxt(177)*y(59)
         mat(173) = .500_r8*rxt(130)*y(12)
         mat(391) = .540_r8*rxt(137)*y(1)
         mat(342) = rxt(141)*y(18)
         mat(292) = rxt(144)*y(5)
         mat(446) = rxt(148)*y(5) + .800_r8*rxt(150)*y(18)
         mat(103) = .500_r8*rxt(157)*y(5)
         mat(313) = .100_r8*rxt(198)*y(5)
         mat(356) = .600_r8*rxt(183)*y(1)
         mat(554) = .510_r8*rxt(185)*y(5) + .600_r8*rxt(186)*y(7) + 1.200_r8*rxt(189) &
                      *y(18) + .600_r8*rxt(190)*y(33)
         mat(515) = .800_r8*rxt(159)*y(1)
         mat(462) = .700_r8*rxt(165)*y(1)
         mat(533) = .250_r8*rxt(166)*y(5) + .250_r8*rxt(168)*y(7) + .880_r8*rxt(170) &
                      *y(18) + .250_r8*rxt(171)*y(33)
         mat(570) = rxt(173)*y(5) + rxt(174)*y(7) + 2.000_r8*rxt(176)*y(18) + rxt(177) &
                      *y(33) + 4.000_r8*rxt(178)*y(59)
         mat(485) = .700_r8*rxt(204)*y(18)
         mat(190) = rxt(135)*y(12)
         mat(229) = .500_r8*rxt(181)*y(12)
         mat(434) = .072_r8*rxt(191)*y(5) + .072_r8*rxt(192)*y(7) + .008_r8*rxt(193) &
                      *y(13)

         mat(203) = -(rxt(103)*y(12))
         mat(766) = -rxt(103)*y(21)

         mat(888) = 2.000_r8*rxt(102)*y(18) + .300_r8*rxt(120)*y(30) &
                      + .500_r8*rxt(150)*y(42) + .250_r8*rxt(189)*y(53) &
                      + .250_r8*rxt(170)*y(57) + .300_r8*rxt(204)*y(63)
         mat(317) = .300_r8*rxt(120)*y(18)
         mat(437) = .500_r8*rxt(150)*y(18)
         mat(537) = .250_r8*rxt(189)*y(18)
         mat(519) = .250_r8*rxt(170)*y(18)
         mat(473) = .300_r8*rxt(204)*y(18)

         mat(74) = -(rxt(133)*y(12))
         mat(744) = -rxt(133)*y(22)

         mat(884) = .200_r8*rxt(120)*y(30)
         mat(315) = .200_r8*rxt(120)*y(18) + .800_r8*rxt(121)*y(30)


         mat(811) = rxt(113)*y(25)
         mat(247) = rxt(113)*y(13)

         mat(123) = -(rxt(111)*y(12) + rxt(116)*y(1))
         mat(752) = -rxt(111)*y(23)
         mat(633) = -rxt(116)*y(23)


         mat(665) = .750_r8*rxt(112)*y(25)
         mat(248) = .750_r8*rxt(112)*y(5)

         mat(249) = -(rxt(112)*y(5) + rxt(113)*y(13))
         mat(674) = -rxt(112)*y(25)
         mat(832) = -rxt(113)*y(25)

         mat(772) = rxt(111)*y(23)
         mat(124) = rxt(111)*y(12)

         mat(175) = -(rxt(117)*y(12))
         mat(761) = -rxt(117)*y(26)

         mat(634) = .250_r8*rxt(137)*y(35) + .200_r8*rxt(183)*y(52)
         mat(826) = .250_r8*rxt(127)*y(33) + .250_r8*rxt(175)*y(59)
         mat(887) = .100_r8*rxt(128)*y(33)
         mat(575) = .250_r8*rxt(127)*y(13) + .100_r8*rxt(128)*y(18)
         mat(379) = .250_r8*rxt(137)*y(1)
         mat(344) = .200_r8*rxt(183)*y(1)
         mat(558) = .250_r8*rxt(175)*y(13)

         mat(327) = -(rxt(131)*y(12))
         mat(781) = -rxt(131)*y(27)

         mat(681) = .530_r8*rxt(166)*y(57) + .250_r8*rxt(201)*y(63)
         mat(605) = .530_r8*rxt(168)*y(57) + .250_r8*rxt(202)*y(63)
         mat(892) = .260_r8*rxt(170)*y(57) + .100_r8*rxt(204)*y(63)
         mat(578) = .530_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(520) = .530_r8*rxt(166)*y(5) + .530_r8*rxt(168)*y(7) + .260_r8*rxt(170) &
                      *y(18) + .530_r8*rxt(171)*y(33)
         mat(475) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)

         mat(22) = -(rxt(110)*y(12))
         mat(731) = -rxt(110)*y(29)

         mat(318) = -(rxt(118)*y(5) + rxt(119)*y(13) + rxt(120)*y(18) + 4._r8*rxt(121) &
                      *y(30))
         mat(680) = -rxt(118)*y(30)
         mat(840) = -rxt(119)*y(30)
         mat(891) = -rxt(120)*y(30)

         mat(780) = rxt(110)*y(29) + .500_r8*rxt(122)*y(31)
         mat(23) = rxt(110)*y(12)
         mat(115) = .500_r8*rxt(122)*y(12)

         mat(114) = -(rxt(122)*y(12))
         mat(750) = -rxt(122)*y(31)

         mat(818) = rxt(119)*y(30)
         mat(316) = rxt(119)*y(13)

         mat(406) = -(rxt(123)*y(12) + rxt(124)*y(7))
         mat(788) = -rxt(123)*y(32)
         mat(609) = -rxt(124)*y(32)

         mat(643) = .500_r8*rxt(137)*y(35) + .040_r8*rxt(159)*y(55)
         mat(684) = rxt(118)*y(30) + .270_r8*rxt(139)*y(37) + rxt(144)*y(39) &
                      + rxt(157)*y(45) + .400_r8*rxt(198)*y(50) + rxt(161)*y(47)
         mat(788) = mat(788) + rxt(133)*y(22) + .500_r8*rxt(122)*y(31)
         mat(896) = .800_r8*rxt(120)*y(30)
         mat(75) = rxt(133)*y(12)
         mat(319) = rxt(118)*y(5) + .800_r8*rxt(120)*y(18) + 3.200_r8*rxt(121)*y(30)
         mat(116) = .500_r8*rxt(122)*y(12)
         mat(382) = .500_r8*rxt(137)*y(1)
         mat(335) = .270_r8*rxt(139)*y(5)
         mat(286) = rxt(144)*y(5)
         mat(99) = rxt(157)*y(5)
         mat(305) = .400_r8*rxt(198)*y(5)
         mat(278) = rxt(161)*y(5)
         mat(503) = .040_r8*rxt(159)*y(1)

         mat(587) = -(rxt(125)*y(5) + rxt(126)*y(6) + rxt(127)*y(13) + rxt(128)*y(18) &
                      + 4._r8*rxt(129)*y(33) + rxt(171)*y(57) + rxt(190)*y(53) + rxt(205) &
                      *y(63))
         mat(697) = -rxt(125)*y(33)
         mat(719) = -rxt(126)*y(33)
         mat(859) = -rxt(127)*y(33)
         mat(907) = -rxt(128)*y(33)
         mat(527) = -rxt(171)*y(33)
         mat(547) = -rxt(190)*y(33)
         mat(479) = -rxt(205)*y(33)

         mat(697) = mat(697) + rxt(148)*y(42) + rxt(161)*y(47) + .530_r8*rxt(166) &
                      *y(57) + rxt(173)*y(59)
         mat(622) = rxt(124)*y(32) + .530_r8*rxt(168)*y(57) + rxt(174)*y(59) &
                      + rxt(154)*y(62)
         mat(801) = rxt(123)*y(32) + .500_r8*rxt(130)*y(34) + rxt(153)*y(62)
         mat(907) = mat(907) + .300_r8*rxt(150)*y(42) + .260_r8*rxt(170)*y(57) &
                      + rxt(176)*y(59)
         mat(407) = rxt(124)*y(7) + rxt(123)*y(12)
         mat(587) = mat(587) + .530_r8*rxt(171)*y(57)
         mat(171) = .500_r8*rxt(130)*y(12)
         mat(441) = rxt(148)*y(5) + .300_r8*rxt(150)*y(18)
         mat(279) = rxt(161)*y(5)
         mat(527) = mat(527) + .530_r8*rxt(166)*y(5) + .530_r8*rxt(168)*y(7) &
                      + .260_r8*rxt(170)*y(18) + .530_r8*rxt(171)*y(33)
         mat(563) = rxt(173)*y(5) + rxt(174)*y(7) + rxt(176)*y(18) + 4.000_r8*rxt(178) &
                      *y(59)
         mat(466) = rxt(154)*y(7) + rxt(153)*y(12)

         mat(170) = -(rxt(130)*y(12))
         mat(760) = -rxt(130)*y(34)

         mat(825) = .750_r8*rxt(127)*y(33) + .750_r8*rxt(175)*y(59)
         mat(574) = .750_r8*rxt(127)*y(13)
         mat(557) = .750_r8*rxt(175)*y(13)

         mat(381) = -(rxt(136)*y(12) + rxt(137)*y(1) + rxt(138)*y(7))
         mat(786) = -rxt(136)*y(35)
         mat(641) = -rxt(137)*y(35)
         mat(608) = -rxt(138)*y(35)

         mat(641) = mat(641) + .070_r8*rxt(183)*y(52)
         mat(346) = .070_r8*rxt(183)*y(1)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(25) = -(rxt(143)*y(12))
         mat(732) = -rxt(143)*y(36)

         mat(334) = -(rxt(139)*y(5) + rxt(140)*y(13) + rxt(141)*y(18))
         mat(682) = -rxt(139)*y(37)
         mat(842) = -rxt(140)*y(37)
         mat(893) = -rxt(141)*y(37)

         mat(782) = rxt(143)*y(36) + rxt(142)*y(38)
         mat(26) = rxt(143)*y(12)
         mat(137) = rxt(142)*y(12)

         mat(135) = -(rxt(142)*y(12))
         mat(754) = -rxt(142)*y(38)

         mat(821) = rxt(140)*y(37)
         mat(332) = rxt(140)*y(13)

         mat(285) = -(rxt(144)*y(5) + rxt(145)*y(13))
         mat(677) = -rxt(144)*y(39)
         mat(837) = -rxt(145)*y(39)

         mat(777) = rxt(136)*y(35) + .500_r8*rxt(146)*y(40)
         mat(380) = rxt(136)*y(12)
         mat(197) = .500_r8*rxt(146)*y(12)

         mat(196) = -(rxt(146)*y(12))
         mat(765) = -rxt(146)*y(40)

         mat(828) = rxt(145)*y(39)
         mat(284) = rxt(145)*y(13)

         mat(293) = -(rxt(147)*y(12))
         mat(778) = -rxt(147)*y(41)

         mat(678) = .820_r8*rxt(139)*y(37) + .500_r8*rxt(157)*y(45) + .250_r8*rxt(198) &
                      *y(50) + .100_r8*rxt(217)*y(66)
         mat(890) = .820_r8*rxt(141)*y(37)
         mat(333) = .820_r8*rxt(139)*y(5) + .820_r8*rxt(141)*y(18)
         mat(98) = .500_r8*rxt(157)*y(5)
         mat(302) = .250_r8*rxt(198)*y(5)
         mat(367) = .100_r8*rxt(217)*y(5)

         mat(438) = -(rxt(148)*y(5) + rxt(149)*y(13) + rxt(150)*y(18))
         mat(687) = -rxt(148)*y(42)
         mat(849) = -rxt(149)*y(42)
         mat(897) = -rxt(150)*y(42)

         mat(791) = rxt(147)*y(41) + rxt(151)*y(43)
         mat(294) = rxt(147)*y(12)
         mat(93) = rxt(151)*y(12)

         mat(92) = -(rxt(151)*y(12))
         mat(746) = -rxt(151)*y(43)

         mat(815) = rxt(149)*y(42)
         mat(436) = rxt(149)*y(13)

         mat(28) = -(rxt(156)*y(12))
         mat(733) = -rxt(156)*y(44)

         mat(97) = -(rxt(157)*y(5))
         mat(666) = -rxt(157)*y(45)

         mat(747) = rxt(156)*y(44)
         mat(29) = rxt(156)*y(12)

         mat(31) = -(rxt(194)*y(12))
         mat(734) = -rxt(194)*y(49)

         mat(303) = -(rxt(198)*y(5) + rxt(199)*y(13))
         mat(679) = -rxt(198)*y(50)
         mat(839) = -rxt(199)*y(50)

         mat(779) = rxt(194)*y(49) + rxt(200)*y(51)
         mat(32) = rxt(194)*y(12)
         mat(269) = rxt(200)*y(12)

         mat(266) = -(rxt(200)*y(12))
         mat(775) = -rxt(200)*y(51)

         mat(835) = rxt(199)*y(50)
         mat(300) = rxt(199)*y(13)

         mat(165) = -(rxt(160)*y(12))
         mat(759) = -rxt(160)*y(46)

         mat(671) = .800_r8*rxt(198)*y(50)
         mat(299) = .800_r8*rxt(198)*y(5)

         mat(277) = -(rxt(161)*y(5) + rxt(162)*y(13))
         mat(676) = -rxt(161)*y(47)
         mat(836) = -rxt(162)*y(47)

         mat(776) = rxt(160)*y(46) + rxt(163)*y(48)
         mat(166) = rxt(160)*y(12)
         mat(105) = rxt(163)*y(12)

         mat(104) = -(rxt(163)*y(12))
         mat(748) = -rxt(163)*y(48)

         mat(816) = rxt(162)*y(47)
         mat(276) = rxt(162)*y(13)

         mat(345) = -(rxt(182)*y(12) + rxt(183)*y(1) + rxt(184)*y(7))
         mat(783) = -rxt(182)*y(52)
         mat(638) = -rxt(183)*y(52)
         mat(606) = -rxt(184)*y(52)

         mat(545) = -(rxt(185)*y(5) + rxt(186)*y(7) + rxt(187)*y(13) + rxt(189)*y(18) &
                      + rxt(190)*y(33))
         mat(695) = -rxt(185)*y(53)
         mat(620) = -rxt(186)*y(53)
         mat(857) = -rxt(187)*y(53)
         mat(905) = -rxt(189)*y(53)
         mat(585) = -rxt(190)*y(53)

         mat(799) = rxt(182)*y(52) + .200_r8*rxt(188)*y(54)
         mat(350) = rxt(182)*y(12)
         mat(234) = .200_r8*rxt(188)*y(12)

         mat(230) = -(rxt(188)*y(12))
         mat(770) = -rxt(188)*y(54)

         mat(831) = rxt(187)*y(53)
         mat(538) = rxt(187)*y(13)

         mat(506) = -(rxt(158)*y(12) + rxt(159)*y(1))
         mat(797) = -rxt(158)*y(55)
         mat(651) = -rxt(159)*y(55)

         mat(651) = mat(651) + .200_r8*rxt(183)*y(52) + rxt(215)*y(65)
         mat(693) = .320_r8*rxt(185)*y(53) + rxt(217)*y(66) + .039_r8*rxt(191)*y(78)
         mat(618) = .350_r8*rxt(186)*y(53) + .039_r8*rxt(192)*y(78)
         mat(855) = .039_r8*rxt(193)*y(78)
         mat(903) = .260_r8*rxt(189)*y(53)
         mat(583) = .350_r8*rxt(190)*y(53)
         mat(349) = .200_r8*rxt(183)*y(1)
         mat(543) = .320_r8*rxt(185)*y(5) + .350_r8*rxt(186)*y(7) + .260_r8*rxt(189) &
                      *y(18) + .350_r8*rxt(190)*y(33)
         mat(241) = rxt(215)*y(1)
         mat(371) = rxt(217)*y(5)
         mat(428) = .039_r8*rxt(191)*y(5) + .039_r8*rxt(192)*y(7) + .039_r8*rxt(193) &
                      *y(13)

         mat(454) = -(rxt(164)*y(12) + rxt(165)*y(1))
         mat(793) = -rxt(164)*y(56)
         mat(647) = -rxt(165)*y(56)

         mat(647) = mat(647) + .400_r8*rxt(183)*y(52) + rxt(215)*y(65)
         mat(689) = .230_r8*rxt(185)*y(53) + rxt(217)*y(66) + .167_r8*rxt(191)*y(78)
         mat(614) = .250_r8*rxt(186)*y(53) + .167_r8*rxt(192)*y(78)
         mat(851) = .167_r8*rxt(193)*y(78)
         mat(899) = .190_r8*rxt(189)*y(53)
         mat(580) = .250_r8*rxt(190)*y(53)
         mat(348) = .400_r8*rxt(183)*y(1)
         mat(540) = .230_r8*rxt(185)*y(5) + .250_r8*rxt(186)*y(7) + .190_r8*rxt(189) &
                      *y(18) + .250_r8*rxt(190)*y(33)
         mat(240) = rxt(215)*y(1)
         mat(370) = rxt(217)*y(5)
         mat(426) = .167_r8*rxt(191)*y(5) + .167_r8*rxt(192)*y(7) + .167_r8*rxt(193) &
                      *y(13)

         mat(525) = -((rxt(166) + rxt(167)) * y(5) + rxt(168)*y(7) + rxt(169)*y(13) &
                      + rxt(170)*y(18) + rxt(171)*y(33))
         mat(694) = -(rxt(166) + rxt(167)) * y(57)
         mat(619) = -rxt(168)*y(57)
         mat(856) = -rxt(169)*y(57)
         mat(904) = -rxt(170)*y(57)
         mat(584) = -rxt(171)*y(57)

         mat(798) = rxt(158)*y(55) + .500_r8*rxt(164)*y(56) + .200_r8*rxt(172)*y(58)
         mat(507) = rxt(158)*y(12)
         mat(456) = .500_r8*rxt(164)*y(12)
         mat(110) = .200_r8*rxt(172)*y(12)

         mat(109) = -(rxt(172)*y(12))
         mat(749) = -rxt(172)*y(58)

         mat(817) = rxt(169)*y(57)
         mat(518) = rxt(169)*y(13)

         mat(562) = -(rxt(173)*y(5) + rxt(174)*y(7) + rxt(175)*y(13) + rxt(176)*y(18) &
                      + rxt(177)*y(33) + 4._r8*rxt(178)*y(59) + rxt(179)*y(6))
         mat(696) = -rxt(173)*y(59)
         mat(621) = -rxt(174)*y(59)
         mat(858) = -rxt(175)*y(59)
         mat(906) = -rxt(176)*y(59)
         mat(586) = -rxt(177)*y(59)
         mat(718) = -rxt(179)*y(59)

         mat(654) = .200_r8*rxt(183)*y(52)
         mat(800) = .500_r8*rxt(164)*y(56) + .500_r8*rxt(172)*y(58)
         mat(351) = .200_r8*rxt(183)*y(1)
         mat(457) = .500_r8*rxt(164)*y(12)
         mat(111) = .500_r8*rxt(172)*y(12)

         mat(145) = -(rxt(197)*y(12))
         mat(756) = -rxt(197)*y(60)

         mat(668) = .370_r8*rxt(185)*y(53)
         mat(600) = .400_r8*rxt(186)*y(53) + rxt(196)*y(79)
         mat(756) = mat(756) + rxt(195)*y(79)
         mat(886) = .300_r8*rxt(189)*y(53)
         mat(573) = .400_r8*rxt(190)*y(53)
         mat(536) = .370_r8*rxt(185)*y(5) + .400_r8*rxt(186)*y(7) + .300_r8*rxt(189) &
                      *y(18) + .400_r8*rxt(190)*y(33)
         mat(414) = rxt(196)*y(7) + rxt(195)*y(12)

         mat(448) = -(rxt(152)*y(12))
         mat(792) = -rxt(152)*y(61)

         mat(688) = .220_r8*rxt(166)*y(57) + .250_r8*rxt(201)*y(63)
         mat(613) = .220_r8*rxt(168)*y(57) + .250_r8*rxt(202)*y(63)
         mat(792) = mat(792) + .500_r8*rxt(146)*y(40) + .500_r8*rxt(181)*y(77)
         mat(898) = .200_r8*rxt(150)*y(42) + .230_r8*rxt(170)*y(57) + .100_r8*rxt(204) &
                      *y(63)
         mat(579) = .220_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(199) = .500_r8*rxt(146)*y(12)
         mat(439) = .200_r8*rxt(150)*y(18)
         mat(522) = .220_r8*rxt(166)*y(5) + .220_r8*rxt(168)*y(7) + .230_r8*rxt(170) &
                      *y(18) + .220_r8*rxt(171)*y(33)
         mat(476) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)
         mat(223) = .500_r8*rxt(181)*y(12)

         mat(465) = -(rxt(153)*y(12) + rxt(154)*y(7))
         mat(794) = -rxt(153)*y(62)
         mat(615) = -rxt(154)*y(62)

         mat(648) = .950_r8*rxt(159)*y(55) + .800_r8*rxt(165)*y(56)
         mat(690) = .250_r8*rxt(166)*y(57) + .250_r8*rxt(201)*y(63) + .450_r8*rxt(209) &
                      *y(70)
         mat(615) = mat(615) + .250_r8*rxt(168)*y(57) + .250_r8*rxt(202)*y(63)
         mat(794) = mat(794) + rxt(152)*y(61) + rxt(155)*y(76)
         mat(900) = .500_r8*rxt(150)*y(42) + .240_r8*rxt(170)*y(57) + .100_r8*rxt(204) &
                      *y(63)
         mat(581) = .250_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(440) = .500_r8*rxt(150)*y(18)
         mat(505) = .950_r8*rxt(159)*y(1)
         mat(455) = .800_r8*rxt(165)*y(1)
         mat(523) = .250_r8*rxt(166)*y(5) + .250_r8*rxt(168)*y(7) + .240_r8*rxt(170) &
                      *y(18) + .250_r8*rxt(171)*y(33)
         mat(449) = rxt(152)*y(12)
         mat(477) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)
         mat(211) = .450_r8*rxt(209)*y(5)
         mat(155) = rxt(155)*y(12)

         mat(478) = -(rxt(201)*y(5) + rxt(202)*y(7) + rxt(203)*y(13) + rxt(204)*y(18) &
                      + rxt(205)*y(33))
         mat(691) = -rxt(201)*y(63)
         mat(616) = -rxt(202)*y(63)
         mat(853) = -rxt(203)*y(63)
         mat(901) = -rxt(204)*y(63)
         mat(582) = -rxt(205)*y(63)

         mat(795) = .800_r8*rxt(188)*y(54) + rxt(197)*y(60) + rxt(206)*y(64)
         mat(232) = .800_r8*rxt(188)*y(12)
         mat(146) = rxt(197)*y(12)
         mat(66) = rxt(206)*y(12)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(65) = -((rxt(206) + rxt(207)) * y(12))
         mat(742) = -(rxt(206) + rxt(207)) * y(64)

         mat(812) = rxt(203)*y(63) + rxt(193)*y(78)
         mat(472) = rxt(203)*y(13)
         mat(423) = rxt(193)*y(13)

         mat(238) = -(rxt(214)*y(12) + rxt(215)*y(1) + rxt(216)*y(7))
         mat(771) = -rxt(214)*y(65)
         mat(635) = -rxt(215)*y(65)
         mat(603) = -rxt(216)*y(65)

         mat(368) = -(rxt(217)*y(5) + rxt(218)*y(13))
         mat(683) = -rxt(217)*y(66)
         mat(844) = -rxt(218)*y(66)

         mat(607) = rxt(216)*y(65)
         mat(785) = rxt(214)*y(65) + rxt(219)*y(67)
         mat(239) = rxt(216)*y(7) + rxt(214)*y(12)
         mat(180) = rxt(219)*y(12)

         mat(178) = -(rxt(219)*y(12))
         mat(762) = -rxt(219)*y(67)

         mat(827) = rxt(218)*y(66)
         mat(366) = rxt(218)*y(13)

         mat(43) = -(rxt(208)*y(12))
         mat(737) = -rxt(208)*y(68)

         mat(48) = -(rxt(212)*y(12))
         mat(738) = -rxt(212)*y(69)

         mat(738) = mat(738) + .250_r8*rxt(208)*y(68)
         mat(44) = .250_r8*rxt(208)*y(12)

         mat(208) = -(rxt(209)*y(5) + rxt(210)*y(13))
         mat(672) = -rxt(209)*y(70)
         mat(829) = -rxt(210)*y(70)

         mat(767) = .700_r8*rxt(208)*y(68) + rxt(211)*y(71)
         mat(45) = .700_r8*rxt(208)*y(12)
         mat(149) = rxt(211)*y(12)

         mat(148) = -(rxt(211)*y(12))
         mat(757) = -rxt(211)*y(71)

         mat(823) = rxt(210)*y(70)
         mat(207) = rxt(210)*y(13)

         mat(57) = -(rxt(213)*y(6))
         mat(707) = -rxt(213)*y(72)

         mat(740) = rxt(212)*y(69)
         mat(49) = rxt(212)*y(12)


         mat(673) = .900_r8*rxt(209)*y(70)
         mat(712) = .700_r8*rxt(213)*y(72)
         mat(209) = .900_r8*rxt(209)*y(5)
         mat(58) = .700_r8*rxt(213)*y(6)

         mat(261) = -(rxt(132)*y(12))
         mat(774) = -rxt(132)*y(74)

         mat(675) = .250_r8*rxt(201)*y(63) + .450_r8*rxt(209)*y(70)
         mat(604) = .250_r8*rxt(202)*y(63)
         mat(774) = mat(774) + .200_r8*rxt(131)*y(27) + .650_r8*rxt(109)*y(88)
         mat(889) = .100_r8*rxt(204)*y(63)
         mat(326) = .200_r8*rxt(131)*y(12)
         mat(577) = .250_r8*rxt(205)*y(63)
         mat(474) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)
         mat(210) = .450_r8*rxt(209)*y(5)
         mat(53) = .650_r8*rxt(109)*y(12)

         mat(185) = -(rxt(135)*y(12))
         mat(763) = -rxt(135)*y(75)

         mat(710) = rxt(126)*y(33)
         mat(576) = rxt(126)*y(6)

         mat(154) = -(rxt(155)*y(12))
         mat(758) = -rxt(155)*y(76)

         mat(669) = .100_r8*rxt(198)*y(50)
         mat(601) = rxt(138)*y(35)
         mat(378) = rxt(138)*y(7)
         mat(298) = .100_r8*rxt(198)*y(5)

         mat(222) = -(rxt(181)*y(12))
         mat(769) = -rxt(181)*y(77)

         mat(713) = rxt(179)*y(59)
         mat(559) = rxt(179)*y(6)

         mat(425) = -(rxt(191)*y(5) + rxt(192)*y(7) + rxt(193)*y(13))
         mat(686) = -rxt(191)*y(78)
         mat(611) = -rxt(192)*y(78)
         mat(848) = -rxt(193)*y(78)

         mat(611) = mat(611) + rxt(184)*y(52)
         mat(347) = rxt(184)*y(7)

         mat(415) = -(rxt(195)*y(12) + rxt(196)*y(7))
         mat(789) = -rxt(195)*y(79)
         mat(610) = -rxt(196)*y(79)

         mat(685) = .080_r8*rxt(185)*y(53) + .800_r8*rxt(167)*y(57) + .794_r8*rxt(191) &
                      *y(78)
         mat(610) = mat(610) + .794_r8*rxt(192)*y(78)
         mat(847) = .794_r8*rxt(193)*y(78)
         mat(539) = .080_r8*rxt(185)*y(5)
         mat(521) = .800_r8*rxt(167)*y(5)
         mat(424) = .794_r8*rxt(191)*y(5) + .794_r8*rxt(192)*y(7) + .794_r8*rxt(193) &
                      *y(13)

         mat(38) = -(rxt(224)*y(12))
         mat(736) = -rxt(224)*y(80)

         mat(597) = rxt(227)*y(81)
         mat(736) = mat(736) + (rxt(225)+.500_r8*rxt(226))*y(81)
         mat(68) = rxt(227)*y(7) + (rxt(225)+.500_r8*rxt(226))*y(12)

         mat(69) = -((rxt(225) + rxt(226)) * y(12) + rxt(227)*y(7))
         mat(743) = -(rxt(225) + rxt(226)) * y(81)
         mat(598) = -rxt(227)*y(81)

         mat(20) = -(rxt(228)*y(12))
         mat(730) = -rxt(228)*y(82)



         mat(51) = -(rxt(109)*y(12))
         mat(739) = -rxt(109)*y(88)

         mat(119) = -(rxt(105)*y(12))
         mat(751) = -rxt(105)*y(89)

         mat(632) = .500_r8*rxt(116)*y(23)
         mat(667) = rxt(107)*y(90)
         mat(751) = mat(751) + .350_r8*rxt(109)*y(88)
         mat(819) = rxt(108)*y(90)
         mat(122) = .500_r8*rxt(116)*y(1)
         mat(52) = .350_r8*rxt(109)*y(12)
         mat(158) = rxt(107)*y(5) + rxt(108)*y(13)

         mat(159) = -(rxt(107)*y(5) + rxt(108)*y(13))
         mat(670) = -rxt(107)*y(90)
         mat(824) = -rxt(108)*y(90)

         mat(824) = mat(824) + rxt(98)*y(20)
         mat(869) = rxt(98)*y(13)


         mat(729) = rxt(224)*y(80)
         mat(37) = rxt(224)*y(12)
      end subroutine nlnmat05
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = mat( 20) + lmat( 20)
         mat( 22) = mat( 22) + lmat( 22)
         mat( 25) = mat( 25) + lmat( 25)
         mat( 28) = mat( 28) + lmat( 28)
         mat( 31) = mat( 31) + lmat( 31)
         mat( 34) = mat( 34) + lmat( 34)
         mat( 38) = mat( 38) + lmat( 38)
         mat( 40) = lmat( 40)
         mat( 41) = lmat( 41)
         mat( 42) = lmat( 42)
         mat( 43) = mat( 43) + lmat( 43)
         mat( 48) = mat( 48) + lmat( 48)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 65) = mat( 65) + lmat( 65)
         mat( 67) = mat( 67) + lmat( 67)
         mat( 69) = mat( 69) + lmat( 69)
         mat( 74) = mat( 74) + lmat( 74)
         mat( 78) = lmat( 78)
         mat( 79) = lmat( 79)
         mat( 80) = lmat( 80)
         mat( 81) = lmat( 81)
         mat( 82) = mat( 82) + lmat( 82)
         mat( 84) = mat( 84) + lmat( 84)
         mat( 86) = lmat( 86)
         mat( 87) = lmat( 87)
         mat( 88) = lmat( 88)
         mat( 89) = lmat( 89)
         mat( 90) = lmat( 90)
         mat( 91) = lmat( 91)
         mat( 92) = mat( 92) + lmat( 92)
         mat( 94) = lmat( 94)
         mat( 95) = mat( 95) + lmat( 95)
         mat( 96) = lmat( 96)
         mat( 97) = mat( 97) + lmat( 97)
         mat( 104) = mat( 104) + lmat( 104)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = mat( 108) + lmat( 108)
         mat( 109) = mat( 109) + lmat( 109)
         mat( 114) = mat( 114) + lmat( 114)
         mat( 116) = mat( 116) + lmat( 116)
         mat( 117) = mat( 117) + lmat( 117)
         mat( 118) = lmat( 118)
         mat( 119) = mat( 119) + lmat( 119)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 131) = lmat( 131)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 134) = lmat( 134)
         mat( 135) = mat( 135) + lmat( 135)
         mat( 136) = lmat( 136)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 139) = lmat( 139)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 141) = lmat( 141)
         mat( 142) = mat( 142) + lmat( 142)
         mat( 143) = mat( 143) + lmat( 143)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 150) = lmat( 150)
         mat( 151) = lmat( 151)
         mat( 152) = lmat( 152)
         mat( 153) = mat( 153) + lmat( 153)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 159) = mat( 159) + lmat( 159)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 164) = lmat( 164)
         mat( 165) = mat( 165) + lmat( 165)
         mat( 167) = lmat( 167)
         mat( 168) = lmat( 168)
         mat( 170) = mat( 170) + lmat( 170)
         mat( 172) = mat( 172) + lmat( 172)
         mat( 174) = lmat( 174)
         mat( 175) = mat( 175) + lmat( 175)
         mat( 178) = mat( 178) + lmat( 178)
         mat( 179) = lmat( 179)
         mat( 181) = lmat( 181)
         mat( 182) = lmat( 182)
         mat( 183) = mat( 183) + lmat( 183)
         mat( 184) = lmat( 184)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 186) = lmat( 186)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 188) = lmat( 188)
         mat( 191) = lmat( 191)
         mat( 192) = mat( 192) + lmat( 192)
         mat( 194) = lmat( 194)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 198) = lmat( 198)
         mat( 200) = mat( 200) + lmat( 200)
         mat( 201) = lmat( 201)
         mat( 202) = lmat( 202)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 216) = lmat( 216)
         mat( 217) = lmat( 217)
         mat( 218) = lmat( 218)
         mat( 219) = lmat( 219)
         mat( 220) = lmat( 220)
         mat( 221) = lmat( 221)
         mat( 222) = mat( 222) + lmat( 222)
         mat( 224) = lmat( 224)
         mat( 226) = lmat( 226)
         mat( 230) = mat( 230) + lmat( 230)
         mat( 231) = lmat( 231)
         mat( 233) = lmat( 233)
         mat( 236) = lmat( 236)
         mat( 237) = lmat( 237)
         mat( 238) = mat( 238) + lmat( 238)
         mat( 249) = mat( 249) + lmat( 249)
         mat( 256) = mat( 256) + lmat( 256)
         mat( 261) = mat( 261) + lmat( 261)
         mat( 263) = mat( 263) + lmat( 263)
         mat( 264) = mat( 264) + lmat( 264)
         mat( 265) = lmat( 265)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 268) = lmat( 268)
         mat( 271) = lmat( 271)
         mat( 273) = mat( 273) + lmat( 273)
         mat( 274) = lmat( 274)
         mat( 275) = lmat( 275)
         mat( 277) = mat( 277) + lmat( 277)
         mat( 285) = mat( 285) + lmat( 285)
         mat( 293) = mat( 293) + lmat( 293)
         mat( 295) = lmat( 295)
         mat( 297) = lmat( 297)
         mat( 303) = mat( 303) + lmat( 303)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 327) = mat( 327) + lmat( 327)
         mat( 329) = mat( 329) + lmat( 329)
         mat( 330) = mat( 330) + lmat( 330)
         mat( 331) = lmat( 331)
         mat( 334) = mat( 334) + lmat( 334)
         mat( 345) = mat( 345) + lmat( 345)
         mat( 360) = mat( 360) + lmat( 360)
         mat( 365) = mat( 365) + lmat( 365)
         mat( 368) = mat( 368) + lmat( 368)
         mat( 381) = mat( 381) + lmat( 381)
         mat( 395) = mat( 395) + lmat( 395)
         mat( 396) = mat( 396) + lmat( 396)
         mat( 397) = mat( 397) + lmat( 397)
         mat( 398) = lmat( 398)
         mat( 400) = lmat( 400)
         mat( 401) = mat( 401) + lmat( 401)
         mat( 402) = lmat( 402)
         mat( 403) = lmat( 403)
         mat( 404) = lmat( 404)
         mat( 406) = mat( 406) + lmat( 406)
         mat( 411) = lmat( 411)
         mat( 412) = lmat( 412)
         mat( 413) = lmat( 413)
         mat( 415) = mat( 415) + lmat( 415)
         mat( 418) = mat( 418) + lmat( 418)
         mat( 420) = mat( 420) + lmat( 420)
         mat( 421) = lmat( 421)
         mat( 422) = lmat( 422)
         mat( 425) = mat( 425) + lmat( 425)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 450) = lmat( 450)
         mat( 452) = mat( 452) + lmat( 452)
         mat( 453) = lmat( 453)
         mat( 454) = mat( 454) + lmat( 454)
         mat( 457) = mat( 457) + lmat( 457)
         mat( 458) = lmat( 458)
         mat( 461) = mat( 461) + lmat( 461)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 463) = mat( 463) + lmat( 463)
         mat( 465) = mat( 465) + lmat( 465)
         mat( 466) = mat( 466) + lmat( 466)
         mat( 470) = lmat( 470)
         mat( 471) = mat( 471) + lmat( 471)
         mat( 478) = mat( 478) + lmat( 478)
         mat( 492) = mat( 492) + lmat( 492)
         mat( 494) = mat( 494) + lmat( 494)
         mat( 502) = lmat( 502)
         mat( 506) = mat( 506) + lmat( 506)
         mat( 508) = lmat( 508)
         mat( 516) = lmat( 516)
         mat( 517) = mat( 517) + lmat( 517)
         mat( 525) = mat( 525) + lmat( 525)
         mat( 545) = mat( 545) + lmat( 545)
         mat( 562) = mat( 562) + lmat( 562)
         mat( 587) = mat( 587) + lmat( 587)
         mat( 602) = mat( 602) + lmat( 602)
         mat( 617) = mat( 617) + lmat( 617)
         mat( 623) = mat( 623) + lmat( 623)
         mat( 625) = mat( 625) + lmat( 625)
         mat( 626) = mat( 626) + lmat( 626)
         mat( 642) = mat( 642) + lmat( 642)
         mat( 650) = mat( 650) + lmat( 650)
         mat( 657) = mat( 657) + lmat( 657)
         mat( 700) = mat( 700) + lmat( 700)
         mat( 711) = mat( 711) + lmat( 711)
         mat( 717) = mat( 717) + lmat( 717)
         mat( 722) = mat( 722) + lmat( 722)
         mat( 723) = mat( 723) + lmat( 723)
         mat( 724) = mat( 724) + lmat( 724)
         mat( 806) = mat( 806) + lmat( 806)
         mat( 809) = mat( 809) + lmat( 809)
         mat( 814) = mat( 814) + lmat( 814)
         mat( 865) = mat( 865) + lmat( 865)
         mat( 871) = lmat( 871)
         mat( 881) = mat( 881) + lmat( 881)
         mat( 883) = mat( 883) + lmat( 883)
         mat( 915) = mat( 915) + lmat( 915)
         mat( 928) = mat( 928) + lmat( 928)
         mat( 162) = 0._r8
         mat( 214) = 0._r8
         mat( 250) = 0._r8
         mat( 253) = 0._r8
         mat( 267) = 0._r8
         mat( 270) = 0._r8
         mat( 272) = 0._r8
         mat( 282) = 0._r8
         mat( 287) = 0._r8
         mat( 290) = 0._r8
         mat( 301) = 0._r8
         mat( 304) = 0._r8
         mat( 306) = 0._r8
         mat( 307) = 0._r8
         mat( 308) = 0._r8
         mat( 311) = 0._r8
         mat( 314) = 0._r8
         mat( 322) = 0._r8
         mat( 336) = 0._r8
         mat( 337) = 0._r8
         mat( 340) = 0._r8
         mat( 357) = 0._r8
         mat( 361) = 0._r8
         mat( 369) = 0._r8
         mat( 372) = 0._r8
         mat( 375) = 0._r8
         mat( 377) = 0._r8
         mat( 383) = 0._r8
         mat( 384) = 0._r8
         mat( 387) = 0._r8
         mat( 388) = 0._r8
         mat( 409) = 0._r8
         mat( 416) = 0._r8
         mat( 427) = 0._r8
         mat( 432) = 0._r8
         mat( 435) = 0._r8
         mat( 444) = 0._r8
         mat( 468) = 0._r8
         mat( 483) = 0._r8
         mat( 491) = 0._r8
         mat( 500) = 0._r8
         mat( 504) = 0._r8
         mat( 509) = 0._r8
         mat( 511) = 0._r8
         mat( 512) = 0._r8
         mat( 524) = 0._r8
         mat( 526) = 0._r8
         mat( 531) = 0._r8
         mat( 541) = 0._r8
         mat( 542) = 0._r8
         mat( 544) = 0._r8
         mat( 546) = 0._r8
         mat( 549) = 0._r8
         mat( 552) = 0._r8
         mat( 556) = 0._r8
         mat( 560) = 0._r8
         mat( 561) = 0._r8
         mat( 568) = 0._r8
         mat( 572) = 0._r8
         mat( 588) = 0._r8
         mat( 592) = 0._r8
         mat( 612) = 0._r8
         mat( 624) = 0._r8
         mat( 630) = 0._r8
         mat( 636) = 0._r8
         mat( 637) = 0._r8
         mat( 640) = 0._r8
         mat( 644) = 0._r8
         mat( 645) = 0._r8
         mat( 646) = 0._r8
         mat( 649) = 0._r8
         mat( 652) = 0._r8
         mat( 653) = 0._r8
         mat( 655) = 0._r8
         mat( 714) = 0._r8
         mat( 715) = 0._r8
         mat( 716) = 0._r8
         mat( 726) = 0._r8
         mat( 727) = 0._r8
         mat( 728) = 0._r8
         mat( 768) = 0._r8
         mat( 787) = 0._r8
         mat( 790) = 0._r8
         mat( 804) = 0._r8
         mat( 813) = 0._r8
         mat( 830) = 0._r8
         mat( 834) = 0._r8
         mat( 838) = 0._r8
         mat( 841) = 0._r8
         mat( 845) = 0._r8
         mat( 846) = 0._r8
         mat( 850) = 0._r8
         mat( 852) = 0._r8
         mat( 868) = 0._r8
         mat( 873) = 0._r8
         mat( 876) = 0._r8
         mat( 877) = 0._r8
         mat( 878) = 0._r8
         mat( 882) = 0._r8
         mat( 894) = 0._r8
         mat( 895) = 0._r8
         mat( 902) = 0._r8
         mat( 908) = 0._r8
         mat( 909) = 0._r8
         mat( 912) = 0._r8
         mat( 918) = 0._r8
         mat( 919) = 0._r8
         mat( 920) = 0._r8
         mat( 921) = 0._r8
         mat( 922) = 0._r8
         mat( 923) = 0._r8
         mat( 926) = 0._r8
         mat( 927) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 22) = mat( 22) - dti
         mat( 25) = mat( 25) - dti
         mat( 28) = mat( 28) - dti
         mat( 31) = mat( 31) - dti
         mat( 34) = mat( 34) - dti
         mat( 38) = mat( 38) - dti
         mat( 40) = mat( 40) - dti
         mat( 43) = mat( 43) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 57) = mat( 57) - dti
         mat( 61) = mat( 61) - dti
         mat( 65) = mat( 65) - dti
         mat( 69) = mat( 69) - dti
         mat( 74) = mat( 74) - dti
         mat( 78) = mat( 78) - dti
         mat( 82) = mat( 82) - dti
         mat( 86) = mat( 86) - dti
         mat( 92) = mat( 92) - dti
         mat( 97) = mat( 97) - dti
         mat( 104) = mat( 104) - dti
         mat( 109) = mat( 109) - dti
         mat( 114) = mat( 114) - dti
         mat( 119) = mat( 119) - dti
         mat( 123) = mat( 123) - dti
         mat( 130) = mat( 130) - dti
         mat( 135) = mat( 135) - dti
         mat( 140) = mat( 140) - dti
         mat( 145) = mat( 145) - dti
         mat( 148) = mat( 148) - dti
         mat( 154) = mat( 154) - dti
         mat( 159) = mat( 159) - dti
         mat( 165) = mat( 165) - dti
         mat( 170) = mat( 170) - dti
         mat( 175) = mat( 175) - dti
         mat( 178) = mat( 178) - dti
         mat( 185) = mat( 185) - dti
         mat( 192) = mat( 192) - dti
         mat( 196) = mat( 196) - dti
         mat( 203) = mat( 203) - dti
         mat( 208) = mat( 208) - dti
         mat( 216) = mat( 216) - dti
         mat( 222) = mat( 222) - dti
         mat( 230) = mat( 230) - dti
         mat( 238) = mat( 238) - dti
         mat( 249) = mat( 249) - dti
         mat( 256) = mat( 256) - dti
         mat( 261) = mat( 261) - dti
         mat( 266) = mat( 266) - dti
         mat( 277) = mat( 277) - dti
         mat( 285) = mat( 285) - dti
         mat( 293) = mat( 293) - dti
         mat( 303) = mat( 303) - dti
         mat( 318) = mat( 318) - dti
         mat( 327) = mat( 327) - dti
         mat( 334) = mat( 334) - dti
         mat( 345) = mat( 345) - dti
         mat( 360) = mat( 360) - dti
         mat( 368) = mat( 368) - dti
         mat( 381) = mat( 381) - dti
         mat( 397) = mat( 397) - dti
         mat( 406) = mat( 406) - dti
         mat( 415) = mat( 415) - dti
         mat( 425) = mat( 425) - dti
         mat( 438) = mat( 438) - dti
         mat( 448) = mat( 448) - dti
         mat( 454) = mat( 454) - dti
         mat( 465) = mat( 465) - dti
         mat( 478) = mat( 478) - dti
         mat( 492) = mat( 492) - dti
         mat( 506) = mat( 506) - dti
         mat( 525) = mat( 525) - dti
         mat( 545) = mat( 545) - dti
         mat( 562) = mat( 562) - dti
         mat( 587) = mat( 587) - dti
         mat( 623) = mat( 623) - dti
         mat( 657) = mat( 657) - dti
         mat( 700) = mat( 700) - dti
         mat( 723) = mat( 723) - dti
         mat( 806) = mat( 806) - dti
         mat( 865) = mat( 865) - dti
         mat( 881) = mat( 881) - dti
         mat( 915) = mat( 915) - dti
         mat( 928) = mat( 928) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
