




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1197) = -(rxt(83)*y(2) + rxt(90)*y(3) + rxt(115)*y(19) + rxt(120)*y(20) &
                      + rxt(128)*y(21) + rxt(140)*y(6) + rxt(143)*y(7) + rxt(155) &
                      *y(25) + rxt(182)*y(34) + rxt(235)*y(41) + rxt(256)*y(56) &
                      + rxt(278)*y(74) + rxt(284)*y(75) + rxt(302)*y(80) + rxt(340) &
                      *y(102))
         mat(1132) = -rxt(83)*y(1)
         mat(1239) = -rxt(90)*y(1)
         mat(719) = -rxt(115)*y(1)
         mat(1018) = -rxt(120)*y(1)
         mat(1089) = -rxt(128)*y(1)
         mat(881) = -rxt(140)*y(1)
         mat(828) = -rxt(143)*y(1)
         mat(1158) = -rxt(155)*y(1)
         mat(1107) = -rxt(182)*y(1)
         mat(154) = -rxt(235)*y(1)
         mat(503) = -rxt(256)*y(1)
         mat(617) = -rxt(278)*y(1)
         mat(571) = -rxt(284)*y(1)
         mat(444) = -rxt(302)*y(1)
         mat(303) = -rxt(340)*y(1)

         mat(1197) = mat(1197) + .100_r8*rxt(302)*y(80) + .200_r8*rxt(278)*y(74) &
                      + .200_r8*rxt(284)*y(75)
         mat(1089) = mat(1089) + .250_r8*rxt(246)*y(45) + .250_r8*rxt(294)*y(73)
         mat(444) = mat(444) + .100_r8*rxt(302)*y(1)
         mat(703) = .250_r8*rxt(246)*y(21)
         mat(617) = mat(617) + .200_r8*rxt(278)*y(1)
         mat(571) = mat(571) + .200_r8*rxt(284)*y(1)
         mat(677) = .250_r8*rxt(294)*y(21)

         mat(1130) = -(rxt(83)*y(1) + 4._r8*rxt(84)*y(2) + rxt(119)*y(20) + rxt(126) &
                      *y(18) + rxt(127)*y(21) + rxt(130)*y(22) + rxt(138)*y(6) &
                      + (rxt(141) + rxt(142)) * y(7) + rxt(149)*y(8) + rxt(162)*y(27) &
                      + rxt(175)*y(30) + rxt(176)*y(31) + rxt(179)*y(32) + rxt(185) &
                      *y(35) + rxt(195)*y(36) + rxt(196)*y(37) + rxt(197)*y(38) &
                      + rxt(215)*y(16))
         mat(1195) = -rxt(83)*y(2)
         mat(1016) = -rxt(119)*y(2)
         mat(522) = -rxt(126)*y(2)
         mat(1087) = -rxt(127)*y(2)
         mat(321) = -rxt(130)*y(2)
         mat(879) = -rxt(138)*y(2)
         mat(826) = -(rxt(141) + rxt(142)) * y(2)
         mat(921) = -rxt(149)*y(2)
         mat(1218) = -rxt(162)*y(2)
         mat(1258) = -rxt(175)*y(2)
         mat(449) = -rxt(176)*y(2)
         mat(461) = -rxt(179)*y(2)
         mat(773) = -rxt(185)*y(2)
         mat(409) = -rxt(195)*y(2)
         mat(384) = -rxt(196)*y(2)
         mat(263) = -rxt(197)*y(2)
         mat(793) = -rxt(215)*y(2)

         mat(87) = rxt(134)*y(6) + rxt(135)*y(7)
         mat(879) = mat(879) + rxt(134)*y(5)
         mat(826) = mat(826) + rxt(135)*y(5)
         mat(1016) = mat(1016) + 2.000_r8*rxt(122)*y(20)
         mat(717) = rxt(118)*y(21)
         mat(1087) = mat(1087) + rxt(118)*y(19)

         mat(1241) = -(rxt(87)*y(124) + rxt(90)*y(1) + rxt(110)*y(18) + rxt(111)*y(30) &
                      + rxt(112)*y(36) + rxt(113)*y(39))
         mat(710) = -rxt(87)*y(3)
         mat(1199) = -rxt(90)*y(3)
         mat(524) = -rxt(110)*y(3)
         mat(1262) = -rxt(111)*y(3)
         mat(410) = -rxt(112)*y(3)
         mat(91) = -rxt(113)*y(3)

         mat(518) = -(rxt(110)*y(3) + rxt(124)*y(20) + rxt(126)*y(2) + rxt(156)*y(25))
         mat(1226) = -rxt(110)*y(18)
         mat(992) = -rxt(124)*y(18)
         mat(1118) = -rxt(126)*y(18)
         mat(1142) = -rxt(156)*y(18)

         mat(712) = rxt(117)*y(21)
         mat(1063) = rxt(117)*y(19)

         mat(526) = -((rxt(211) + rxt(212)) * y(20))
         mat(993) = -(rxt(211) + rxt(212)) * y(17)

         mat(1172) = .560_r8*rxt(256)*y(56) + .300_r8*rxt(302)*y(80) &
                      + .500_r8*rxt(235)*y(41) + .050_r8*rxt(278)*y(74) &
                      + .200_r8*rxt(284)*y(75)
         mat(1119) = rxt(215)*y(16)
         mat(856) = .220_r8*rxt(285)*y(76) + .500_r8*rxt(320)*y(88)
         mat(993) = mat(993) + rxt(214)*y(16) + rxt(251)*y(50) + rxt(272)*y(65) &
                      + .350_r8*rxt(228)*y(125)
         mat(899) = rxt(213)*y(16) + .220_r8*rxt(287)*y(76) + rxt(273)*y(65) &
                      + .500_r8*rxt(321)*y(88)
         mat(732) = .110_r8*rxt(289)*y(76) + .200_r8*rxt(323)*y(88)
         mat(783) = rxt(215)*y(2) + rxt(214)*y(20) + rxt(213)*y(8) + rxt(160)*y(25) &
                      + rxt(184)*y(34)
         mat(1143) = rxt(160)*y(16)
         mat(1094) = rxt(184)*y(16)
         mat(491) = .560_r8*rxt(256)*y(1)
         mat(433) = .300_r8*rxt(302)*y(1)
         mat(684) = .220_r8*rxt(290)*y(76) + .500_r8*rxt(324)*y(88)
         mat(150) = .500_r8*rxt(235)*y(1)
         mat(325) = rxt(251)*y(20)
         mat(601) = .050_r8*rxt(278)*y(1)
         mat(560) = .200_r8*rxt(284)*y(1)
         mat(622) = .220_r8*rxt(285)*y(6) + .220_r8*rxt(287)*y(8) + .110_r8*rxt(289) &
                      *y(13) + .220_r8*rxt(290)*y(45)
         mat(573) = rxt(272)*y(20) + rxt(273)*y(8)
         mat(586) = .500_r8*rxt(320)*y(6) + .500_r8*rxt(321)*y(8) + .200_r8*rxt(323) &
                      *y(13) + .500_r8*rxt(324)*y(45)
         mat(75) = .350_r8*rxt(228)*y(20)

         mat(84) = -(rxt(134)*y(6) + (rxt(135) + rxt(136) + rxt(137)) * y(7))
         mat(832) = -rxt(134)*y(5)
         mat(799) = -(rxt(135) + rxt(136) + rxt(137)) * y(5)

         mat(874) = -(rxt(134)*y(5) + rxt(138)*y(2) + rxt(139)*y(21) + rxt(140)*y(1) &
                      + rxt(148)*y(8) + rxt(167)*y(27) + rxt(188)*y(35) + rxt(217) &
                      *y(13) + rxt(225)*y(127) + rxt(231)*y(52) + rxt(237)*y(43) &
                      + rxt(244)*y(45) + rxt(258)*y(58) + rxt(263)*y(61) + rxt(267) &
                      *y(64) + rxt(276)*y(70) + rxt(280)*y(71) + (rxt(285) + rxt(286) &
                      ) * y(76) + rxt(292)*y(73) + rxt(304)*y(85) + rxt(310)*y(86) &
                      + rxt(317)*y(81) + rxt(320)*y(88) + rxt(328)*y(93) + rxt(335) &
                      *y(97) + rxt(338)*y(100) + rxt(342)*y(103))
         mat(86) = -rxt(134)*y(6)
         mat(1125) = -rxt(138)*y(6)
         mat(1082) = -rxt(139)*y(6)
         mat(1190) = -rxt(140)*y(6)
         mat(916) = -rxt(148)*y(6)
         mat(1213) = -rxt(167)*y(6)
         mat(768) = -rxt(188)*y(6)
         mat(749) = -rxt(217)*y(6)
         mat(228) = -rxt(225)*y(6)
         mat(310) = -rxt(231)*y(6)
         mat(395) = -rxt(237)*y(6)
         mat(699) = -rxt(244)*y(6)
         mat(426) = -rxt(258)*y(6)
         mat(375) = -rxt(263)*y(6)
         mat(540) = -rxt(267)*y(6)
         mat(126) = -rxt(276)*y(6)
         mat(344) = -rxt(280)*y(6)
         mat(634) = -(rxt(285) + rxt(286)) * y(6)
         mat(673) = -rxt(292)*y(6)
         mat(656) = -rxt(304)*y(6)
         mat(514) = -rxt(310)*y(6)
         mat(359) = -rxt(317)*y(6)
         mat(596) = -rxt(320)*y(6)
         mat(278) = -rxt(328)*y(6)
         mat(169) = -rxt(335)*y(6)
         mat(214) = -rxt(338)*y(6)
         mat(484) = -rxt(342)*y(6)

         mat(1125) = mat(1125) + rxt(141)*y(7)
         mat(86) = mat(86) + 2.000_r8*rxt(136)*y(7)
         mat(821) = rxt(141)*y(2) + 2.000_r8*rxt(136)*y(5)

         mat(820) = -((rxt(135) + rxt(136) + rxt(137)) * y(5) + (rxt(141) + rxt(142) &
                      ) * y(2) + rxt(143)*y(1) + rxt(144)*y(8) + rxt(146)*y(20) &
                      + rxt(152)*y(21) + rxt(168)*y(27) + rxt(189)*y(35) + rxt(245) &
                      *y(45) + rxt(298)*y(73) + rxt(332)*y(95))
         mat(85) = -(rxt(135) + rxt(136) + rxt(137)) * y(7)
         mat(1124) = -(rxt(141) + rxt(142)) * y(7)
         mat(1189) = -rxt(143)*y(7)
         mat(915) = -rxt(144)*y(7)
         mat(1010) = -rxt(146)*y(7)
         mat(1081) = -rxt(152)*y(7)
         mat(1212) = -rxt(168)*y(7)
         mat(767) = -rxt(189)*y(7)
         mat(698) = -rxt(245)*y(7)
         mat(672) = -rxt(298)*y(7)
         mat(82) = -rxt(332)*y(7)

         mat(1189) = mat(1189) + rxt(140)*y(6)
         mat(1124) = mat(1124) + rxt(138)*y(6) + rxt(149)*y(8)
         mat(873) = rxt(140)*y(1) + rxt(138)*y(2) + 2.000_r8*rxt(148)*y(8) + rxt(217) &
                      *y(13) + rxt(139)*y(21) + rxt(167)*y(27) + rxt(188)*y(35) &
                      + rxt(263)*y(61) + rxt(244)*y(45) + rxt(276)*y(70) &
                      + .900_r8*rxt(317)*y(81) + rxt(280)*y(71) + .900_r8*rxt(328) &
                      *y(93) + rxt(342)*y(103) + .900_r8*rxt(335)*y(97) &
                      + .900_r8*rxt(338)*y(100) + .920_r8*rxt(304)*y(85) + rxt(285) &
                      *y(76) + rxt(292)*y(73) + rxt(237)*y(43) + rxt(258)*y(58) &
                      + rxt(231)*y(52) + rxt(267)*y(64) + 1.206_r8*rxt(310)*y(86) &
                      + rxt(320)*y(88) + rxt(225)*y(127)
         mat(820) = mat(820) + .700_r8*rxt(332)*y(95)
         mat(1010) = mat(1010) + rxt(150)*y(8) + rxt(153)*y(10) + rxt(274)*y(79) &
                      + .400_r8*rxt(314)*y(87)
         mat(915) = mat(915) + rxt(149)*y(2) + 2.000_r8*rxt(148)*y(6) + rxt(150)*y(20) &
                      + rxt(151)*y(21) + rxt(305)*y(85) + rxt(287)*y(76) + rxt(293) &
                      *y(73) + rxt(341)*y(102) + 1.206_r8*rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88)
         mat(193) = rxt(153)*y(20)
         mat(748) = rxt(217)*y(6)
         mat(1081) = mat(1081) + rxt(139)*y(6) + rxt(151)*y(8) + .206_r8*rxt(312) &
                      *y(86)
         mat(1212) = mat(1212) + rxt(167)*y(6)
         mat(767) = mat(767) + rxt(188)*y(6)
         mat(374) = rxt(263)*y(6)
         mat(698) = mat(698) + rxt(244)*y(6)
         mat(173) = rxt(274)*y(20)
         mat(125) = rxt(276)*y(6)
         mat(358) = .900_r8*rxt(317)*y(6)
         mat(343) = rxt(280)*y(6)
         mat(277) = .900_r8*rxt(328)*y(6)
         mat(82) = mat(82) + .700_r8*rxt(332)*y(7)
         mat(483) = rxt(342)*y(6)
         mat(168) = .900_r8*rxt(335)*y(6)
         mat(213) = .900_r8*rxt(338)*y(6)
         mat(655) = .920_r8*rxt(304)*y(6) + rxt(305)*y(8)
         mat(633) = rxt(285)*y(6) + rxt(287)*y(8)
         mat(672) = mat(672) + rxt(292)*y(6) + rxt(293)*y(8)
         mat(394) = rxt(237)*y(6)
         mat(299) = rxt(341)*y(8)
         mat(425) = rxt(258)*y(6)
         mat(309) = rxt(231)*y(6)
         mat(539) = rxt(267)*y(6)
         mat(513) = 1.206_r8*rxt(310)*y(6) + 1.206_r8*rxt(311)*y(8) + .206_r8*rxt(312) &
                      *y(21)
         mat(470) = .400_r8*rxt(314)*y(20) + rxt(315)*y(8)
         mat(595) = rxt(320)*y(6) + rxt(321)*y(8)
         mat(227) = rxt(225)*y(6)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1013) = -(rxt(119)*y(2) + rxt(120)*y(1) + rxt(121)*y(21) + (4._r8*rxt(122) &
                      + 4._r8*rxt(123)) * y(20) + rxt(124)*y(18) + rxt(125)*y(22) &
                      + rxt(131)*y(39) + rxt(132)*y(40) + rxt(146)*y(7) + rxt(147) &
                      *y(9) + rxt(150)*y(8) + rxt(153)*y(10) + (rxt(163) + rxt(164) &
                      ) * y(27) + rxt(174)*y(30) + rxt(178)*y(31) + rxt(180)*y(32) &
                      + rxt(186)*y(35) + rxt(194)*y(36) + (rxt(211) + rxt(212) &
                      ) * y(17) + rxt(214)*y(16) + rxt(221)*y(15) + rxt(222)*y(14) &
                      + rxt(223)*y(126) + rxt(228)*y(125) + rxt(229)*y(42) + rxt(230) &
                      *y(41) + rxt(236)*y(46) + rxt(241)*y(44) + rxt(242)*y(47) &
                      + rxt(249)*y(51) + rxt(250)*y(49) + rxt(251)*y(50) + rxt(252) &
                      *y(48) + rxt(254)*y(55) + rxt(255)*y(56) + rxt(261)*y(59) &
                      + rxt(262)*y(57) + rxt(265)*y(62) + rxt(266)*y(60) + rxt(270) &
                      *y(66) + rxt(271)*y(63) + rxt(272)*y(65) + rxt(274)*y(79) &
                      + rxt(275)*y(67) + rxt(277)*y(74) + rxt(279)*y(69) + rxt(282) &
                      *y(72) + rxt(283)*y(75) + rxt(291)*y(77) + rxt(300)*y(78) &
                      + rxt(301)*y(80) + rxt(307)*y(90) + rxt(313)*y(68) + rxt(314) &
                      *y(87) + rxt(316)*y(84) + rxt(319)*y(82) + rxt(325)*y(89) &
                      + rxt(327)*y(91) + rxt(330)*y(94) + rxt(331)*y(92) + rxt(333) &
                      *y(96) + rxt(336)*y(99) + rxt(339)*y(102) + rxt(344)*y(104) &
                      + rxt(350)*y(142) + (rxt(351) + rxt(352)) * y(143) + rxt(354) &
                      *y(145))
         mat(1127) = -rxt(119)*y(20)
         mat(1192) = -rxt(120)*y(20)
         mat(1084) = -rxt(121)*y(20)
         mat(521) = -rxt(124)*y(20)
         mat(319) = -rxt(125)*y(20)
         mat(89) = -rxt(131)*y(20)
         mat(46) = -rxt(132)*y(20)
         mat(823) = -rxt(146)*y(20)
         mat(415) = -rxt(147)*y(20)
         mat(918) = -rxt(150)*y(20)
         mat(195) = -rxt(153)*y(20)
         mat(1215) = -(rxt(163) + rxt(164)) * y(20)
         mat(1255) = -rxt(174)*y(20)
         mat(448) = -rxt(178)*y(20)
         mat(460) = -rxt(180)*y(20)
         mat(770) = -rxt(186)*y(20)
         mat(407) = -rxt(194)*y(20)
         mat(528) = -(rxt(211) + rxt(212)) * y(20)
         mat(790) = -rxt(214)*y(20)
         mat(246) = -rxt(221)*y(20)
         mat(202) = -rxt(222)*y(20)
         mat(189) = -rxt(223)*y(20)
         mat(76) = -rxt(228)*y(20)
         mat(112) = -rxt(229)*y(20)
         mat(152) = -rxt(230)*y(20)
         mat(316) = -rxt(236)*y(20)
         mat(141) = -rxt(241)*y(20)
         mat(558) = -rxt(242)*y(20)
         mat(243) = -rxt(249)*y(20)
         mat(402) = -rxt(250)*y(20)
         mat(326) = -rxt(251)*y(20)
         mat(103) = -rxt(252)*y(20)
         mat(237) = -rxt(254)*y(20)
         mat(501) = -rxt(255)*y(20)
         mat(179) = -rxt(261)*y(20)
         mat(54) = -rxt(262)*y(20)
         mat(293) = -rxt(265)*y(20)
         mat(367) = -rxt(266)*y(20)
         mat(186) = -rxt(270)*y(20)
         mat(547) = -rxt(271)*y(20)
         mat(580) = -rxt(272)*y(20)
         mat(174) = -rxt(274)*y(20)
         mat(35) = -rxt(275)*y(20)
         mat(615) = -rxt(277)*y(20)
         mat(207) = -rxt(279)*y(20)
         mat(132) = -rxt(282)*y(20)
         mat(569) = -rxt(283)*y(20)
         mat(136) = -rxt(291)*y(20)
         mat(270) = -rxt(300)*y(20)
         mat(442) = -rxt(301)*y(20)
         mat(254) = -rxt(307)*y(20)
         mat(32) = -rxt(313)*y(20)
         mat(472) = -rxt(314)*y(20)
         mat(157) = -rxt(316)*y(20)
         mat(337) = -rxt(319)*y(20)
         mat(146) = -rxt(325)*y(20)
         mat(61) = -rxt(327)*y(20)
         mat(163) = -rxt(330)*y(20)
         mat(65) = -rxt(331)*y(20)
         mat(38) = -rxt(333)*y(20)
         mat(41) = -rxt(336)*y(20)
         mat(301) = -rxt(339)*y(20)
         mat(221) = -rxt(344)*y(20)
         mat(57) = -rxt(350)*y(20)
         mat(99) = -(rxt(351) + rxt(352)) * y(20)
         mat(44) = -rxt(354)*y(20)

         mat(1192) = mat(1192) + rxt(115)*y(19) + rxt(128)*y(21) + .330_r8*rxt(256) &
                      *y(56) + .270_r8*rxt(302)*y(80) + .120_r8*rxt(235)*y(41) &
                      + .080_r8*rxt(278)*y(74) + .215_r8*rxt(284)*y(75) &
                      + .700_r8*rxt(340)*y(102)
         mat(1127) = mat(1127) + rxt(126)*y(18) + rxt(215)*y(16) + rxt(127)*y(21) &
                      + rxt(130)*y(22) + rxt(175)*y(30) + rxt(176)*y(31) + rxt(195) &
                      *y(36) + rxt(196)*y(37)
         mat(1234) = rxt(110)*y(18) + rxt(113)*y(39) + 2.000_r8*rxt(87)*y(124) &
                      + rxt(111)*y(30) + rxt(112)*y(36)
         mat(521) = mat(521) + rxt(126)*y(2) + rxt(110)*y(3)
         mat(876) = rxt(139)*y(21)
         mat(1013) = mat(1013) + .300_r8*rxt(222)*y(14) + .500_r8*rxt(265)*y(62) &
                      + .100_r8*rxt(291)*y(77) + .500_r8*rxt(241)*y(44) &
                      + .650_r8*rxt(228)*y(125)
         mat(918) = mat(918) + rxt(151)*y(21)
         mat(202) = mat(202) + .300_r8*rxt(222)*y(20)
         mat(89) = mat(89) + rxt(113)*y(3)
         mat(790) = mat(790) + rxt(215)*y(2)
         mat(715) = rxt(115)*y(1) + 2.000_r8*rxt(116)*y(21)
         mat(1084) = mat(1084) + rxt(128)*y(1) + rxt(127)*y(2) + rxt(139)*y(6) &
                      + rxt(151)*y(8) + 2.000_r8*rxt(116)*y(19) + rxt(159)*y(25)
         mat(319) = mat(319) + rxt(130)*y(2)
         mat(707) = 2.000_r8*rxt(87)*y(3)
         mat(1153) = rxt(159)*y(21)
         mat(1255) = mat(1255) + rxt(175)*y(2) + rxt(111)*y(3)
         mat(448) = mat(448) + rxt(176)*y(2)
         mat(407) = mat(407) + rxt(195)*y(2) + rxt(112)*y(3)
         mat(382) = rxt(196)*y(2)
         mat(501) = mat(501) + .330_r8*rxt(256)*y(1)
         mat(442) = mat(442) + .270_r8*rxt(302)*y(1)
         mat(293) = mat(293) + .500_r8*rxt(265)*y(20)
         mat(152) = mat(152) + .120_r8*rxt(235)*y(1)
         mat(615) = mat(615) + .080_r8*rxt(278)*y(1)
         mat(569) = mat(569) + .215_r8*rxt(284)*y(1)
         mat(136) = mat(136) + .100_r8*rxt(291)*y(20)
         mat(141) = mat(141) + .500_r8*rxt(241)*y(20)
         mat(301) = mat(301) + .700_r8*rxt(340)*y(1)
         mat(76) = mat(76) + .650_r8*rxt(228)*y(20)

         mat(917) = -(rxt(144)*y(7) + rxt(148)*y(6) + rxt(149)*y(2) + rxt(150)*y(20) &
                      + rxt(151)*y(21) + rxt(213)*y(16) + rxt(243)*y(47) + rxt(257) &
                      *y(56) + rxt(273)*y(65) + rxt(287)*y(76) + rxt(293)*y(73) &
                      + rxt(303)*y(80) + rxt(305)*y(85) + rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88) + rxt(341)*y(102) + rxt(353)*y(143))
         mat(822) = -rxt(144)*y(8)
         mat(875) = -rxt(148)*y(8)
         mat(1126) = -rxt(149)*y(8)
         mat(1012) = -rxt(150)*y(8)
         mat(1083) = -rxt(151)*y(8)
         mat(789) = -rxt(213)*y(8)
         mat(557) = -rxt(243)*y(8)
         mat(500) = -rxt(257)*y(8)
         mat(579) = -rxt(273)*y(8)
         mat(635) = -rxt(287)*y(8)
         mat(674) = -rxt(293)*y(8)
         mat(441) = -rxt(303)*y(8)
         mat(657) = -rxt(305)*y(8)
         mat(515) = -rxt(311)*y(8)
         mat(471) = -rxt(315)*y(8)
         mat(597) = -rxt(321)*y(8)
         mat(300) = -rxt(341)*y(8)
         mat(98) = -rxt(353)*y(8)

         mat(1191) = rxt(143)*y(7)
         mat(1126) = mat(1126) + rxt(142)*y(7) + rxt(179)*y(32) + rxt(197)*y(38)
         mat(822) = mat(822) + rxt(143)*y(1) + rxt(142)*y(2)
         mat(1012) = mat(1012) + rxt(147)*y(9) + rxt(180)*y(32) + rxt(254)*y(55) &
                      + .500_r8*rxt(300)*y(78)
         mat(414) = rxt(147)*y(20)
         mat(1152) = rxt(181)*y(32)
         mat(459) = rxt(179)*y(2) + rxt(180)*y(20) + rxt(181)*y(25)
         mat(261) = rxt(197)*y(2)
         mat(236) = rxt(254)*y(20)
         mat(269) = .500_r8*rxt(300)*y(20)

         mat(411) = -(rxt(147)*y(20))
         mat(983) = -rxt(147)*y(9)

         mat(808) = rxt(146)*y(20)
         mat(983) = mat(983) + rxt(146)*y(7)
         mat(893) = rxt(213)*y(16) + rxt(243)*y(47) + rxt(273)*y(65) + rxt(353)*y(143)
         mat(781) = rxt(213)*y(8)
         mat(1246) = (rxt(360)+rxt(365)+rxt(371))*y(32)
         mat(454) = (rxt(360)+rxt(365)+rxt(371))*y(30)
         mat(549) = rxt(243)*y(8)
         mat(572) = rxt(273)*y(8)
         mat(97) = rxt(353)*y(8)

         mat(191) = -(rxt(153)*y(20))
         mat(957) = -rxt(153)*y(10)

         mat(801) = rxt(152)*y(21)
         mat(1035) = rxt(152)*y(7)


         mat(800) = rxt(144)*y(8)
         mat(887) = rxt(144)*y(7)

         mat(746) = -(rxt(166)*y(27) + rxt(217)*y(6) + rxt(218)*y(21) + (4._r8*rxt(219) &
                      + 4._r8*rxt(220)) * y(13) + rxt(239)*y(43) + rxt(247)*y(45) &
                      + rxt(260)*y(58) + rxt(269)*y(64) + rxt(289)*y(76) + rxt(295) &
                      *y(73) + rxt(308)*y(85) + rxt(323)*y(88))
         mat(1209) = -rxt(166)*y(13)
         mat(870) = -rxt(217)*y(13)
         mat(1078) = -rxt(218)*y(13)
         mat(392) = -rxt(239)*y(13)
         mat(696) = -rxt(247)*y(13)
         mat(423) = -rxt(260)*y(13)
         mat(537) = -rxt(269)*y(13)
         mat(631) = -rxt(289)*y(13)
         mat(670) = -rxt(295)*y(13)
         mat(653) = -rxt(308)*y(13)
         mat(593) = -rxt(323)*y(13)

         mat(1186) = .310_r8*rxt(256)*y(56)
         mat(870) = mat(870) + rxt(244)*y(45)
         mat(1007) = .700_r8*rxt(222)*y(14) + rxt(236)*y(46)
         mat(746) = mat(746) + .900_r8*rxt(247)*y(45)
         mat(200) = .700_r8*rxt(222)*y(20)
         mat(496) = .310_r8*rxt(256)*y(1)
         mat(315) = rxt(236)*y(20)
         mat(696) = mat(696) + rxt(244)*y(6) + .900_r8*rxt(247)*y(13) &
                      + 4.000_r8*rxt(248)*y(45) + rxt(309)*y(85) + rxt(290)*y(76) &
                      + rxt(296)*y(73) + rxt(324)*y(88)
         mat(653) = mat(653) + rxt(309)*y(45)
         mat(631) = mat(631) + rxt(290)*y(45)
         mat(670) = mat(670) + rxt(296)*y(45)
         mat(593) = mat(593) + rxt(324)*y(45)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(197) = -(rxt(222)*y(20))
         mat(958) = -rxt(222)*y(14)

         mat(724) = rxt(218)*y(21)
         mat(1036) = rxt(218)*y(13)

         mat(88) = -(rxt(113)*y(3) + rxt(131)*y(20))
         mat(1224) = -rxt(113)*y(39)
         mat(940) = -rxt(131)*y(39)

         mat(45) = -(rxt(132)*y(20))
         mat(933) = -rxt(132)*y(40)

         mat(786) = -(rxt(160)*y(25) + rxt(184)*y(34) + rxt(213)*y(8) + rxt(214)*y(20) &
                      + rxt(215)*y(2) + rxt(216)*y(21))
         mat(1149) = -rxt(160)*y(16)
         mat(1098) = -rxt(184)*y(16)
         mat(914) = -rxt(213)*y(16)
         mat(1009) = -rxt(214)*y(16)
         mat(1123) = -rxt(215)*y(16)
         mat(1080) = -rxt(216)*y(16)

         mat(1188) = .540_r8*rxt(256)*y(56) + .600_r8*rxt(302)*y(80) + rxt(235)*y(41) &
                      + .800_r8*rxt(278)*y(74) + .700_r8*rxt(284)*y(75)
         mat(872) = rxt(217)*y(13) + rxt(263)*y(61) + .500_r8*rxt(276)*y(70) &
                      + .100_r8*rxt(317)*y(81) + .510_r8*rxt(304)*y(85) &
                      + .250_r8*rxt(285)*y(76) + rxt(292)*y(73) + .500_r8*rxt(231) &
                      *y(52) + rxt(267)*y(64) + .072_r8*rxt(310)*y(86)
         mat(1009) = mat(1009) + .300_r8*rxt(222)*y(14) + .500_r8*rxt(249)*y(51) &
                      + rxt(254)*y(55) + .500_r8*rxt(300)*y(78) + rxt(221)*y(15) &
                      + .800_r8*rxt(250)*y(49)
         mat(914) = mat(914) + .600_r8*rxt(305)*y(85) + .250_r8*rxt(287)*y(76) &
                      + rxt(293)*y(73) + .072_r8*rxt(311)*y(86)
         mat(747) = rxt(217)*y(6) + (4.000_r8*rxt(219)+2.000_r8*rxt(220))*y(13) &
                      + rxt(166)*y(27) + rxt(247)*y(45) + 1.200_r8*rxt(308)*y(85) &
                      + .880_r8*rxt(289)*y(76) + 2.000_r8*rxt(295)*y(73) &
                      + .700_r8*rxt(239)*y(43) + rxt(260)*y(58) + .800_r8*rxt(269) &
                      *y(64) + .700_r8*rxt(323)*y(88)
         mat(201) = .300_r8*rxt(222)*y(20)
         mat(1080) = mat(1080) + .008_r8*rxt(312)*y(86)
         mat(1211) = rxt(166)*y(13)
         mat(497) = .540_r8*rxt(256)*y(1)
         mat(440) = .600_r8*rxt(302)*y(1)
         mat(373) = rxt(263)*y(6)
         mat(697) = rxt(247)*y(13) + .600_r8*rxt(309)*y(85) + .250_r8*rxt(290)*y(76) &
                      + rxt(296)*y(73)
         mat(242) = .500_r8*rxt(249)*y(20)
         mat(234) = rxt(254)*y(20)
         mat(151) = rxt(235)*y(1)
         mat(267) = .500_r8*rxt(300)*y(20)
         mat(124) = .500_r8*rxt(276)*y(6)
         mat(357) = .100_r8*rxt(317)*y(6)
         mat(654) = .510_r8*rxt(304)*y(6) + .600_r8*rxt(305)*y(8) + 1.200_r8*rxt(308) &
                      *y(13) + .600_r8*rxt(309)*y(45)
         mat(611) = .800_r8*rxt(278)*y(1)
         mat(568) = .700_r8*rxt(284)*y(1)
         mat(632) = .250_r8*rxt(285)*y(6) + .250_r8*rxt(287)*y(8) + .880_r8*rxt(289) &
                      *y(13) + .250_r8*rxt(290)*y(45)
         mat(671) = rxt(292)*y(6) + rxt(293)*y(8) + 2.000_r8*rxt(295)*y(13) + rxt(296) &
                      *y(45) + 4.000_r8*rxt(297)*y(73)
         mat(393) = .700_r8*rxt(239)*y(13)
         mat(424) = rxt(260)*y(13)
         mat(245) = rxt(221)*y(20)
         mat(401) = .800_r8*rxt(250)*y(20)
         mat(308) = .500_r8*rxt(231)*y(6)
         mat(538) = rxt(267)*y(6) + .800_r8*rxt(269)*y(13)
         mat(512) = .072_r8*rxt(310)*y(6) + .072_r8*rxt(311)*y(8) + .008_r8*rxt(312) &
                      *y(21)
         mat(594) = .700_r8*rxt(323)*y(13)

         mat(714) = -(rxt(115)*y(1) + (rxt(116) + rxt(117) + rxt(118)) * y(21))
         mat(1185) = -rxt(115)*y(19)
         mat(1077) = -(rxt(116) + rxt(117) + rxt(118)) * y(19)

         mat(1121) = rxt(126)*y(18) + rxt(119)*y(20)
         mat(1228) = rxt(110)*y(18)
         mat(520) = rxt(126)*y(2) + rxt(110)*y(3) + rxt(124)*y(20) + rxt(156)*y(25)
         mat(527) = rxt(211)*y(20)
         mat(1006) = rxt(119)*y(2) + rxt(124)*y(18) + rxt(211)*y(17) + rxt(214)*y(16)
         mat(785) = rxt(214)*y(20)
         mat(1147) = rxt(156)*y(18)

         mat(1085) = -((rxt(116) + rxt(117) + rxt(118)) * y(19) + rxt(121)*y(20) &
                      + rxt(127)*y(2) + rxt(128)*y(1) + 4._r8*rxt(129)*y(21) + rxt(139) &
                      *y(6) + rxt(151)*y(8) + rxt(152)*y(7) + (rxt(158) + rxt(159) &
                      ) * y(25) + rxt(165)*y(27) + rxt(183)*y(34) + rxt(187)*y(35) &
                      + rxt(216)*y(16) + rxt(218)*y(13) + rxt(226)*y(127) + rxt(232) &
                      *y(52) + rxt(238)*y(43) + rxt(246)*y(45) + rxt(259)*y(58) &
                      + rxt(264)*y(61) + rxt(268)*y(64) + rxt(281)*y(71) + rxt(288) &
                      *y(76) + rxt(294)*y(73) + rxt(306)*y(85) + rxt(312)*y(86) &
                      + rxt(318)*y(81) + rxt(322)*y(88) + rxt(329)*y(93) + rxt(334) &
                      *y(97) + rxt(337)*y(100) + rxt(343)*y(103))
         mat(716) = -(rxt(116) + rxt(117) + rxt(118)) * y(21)
         mat(1014) = -rxt(121)*y(21)
         mat(1128) = -rxt(127)*y(21)
         mat(1193) = -rxt(128)*y(21)
         mat(877) = -rxt(139)*y(21)
         mat(919) = -rxt(151)*y(21)
         mat(824) = -rxt(152)*y(21)
         mat(1154) = -(rxt(158) + rxt(159)) * y(21)
         mat(1216) = -rxt(165)*y(21)
         mat(1103) = -rxt(183)*y(21)
         mat(771) = -rxt(187)*y(21)
         mat(791) = -rxt(216)*y(21)
         mat(752) = -rxt(218)*y(21)
         mat(230) = -rxt(226)*y(21)
         mat(312) = -rxt(232)*y(21)
         mat(397) = -rxt(238)*y(21)
         mat(702) = -rxt(246)*y(21)
         mat(428) = -rxt(259)*y(21)
         mat(377) = -rxt(264)*y(21)
         mat(542) = -rxt(268)*y(21)
         mat(346) = -rxt(281)*y(21)
         mat(637) = -rxt(288)*y(21)
         mat(676) = -rxt(294)*y(21)
         mat(659) = -rxt(306)*y(21)
         mat(517) = -rxt(312)*y(21)
         mat(361) = -rxt(318)*y(21)
         mat(599) = -rxt(322)*y(21)
         mat(280) = -rxt(329)*y(21)
         mat(170) = -rxt(334)*y(21)
         mat(215) = -rxt(337)*y(21)
         mat(486) = -rxt(343)*y(21)

         mat(1193) = mat(1193) + rxt(120)*y(20) + .190_r8*rxt(256)*y(56) &
                      + .060_r8*rxt(302)*y(80) + .120_r8*rxt(235)*y(41) &
                      + .060_r8*rxt(278)*y(74) + .275_r8*rxt(284)*y(75) + rxt(340) &
                      *y(102)
         mat(1128) = mat(1128) + rxt(215)*y(16) + rxt(130)*y(22)
         mat(529) = rxt(212)*y(20)
         mat(877) = mat(877) + rxt(217)*y(13) + rxt(263)*y(61) + rxt(276)*y(70) &
                      + .900_r8*rxt(317)*y(81) + .900_r8*rxt(328)*y(93) + rxt(342) &
                      *y(103) + .900_r8*rxt(335)*y(97) + .900_r8*rxt(338)*y(100) &
                      + rxt(304)*y(85) + .470_r8*rxt(285)*y(76) + rxt(237)*y(43) &
                      + rxt(258)*y(58) + .250_r8*rxt(231)*y(52) + .794_r8*rxt(310) &
                      *y(86) + rxt(320)*y(88) + rxt(225)*y(127)
         mat(824) = mat(824) + .700_r8*rxt(332)*y(95)
         mat(1014) = mat(1014) + rxt(120)*y(1) + rxt(212)*y(17) + rxt(150)*y(8) &
                      + rxt(131)*y(39) + rxt(132)*y(40) + rxt(125)*y(22) + rxt(163) &
                      *y(27) + rxt(186)*y(35) + .500_r8*rxt(300)*y(78) &
                      + .250_r8*rxt(327)*y(91) + rxt(251)*y(50) + .200_r8*rxt(291) &
                      *y(77) + rxt(221)*y(15) + rxt(252)*y(48) + rxt(250)*y(49) &
                      + rxt(271)*y(63) + rxt(314)*y(87) + .350_r8*rxt(228)*y(125) &
                      + rxt(223)*y(126) + .500_r8*rxt(352)*y(143)
         mat(919) = mat(919) + rxt(150)*y(20) + rxt(213)*y(16) + rxt(305)*y(85) &
                      + .470_r8*rxt(287)*y(76) + .794_r8*rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88)
         mat(752) = mat(752) + rxt(217)*y(6) + 4.000_r8*rxt(219)*y(13) + rxt(166) &
                      *y(27) + .900_r8*rxt(247)*y(45) + rxt(308)*y(85) &
                      + .730_r8*rxt(289)*y(76) + rxt(295)*y(73) + rxt(239)*y(43) &
                      + rxt(260)*y(58) + .300_r8*rxt(269)*y(64) + .800_r8*rxt(323) &
                      *y(88)
         mat(90) = rxt(131)*y(20)
         mat(47) = rxt(132)*y(20)
         mat(791) = mat(791) + rxt(215)*y(2) + rxt(213)*y(8) + rxt(160)*y(25) &
                      + rxt(184)*y(34)
         mat(1085) = mat(1085) + .794_r8*rxt(312)*y(86)
         mat(320) = rxt(130)*y(2) + rxt(125)*y(20) + rxt(157)*y(25)
         mat(1154) = mat(1154) + rxt(160)*y(16) + rxt(157)*y(22)
         mat(1216) = mat(1216) + rxt(163)*y(20) + rxt(166)*y(13)
         mat(1103) = mat(1103) + rxt(184)*y(16)
         mat(771) = mat(771) + rxt(186)*y(20)
         mat(502) = .190_r8*rxt(256)*y(1)
         mat(443) = .060_r8*rxt(302)*y(1)
         mat(377) = mat(377) + rxt(263)*y(6)
         mat(702) = mat(702) + .900_r8*rxt(247)*y(13) + rxt(309)*y(85) &
                      + .470_r8*rxt(290)*y(76) + rxt(324)*y(88)
         mat(153) = .120_r8*rxt(235)*y(1)
         mat(271) = .500_r8*rxt(300)*y(20)
         mat(127) = rxt(276)*y(6)
         mat(361) = mat(361) + .900_r8*rxt(317)*y(6)
         mat(62) = .250_r8*rxt(327)*y(20)
         mat(280) = mat(280) + .900_r8*rxt(328)*y(6)
         mat(83) = .700_r8*rxt(332)*y(7)
         mat(486) = mat(486) + rxt(342)*y(6)
         mat(327) = rxt(251)*y(20)
         mat(170) = mat(170) + .900_r8*rxt(335)*y(6)
         mat(215) = mat(215) + .900_r8*rxt(338)*y(6)
         mat(659) = mat(659) + rxt(304)*y(6) + rxt(305)*y(8) + rxt(308)*y(13) &
                      + rxt(309)*y(45)
         mat(616) = .060_r8*rxt(278)*y(1)
         mat(570) = .275_r8*rxt(284)*y(1)
         mat(637) = mat(637) + .470_r8*rxt(285)*y(6) + .470_r8*rxt(287)*y(8) &
                      + .730_r8*rxt(289)*y(13) + .470_r8*rxt(290)*y(45)
         mat(137) = .200_r8*rxt(291)*y(20)
         mat(676) = mat(676) + rxt(295)*y(13)
         mat(397) = mat(397) + rxt(237)*y(6) + rxt(239)*y(13) + 2.400_r8*rxt(240) &
                      *y(43)
         mat(302) = rxt(340)*y(1)
         mat(428) = mat(428) + rxt(258)*y(6) + rxt(260)*y(13)
         mat(247) = rxt(221)*y(20)
         mat(104) = rxt(252)*y(20)
         mat(403) = rxt(250)*y(20)
         mat(548) = rxt(271)*y(20)
         mat(312) = mat(312) + .250_r8*rxt(231)*y(6)
         mat(542) = mat(542) + .300_r8*rxt(269)*y(13)
         mat(517) = mat(517) + .794_r8*rxt(310)*y(6) + .794_r8*rxt(311)*y(8) &
                      + .794_r8*rxt(312)*y(21)
         mat(473) = rxt(314)*y(20) + rxt(315)*y(8)
         mat(599) = mat(599) + rxt(320)*y(6) + rxt(321)*y(8) + .800_r8*rxt(323)*y(13) &
                      + rxt(324)*y(45)
         mat(77) = .350_r8*rxt(228)*y(20)
         mat(190) = rxt(223)*y(20)
         mat(230) = mat(230) + rxt(225)*y(6)
         mat(100) = .500_r8*rxt(352)*y(20)

         mat(317) = -(rxt(125)*y(20) + rxt(130)*y(2) + rxt(157)*y(25))
         mat(973) = -rxt(125)*y(22)
         mat(1112) = -rxt(130)*y(22)
         mat(1138) = -rxt(157)*y(22)

         mat(973) = mat(973) + 2.000_r8*rxt(123)*y(20)
         mat(1047) = 2.000_r8*rxt(129)*y(21)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(705) = -(rxt(87)*y(3))
         mat(1227) = -rxt(87)*y(124)

         mat(519) = rxt(124)*y(20)
         mat(1005) = rxt(124)*y(18) + 2.000_r8*rxt(122)*y(20) + rxt(147)*y(9) &
                      + rxt(153)*y(10) + rxt(222)*y(14) + rxt(214)*y(16) + rxt(121) &
                      *y(21) + rxt(125)*y(22) + rxt(174)*y(30) + rxt(178)*y(31) &
                      + rxt(194)*y(36) + rxt(242)*y(47) + rxt(236)*y(46) + rxt(265) &
                      *y(62) + rxt(249)*y(51) + rxt(229)*y(42) + .500_r8*rxt(283) &
                      *y(75) + rxt(262)*y(57) + rxt(261)*y(59) + rxt(266)*y(60) &
                      + rxt(270)*y(66) + rxt(272)*y(65) + (rxt(325)+rxt(326))*y(89) &
                      + rxt(223)*y(126) + rxt(354)*y(145)
         mat(412) = rxt(147)*y(20)
         mat(192) = rxt(153)*y(20)
         mat(198) = rxt(222)*y(20)
         mat(784) = rxt(214)*y(20)
         mat(713) = rxt(118)*y(21)
         mat(1076) = rxt(121)*y(20) + rxt(118)*y(19)
         mat(318) = rxt(125)*y(20)
         mat(1249) = rxt(174)*y(20) + (rxt(361)+rxt(366)+rxt(372))*y(31) + (rxt(362) &
                       +rxt(373))*y(37)
         mat(447) = rxt(178)*y(20) + (rxt(361)+rxt(366)+rxt(372))*y(30)
         mat(405) = rxt(194)*y(20)
         mat(380) = (rxt(362)+rxt(373))*y(30)
         mat(553) = rxt(242)*y(20)
         mat(314) = rxt(236)*y(20)
         mat(291) = rxt(265)*y(20)
         mat(240) = rxt(249)*y(20)
         mat(111) = rxt(229)*y(20)
         mat(566) = .500_r8*rxt(283)*y(20)
         mat(53) = rxt(262)*y(20)
         mat(178) = rxt(261)*y(20)
         mat(365) = rxt(266)*y(20)
         mat(184) = rxt(270)*y(20)
         mat(576) = rxt(272)*y(20)
         mat(145) = (rxt(325)+rxt(326))*y(20)
         mat(188) = rxt(223)*y(20)
         mat(43) = rxt(354)*y(20)

         mat(1157) = -(rxt(155)*y(1) + rxt(156)*y(18) + rxt(157)*y(22) + (rxt(158) &
                      + rxt(159)) * y(21) + rxt(160)*y(16) + rxt(177)*y(31) + rxt(181) &
                      *y(32) + rxt(227)*y(42))
         mat(1196) = -rxt(155)*y(25)
         mat(523) = -rxt(156)*y(25)
         mat(322) = -rxt(157)*y(25)
         mat(1088) = -(rxt(158) + rxt(159)) * y(25)
         mat(794) = -rxt(160)*y(25)
         mat(450) = -rxt(177)*y(25)
         mat(462) = -rxt(181)*y(25)
         mat(113) = -rxt(227)*y(25)

         mat(1131) = rxt(162)*y(27) + rxt(175)*y(30)
         mat(1238) = rxt(111)*y(30)
         mat(880) = rxt(167)*y(27)
         mat(1017) = rxt(163)*y(27) + rxt(174)*y(30)
         mat(754) = rxt(166)*y(27)
         mat(1219) = rxt(162)*y(2) + rxt(167)*y(6) + rxt(163)*y(20) + rxt(166)*y(13) + ( &
                      + 4.000_r8*rxt(169)+2.000_r8*rxt(171))*y(27) + rxt(191)*y(35)
         mat(1259) = rxt(175)*y(2) + rxt(111)*y(3) + rxt(174)*y(20)
         mat(774) = rxt(191)*y(27)


         mat(1136) = rxt(181)*y(32)
         mat(1203) = 2.000_r8*rxt(170)*y(27)
         mat(1243) = (rxt(361)+rxt(366)+rxt(372))*y(31) + (rxt(360)+rxt(365)+rxt(371)) &
                      *y(32)
         mat(445) = (rxt(361)+rxt(366)+rxt(372))*y(30)
         mat(453) = rxt(181)*y(25) + (rxt(360)+rxt(365)+rxt(371))*y(30)

         mat(1221) = -(rxt(162)*y(2) + (rxt(163) + rxt(164)) * y(20) + rxt(165)*y(21) &
                      + rxt(166)*y(13) + rxt(167)*y(6) + rxt(168)*y(7) + (4._r8*rxt(169) &
                      + 4._r8*rxt(170) + 4._r8*rxt(171) + 4._r8*rxt(172)) * y(27) &
                      + (rxt(190) + rxt(191) + rxt(192)) * y(35))
         mat(1133) = -rxt(162)*y(27)
         mat(1019) = -(rxt(163) + rxt(164)) * y(27)
         mat(1090) = -rxt(165)*y(27)
         mat(756) = -rxt(166)*y(27)
         mat(882) = -rxt(167)*y(27)
         mat(829) = -rxt(168)*y(27)
         mat(776) = -(rxt(190) + rxt(191) + rxt(192)) * y(27)

         mat(1198) = rxt(155)*y(25)
         mat(1133) = mat(1133) + rxt(176)*y(31) + rxt(179)*y(32)
         mat(1019) = mat(1019) + rxt(178)*y(31)
         mat(1090) = mat(1090) + rxt(159)*y(25)
         mat(1159) = rxt(155)*y(1) + rxt(159)*y(21) + rxt(177)*y(31)
         mat(451) = rxt(176)*y(2) + rxt(178)*y(20) + rxt(177)*y(25)
         mat(463) = rxt(179)*y(2)


         mat(1202) = 2.000_r8*rxt(171)*y(27) + rxt(190)*y(35)
         mat(759) = rxt(190)*y(27)


         mat(1201) = 2.000_r8*rxt(172)*y(27)

         mat(1263) = -(rxt(111)*y(3) + rxt(174)*y(20) + rxt(175)*y(2) + (rxt(360) &
                      + rxt(365) + rxt(371)) * y(32) + (rxt(361) + rxt(366) + rxt(372) &
                      ) * y(31) + (rxt(362) + rxt(373)) * y(37))
         mat(1242) = -rxt(111)*y(30)
         mat(1021) = -rxt(174)*y(30)
         mat(1135) = -rxt(175)*y(30)
         mat(464) = -(rxt(360) + rxt(365) + rxt(371)) * y(30)
         mat(452) = -(rxt(361) + rxt(366) + rxt(372)) * y(30)
         mat(386) = -(rxt(362) + rxt(373)) * y(30)

         mat(525) = rxt(156)*y(25)
         mat(1021) = mat(1021) + rxt(164)*y(27)
         mat(797) = rxt(160)*y(25)
         mat(1092) = rxt(158)*y(25)
         mat(323) = rxt(157)*y(25)
         mat(1161) = rxt(156)*y(18) + rxt(160)*y(16) + rxt(158)*y(21) + rxt(157)*y(22) &
                      + rxt(177)*y(31) + rxt(227)*y(42)
         mat(1223) = rxt(164)*y(20)
         mat(452) = mat(452) + rxt(177)*y(25)
         mat(114) = rxt(227)*y(25)

         mat(446) = -(rxt(176)*y(2) + rxt(177)*y(25) + rxt(178)*y(20) + (rxt(361) &
                      + rxt(366) + rxt(372)) * y(30))
         mat(1116) = -rxt(176)*y(31)
         mat(1140) = -rxt(177)*y(31)
         mat(986) = -rxt(178)*y(31)
         mat(1247) = -(rxt(361) + rxt(366) + rxt(372)) * y(31)

         mat(986) = mat(986) + rxt(180)*y(32)
         mat(1059) = rxt(165)*y(27)
         mat(1205) = rxt(165)*y(21)
         mat(455) = rxt(180)*y(20)

         mat(456) = -(rxt(179)*y(2) + rxt(180)*y(20) + rxt(181)*y(25) + (rxt(360) &
                      + rxt(365) + rxt(371)) * y(30))
         mat(1117) = -rxt(179)*y(32)
         mat(987) = -rxt(180)*y(32)
         mat(1141) = -rxt(181)*y(32)
         mat(1248) = -(rxt(360) + rxt(365) + rxt(371)) * y(32)

         mat(809) = rxt(168)*y(27)
         mat(1206) = rxt(168)*y(7)


         mat(1204) = rxt(192)*y(35)
         mat(1244) = (rxt(362)+rxt(373))*y(37)
         mat(760) = rxt(192)*y(27)
         mat(378) = (rxt(362)+rxt(373))*y(30)

         mat(1104) = -(rxt(182)*y(1) + rxt(183)*y(21) + rxt(184)*y(16))
         mat(1194) = -rxt(182)*y(34)
         mat(1086) = -rxt(183)*y(34)
         mat(792) = -rxt(184)*y(34)

         mat(1129) = rxt(185)*y(35) + rxt(195)*y(36)
         mat(1236) = rxt(112)*y(36)
         mat(878) = rxt(188)*y(35)
         mat(1015) = rxt(186)*y(35) + rxt(194)*y(36)
         mat(1217) = (rxt(190)+rxt(191))*y(35)
         mat(772) = rxt(185)*y(2) + rxt(188)*y(6) + rxt(186)*y(20) + (rxt(190) &
                       +rxt(191))*y(27) + 4.000_r8*rxt(193)*y(35)
         mat(408) = rxt(195)*y(2) + rxt(112)*y(3) + rxt(194)*y(20)

         mat(766) = -(rxt(185)*y(2) + rxt(186)*y(20) + rxt(187)*y(21) + rxt(188)*y(6) &
                      + rxt(189)*y(7) + (rxt(190) + rxt(191) + rxt(192)) * y(27) &
                      + 4._r8*rxt(193)*y(35))
         mat(1122) = -rxt(185)*y(35)
         mat(1008) = -rxt(186)*y(35)
         mat(1079) = -rxt(187)*y(35)
         mat(871) = -rxt(188)*y(35)
         mat(818) = -rxt(189)*y(35)
         mat(1210) = -(rxt(190) + rxt(191) + rxt(192)) * y(35)

         mat(1187) = rxt(182)*y(34)
         mat(1122) = mat(1122) + rxt(196)*y(37) + rxt(197)*y(38)
         mat(1097) = rxt(182)*y(1)
         mat(381) = rxt(196)*y(2)
         mat(259) = rxt(197)*y(2)

         mat(404) = -(rxt(112)*y(3) + rxt(194)*y(20) + rxt(195)*y(2))
         mat(1225) = -rxt(112)*y(36)
         mat(982) = -rxt(194)*y(36)
         mat(1114) = -rxt(195)*y(36)

         mat(780) = rxt(184)*y(34)
         mat(1057) = rxt(183)*y(34)
         mat(1093) = rxt(184)*y(16) + rxt(183)*y(21)

         mat(379) = -(rxt(196)*y(2) + (rxt(362) + rxt(373)) * y(30))
         mat(1113) = -rxt(196)*y(37)
         mat(1245) = -(rxt(362) + rxt(373)) * y(37)

         mat(1054) = rxt(187)*y(35)
         mat(762) = rxt(187)*y(21)

         mat(256) = -(rxt(197)*y(2))
         mat(1111) = -rxt(197)*y(38)

         mat(803) = rxt(189)*y(35)
         mat(761) = rxt(189)*y(7)

         mat(490) = -(rxt(255)*y(20) + rxt(256)*y(1) + rxt(257)*y(8))
         mat(990) = -rxt(255)*y(56)
         mat(1170) = -rxt(256)*y(56)
         mat(897) = -rxt(257)*y(56)

         mat(1170) = mat(1170) + .070_r8*rxt(302)*y(80)
         mat(431) = .070_r8*rxt(302)*y(1)

         mat(430) = -(rxt(301)*y(20) + rxt(302)*y(1) + rxt(303)*y(8))
         mat(985) = -rxt(301)*y(80)
         mat(1168) = -rxt(302)*y(80)
         mat(894) = -rxt(303)*y(80)

         mat(369) = -(rxt(263)*y(6) + rxt(264)*y(21))
         mat(849) = -rxt(263)*y(61)
         mat(1053) = -rxt(264)*y(61)

         mat(979) = rxt(255)*y(56) + .500_r8*rxt(265)*y(62)
         mat(489) = rxt(255)*y(20)
         mat(288) = .500_r8*rxt(265)*y(20)

         mat(551) = -(rxt(242)*y(20) + rxt(243)*y(8))
         mat(996) = -rxt(242)*y(47)
         mat(902) = -rxt(243)*y(47)

         mat(1175) = .500_r8*rxt(256)*y(56) + .040_r8*rxt(278)*y(74)
         mat(859) = rxt(263)*y(61) + rxt(276)*y(70) + .400_r8*rxt(317)*y(81) &
                      + rxt(280)*y(71) + rxt(237)*y(43) + .270_r8*rxt(258)*y(58)
         mat(996) = mat(996) + .500_r8*rxt(241)*y(44) + rxt(252)*y(48)
         mat(735) = .800_r8*rxt(239)*y(43)
         mat(493) = .500_r8*rxt(256)*y(1)
         mat(371) = rxt(263)*y(6)
         mat(123) = rxt(276)*y(6)
         mat(354) = .400_r8*rxt(317)*y(6)
         mat(341) = rxt(280)*y(6)
         mat(603) = .040_r8*rxt(278)*y(1)
         mat(391) = rxt(237)*y(6) + .800_r8*rxt(239)*y(13) + 3.200_r8*rxt(240)*y(43)
         mat(140) = .500_r8*rxt(241)*y(20)
         mat(420) = .270_r8*rxt(258)*y(6)
         mat(102) = rxt(252)*y(20)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(313) = -(rxt(236)*y(20))
         mat(972) = -rxt(236)*y(46)

         mat(1166) = .250_r8*rxt(256)*y(56) + .200_r8*rxt(302)*y(80)
         mat(726) = .100_r8*rxt(247)*y(45)
         mat(1046) = .250_r8*rxt(246)*y(45) + .250_r8*rxt(294)*y(73)
         mat(488) = .250_r8*rxt(256)*y(1)
         mat(429) = .200_r8*rxt(302)*y(1)
         mat(681) = .100_r8*rxt(247)*y(13) + .250_r8*rxt(246)*y(21)
         mat(663) = .250_r8*rxt(294)*y(21)

         mat(287) = -(rxt(265)*y(20))
         mat(969) = -rxt(265)*y(62)

         mat(1044) = rxt(264)*y(61)
         mat(368) = rxt(264)*y(21)

         mat(693) = -(rxt(244)*y(6) + rxt(245)*y(7) + rxt(246)*y(21) + rxt(247)*y(13) &
                      + 4._r8*rxt(248)*y(45) + rxt(290)*y(76) + rxt(309)*y(85) + rxt(324) &
                      *y(88))
         mat(867) = -rxt(244)*y(45)
         mat(814) = -rxt(245)*y(45)
         mat(1075) = -rxt(246)*y(45)
         mat(743) = -rxt(247)*y(45)
         mat(628) = -rxt(290)*y(45)
         mat(650) = -rxt(309)*y(45)
         mat(590) = -rxt(324)*y(45)

         mat(867) = mat(867) + rxt(280)*y(71) + .530_r8*rxt(285)*y(76) + rxt(292) &
                      *y(73) + rxt(267)*y(64)
         mat(1004) = rxt(242)*y(47) + .500_r8*rxt(249)*y(51) + rxt(272)*y(65)
         mat(910) = rxt(243)*y(47) + .530_r8*rxt(287)*y(76) + rxt(293)*y(73) &
                      + rxt(273)*y(65)
         mat(743) = mat(743) + .260_r8*rxt(289)*y(76) + rxt(295)*y(73) &
                      + .300_r8*rxt(269)*y(64)
         mat(552) = rxt(242)*y(20) + rxt(243)*y(8)
         mat(693) = mat(693) + .530_r8*rxt(290)*y(76)
         mat(239) = .500_r8*rxt(249)*y(20)
         mat(342) = rxt(280)*y(6)
         mat(628) = mat(628) + .530_r8*rxt(285)*y(6) + .530_r8*rxt(287)*y(8) &
                      + .260_r8*rxt(289)*y(13) + .530_r8*rxt(290)*y(45)
         mat(667) = rxt(292)*y(6) + rxt(293)*y(8) + rxt(295)*y(13) + 4.000_r8*rxt(297) &
                      *y(73)
         mat(535) = rxt(267)*y(6) + .300_r8*rxt(269)*y(13)
         mat(575) = rxt(272)*y(20) + rxt(273)*y(8)

         mat(238) = -(rxt(249)*y(20))
         mat(963) = -rxt(249)*y(51)

         mat(1040) = .750_r8*rxt(246)*y(45) + .750_r8*rxt(294)*y(73)
         mat(680) = .750_r8*rxt(246)*y(21)
         mat(661) = .750_r8*rxt(294)*y(21)

         mat(231) = -(rxt(254)*y(20))
         mat(962) = -rxt(254)*y(55)

         mat(802) = rxt(245)*y(45)
         mat(679) = rxt(245)*y(7)

         mat(171) = -(rxt(274)*y(20))
         mat(953) = -rxt(274)*y(79)

         mat(837) = .100_r8*rxt(317)*y(81)
         mat(889) = rxt(257)*y(56)
         mat(487) = rxt(257)*y(8)
         mat(347) = .100_r8*rxt(317)*y(6)

         mat(109) = -(rxt(227)*y(25) + rxt(229)*y(20))
         mat(1137) = -rxt(227)*y(42)
         mat(943) = -rxt(229)*y(42)

         mat(147) = -(rxt(230)*y(20) + rxt(235)*y(1))
         mat(949) = -rxt(230)*y(41)
         mat(1162) = -rxt(235)*y(41)

         mat(30) = -(rxt(313)*y(20))
         mat(928) = -rxt(313)*y(68)

         mat(264) = -(rxt(300)*y(20))
         mat(966) = -rxt(300)*y(78)

         mat(804) = rxt(298)*y(73)
         mat(662) = rxt(298)*y(7)

         mat(33) = -(rxt(275)*y(20))
         mat(929) = -rxt(275)*y(67)

         mat(121) = -(rxt(276)*y(6))
         mat(834) = -rxt(276)*y(70)

         mat(944) = rxt(275)*y(67)
         mat(34) = rxt(275)*y(20)

         mat(351) = -(rxt(317)*y(6) + rxt(318)*y(21))
         mat(847) = -rxt(317)*y(81)
         mat(1051) = -rxt(318)*y(81)

         mat(977) = rxt(313)*y(68) + rxt(319)*y(82)
         mat(31) = rxt(313)*y(20)
         mat(331) = rxt(319)*y(20)

         mat(329) = -(rxt(319)*y(20))
         mat(975) = -rxt(319)*y(82)

         mat(1049) = rxt(318)*y(81)
         mat(349) = rxt(318)*y(21)

         mat(203) = -(rxt(279)*y(20))
         mat(959) = -rxt(279)*y(69)

         mat(839) = .800_r8*rxt(317)*y(81)
         mat(348) = .800_r8*rxt(317)*y(6)

         mat(340) = -(rxt(280)*y(6) + rxt(281)*y(21))
         mat(846) = -rxt(280)*y(71)
         mat(1050) = -rxt(281)*y(71)

         mat(976) = rxt(279)*y(69) + rxt(282)*y(72)
         mat(204) = rxt(279)*y(20)
         mat(129) = rxt(282)*y(20)

         mat(128) = -(rxt(282)*y(20))
         mat(945) = -rxt(282)*y(72)

         mat(1026) = rxt(281)*y(71)
         mat(339) = rxt(281)*y(21)

         mat(58) = -(rxt(327)*y(20))
         mat(936) = -rxt(327)*y(91)

         mat(63) = -(rxt(331)*y(20))
         mat(937) = -rxt(331)*y(92)

         mat(937) = mat(937) + .250_r8*rxt(327)*y(91)
         mat(59) = .250_r8*rxt(327)*y(20)

         mat(273) = -(rxt(328)*y(6) + rxt(329)*y(21))
         mat(842) = -rxt(328)*y(93)
         mat(1042) = -rxt(329)*y(93)

         mat(967) = .700_r8*rxt(327)*y(91) + rxt(330)*y(94)
         mat(60) = .700_r8*rxt(327)*y(20)
         mat(159) = rxt(330)*y(20)

         mat(158) = -(rxt(330)*y(20))
         mat(951) = -rxt(330)*y(94)

         mat(1030) = rxt(329)*y(93)
         mat(272) = rxt(329)*y(21)

         mat(80) = -(rxt(332)*y(7))
         mat(798) = -rxt(332)*y(95)

         mat(939) = rxt(331)*y(92)
         mat(64) = rxt(331)*y(20)

         mat(476) = -(rxt(342)*y(6) + rxt(343)*y(21))
         mat(854) = -rxt(342)*y(103)
         mat(1061) = -rxt(343)*y(103)

         mat(989) = rxt(344)*y(104) + rxt(339)*y(102)
         mat(896) = rxt(341)*y(102)
         mat(218) = rxt(344)*y(20)
         mat(296) = rxt(339)*y(20) + rxt(341)*y(8)

         mat(216) = -(rxt(344)*y(20))
         mat(961) = -rxt(344)*y(104)

         mat(1038) = rxt(343)*y(103)
         mat(474) = rxt(343)*y(21)


         mat(843) = .900_r8*rxt(328)*y(93) + .900_r8*rxt(335)*y(97) + .620_r8*rxt(338) &
                      *y(100)
         mat(805) = .700_r8*rxt(332)*y(95)
         mat(274) = .900_r8*rxt(328)*y(6)
         mat(81) = .700_r8*rxt(332)*y(7)
         mat(166) = .900_r8*rxt(335)*y(6)
         mat(210) = .620_r8*rxt(338)*y(6)

         mat(324) = -(rxt(251)*y(20))
         mat(974) = -rxt(251)*y(50)

         mat(845) = .450_r8*rxt(328)*y(93) + .900_r8*rxt(335)*y(97) + .340_r8*rxt(338) &
                      *y(100) + .250_r8*rxt(320)*y(88)
         mat(974) = mat(974) + .200_r8*rxt(250)*y(49) + .650_r8*rxt(228)*y(125)
         mat(891) = .250_r8*rxt(321)*y(88)
         mat(727) = .100_r8*rxt(323)*y(88)
         mat(682) = .250_r8*rxt(324)*y(88)
         mat(275) = .450_r8*rxt(328)*y(6)
         mat(167) = .900_r8*rxt(335)*y(6)
         mat(211) = .340_r8*rxt(338)*y(6)
         mat(398) = .200_r8*rxt(250)*y(20)
         mat(584) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)
         mat(74) = .650_r8*rxt(228)*y(20)

         mat(36) = -(rxt(333)*y(20))
         mat(930) = -rxt(333)*y(96)

         mat(165) = -(rxt(334)*y(21) + rxt(335)*y(6))
         mat(1031) = -rxt(334)*y(97)
         mat(836) = -rxt(335)*y(97)

         mat(952) = rxt(333)*y(96)
         mat(37) = rxt(333)*y(20)


         mat(1022) = rxt(334)*y(97)
         mat(164) = rxt(334)*y(21)

         mat(39) = -(rxt(336)*y(20))
         mat(931) = -rxt(336)*y(99)

         mat(209) = -(rxt(337)*y(21) + rxt(338)*y(6))
         mat(1037) = -rxt(337)*y(100)
         mat(840) = -rxt(338)*y(100)

         mat(960) = rxt(336)*y(99)
         mat(40) = rxt(336)*y(20)


         mat(1023) = rxt(337)*y(100)
         mat(208) = rxt(337)*y(21)

         mat(648) = -(rxt(304)*y(6) + rxt(305)*y(8) + rxt(306)*y(21) + rxt(308)*y(13) &
                      + rxt(309)*y(45))
         mat(865) = -rxt(304)*y(85)
         mat(908) = -rxt(305)*y(85)
         mat(1073) = -rxt(306)*y(85)
         mat(741) = -rxt(308)*y(85)
         mat(691) = -rxt(309)*y(85)

         mat(1002) = rxt(301)*y(80) + .200_r8*rxt(307)*y(90)
         mat(436) = rxt(301)*y(20)
         mat(252) = .200_r8*rxt(307)*y(20)

         mat(605) = -(rxt(277)*y(20) + rxt(278)*y(1))
         mat(1000) = -rxt(277)*y(74)
         mat(1179) = -rxt(278)*y(74)

         mat(1179) = mat(1179) + .200_r8*rxt(302)*y(80) + rxt(340)*y(102)
         mat(863) = rxt(342)*y(103) + .320_r8*rxt(304)*y(85) + .039_r8*rxt(310)*y(86)
         mat(906) = .350_r8*rxt(305)*y(85) + .039_r8*rxt(311)*y(86)
         mat(739) = .260_r8*rxt(308)*y(85)
         mat(1071) = .039_r8*rxt(312)*y(86)
         mat(435) = .200_r8*rxt(302)*y(1)
         mat(689) = .350_r8*rxt(309)*y(85)
         mat(479) = rxt(342)*y(6)
         mat(646) = .320_r8*rxt(304)*y(6) + .350_r8*rxt(305)*y(8) + .260_r8*rxt(308) &
                      *y(13) + .350_r8*rxt(309)*y(45)
         mat(298) = rxt(340)*y(1)
         mat(510) = .039_r8*rxt(310)*y(6) + .039_r8*rxt(311)*y(8) + .039_r8*rxt(312) &
                      *y(21)

         mat(561) = -(rxt(283)*y(20) + rxt(284)*y(1))
         mat(997) = -rxt(283)*y(75)
         mat(1176) = -rxt(284)*y(75)

         mat(1176) = mat(1176) + .400_r8*rxt(302)*y(80) + rxt(340)*y(102)
         mat(860) = rxt(342)*y(103) + .230_r8*rxt(304)*y(85) + .167_r8*rxt(310)*y(86)
         mat(903) = .250_r8*rxt(305)*y(85) + .167_r8*rxt(311)*y(86)
         mat(736) = .190_r8*rxt(308)*y(85)
         mat(1068) = .167_r8*rxt(312)*y(86)
         mat(434) = .400_r8*rxt(302)*y(1)
         mat(686) = .250_r8*rxt(309)*y(85)
         mat(478) = rxt(342)*y(6)
         mat(643) = .230_r8*rxt(304)*y(6) + .250_r8*rxt(305)*y(8) + .190_r8*rxt(308) &
                      *y(13) + .250_r8*rxt(309)*y(45)
         mat(297) = rxt(340)*y(1)
         mat(508) = .167_r8*rxt(310)*y(6) + .167_r8*rxt(311)*y(8) + .167_r8*rxt(312) &
                      *y(21)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(626) = -((rxt(285) + rxt(286)) * y(6) + rxt(287)*y(8) + rxt(288)*y(21) &
                      + rxt(289)*y(13) + rxt(290)*y(45))
         mat(864) = -(rxt(285) + rxt(286)) * y(76)
         mat(907) = -rxt(287)*y(76)
         mat(1072) = -rxt(288)*y(76)
         mat(740) = -rxt(289)*y(76)
         mat(690) = -rxt(290)*y(76)

         mat(1001) = rxt(277)*y(74) + .500_r8*rxt(283)*y(75) + .200_r8*rxt(291)*y(77)
         mat(606) = rxt(277)*y(20)
         mat(563) = .500_r8*rxt(283)*y(20)
         mat(134) = .200_r8*rxt(291)*y(20)

         mat(133) = -(rxt(291)*y(20))
         mat(946) = -rxt(291)*y(77)

         mat(1027) = rxt(288)*y(76)
         mat(618) = rxt(288)*y(21)

         mat(666) = -(rxt(292)*y(6) + rxt(293)*y(8) + rxt(294)*y(21) + rxt(295)*y(13) &
                      + rxt(296)*y(45) + 4._r8*rxt(297)*y(73) + rxt(298)*y(7))
         mat(866) = -rxt(292)*y(73)
         mat(909) = -rxt(293)*y(73)
         mat(1074) = -rxt(294)*y(73)
         mat(742) = -rxt(295)*y(73)
         mat(692) = -rxt(296)*y(73)
         mat(813) = -rxt(298)*y(73)

         mat(1182) = .200_r8*rxt(302)*y(80)
         mat(1003) = .500_r8*rxt(283)*y(75) + .500_r8*rxt(291)*y(77)
         mat(437) = .200_r8*rxt(302)*y(1)
         mat(564) = .500_r8*rxt(283)*y(20)
         mat(135) = .500_r8*rxt(291)*y(20)

         mat(390) = -(rxt(237)*y(6) + rxt(238)*y(21) + rxt(239)*y(13) + 4._r8*rxt(240) &
                      *y(43))
         mat(850) = -rxt(237)*y(43)
         mat(1055) = -rxt(238)*y(43)
         mat(729) = -rxt(239)*y(43)

         mat(980) = rxt(229)*y(42) + .500_r8*rxt(241)*y(44)
         mat(1139) = rxt(227)*y(42)
         mat(110) = rxt(229)*y(20) + rxt(227)*y(25)
         mat(139) = .500_r8*rxt(241)*y(20)

         mat(138) = -(rxt(241)*y(20))
         mat(947) = -rxt(241)*y(44)

         mat(1028) = rxt(238)*y(43)
         mat(388) = rxt(238)*y(21)

         mat(295) = -(rxt(339)*y(20) + rxt(340)*y(1) + rxt(341)*y(8))
         mat(970) = -rxt(339)*y(102)
         mat(1164) = -rxt(340)*y(102)
         mat(890) = -rxt(341)*y(102)

         mat(51) = -(rxt(262)*y(20))
         mat(934) = -rxt(262)*y(57)

         mat(418) = -(rxt(258)*y(6) + rxt(259)*y(21) + rxt(260)*y(13))
         mat(852) = -rxt(258)*y(58)
         mat(1058) = -rxt(259)*y(58)
         mat(731) = -rxt(260)*y(58)

         mat(984) = rxt(262)*y(57) + rxt(261)*y(59)
         mat(52) = rxt(262)*y(20)
         mat(177) = rxt(261)*y(20)

         mat(175) = -(rxt(261)*y(20))
         mat(954) = -rxt(261)*y(59)

         mat(1032) = rxt(259)*y(58)
         mat(416) = rxt(259)*y(21)

         mat(362) = -(rxt(266)*y(20))
         mat(978) = -rxt(266)*y(60)

         mat(848) = .500_r8*rxt(276)*y(70) + .250_r8*rxt(317)*y(81) + .100_r8*rxt(342) &
                      *y(103) + .820_r8*rxt(258)*y(58)
         mat(728) = .820_r8*rxt(260)*y(58)
         mat(122) = .500_r8*rxt(276)*y(6)
         mat(352) = .250_r8*rxt(317)*y(6)
         mat(475) = .100_r8*rxt(342)*y(6)
         mat(417) = .820_r8*rxt(258)*y(6) + .820_r8*rxt(260)*y(13)

         mat(181) = -(rxt(270)*y(20))
         mat(955) = -rxt(270)*y(66)

         mat(1033) = rxt(268)*y(64)
         mat(530) = rxt(268)*y(21)

         mat(244) = -(rxt(221)*y(20))
         mat(964) = -rxt(221)*y(15)

         mat(725) = 2.000_r8*rxt(220)*y(13) + .250_r8*rxt(308)*y(85) &
                      + .250_r8*rxt(289)*y(76) + .300_r8*rxt(239)*y(43) &
                      + .500_r8*rxt(269)*y(64) + .300_r8*rxt(323)*y(88)
         mat(639) = .250_r8*rxt(308)*y(13)
         mat(619) = .250_r8*rxt(289)*y(13)
         mat(389) = .300_r8*rxt(239)*y(13)
         mat(531) = .500_r8*rxt(269)*y(13)
         mat(583) = .300_r8*rxt(323)*y(13)

         mat(101) = -(rxt(252)*y(20))
         mat(942) = -rxt(252)*y(48)

         mat(722) = .200_r8*rxt(239)*y(43)
         mat(387) = .200_r8*rxt(239)*y(13) + .800_r8*rxt(240)*y(43)

         mat(399) = -(rxt(250)*y(20))
         mat(981) = -rxt(250)*y(49)

         mat(851) = .530_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(892) = .530_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(730) = .260_r8*rxt(289)*y(76) + .100_r8*rxt(323)*y(88)
         mat(683) = .530_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(620) = .530_r8*rxt(285)*y(6) + .530_r8*rxt(287)*y(8) + .260_r8*rxt(289) &
                      *y(13) + .530_r8*rxt(290)*y(45)
         mat(585) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(543) = -(rxt(271)*y(20))
         mat(995) = -rxt(271)*y(63)

         mat(858) = .220_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(995) = mat(995) + .500_r8*rxt(265)*y(62) + .500_r8*rxt(300)*y(78)
         mat(901) = .220_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(734) = .230_r8*rxt(289)*y(76) + .200_r8*rxt(269)*y(64) + .100_r8*rxt(323) &
                      *y(88)
         mat(289) = .500_r8*rxt(265)*y(20)
         mat(685) = .220_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(265) = .500_r8*rxt(300)*y(20)
         mat(623) = .220_r8*rxt(285)*y(6) + .220_r8*rxt(287)*y(8) + .230_r8*rxt(289) &
                      *y(13) + .220_r8*rxt(290)*y(45)
         mat(533) = .200_r8*rxt(269)*y(13)
         mat(587) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(306) = -(rxt(231)*y(6) + rxt(232)*y(21))
         mat(844) = -rxt(231)*y(52)
         mat(1045) = -rxt(232)*y(52)

         mat(971) = rxt(230)*y(41)
         mat(149) = rxt(230)*y(20)


         mat(833) = .750_r8*rxt(231)*y(52)
         mat(305) = .750_r8*rxt(231)*y(6)


         mat(1024) = rxt(232)*y(52)
         mat(304) = rxt(232)*y(21)

         mat(155) = -(rxt(316)*y(20))
         mat(950) = -rxt(316)*y(84)

         mat(835) = .370_r8*rxt(304)*y(85)
         mat(950) = mat(950) + rxt(314)*y(87)
         mat(888) = .400_r8*rxt(305)*y(85) + rxt(315)*y(87)
         mat(723) = .300_r8*rxt(308)*y(85)
         mat(678) = .400_r8*rxt(309)*y(85)
         mat(638) = .370_r8*rxt(304)*y(6) + .400_r8*rxt(305)*y(8) + .300_r8*rxt(308) &
                      *y(13) + .400_r8*rxt(309)*y(45)
         mat(465) = rxt(314)*y(20) + rxt(315)*y(8)

         mat(532) = -(rxt(267)*y(6) + rxt(268)*y(21) + rxt(269)*y(13))
         mat(857) = -rxt(267)*y(64)
         mat(1065) = -rxt(268)*y(64)
         mat(733) = -rxt(269)*y(64)

         mat(994) = rxt(266)*y(60) + rxt(270)*y(66)
         mat(363) = rxt(266)*y(20)
         mat(182) = rxt(270)*y(20)

         mat(574) = -(rxt(272)*y(20) + rxt(273)*y(8))
         mat(998) = -rxt(272)*y(65)
         mat(904) = -rxt(273)*y(65)

         mat(1177) = .950_r8*rxt(278)*y(74) + .800_r8*rxt(284)*y(75)
         mat(861) = .450_r8*rxt(328)*y(93) + .540_r8*rxt(338)*y(100) &
                      + .250_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(998) = mat(998) + rxt(274)*y(79) + rxt(271)*y(63)
         mat(904) = mat(904) + .250_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(737) = .240_r8*rxt(289)*y(76) + .500_r8*rxt(269)*y(64) + .100_r8*rxt(323) &
                      *y(88)
         mat(687) = .250_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(172) = rxt(274)*y(20)
         mat(276) = .450_r8*rxt(328)*y(6)
         mat(212) = .540_r8*rxt(338)*y(6)
         mat(604) = .950_r8*rxt(278)*y(1)
         mat(562) = .800_r8*rxt(284)*y(1)
         mat(624) = .250_r8*rxt(285)*y(6) + .250_r8*rxt(287)*y(8) + .240_r8*rxt(289) &
                      *y(13) + .250_r8*rxt(290)*y(45)
         mat(544) = rxt(271)*y(20)
         mat(534) = .500_r8*rxt(269)*y(13)
         mat(588) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(506) = -(rxt(310)*y(6) + rxt(311)*y(8) + rxt(312)*y(21))
         mat(855) = -rxt(310)*y(86)
         mat(898) = -rxt(311)*y(86)
         mat(1062) = -rxt(312)*y(86)

         mat(898) = mat(898) + rxt(303)*y(80)
         mat(432) = rxt(303)*y(8)

         mat(466) = -(rxt(314)*y(20) + rxt(315)*y(8))
         mat(988) = -rxt(314)*y(87)
         mat(895) = -rxt(315)*y(87)

         mat(853) = .080_r8*rxt(304)*y(85) + .800_r8*rxt(286)*y(76) + .794_r8*rxt(310) &
                      *y(86)
         mat(895) = mat(895) + .794_r8*rxt(311)*y(86)
         mat(1060) = .794_r8*rxt(312)*y(86)
         mat(641) = .080_r8*rxt(304)*y(6)
         mat(621) = .800_r8*rxt(286)*y(6)
         mat(505) = .794_r8*rxt(310)*y(6) + .794_r8*rxt(311)*y(8) + .794_r8*rxt(312) &
                      *y(21)

         mat(589) = -(rxt(320)*y(6) + rxt(321)*y(8) + rxt(322)*y(21) + rxt(323)*y(13) &
                      + rxt(324)*y(45))
         mat(862) = -rxt(320)*y(88)
         mat(905) = -rxt(321)*y(88)
         mat(1070) = -rxt(322)*y(88)
         mat(738) = -rxt(323)*y(88)
         mat(688) = -rxt(324)*y(88)

         mat(999) = rxt(316)*y(84) + rxt(325)*y(89) + .800_r8*rxt(307)*y(90)
         mat(156) = rxt(316)*y(20)
         mat(144) = rxt(325)*y(20)
         mat(250) = .800_r8*rxt(307)*y(20)

         mat(143) = -((rxt(325) + rxt(326)) * y(20))
         mat(948) = -(rxt(325) + rxt(326)) * y(89)

         mat(1029) = rxt(312)*y(86) + rxt(322)*y(88)
         mat(504) = rxt(312)*y(21)
         mat(582) = rxt(322)*y(21)

         mat(248) = -(rxt(307)*y(20))
         mat(965) = -rxt(307)*y(90)

         mat(1041) = rxt(306)*y(85)
         mat(640) = rxt(306)*y(21)

         mat(72) = -(rxt(228)*y(20))
         mat(938) = -rxt(228)*y(125)

         mat(187) = -(rxt(223)*y(20))
         mat(956) = -rxt(223)*y(126)

         mat(1163) = .500_r8*rxt(235)*y(41)
         mat(838) = rxt(225)*y(127)
         mat(956) = mat(956) + .350_r8*rxt(228)*y(125)
         mat(1034) = rxt(226)*y(127)
         mat(148) = .500_r8*rxt(235)*y(1)
         mat(73) = .350_r8*rxt(228)*y(20)
         mat(223) = rxt(225)*y(6) + rxt(226)*y(21)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(224) = -(rxt(225)*y(6) + rxt(226)*y(21))
         mat(841) = -rxt(225)*y(127)
         mat(1039) = -rxt(226)*y(127)

         mat(779) = rxt(216)*y(21)
         mat(1039) = mat(1039) + rxt(216)*y(16)

         mat(56) = -(rxt(350)*y(20))
         mat(935) = -rxt(350)*y(142)

         mat(935) = mat(935) + (rxt(351)+.500_r8*rxt(352))*y(143)
         mat(885) = rxt(353)*y(143)
         mat(95) = (rxt(351)+.500_r8*rxt(352))*y(20) + rxt(353)*y(8)

         mat(96) = -((rxt(351) + rxt(352)) * y(20) + rxt(353)*y(8))
         mat(941) = -(rxt(351) + rxt(352)) * y(143)
         mat(886) = -rxt(353)*y(143)


         mat(927) = rxt(350)*y(142)
         mat(55) = rxt(350)*y(20)

         mat(42) = -(rxt(354)*y(20))
         mat(932) = -rxt(354)*y(145)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = mat( 30) + lmat( 30)
         mat( 33) = mat( 33) + lmat( 33)
         mat( 36) = mat( 36) + lmat( 36)
         mat( 39) = mat( 39) + lmat( 39)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 48) = lmat( 48)
         mat( 49) = lmat( 49)
         mat( 50) = lmat( 50)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 58) = mat( 58) + lmat( 58)
         mat( 63) = mat( 63) + lmat( 63)
         mat( 66) = lmat( 66)
         mat( 67) = lmat( 67)
         mat( 68) = lmat( 68)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = lmat( 71)
         mat( 72) = mat( 72) + lmat( 72)
         mat( 78) = lmat( 78)
         mat( 79) = lmat( 79)
         mat( 80) = mat( 80) + lmat( 80)
         mat( 84) = mat( 84) + lmat( 84)
         mat( 86) = mat( 86) + lmat( 86)
         mat( 87) = mat( 87) + lmat( 87)
         mat( 88) = mat( 88) + lmat( 88)
         mat( 92) = lmat( 92)
         mat( 93) = lmat( 93)
         mat( 94) = lmat( 94)
         mat( 96) = mat( 96) + lmat( 96)
         mat( 101) = mat( 101) + lmat( 101)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = mat( 109) + lmat( 109)
         mat( 115) = lmat( 115)
         mat( 116) = lmat( 116)
         mat( 117) = lmat( 117)
         mat( 118) = lmat( 118)
         mat( 119) = lmat( 119)
         mat( 120) = lmat( 120)
         mat( 121) = mat( 121) + lmat( 121)
         mat( 128) = mat( 128) + lmat( 128)
         mat( 130) = lmat( 130)
         mat( 131) = lmat( 131)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 142) = lmat( 142)
         mat( 143) = mat( 143) + lmat( 143)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 147) = mat( 147) + lmat( 147)
         mat( 155) = mat( 155) + lmat( 155)
         mat( 158) = mat( 158) + lmat( 158)
         mat( 160) = lmat( 160)
         mat( 161) = lmat( 161)
         mat( 162) = lmat( 162)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 165) = mat( 165) + lmat( 165)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 175) = mat( 175) + lmat( 175)
         mat( 176) = lmat( 176)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 180) = lmat( 180)
         mat( 181) = mat( 181) + lmat( 181)
         mat( 183) = lmat( 183)
         mat( 185) = lmat( 185)
         mat( 186) = mat( 186) + lmat( 186)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 193) = mat( 193) + lmat( 193)
         mat( 194) = lmat( 194)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 196) = lmat( 196)
         mat( 197) = mat( 197) + lmat( 197)
         mat( 199) = lmat( 199)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 202) = mat( 202) + lmat( 202)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 205) = lmat( 205)
         mat( 206) = lmat( 206)
         mat( 209) = mat( 209) + lmat( 209)
         mat( 216) = mat( 216) + lmat( 216)
         mat( 217) = lmat( 217)
         mat( 219) = lmat( 219)
         mat( 220) = lmat( 220)
         mat( 221) = mat( 221) + lmat( 221)
         mat( 222) = lmat( 222)
         mat( 224) = mat( 224) + lmat( 224)
         mat( 226) = lmat( 226)
         mat( 230) = mat( 230) + lmat( 230)
         mat( 231) = mat( 231) + lmat( 231)
         mat( 232) = lmat( 232)
         mat( 233) = lmat( 233)
         mat( 235) = lmat( 235)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 238) = mat( 238) + lmat( 238)
         mat( 241) = lmat( 241)
         mat( 243) = mat( 243) + lmat( 243)
         mat( 244) = mat( 244) + lmat( 244)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 249) = lmat( 249)
         mat( 251) = lmat( 251)
         mat( 253) = lmat( 253)
         mat( 255) = lmat( 255)
         mat( 256) = mat( 256) + lmat( 256)
         mat( 257) = lmat( 257)
         mat( 258) = lmat( 258)
         mat( 259) = mat( 259) + lmat( 259)
         mat( 260) = lmat( 260)
         mat( 261) = mat( 261) + lmat( 261)
         mat( 262) = lmat( 262)
         mat( 264) = mat( 264) + lmat( 264)
         mat( 266) = lmat( 266)
         mat( 268) = lmat( 268)
         mat( 273) = mat( 273) + lmat( 273)
         mat( 281) = lmat( 281)
         mat( 282) = lmat( 282)
         mat( 283) = lmat( 283)
         mat( 284) = lmat( 284)
         mat( 285) = lmat( 285)
         mat( 286) = lmat( 286)
         mat( 287) = mat( 287) + lmat( 287)
         mat( 290) = lmat( 290)
         mat( 292) = lmat( 292)
         mat( 293) = mat( 293) + lmat( 293)
         mat( 294) = lmat( 294)
         mat( 295) = mat( 295) + lmat( 295)
         mat( 306) = mat( 306) + lmat( 306)
         mat( 313) = mat( 313) + lmat( 313)
         mat( 317) = mat( 317) + lmat( 317)
         mat( 319) = mat( 319) + lmat( 319)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 325) = mat( 325) + lmat( 325)
         mat( 327) = mat( 327) + lmat( 327)
         mat( 328) = lmat( 328)
         mat( 329) = mat( 329) + lmat( 329)
         mat( 332) = lmat( 332)
         mat( 334) = lmat( 334)
         mat( 336) = lmat( 336)
         mat( 337) = mat( 337) + lmat( 337)
         mat( 338) = lmat( 338)
         mat( 340) = mat( 340) + lmat( 340)
         mat( 351) = mat( 351) + lmat( 351)
         mat( 362) = mat( 362) + lmat( 362)
         mat( 364) = lmat( 364)
         mat( 366) = lmat( 366)
         mat( 369) = mat( 369) + lmat( 369)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 382) = mat( 382) + lmat( 382)
         mat( 383) = lmat( 383)
         mat( 390) = mat( 390) + lmat( 390)
         mat( 399) = mat( 399) + lmat( 399)
         mat( 400) = lmat( 400)
         mat( 401) = mat( 401) + lmat( 401)
         mat( 403) = mat( 403) + lmat( 403)
         mat( 404) = mat( 404) + lmat( 404)
         mat( 406) = lmat( 406)
         mat( 408) = mat( 408) + lmat( 408)
         mat( 411) = mat( 411) + lmat( 411)
         mat( 413) = lmat( 413)
         mat( 415) = mat( 415) + lmat( 415)
         mat( 418) = mat( 418) + lmat( 418)
         mat( 430) = mat( 430) + lmat( 430)
         mat( 446) = mat( 446) + lmat( 446)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 450) = mat( 450) + lmat( 450)
         mat( 454) = mat( 454) + lmat( 454)
         mat( 455) = mat( 455) + lmat( 455)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 458) = lmat( 458)
         mat( 459) = mat( 459) + lmat( 459)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 463) = mat( 463) + lmat( 463)
         mat( 466) = mat( 466) + lmat( 466)
         mat( 467) = lmat( 467)
         mat( 469) = lmat( 469)
         mat( 470) = mat( 470) + lmat( 470)
         mat( 473) = mat( 473) + lmat( 473)
         mat( 476) = mat( 476) + lmat( 476)
         mat( 490) = mat( 490) + lmat( 490)
         mat( 506) = mat( 506) + lmat( 506)
         mat( 518) = mat( 518) + lmat( 518)
         mat( 526) = mat( 526) + lmat( 526)
         mat( 532) = mat( 532) + lmat( 532)
         mat( 543) = mat( 543) + lmat( 543)
         mat( 545) = lmat( 545)
         mat( 546) = lmat( 546)
         mat( 548) = mat( 548) + lmat( 548)
         mat( 550) = lmat( 550)
         mat( 551) = mat( 551) + lmat( 551)
         mat( 555) = lmat( 555)
         mat( 559) = lmat( 559)
         mat( 560) = mat( 560) + lmat( 560)
         mat( 561) = mat( 561) + lmat( 561)
         mat( 564) = mat( 564) + lmat( 564)
         mat( 565) = lmat( 565)
         mat( 568) = mat( 568) + lmat( 568)
         mat( 570) = mat( 570) + lmat( 570)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 574) = mat( 574) + lmat( 574)
         mat( 575) = mat( 575) + lmat( 575)
         mat( 581) = lmat( 581)
         mat( 589) = mat( 589) + lmat( 589)
         mat( 600) = lmat( 600)
         mat( 601) = mat( 601) + lmat( 601)
         mat( 605) = mat( 605) + lmat( 605)
         mat( 607) = lmat( 607)
         mat( 610) = lmat( 610)
         mat( 626) = mat( 626) + lmat( 626)
         mat( 648) = mat( 648) + lmat( 648)
         mat( 666) = mat( 666) + lmat( 666)
         mat( 693) = mat( 693) + lmat( 693)
         mat( 704) = lmat( 704)
         mat( 705) = mat( 705) + lmat( 705)
         mat( 706) = lmat( 706)
         mat( 707) = mat( 707) + lmat( 707)
         mat( 708) = lmat( 708)
         mat( 710) = mat( 710) + lmat( 710)
         mat( 714) = mat( 714) + lmat( 714)
         mat( 716) = mat( 716) + lmat( 716)
         mat( 746) = mat( 746) + lmat( 746)
         mat( 766) = mat( 766) + lmat( 766)
         mat( 772) = mat( 772) + lmat( 772)
         mat( 773) = mat( 773) + lmat( 773)
         mat( 782) = lmat( 782)
         mat( 783) = mat( 783) + lmat( 783)
         mat( 785) = mat( 785) + lmat( 785)
         mat( 786) = mat( 786) + lmat( 786)
         mat( 808) = mat( 808) + lmat( 808)
         mat( 820) = mat( 820) + lmat( 820)
         mat( 821) = mat( 821) + lmat( 821)
         mat( 823) = mat( 823) + lmat( 823)
         mat( 826) = mat( 826) + lmat( 826)
         mat( 832) = mat( 832) + lmat( 832)
         mat( 874) = mat( 874) + lmat( 874)
         mat( 879) = mat( 879) + lmat( 879)
         mat( 893) = mat( 893) + lmat( 893)
         mat( 915) = mat( 915) + lmat( 915)
         mat( 916) = mat( 916) + lmat( 916)
         mat( 917) = mat( 917) + lmat( 917)
         mat( 921) = mat( 921) + lmat( 921)
         mat(1005) = mat(1005) + lmat(1005)
         mat(1007) = mat(1007) + lmat(1007)
         mat(1013) = mat(1013) + lmat(1013)
         mat(1014) = mat(1014) + lmat(1014)
         mat(1015) = mat(1015) + lmat(1015)
         mat(1017) = mat(1017) + lmat(1017)
         mat(1047) = mat(1047) + lmat(1047)
         mat(1085) = mat(1085) + lmat(1085)
         mat(1104) = mat(1104) + lmat(1104)
         mat(1130) = mat(1130) + lmat(1130)
         mat(1132) = mat(1132) + lmat(1132)
         mat(1143) = mat(1143) + lmat(1143)
         mat(1148) = lmat(1148)
         mat(1154) = mat(1154) + lmat(1154)
         mat(1155) = lmat(1155)
         mat(1157) = mat(1157) + lmat(1157)
         mat(1161) = mat(1161) + lmat(1161)
         mat(1195) = mat(1195) + lmat(1195)
         mat(1197) = mat(1197) + lmat(1197)
         mat(1199) = mat(1199) + lmat(1199)
         mat(1218) = mat(1218) + lmat(1218)
         mat(1219) = mat(1219) + lmat(1219)
         mat(1221) = mat(1221) + lmat(1221)
         mat(1226) = mat(1226) + lmat(1226)
         mat(1228) = mat(1228) + lmat(1228)
         mat(1229) = lmat(1229)
         mat(1230) = lmat(1230)
         mat(1232) = lmat(1232)
         mat(1234) = mat(1234) + lmat(1234)
         mat(1235) = lmat(1235)
         mat(1236) = mat(1236) + lmat(1236)
         mat(1237) = lmat(1237)
         mat(1238) = mat(1238) + lmat(1238)
         mat(1241) = mat(1241) + lmat(1241)
         mat(1250) = lmat(1250)
         mat(1259) = mat(1259) + lmat(1259)
         mat(1263) = mat(1263) + lmat(1263)
         mat( 225) = 0._r8
         mat( 229) = 0._r8
         mat( 279) = 0._r8
         mat( 307) = 0._r8
         mat( 311) = 0._r8
         mat( 330) = 0._r8
         mat( 333) = 0._r8
         mat( 335) = 0._r8
         mat( 345) = 0._r8
         mat( 350) = 0._r8
         mat( 353) = 0._r8
         mat( 355) = 0._r8
         mat( 356) = 0._r8
         mat( 360) = 0._r8
         mat( 370) = 0._r8
         mat( 372) = 0._r8
         mat( 376) = 0._r8
         mat( 385) = 0._r8
         mat( 396) = 0._r8
         mat( 419) = 0._r8
         mat( 421) = 0._r8
         mat( 422) = 0._r8
         mat( 427) = 0._r8
         mat( 438) = 0._r8
         mat( 439) = 0._r8
         mat( 457) = 0._r8
         mat( 468) = 0._r8
         mat( 477) = 0._r8
         mat( 480) = 0._r8
         mat( 481) = 0._r8
         mat( 482) = 0._r8
         mat( 485) = 0._r8
         mat( 492) = 0._r8
         mat( 494) = 0._r8
         mat( 495) = 0._r8
         mat( 498) = 0._r8
         mat( 499) = 0._r8
         mat( 507) = 0._r8
         mat( 509) = 0._r8
         mat( 511) = 0._r8
         mat( 516) = 0._r8
         mat( 536) = 0._r8
         mat( 541) = 0._r8
         mat( 554) = 0._r8
         mat( 556) = 0._r8
         mat( 567) = 0._r8
         mat( 577) = 0._r8
         mat( 578) = 0._r8
         mat( 591) = 0._r8
         mat( 592) = 0._r8
         mat( 598) = 0._r8
         mat( 602) = 0._r8
         mat( 608) = 0._r8
         mat( 609) = 0._r8
         mat( 612) = 0._r8
         mat( 613) = 0._r8
         mat( 614) = 0._r8
         mat( 625) = 0._r8
         mat( 627) = 0._r8
         mat( 629) = 0._r8
         mat( 630) = 0._r8
         mat( 636) = 0._r8
         mat( 642) = 0._r8
         mat( 644) = 0._r8
         mat( 645) = 0._r8
         mat( 647) = 0._r8
         mat( 649) = 0._r8
         mat( 651) = 0._r8
         mat( 652) = 0._r8
         mat( 658) = 0._r8
         mat( 660) = 0._r8
         mat( 664) = 0._r8
         mat( 665) = 0._r8
         mat( 668) = 0._r8
         mat( 669) = 0._r8
         mat( 675) = 0._r8
         mat( 694) = 0._r8
         mat( 695) = 0._r8
         mat( 700) = 0._r8
         mat( 701) = 0._r8
         mat( 709) = 0._r8
         mat( 711) = 0._r8
         mat( 718) = 0._r8
         mat( 720) = 0._r8
         mat( 721) = 0._r8
         mat( 744) = 0._r8
         mat( 745) = 0._r8
         mat( 750) = 0._r8
         mat( 751) = 0._r8
         mat( 753) = 0._r8
         mat( 755) = 0._r8
         mat( 757) = 0._r8
         mat( 758) = 0._r8
         mat( 763) = 0._r8
         mat( 764) = 0._r8
         mat( 765) = 0._r8
         mat( 769) = 0._r8
         mat( 775) = 0._r8
         mat( 777) = 0._r8
         mat( 778) = 0._r8
         mat( 787) = 0._r8
         mat( 788) = 0._r8
         mat( 795) = 0._r8
         mat( 796) = 0._r8
         mat( 806) = 0._r8
         mat( 807) = 0._r8
         mat( 810) = 0._r8
         mat( 811) = 0._r8
         mat( 812) = 0._r8
         mat( 815) = 0._r8
         mat( 816) = 0._r8
         mat( 817) = 0._r8
         mat( 819) = 0._r8
         mat( 825) = 0._r8
         mat( 827) = 0._r8
         mat( 830) = 0._r8
         mat( 831) = 0._r8
         mat( 868) = 0._r8
         mat( 869) = 0._r8
         mat( 883) = 0._r8
         mat( 884) = 0._r8
         mat( 900) = 0._r8
         mat( 911) = 0._r8
         mat( 912) = 0._r8
         mat( 913) = 0._r8
         mat( 920) = 0._r8
         mat( 922) = 0._r8
         mat( 923) = 0._r8
         mat( 924) = 0._r8
         mat( 925) = 0._r8
         mat( 926) = 0._r8
         mat( 968) = 0._r8
         mat( 991) = 0._r8
         mat(1011) = 0._r8
         mat(1020) = 0._r8
         mat(1025) = 0._r8
         mat(1043) = 0._r8
         mat(1048) = 0._r8
         mat(1052) = 0._r8
         mat(1056) = 0._r8
         mat(1064) = 0._r8
         mat(1066) = 0._r8
         mat(1067) = 0._r8
         mat(1069) = 0._r8
         mat(1091) = 0._r8
         mat(1095) = 0._r8
         mat(1096) = 0._r8
         mat(1099) = 0._r8
         mat(1100) = 0._r8
         mat(1101) = 0._r8
         mat(1102) = 0._r8
         mat(1105) = 0._r8
         mat(1106) = 0._r8
         mat(1108) = 0._r8
         mat(1109) = 0._r8
         mat(1110) = 0._r8
         mat(1115) = 0._r8
         mat(1120) = 0._r8
         mat(1134) = 0._r8
         mat(1144) = 0._r8
         mat(1145) = 0._r8
         mat(1146) = 0._r8
         mat(1150) = 0._r8
         mat(1151) = 0._r8
         mat(1156) = 0._r8
         mat(1160) = 0._r8
         mat(1165) = 0._r8
         mat(1167) = 0._r8
         mat(1169) = 0._r8
         mat(1171) = 0._r8
         mat(1173) = 0._r8
         mat(1174) = 0._r8
         mat(1178) = 0._r8
         mat(1180) = 0._r8
         mat(1181) = 0._r8
         mat(1183) = 0._r8
         mat(1184) = 0._r8
         mat(1200) = 0._r8
         mat(1207) = 0._r8
         mat(1208) = 0._r8
         mat(1214) = 0._r8
         mat(1220) = 0._r8
         mat(1222) = 0._r8
         mat(1231) = 0._r8
         mat(1233) = 0._r8
         mat(1240) = 0._r8
         mat(1251) = 0._r8
         mat(1252) = 0._r8
         mat(1253) = 0._r8
         mat(1254) = 0._r8
         mat(1256) = 0._r8
         mat(1257) = 0._r8
         mat(1260) = 0._r8
         mat(1261) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 33) = mat( 33) - dti
         mat( 36) = mat( 36) - dti
         mat( 39) = mat( 39) - dti
         mat( 42) = mat( 42) - dti
         mat( 45) = mat( 45) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 56) = mat( 56) - dti
         mat( 58) = mat( 58) - dti
         mat( 63) = mat( 63) - dti
         mat( 66) = mat( 66) - dti
         mat( 69) = mat( 69) - dti
         mat( 72) = mat( 72) - dti
         mat( 78) = mat( 78) - dti
         mat( 80) = mat( 80) - dti
         mat( 84) = mat( 84) - dti
         mat( 88) = mat( 88) - dti
         mat( 92) = mat( 92) - dti
         mat( 96) = mat( 96) - dti
         mat( 101) = mat( 101) - dti
         mat( 105) = mat( 105) - dti
         mat( 109) = mat( 109) - dti
         mat( 115) = mat( 115) - dti
         mat( 121) = mat( 121) - dti
         mat( 128) = mat( 128) - dti
         mat( 133) = mat( 133) - dti
         mat( 138) = mat( 138) - dti
         mat( 143) = mat( 143) - dti
         mat( 147) = mat( 147) - dti
         mat( 155) = mat( 155) - dti
         mat( 158) = mat( 158) - dti
         mat( 165) = mat( 165) - dti
         mat( 171) = mat( 171) - dti
         mat( 175) = mat( 175) - dti
         mat( 181) = mat( 181) - dti
         mat( 187) = mat( 187) - dti
         mat( 191) = mat( 191) - dti
         mat( 197) = mat( 197) - dti
         mat( 203) = mat( 203) - dti
         mat( 209) = mat( 209) - dti
         mat( 216) = mat( 216) - dti
         mat( 224) = mat( 224) - dti
         mat( 231) = mat( 231) - dti
         mat( 238) = mat( 238) - dti
         mat( 244) = mat( 244) - dti
         mat( 248) = mat( 248) - dti
         mat( 256) = mat( 256) - dti
         mat( 264) = mat( 264) - dti
         mat( 273) = mat( 273) - dti
         mat( 281) = mat( 281) - dti
         mat( 287) = mat( 287) - dti
         mat( 295) = mat( 295) - dti
         mat( 306) = mat( 306) - dti
         mat( 313) = mat( 313) - dti
         mat( 317) = mat( 317) - dti
         mat( 324) = mat( 324) - dti
         mat( 329) = mat( 329) - dti
         mat( 340) = mat( 340) - dti
         mat( 351) = mat( 351) - dti
         mat( 362) = mat( 362) - dti
         mat( 369) = mat( 369) - dti
         mat( 379) = mat( 379) - dti
         mat( 390) = mat( 390) - dti
         mat( 399) = mat( 399) - dti
         mat( 404) = mat( 404) - dti
         mat( 411) = mat( 411) - dti
         mat( 418) = mat( 418) - dti
         mat( 430) = mat( 430) - dti
         mat( 446) = mat( 446) - dti
         mat( 456) = mat( 456) - dti
         mat( 466) = mat( 466) - dti
         mat( 476) = mat( 476) - dti
         mat( 490) = mat( 490) - dti
         mat( 506) = mat( 506) - dti
         mat( 518) = mat( 518) - dti
         mat( 526) = mat( 526) - dti
         mat( 532) = mat( 532) - dti
         mat( 543) = mat( 543) - dti
         mat( 551) = mat( 551) - dti
         mat( 561) = mat( 561) - dti
         mat( 574) = mat( 574) - dti
         mat( 589) = mat( 589) - dti
         mat( 605) = mat( 605) - dti
         mat( 626) = mat( 626) - dti
         mat( 648) = mat( 648) - dti
         mat( 666) = mat( 666) - dti
         mat( 693) = mat( 693) - dti
         mat( 705) = mat( 705) - dti
         mat( 714) = mat( 714) - dti
         mat( 746) = mat( 746) - dti
         mat( 766) = mat( 766) - dti
         mat( 786) = mat( 786) - dti
         mat( 820) = mat( 820) - dti
         mat( 874) = mat( 874) - dti
         mat( 917) = mat( 917) - dti
         mat(1013) = mat(1013) - dti
         mat(1085) = mat(1085) - dti
         mat(1104) = mat(1104) - dti
         mat(1130) = mat(1130) - dti
         mat(1157) = mat(1157) - dti
         mat(1197) = mat(1197) - dti
         mat(1221) = mat(1221) - dti
         mat(1241) = mat(1241) - dti
         mat(1263) = mat(1263) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
