module ECEP_cldchem

use shr_kind_mod,   only: r8 => shr_kind_r8
use constituents,   only: pcnst
use cam_abortutils,  only: endrun
implicit none
private
public :: crm_cldchem

contains

subroutine crm_cldchem(tracer,tend_cldchem,tend_rename,pmid, pdel,tl, dtn, it, jt, pbuf,aqso4_h2o2, aqso4_o3)

use chemistry,      only: imozart
use chem_mods,      only: gas_pcnst,  nfs, indexm, adv_mass !==Guangxing Lin
use mo_mean_mass,   only: set_mean_mass
use mo_setsox,         only : setsox
use vars, only: qcl, qci, tabs
use grid, only:  nx, ny, nzm
use params, only: num_moist
use ppgrid,       only : pver, pcols
use modal_aero_data
use time_manager,  only: get_nstep
use physics_buffer, only: physics_buffer_desc

use mo_setsox,         only : setsox
use modal_aero_rename, only : modal_aero_rename_sub
use mo_mean_mass,   only: set_mean_mass
use mo_setinv,         only : setinv

implicit none

 !real(r8), intent(in):: tracer(nx,ny,nzm, 2*(pcnst-num_moist))
 !real(r8), intent(out) :: tend_cldchem(nx,ny,nzm, 2*(pcnst-num_moist))
 !real(r8), intent(out) :: tend_rename(nx,ny,nzm, 2*(pcnst-num_moist))
 real(r8), intent(in):: tracer(:,:,:,:)
 real(r8), intent(out) :: tend_cldchem(:,:,:,:)
 real(r8), intent(out) :: tend_rename(:,:,:,:)
 real(r8), intent(out) :: aqso4_h2o2(:,:,:)
 real(r8), intent(out) :: aqso4_o3(:,:,:)


 real(r8), intent(in):: pmid (:) !pressure at model levels (Pa)
 real(r8), intent(in):: pdel (:) !pressure thinkness of levels  (Pa)
 real(r8), intent(in):: tl (:) ! temperature (K) 
 real(r8), intent(in):: dtn !time step (s)
 integer, intent(in) :: it ! !it, the column index number
 integer, intent(in) :: jt !  =lchnk
 type(physics_buffer_desc), pointer :: pbuf(:)
!!

!cwat(:,:)          ! cloud liquid water content (kg/kg)
!cldnum(:,:)       ! droplet number concentration (#/kg)
!pmid(:,:)              ! pressure at model levels (Pa)
! pdel(:,:)              ! pressure thickness of levels (Pa)
! mbar(:,:)              ! mean wet atmospheric mass ( amu )
!tfld(:,:)              ! temperature (K)
!delt                   ! time step size (sec)
!loffset                ! offset applied to modal aero "pointers"

!airdens(:,:)           ! total atms density (molec/cm**3)

!------------------------------------------------------
!Local variables
!------------------------------------------------------

 integer :: loffset, ix, iy, m, n, k, km, lnumcw, nn, mm
 real(r8) :: tracer_gcm_tmp(pver,2*gas_pcnst)
 real(r8) :: cwat_3d(1,pver)
 real(r8) :: mmr_3d(1,pver,gas_pcnst)
 real(r8) :: mmrcw(pver,gas_pcnst)
 real(r8) :: mmrcw_sv1(pver,gas_pcnst)
 real(r8) :: mmrcw_sv2(pver,gas_pcnst)
 real(r8) :: mmrcw_3d(1,pver,gas_pcnst)
 real(r8) :: cldnum(1,pver)
 real(r8) :: mbar_3d(1,pver)
 real(r8) :: mbar(pver)
 real(r8) :: vmr(pver,gas_pcnst)
 real(r8) :: vmr_sv1(pver,gas_pcnst)
 real(r8) :: vmr_sv2(pver,gas_pcnst)
 real(r8) :: mmr(pver,gas_pcnst)
 real(r8) :: mmr_sv1(pver,gas_pcnst)
 real(r8) :: mmr_sv2(pver,gas_pcnst)
 real(r8) :: vmrcw(pver,gas_pcnst)
 real(r8) :: vmrcw_sv1(pver,gas_pcnst)
 real(r8) :: vmrcw_sv2(pver,gas_pcnst)
 real(r8) :: vmr_3d(1,pver,gas_pcnst)
 real(r8) :: vmrcw_3d(1,pver,gas_pcnst)
 real(r8) :: airdens_3d(1,pver)
 real(r8) :: cldfr_3d(1,pver)
 real(r8) :: aqso4_h2o2_tmp(pver)
 real(r8) :: aqso4_o3_tmp(pver)
 real(r8) :: xphlwc_tmp(pver)
 integer :: ncol
 integer  :: nstep
 integer  :: nsrflx
 integer  :: jsrflx_rename

 real(r8) :: invariants_full(pcols, pver, nfs)
 real(r8) :: invariants(pver, nfs)
 real(r8) :: t_full(pcols, pver)
 real(r8) :: pmid_full(pcols, pver)
 real(r8) :: pdel_full(pcols, pver)
 real(r8) :: h2ovmr_full(pcols, pver)
 real(r8) :: vmr_full(pcols, pver, gas_pcnst)
 real(r8), allocatable :: qsrflx_full(:, :,:), qqcwsrflx_full(:, :,:)
 real(r8) :: dqdt(pver, gas_pcnst)
 real(r8) :: dqdt_other(pver, gas_pcnst)
 real(r8) :: dqqcwdt(pver, gas_pcnst)
 real(r8) :: dqqcwdt_other(pver, gas_pcnst)
 logical  :: dotendrn(gas_pcnst)
 logical  :: dotendqqcwrn(gas_pcnst)
 logical  :: is_dorename_atik
 logical  :: dorename_atik(pver)

 loffset=imozart-1
         nsrflx = 2
         jsrflx_rename = 2 
         nstep = get_nstep()  
          ncol=1

         allocate  (qsrflx_full(pcols, gas_pcnst, nsrflx))
         allocate  (qqcwsrflx_full(pcols, gas_pcnst, nsrflx))
          !-----------------------------------------------------------------------      
          !        ... Set atmosphere mean mass
          !-----------------------------------------------------------------------      
          call set_mean_mass( ncol, mmr_3d, mbar_3d )
          mbar(:) = mbar_3d(1, :)
          
          !-----------------------------------------------------------------------      
          !        ... Set the "invariants"
          !-----------------------------------------------------------------------  
!==Guangxing Lin          
           !h2ovmr_full(:, :) = 0.0   ! h2ommr is not used in CAM aqueous chemistry, so set it to zero here. 
          h2ovmr_full(:it, :) = 0.0_r8   ! h2ommr is not used in CAM aqueous chemistry, so set it to zero here. 
!==Guangxing Lin          
          do k = 1, pver 
            t_full(:it, k) = tl(k)
            pmid_full(:it, k) = pmid( k)
            pdel_full(:it, k) = pdel( k)
            do n=1, gas_pcnst
              vmr_full(:it, k, n) = vmr(k, n)
            end do
          end do
          call setinv( invariants_full(:it,:,:), t_full, h2ovmr_full(:it,:), vmr_full(:it,:,:), pmid_full, it, jt, pbuf)   ! jt=lchnk
          invariants(:, :) = invariants_full(it, :, :)

          airdens_3d(1,:)=invariants(:,indexm)

do ix=1, nx
  do iy=1,ny
          
          !----------------------------------------------------------------------
          !     calculate cldnum from cloud borne aerosol particles
          !     Vertical coordinate is from bottom to top in the ECEP for tracer,
          !     so convert it to from top to the bottom for aqueous chemistry at CAM.
          !----------------------------------------------------------------------
          do k=1, nzm
            km=pver-k+1
            tracer_gcm_tmp(km,:)=tracer(ix,iy,k,:)
           cwat_3d(1,km)=qcl(ix,iy,k)
          end do

          do k=nzm+1, pver
             km=pver-k+1
            tracer_gcm_tmp(km,:)=0.0_r8
            cwat_3d(1,km)=0.0_r8
          end do

          do k=1,pver
            mmr(k,1:gas_pcnst)=tracer_gcm_tmp(k,1:gas_pcnst)
            mmrcw(k,1:gas_pcnst)=tracer_gcm_tmp(k,(gas_pcnst+1):(2*gas_pcnst))
            do m=1,gas_pcnst
              if(mmr(k,m).lt.0.0) then 
                write(0, *) 'crm_cldchem--1, k= ',k, ' m= ', m, ' mmr= ',mmr(k,m)
                call endrun('negative tracer error in crm_cldchem-----1')
              end if
            end do
          enddo

          mmr_3d(1,:,:)=mmr(:,:)
          mmrcw_3d(1,:,:)=mmrcw(:,:)

          mmr_sv1 = mmr
          mmrcw_sv1 = mmrcw

          cldnum(1,:) = 0.0_r8
          do mm=1, ntot_amode !aerosol modes 
            do nn=1, nspec_amode(mm)!aerosol components
              lnumcw = numptrcw_amode(mm) 
              do k=1, pver
                cldnum(1,k) = cldnum(1,k)+tracer_gcm_tmp(k,lnumcw-num_moist+gas_pcnst) !gas_pcnst=pcnst-num_moist 
              end do
            end do
          end do


          !-----------------------------------------------------------------------      
          !        ... Xform from mmr to vmr
          !-----------------------------------------------------------------------  
      do m = 1,gas_pcnst
           if( adv_mass(m) /= 0._r8 ) then
           do k =1, pver 
             vmr(k,m) = mbar(k) * mmr(k,m) / adv_mass(m)
             vmrcw(k,m) = mbar(k) * mmrcw(k,m) / adv_mass(m)
          end do
          end if
        end do
           do k =1, pver 
            do m=1,gas_pcnst
              if(vmr(k,m).lt.0.0) then 
                write(0, *) 'crm_cldchem--vmr1, k= ',k, ' m= ', m, ' vmr= ',vmr(k,m)
                call endrun('negative tracer error in crm_cldchem-----vmr1')
              end if
            end do
          enddo

         vmr_sv1 = vmr
          vmrcw_sv1 = vmrcw

          vmr_3d(1, :, :) = vmr(:, :) !Guangxing Lin
          vmrcw_3d(1, :, :) = vmrcw(:, :)!==Guangxing Lin



          cldfr_3d(1,:)=1.0d0 ! diagnosed through subroutine clddiag, but temporally set to 1
       
      

          call setsox(   &
            ncol,     &
            jt,    &
            loffset,  &
            dtn,     &
            pmid_full(it:it,:),     &
            pdel_full(it:it,:),     &
            t_full(it:it,:),     &
            mbar_3d,     &
            cwat_3d,     &
            cldfr_3d,    &
            cldnum,   &
            airdens_3d,  &
            invariants_full(it:it,:,:), &
            vmrcw_3d,    &
            vmr_3d,      &
            aqso4_h2o2_tmp(:), aqso4_o3_tmp(:), xphlwc_tmp(:)) 

          
          do k=1, nzm
            km=pver-k+1
            aqso4_h2o2(ix,iy,k)=aqso4_h2o2_tmp(km)
            aqso4_o3(ix,iy,k)=aqso4_o3_tmp(km)
          end do


          vmr(:,:)   = vmr_3d(1,:,:)
          vmrcw(:,:) = vmrcw_3d(1,:,:)
           do k =1, pver 
            do m=1,gas_pcnst
              if(vmr(k,m).lt.0.0) then
                 
               ! if(abs(vmr(k,m)).gt.1.0d-30) then 
                write(0, *) 'crm_cldchem--vmr2, k= ',k, ' m= ', m, ' vmr= ',vmr(k,m), ' vmrsv= ', vmr_sv1(k,m)
                !write(0, *) 'crm_cldchem--vmr2, k= ',k, ' m= ', m, ' cwat ',cwat_3d(1,k), ' cldfra= ', cldfr_3d(1,k)
                !write(0, *) 'crm_cldchem--vmr2, k= ',k, ' m= ', m, ' dtn ',dtn, ' pmid= ', pmid_full(it,k)
                !write(0, *) 'crm_cldchem--vmr2, k= ',k, ' m= ', m,  ' pdel= ', pdel_full(it,k),' t= ',t_full(it,k)
                !write(0, *) 'crm_cldchem--vmr2, k= ',k, ' m= ', m,  ' mbar= ', mbar_3d(1,k),' cldnum= ',cldnum(1,k)
                !write(0, *) 'crm_cldchem--vmr2, k= ',k, ' m= ', m,  ' airdens= ', airdens_3d(1,k),' invar= ',invariants_full(it,k,m), 'nfs= ', nfs
                !write(0, *) 'crm_cldchem--vmr2, invar= ',invariants_full(it,k,m), 'nfs= ', nfs
                 vmr(k,m)=1.0d-30
                !call endrun('negative tracer error in crm_cldchem-----vmr2')
                 !else
                
                 !vmr(k,m)=1.0d-30
               !end if
 
              end if
            end do
            end do
         vmr_sv2 = vmr
          vmrcw_sv2 = vmrcw
          do m = 1,gas_pcnst
           if( adv_mass(m) /= 0._r8 ) then
           do k =1, pver 
             mmr_3d(1,k,m) = adv_mass(m)*vmr(k,m)/mbar(k)
             mmrcw_3d(1,k,m) = adv_mass(m)*vmrcw(k,m)/mbar(k)
             if(mmr_3d(1,k,m).lt.0.0) then
              write(0, *) 'crm_cldchem--2, k= ',k, ' m= ', m, ' mmr= ',mmr_3d(1,k,m)
              call endrun('negative tracer error in crm_cldchem-----2')
             end if
          end do
          end if
        end do
          
          mmr(:, :) = mmr_3d(1, :, :)
          mmrcw(:, :) = mmrcw_3d(1, :, :)
         mmr_sv2 = mmr
          mmrcw_sv2 = mmrcw

          !-----------------------------------------------------------------------      
          !         ... Form the tendencies
          !   Vertical coordinate is from top to bottom in the aqueous chemistry at CAM,  
          !     so convert it to from bottom to the top in the ECPP for chem_tmpb.
          !----------------------------------------------------------------------- 
           
          tend_cldchem(ix,iy,:,:)=0.d0
          do k=1, nzm
            km=pver-k+1
            tend_cldchem(ix,iy,k,1:gas_pcnst)= tend_cldchem(ix,iy,k,1:gas_pcnst)+(mmr(km,1:gas_pcnst)-mmr_sv1(km,1:gas_pcnst)) !kg/kg
            tend_cldchem(ix,iy,k,(gas_pcnst+1):(2*gas_pcnst))=tend_cldchem(ix,iy,k,(gas_pcnst+1):(2*gas_pcnst))+ (mmrcw(km,1:gas_pcnst)-mmrcw_sv1(km,1:gas_pcnst)) !kg/kg
          end do
        
        !-----------------------------------------------------------------------------
        !        ----- renaming: modal aerosol mode merging ------
        !-----------------------------------------------------------------------------
      

         qsrflx_full(:ncol,:,:) = 0.0_r8
            qqcwsrflx_full(:ncol,:,:) = 0.0_r8
            dotendrn(:) = .false.
            dotendqqcwrn(:) = .false.
            dorename_atik(:) = .true.
            is_dorename_atik = .true.
            dqdt (:,:) = 0.0_r8
            dqqcwdt(:,:) = 0.0_r8
            dqdt_other(:,:)=(vmr-vmr_sv1)/dtn
            dqqcwdt_other(:,:)=(vmrcw-vmrcw_sv1)/dtn         
    
       
        call modal_aero_rename_sub('ecep_modal_cloudchem', jt,    &
                                         ncol, nstep,                  &
                                         imozart-1,  dtn,           &
                                         pdel_full,                    &
                                         dotendrn,        vmr,        &
                                         dqdt,        dqdt_other,      &
                                         dotendqqcwrn,    vmrcw,       &
                                         dqqcwdt,    dqqcwdt_other,    &
                                         is_dorename_atik, dorename_atik, &
                                         jsrflx_rename,  nsrflx,       &
                                         qsrflx_full,   qqcwsrflx_full         )
             vmr = vmr + dqdt * dtn
             vmrcw = vmrcw + dqqcwdt * dtn

          do m = 1,gas_pcnst
           if( adv_mass(m) /= 0._r8 ) then
           do k =1, pver 
             mmr_3d(1,k,m) = adv_mass(m)*vmr(k,m)/mbar(k)
             mmrcw_3d(1,k,m) = adv_mass(m)*vmrcw(k,m)/mbar(k)
          end do
          end if
        end do
             mmr(:, :) = mmr_3d(1, :, :)
             mmrcw(:, :) = mmrcw_3d(1, :, :)
!--------------------------------------------------------------------------------
!          Form the tendency
!--------------------------------------------------------------------------------

           tend_rename(ix,iy,:,:)=0.d0
          do k=1, nzm
            km=pver-k+1
            tend_rename(ix,iy,k,1:gas_pcnst)=tend_rename(ix,iy,k,1:gas_pcnst)+(mmr(km,1:gas_pcnst)-mmr_sv2(km,1:gas_pcnst)) !kg/kg
            tend_rename(ix,iy,k,(gas_pcnst+1):(2*gas_pcnst))=tend_rename(ix,iy,k,(gas_pcnst+1):(2*gas_pcnst))+ (mmrcw(km,1:gas_pcnst)-mmrcw_sv2(km,1:gas_pcnst)) !kg/kg
          enddo 

       enddo !iy
    enddo !ix

    deallocate(qsrflx_full)
    deallocate(qqcwsrflx_full)
   
   end subroutine crm_cldchem

end module ECEP_cldchem  
