module module_ECEP_gas_wetdep_driver

  use shr_kind_mod,       only: r8 => shr_kind_r8
  use module_ECEP_support, only:  pcols, pver
  use constituents,   only: pcnst

  implicit none
  save

  private
  public :: ECEP_gas_wetdep_driver

contains

  
  subroutine ECEP_gas_wetdep_driver(          &
       XLAT, tracer, tend_gas_wetdep, &
       lchnk                 )


    use physconst,                 only: mwdry, avogad, gravit
    use mo_sethet,                 only: sethet
    use vars, only: rho, tabs
    use chem_mods,        only : adv_mass, gas_pcnst
    use grid, only: pdel_crm,dt, pres, nx, ny, nzm, phis_crm, zmid_crm
    use  ecppvars, only: precr
    use params, only: ggr, num_moist
    use microphysics, only:  evpr1 
    !
    implicit none

    real(r8),  intent(in) :: XLAT(nx,ny)   !Latitude

    real(r8), intent(in) :: tracer(nx,ny,nzm, 2*(pcnst-num_moist))
    real(r8), intent(out) :: tend_gas_wetdep(nx,ny,nzm, 2*(pcnst-num_moist))
    integer, intent(in)             :: lchnk                         ! chunk index


    !!-----------------------------------------------------------------------
    !!        ... Dummy arguments
    !!-----------------------------------------------------------------------
    integer            :: ncol                          ! number columns in chunk
    real(r8)           :: delt                          ! timestep (s)
    real(r8)           :: tfld(pcols,nzm)               ! midpoint temperature (K)
    real(r8)           :: pmid(pcols,nzm)               ! midpoint pressures (Pa)

    !!-----------------------------------------------------------------------
    !!          ... Local variables
    !!-----------------------------------------------------------------------

    integer  :: i, j,k, m, n
    real(r8) :: zsurf(pcols)                          ! surface height (m)
    real(r8) :: phis(pcols)    
    real(r8) :: cmfdqr(pcols, nzm)
    real(r8) :: nevapr(pcols, nzm)
    real(r8) :: zmid(pcols,nzm)
    real(r8) :: vmr(pcols,nzm,gas_pcnst)              ! xported species (vmr)
    real(r8) :: het_rates(pcols,nzm,gas_pcnst)           !washout rate (1/s)
    real(r8) :: prain(pcols,nzm)

    !Variables needed for porting CAM parameterization in WRF
    integer  ::  icol, itsm1, itile_len
    integer  ::   ktep1, kflip, l, l2, l3
    integer  ::  p1st, ichem
    real(r8) ::  dp, multFrc, fconv
    real(r8) ::  rlat(pcols) 
    real(r8) ::  xhnm(pcols,nzm)


    !Time step for chemistry (following module_cam_mam_aerchem_driver.F)
    delt = dt ! converts to r8
    pver = nzm 

    !Required assignments

    ncol = pcols
    icol = ncol 

    !This subroutine requires that ncol == 1

   tend_gas_wetdep =0.0_r8 
    do j = 1,ny
       do i = 1,nx


          phis(1) =  phis_crm 

          !Flip vertically quantities computed at the mid points
          do k= 1, nzm
             kflip             =  k
             pmid(1,kflip)     = pres(k)*100.d0                   ! mba-->Pa
             tfld(1,kflip)     = tabs(i,j,k)                   !Temprature at the mid points (K) 
             zmid(1,kflip)     = zmid_crm(k)                   !Global grid height (m) 
             rlat(1)           = xlat(i,j)

             prain(1,kflip)=precr(i,j,k) /(pdel_crm(k)/ggr) ! kg/m2/s-->kg/kg/s
             nevapr(1,kflip)=dble(evpr1(i,j,k)) !kg/kg/s  
 
             !xhnm is air density in molecules/cm3 (Formulated by RCE, codded by balwinder.singh@pnnl.gov)
             xhnm(1,kflip) = (avogad*1.0e-6_r8)/(mwdry)*rho(k) !Note that avogad is in kmoles/moles, rho in kg/m3

             do ichem = 1 , gas_pcnst 
                   fconv                = mwdry/adv_mass(ichem)
                   vmr(1,kflip,ichem)   = tracer(i,j,k,ichem)*fconv
             end do

          enddo !enddo for k= 1, nzm



          cmfdqr(:ncol,:) = 0.0_r8 ! CRM does not distinguish convective precipitation and stratiform precipitation

          !Note: Only het_rates is the output from the sethet call
          call sethet( het_rates, pmid, zmid, phis, tfld, &
                   cmfdqr, prain, nevapr, delt, xhnm, & !In original call, invariants(1,1,indexm), is being passed but it is replaced here with xhnm
                   vmr, ncol, lchnk,rlat)
          
          do l2 = num_moist+1, pcnst
             l3                 = l2 - num_moist    
             het_rates(icol,:,l3) = min(max(0._r8, het_rates(icol,:,l3)),(1._r8-1.e-5_r8)/delt) !BSINGH - PMA advised to introduce limit on het_rates to keep vmr positive
             !het_rates(icol,:,l3) = max(0._r8, het_rates(icol,:,l3)) !BSINGH - PMA advised to introduce limit on het_rates to keep vmr positive
             tend_gas_wetdep(i,j,:,l3) =  het_rates(icol,:,l3)*tracer(i,j,:,l3)*delt !het_rates unis is 1/s; so tend_gas_wetdep is dq (kg/kg)
          end do

          !Post processing of the output from CAM's parameterization
          !do kw = kts , kte
          !   kflip = kte-kw+1

           !  do l = p1st, num_chem
           !     l2 = lptr_chem_to_q(l)
           !     if ((l2 >= 1) .and. (l2 <= pcnst)) then
           !        chem(iw,kw,jw,l) = state_q(1,kflip,l2)/factconv_chem_to_q(l)             
           !     end if
           !  end do ! l
          !end do !kw post processing do -loop


       enddo !i do-loop
    enddo    !j do-loop



  end subroutine ECEP_gas_wetdep_driver 

end module module_ECEP_gas_wetdep_driver 
