
       module module_ECEP_mixactivate
       private
       public ECEP_mixactivate
       
       contains 
 
       subroutine ECEP_mixactivate(tracer,qv_crm, qc_crm, qi_crm, t_phy_crm, &
                  w_crm, dtn,  qndrop3d_crm, cldfra_crm, cldfra_old_crm, &
                  tend_activate,dchem_1,dchem_2,dchem_3,dchem_4,dchem_5, &
                  ccn1,ccn2,ccn3,ccn4,ccn5,ccn6, icol,lchnk)

       use modal_aero_data
       use constituents,  only: pcnst
       use vars, only: rho, tk2
       use grid, only:  zmid_crm, adz, dz_crm
       use params, only: ntracers, num_moist
       use grid, only: nx,ny,nzm,nz
       use module_mixactivate, only: mixactivate
       use cam_logfile,  only: iulog 
       implicit none 
  
        REAL, intent(in) :: tracer(nx,ny,nzm, ntracers)
        REAL, intent(out) :: tend_activate(nx,ny,nzm, ntracers)
        REAL, intent(out) :: dchem_1(nx,ny,nzm, pcnst) !debug
        REAL, intent(out) :: dchem_2(nx,ny,nzm, pcnst) !debug
        REAL, intent(out) :: dchem_3(nx,ny,nzm, pcnst) !debug
        REAL, intent(out) :: dchem_4(nx,ny,nzm, pcnst) !debug
        REAL, intent(out) :: dchem_5(nx,ny,nzm, pcnst) !debug
        REAL, intent(in) :: qv_crm(nx,ny,nzm)
        REAL, intent(in) :: qc_crm(nx,ny,nzm)
        REAL, intent(in) :: qi_crm(nx,ny,nzm)
        REAL, intent(in) :: t_phy_crm(nx,ny,nzm) ! temperature (K) 
        REAL, intent(in) :: w_crm(nx,ny,nzm) ! vertical velocity (m/s) 
!        REAL, intent(in) :: ddvel ! deposition velocity (m/s)
        real, intent(in):: dtn !time step (s) 
        !real, intent(in):: dz_crm(nzm) ! layer thickness (m) 
        REAL, intent(inout) :: qndrop3d_crm(nx,ny,nzm)
        real, intent(inout) :: cldfra_crm(nx,ny,nzm), cldfra_old_crm(nx,ny,nzm)   
        real, intent(out) :: ccn1(nx,ny,nzm )  ! number conc of aerosols activated at supersat
        real, intent(out) :: ccn2(nx,ny,nzm )  ! number conc of aerosols activated at supersat
        real, intent(out) :: ccn3(nx,ny,nzm )  ! number conc of aerosols activated at supersat
        real, intent(out) :: ccn4(nx,ny,nzm )  ! number conc of aerosols activated at supersat
        real, intent(out) :: ccn5(nx,ny,nzm )  ! number conc of aerosols activated at supersat
        real, intent(out) :: ccn6(nx,ny,nzm )  ! number conc of aerosols activated at supersat
        integer, intent(in) :: icol, lchnk !ECEP debug
         !local vars

        integer idrydep_onoff
        integer, parameter :: maxd_aphase=2, maxd_atype=ntot_amode, maxd_asize=1, maxd_acomp=maxd_aspectype
        !maxd_atype = ntot_amode
        !maxd_asize = 1
        !maxd_acomp = maxd_aspectype ! should be ntot_aspectype ?
        !maxd_aphase = 2
        real ::   qsrflx(nx,ny,2*pcnst) ! dry deposition rate for aerosol
        real :: qv(nx,nz,ny)  !
        real :: qc(nx,nz,ny)  
        real :: qi(nx,nz,ny)  
        real :: qndrop3d(nx,nz,ny)  
        real :: cldfra(nx,nz,ny)  
        real :: cldfra_old(nx,nz,ny)  
        real :: t_phy(nx,nz,ny)  
        real :: rho_phy(nx,nz,ny)  
        real :: w(nx,nz,ny)  
        real :: z(nx,nz,ny)  
        real :: dz8w(nx,nz,ny)  
        real :: p_at_w(nx,nz,ny)  
        real :: t_at_w(nx,nz,ny)  
        real :: exch_h(nx,nz,ny)  
        real :: nsource(nx,nz,ny)  ! droplet number source (#/kg/s) ! note the order of nzm, ny in the mixactivate subroutine
        real :: ddvel(nx,ny,2*pcnst)  ! number conc of aerosols activated at supersat
        real :: chem(nx,nz,ny,2*pcnst)  ! note pcnst, not ntracers 
        real :: dchem_1_tmp(nx,nz,ny,pcnst)  ! debug 
        real :: dchem_2_tmp(nx,nz,ny,pcnst)  ! debug 
        real :: dchem_3_tmp(nx,nz,ny,pcnst)  ! debug 
        real :: dchem_4_tmp(nx,nz,ny,pcnst)  ! debug 
        real :: dchem_5_tmp(nx,nz,ny,pcnst)  ! debug 
        real :: ccn1_tmp(nx,nz,ny )  ! number conc of aerosols activated at supersat
        real :: ccn2_tmp(nx,nz,ny )  ! number conc of aerosols activated at supersat
        real :: ccn3_tmp(nx,nz,ny )  ! number conc of aerosols activated at supersat
        real :: ccn4_tmp(nx,nz,ny )  ! number conc of aerosols activated at supersat
        real :: ccn5_tmp(nx,nz,ny )  ! number conc of aerosols activated at supersat
        real :: ccn6_tmp(nx,nz,ny )  ! number conc of aerosols activated at supersat
        real :: hygro(nx, nz, ny, maxd_asize, maxd_atype ) ! bulk hygroscopicity
        real :: dtstep !time step
        logical :: f_qc, f_qi
        integer  :: ncomp_aer(maxd_atype),   &
             massptr_aer(maxd_acomp, maxd_asize, maxd_atype, maxd_aphase),   &
             waterptr_aer(maxd_asize, maxd_atype),   &
             numptr_aer(maxd_asize, maxd_atype, maxd_aphase), &
             ai_phase, cw_phase
        integer nsize_aer(maxd_atype)   
        integer nphase_aer,  ntype_aer

        real :: dlo_sect( maxd_asize, maxd_atype ),   & ! minimum size of section (cm)
            dhi_sect( maxd_asize, maxd_atype ),   & ! maximum size of section (cm)
            sigmag_aer(maxd_asize, maxd_atype),   & ! geometric standard deviation of aerosol size dist
            dens_aer( maxd_acomp, maxd_atype),    & ! density (g/cm3) of material
            mw_aer( maxd_acomp, maxd_atype),      & ! molecular weight (g/mole)
            dcen_sect(maxd_asize, maxd_atype)   ! mean-volume diameter (cm) of mode
! terminology:  (pi/6) * (mean-volume diameter)**3 ==
!       (volume mixing ratio of section/mode)/(number mixing ratio)
         integer :: num_chem, n, ll,id, ktau, i, j, it,ids, jds, kds, ide, &
                 jde, kde,ims,jms, kms, ime,jme,kme,its,jts,kts,ite,jte,kte,&
                 mtmp, m,l, lnum, lnumcw, lmass,lmasscw
         real :: tmpa, tmpd, tmpe, tmpf, colmass_bgn, colmass_diff 

       
        ddvel =0.0 !set to be 0.0 in the subroutine of prescribe_aerosol_mixactivate, not sure why!
        mw_aer=132.0 ! in the mixactive subroutine, mw _aer is not used
          
!        parameter (maxd_aphase=2,maxd_atype=1,maxd_asize=1,maxd_acomp=1, max_chem=10) 
          idrydep_onoff = 0
          msectional = 0
          num_chem= 2*pcnst ! 
!   Map the modal aerosol information in modal_aero_data.F90 to module_data_mosaic_asect.F90 
!   In the ECPP written for the WRF-chem, it used the MOSAIC aerosol data. MOSAIC have different
!   classifications, and use aeroso types, aerosol size bins, chemical components, and aerosol phases
!   to describe aerosols. In the CAM4's modal aerosol treatment, it use aerosol modes, and chemical
!   components to describe aerosols, and interstial and cloud-borne aerosols are separately tracked.  
!   When the ECPP codes are ported from the WRF-chem into the MMF model (CAM4.0_SAM), 
!   the MOSAIC's description of the aerosols are kept, in order to minimize
!   the codes changes, but the aerosol information in CAM4.0 is mapped into the MOSAIC one in the
!   following way: aeroso type is equivalent to aerosol modes in CAM4, and aerosol size is one for each aerosol type, 
!   and the aerosol chemical composition is just the same as that in CAM4. Interstitial aerosols in CAM4 is put into
!   the phase 1, and cloud-borne aerosol in CAM4 is put into the pase 2. -Minghuai Wang (minghuai.wang@pnl.gov)
!
        ai_phase = 1      ! index for interstial aerosols
        cw_phase = 2      ! index for cloud-borne aerosols

        ntype_aer = ntot_amode
        nphase_aer = 2
  
        nsize_aer(1:maxd_atype) = 1
        ncomp_aer(1:maxd_atype) = nspec_amode(1:ntot_amode)

        massptr_aer(1:maxd_acomp, 1, 1:maxd_atype, 1) =  &
           lmassptr_amode(1:maxd_aspectype, 1:ntot_amode)
        massptr_aer(1:maxd_acomp, 1, 1:maxd_atype, 2) =  &
              lmassptrcw_amode(1:maxd_aspectype, 1:ntot_amode) + pcnst

        numptr_aer(1, 1:maxd_atype, 1) = numptr_amode(1:ntot_amode)
        numptr_aer(1, 1:maxd_atype, 2) =  &
          numptrcw_amode(1:ntot_amode) + pcnst 

         do n=1, ntype_aer
            !hygro(:,:,:,1, n) = spechygro(lspectype_amode(1, n)) !maxd_asize=1, for hygro
          do ll=1, ncomp_aer(n)
            dens_aer(ll, n) = specdens_amode(lspectype_amode(ll, n))*1e-3 ! 1e-3 is for kg/m3 to g/cm3
!            mw_aer( ll, n)=       =specmw_amode(n)

          end do

          sigmag_aer(1, n) = sigmag_amode(n)  !100.0 from m to cm
! Notes: 
!        the tmpa factor is because
!        dcen_sect, dlo_sect, dhi_sect are used as,
!            and are compared to, volume-mean diameters
!        dgnum_amode, dgnumlo_amode, dgnumhi_amode are used as,
!            and are compared to, number-distribution geometric-mean diameters
!        volume_mixing_ratio/(number_mixing_ratio*pi/6)
!                = volume_mean_diameter**3
!                = (number_geometric_mean_diameter*tmpa)**3

          tmpa = exp( 1.5 * log(sigmag_amode(n))**2 )
          dcen_sect(1, n) =   dgnum_amode(n)*tmpa*100.0 !100.0 from m to cm
          dlo_sect( 1, n) = dgnumlo_amode(n)*tmpa*100.0 !100.0 from m to cm 
          dhi_sect( 1, n) = dgnumhi_amode(n)*tmpa*100.0 !100.0 from m to cm

        end do

        waterptr_aer=-1 ! because we don't track aerosol water 

 
        p_at_w=0.0 ! not used in mixactivate subroutine!
        t_at_w=0.0 ! not used in mixactivate subroutine!

        
        id=1  ! grid%id for debugging, temporally set to be 1 
        ktau =1 !time step count for debugging, temporally set to be 1

        dtstep=dtn

        f_qc= .true.
        f_qi=.true. 
       
          chem=1.0d-30
          qv=0.d0
          qc=0.d0
          qi=0.d0
        
        qndrop3d=0.d0
        t_phy=0.d0
        w=0.d0
        rho_phy=0.d0
        z=0.d0
        dz8w=0.d0
        exch_h=0.d0
        cldfra=0.d0
        cldfra_old=0.d0
 
        do i=1,nx
          do j=1,ny
             chem(i,:,j,1:num_moist)=1.0d-30 ! not used in mixactivate 
             chem(i,:,j,(1+pcnst):(pcnst+num_moist))=1.0d-30 ! not used in mixactivate 
                  
           do id=num_moist+1, pcnst  
             chem(i,1:nzm,j,id)= tracer(i,j,1:nzm,id-num_moist) ! mixing ratio 
             chem(i,1:nzm,j,id+pcnst)=  &
                    tracer(i,j,1:nzm,id-num_moist+pcnst-num_moist) ! mixing ratio, ntracers=pcnst-num_moist 
           end do
             
           do mtmp =1, ntot_amode ! aerosol modes
               do n =1, nspec_amode(mtmp) ! aerosol components
                 chem(i,1:nzm,j,lmassptr_amode(n,mtmp))= & 
                      chem(i,1:nzm,j,(lmassptr_amode(n,mtmp)))*1.0d9 !1e9ug/kg, from kg/kg to ug/kg
                 chem(i,1:nzm,j,(lmassptr_amode(n,mtmp)+pcnst))= &
                       chem(i,1:nzm,j,(lmassptr_amode(n,mtmp)+pcnst))*1.0d9 !1e9ug/kg, from kg/kg to ug/kg
                 !debug
                  !print *, "debug2, lmass= ", lmassptr_amode(n,mtmp)
               enddo 
            end do 
           qv(i,1:nzm,j)= qv_crm(i,j,1:nzm) 
           qc(i,1:nzm,j)= qc_crm(i,j,1:nzm) 
           qi(i,1:nzm,j)= qi_crm(i,j,1:nzm) 
           qndrop3d(i,1:nzm,j)= qndrop3d_crm(i,j,1:nzm) 
           t_phy(i,1:nzm,j)= t_phy_crm(i,j,1:nzm) 
           w(i,1:nzm,j)= w_crm(i,j,1:nzm) 
           rho_phy(i,1:nzm,j) =rho(1:nzm) ! air density (kg/m3)
           z(i,1:nzm,j)=zmid_crm(1:nzm) ! global grid height (m)
           dz8w(i,1:nzm,j) =dz_crm(1:nzm) !vertical layer thinkness, should be got from the zint (grid interface height (m))
           exch_h(i,1:nzm,j)=tk2(i,j,1:nzm)/adz(1:nzm) !vertical diffusivity (m2/s) ?? not sure 
           cldfra(i,1:nzm,j)= cldfra_crm(i,j,1:nzm) 
           cldfra_old(i,1:nzm,j)= cldfra_old_crm(i,j,1:nzm) 
          end do!j
        end do! i

!for debug
!           do mtmp =1, ntot_amode ! aerosol modes
!               do n =1, nspec_amode(mtmp) ! aerosol components
!        do n=1,ntype_aer
!          do m=1,nsize_aer(n)
!           lnum=numptr_aer(m,n,ai_phase)
!           lnumcw=numptr_aer(m,n,cw_phase)
!           write(iulog,*) "mixactivate driver, n= ",n," m= ",m," lnum= ",&
!                 lnum, " lnumcw= ",lnumcw
!            do l=1,ncomp_aer(n)
!              lmass=massptr_aer(l,m,n,ai_phase)
!              lmasscw=massptr_aer(l,m,n,cw_phase)
!           write(iulog,*) "mixactivate driver, n= ",n," m= ",m,&
!                 " lmass= ",lmass, " lmasscw= ",lmasscw, " l= ",l
!            end do
!          end do
!         end do
        ids=1
        jds=1
        kds=1
        ide=nx
        jde=ny
        kde=nzm
        ims=1
        jms=1
        kms=1
        ime=nx
        jme=ny
        kme=nz
        its=1
        jts=1
        kts=1
        ite=nx
        jte=ny
        kte=nzm ! be careful here
        !kte=nzm-1 ! be careful here

          call mixactivate(  msectional, &
           chem, num_chem, qv, qc, qi, qndrop3d,   &
           t_phy, w, ddvel, idrydep_onoff,  &
           maxd_acomp, maxd_asize, maxd_atype, maxd_aphase,   &
           ncomp_aer, nsize_aer, ntype_aer, nphase_aer,  &
           numptr_aer, massptr_aer, dlo_sect, dhi_sect, sigmag_aer, dcen_sect,  &
           dens_aer, mw_aer,           &
           waterptr_aer, hygro,  ai_phase, cw_phase,                &
           ids,ide, jds,jde, kds,kde,                            &
           ims,ime, jms,jme, kms,kme,                            &
           its,ite, jts,jte, kts,kte,                            &
           rho_phy, z, dz8w, p_at_w, t_at_w, exch_h,      &
           cldfra, cldfra_old, qsrflx, &
           ccn1_tmp, ccn2_tmp, ccn3_tmp, ccn4_tmp, ccn5_tmp, ccn6_tmp, nsource,       &
           id, ktau, dtstep, &
           f_qc, f_qi,dchem_1_tmp,dchem_2_tmp,dchem_3_tmp,dchem_4_tmp,dchem_5_tmp )
        
       do i=1,nx
          do j=1,ny
           do mtmp =1, ntot_amode ! aerosol modes
               do n =1, nspec_amode(mtmp) ! aerosol components
                 chem(i,1:nzm,j,lmassptr_amode(n,mtmp))=  & 
                    chem(i,1:nzm,j,(lmassptr_amode(n,mtmp)))*1.0d-9 !1e-9kg/ug, from ug/kg to kg/kg
                 chem(i,1:nzm,j,(lmassptr_amode(n,mtmp)+pcnst))= & 
                    chem(i,1:nzm,j,(lmassptr_amode(n,mtmp)+pcnst))*1.0d-9 !1e9kg/ug, from ug/kg to kg/kg
               enddo 
            end do 
           qndrop3d_crm(i,j,1:nzm)=qndrop3d(i,1:nzm,j) 
           cldfra_crm(i,j,1:nzm)=cldfra(i,1:nzm,j) 
           cldfra_old_crm(i,j,1:nzm)=cldfra_old(i,1:nzm,j) 
           do id=num_moist+1, pcnst  
             tend_activate(i,j,1:nzm,id-num_moist) = &
               chem(i,1:nzm,j,id) - tracer(i,j,1:nzm,id-num_moist) ! mixing ratio kg/kg 
             tend_activate(i,j,1:nzm,id-num_moist+pcnst-num_moist) = &
             chem(i,1:nzm,j,id+pcnst) - tracer(i,j,1:nzm,id-num_moist+pcnst-num_moist) ! mixing ratio kg/kg, ntracers=pcnst-num_moist 
           end do

         !debug
           do mtmp =1, ntot_amode ! aerosol modes
               do n =1, nspec_amode(mtmp) ! aerosol components
                 id=lmassptr_amode(n,mtmp)
              if(id.eq.23) then
               
                colmass_bgn= &
               sum((tracer(i,j,1:nzm,id-num_moist) + tracer(i,j,1:nzm,id-num_moist + pcnst-num_moist))*  &
                  rho(1:nzm) *dz_crm(1:nzm))
                colmass_diff= &
               sum((tend_activate(i,j,1:nzm,id-num_moist) + tend_activate(i,j,1:nzm,id-num_moist + pcnst-num_moist))*  &
                  rho(1:nzm) *dz_crm(1:nzm))
               !print *, "rho_sum= ",sum(rho(1:nzm) ), "dz_sum =", sum(dz_crm(1:nzm)),"icol= ", icol, "lchnk= ",lchnk
              end if
               end do
           end do

            tmpd = colmass_diff 
              tmpe = max( colmass_bgn, 1.0e-20 )

              ! tmpf = (burden change error) / (initial burden)
              if (abs(tmpd) < 1.0e5*tmpe) then
                 tmpf = tmpd/tmpe
              else if (tmpf < 0.0) then
                 tmpf = -1.0e5
              else
                 tmpf = 1.0e5
              end if

           if (abs(tmpf).ge.1.0e-6) then
!              print *, "ECEP_mixactivate,tmpf= ", tmpf, "i= ", i, "j= ",j                
            end if

           do id=1, pcnst
               dchem_1(i,j,1:nzm,id)=dchem_1_tmp(i,1:nzm,j,id)!debug  
               dchem_2(i,j,1:nzm,id)=dchem_2_tmp(i,1:nzm,j,id)!debug  
               dchem_3(i,j,1:nzm,id)=dchem_3_tmp(i,1:nzm,j,id)!debug  
               dchem_4(i,j,1:nzm,id)=dchem_4_tmp(i,1:nzm,j,id)!debug  
               dchem_5(i,j,1:nzm,id)=dchem_5_tmp(i,1:nzm,j,id)!debug
           end do ! id
               ccn1(i,j,1:nzm)=ccn1_tmp(i,1:nzm,j) !  
               ccn2(i,j,1:nzm)=ccn2_tmp(i,1:nzm,j) !  
               ccn3(i,j,1:nzm)=ccn3_tmp(i,1:nzm,j) !  
               ccn4(i,j,1:nzm)=ccn4_tmp(i,1:nzm,j) !  
               ccn5(i,j,1:nzm)=ccn5_tmp(i,1:nzm,j) !  
               ccn6(i,j,1:nzm)=ccn6_tmp(i,1:nzm,j) !  
          end do !j
        end do !i
          
       end subroutine ECEP_mixactivate

       end module module_ECEP_mixactivate
