module ECEP_wetdep 

use cam_abortutils,     only: endrun
use shr_kind_mod,   only: r8 => shr_kind_r8
use constituents,   only: pcnst


implicit none
private 
public :: do_aero_wetdep_crm

contains



    subroutine do_aero_wetdep_crm (tracer,trphys,dt,tend_aero_wetdep)

!!!!!!follow the wet deposition in CAM5

     use  ecppvars, only: precr, rh, prain
     use grid, only: pdel_crm, pres, nx, ny, nzm
     use params
     use vars, only: qcl, qci, tabs
     use microphysics, only: micro_field, evpr1
   !  use crmtracers, only: tracer
     use modal_aero_data 
     use aero_model, only: dlndg_nimptblgrow, nimptblgrow_mind, nimptblgrow_maxd,   &
                scavimptblnum, scavimptblvol
     use modal_aero_wateruptake, only:  modal_aero_kohler
     use ECEP_sub, only: wetdepa_v2_crm, clddiag_crm
     implicit none

     real(r8), intent(in) :: tracer(nx,ny,nzm, 2*(pcnst-num_moist))
     real(r8), intent(in) :: dt 
     real(r8), intent(inout) :: trphys(nzm, 2*(pcnst-num_moist))
     real, intent(out) :: tend_aero_wetdep(nx,ny,nzm, 2*(pcnst-num_moist))
     !local vars

     integer :: lphase                  ! index for interstitial / cloudborne aerosol
     integer :: lspec                   ! index for aerosol number / chem-mass / water-mass
     integer :: m                       ! aerosol mode index
     integer :: mm                      ! tracer index
     integer :: i,j,k,mtmp, n, mmai, jnv, ncol
     real(r8) :: fracis (nx,nzm) 
     real(r8) :: scavt (nx,nzm) 
     real(r8) :: iscavt (nx,nzm) 
     real(r8) :: icscavt (nx,nzm) 
     real(r8) :: isscavt (nx,nzm) 
     real(r8) :: bcscavt (nx,nzm) 
     real(r8) :: bsscavt (nx,nzm) 
     real(r8) :: rcscavt (nx,nzm) 
     real(r8) :: rsscavt (nx,nzm)
     real(r8) :: sol_factb, sol_facti
     real(r8) :: sol_factic(nx,nzm)
     real(r8) :: sol_factbi, sol_factii, sol_factiic
     real(r8) :: scavcoef(nx,nzm,0:2)
     real(r8) :: scavcoefnv(nx,nzm,0:2)
     real(r8) :: scavcoefnv_crm(nx,ny,nzm,ntot_amode,0:2)
     real(r8) :: f_act_conv(nx, nzm) 
     real(r8) :: qqcw_in(nx,nzm)
     real(r8) :: temp_crm(nx,nzm)
     real(r8) :: pres_crm(nx,nzm)
     real(r8) :: q_crm(nx,nzm)
     real(r8) :: fldcw(nx,nzm)
     real(r8) :: qaerwat(nx,nzm)
     real(r8) :: fracis_cw(nx,nzm)
     real(r8) :: dgncur_awet(nx,nzm,ntot_amode)
     real(r8) :: fact_mass, fact_leng, dry_mass_cut, dry_volu_cut
     real(r8) :: temp_num, tmpb
     real(r8) :: dcen_sect(1,ntot_amode) 
     real(r8) :: dlo_sect(1,ntot_amode) 
     real(r8) :: dhi_sect(1,ntot_amode) 
     real(r8) :: volumlo_sect(1,ntot_amode) 
     real(r8) :: volumhi_sect(1,ntot_amode)
     real(r8), parameter :: onethird = 1.0_r8/3.0_r8
     real(r8) :: dry_diam, tmp_hygro, tmp_rh, tmp_rdry, tmp_rwet
     real(r8) :: rdry_in_mak(1), hygro_mak(1), s_mak(1),rwet_out_mak(1)
     real(r8) :: wet_diam, wet_volu,watr_mass, wet_dens, dry_dens
     real(r8) :: dgratio, scavimpvol, scavimpnum,xgrow, tmpfhi
     real(r8) :: tmpflo,dt_crm
     real(r8) :: rtscavt_sv(nx, nzm, (pcnst-num_moist)) ! REASTER 08/12/2015
     real(r8) :: q_tmp(nx,nzm) ! temporary array to hold "most current" mixing ratio for 1 species
     real(r8) :: qqcw_tmp(nx,nzm) ! temporary array to hold qqcw ! rce 2010/05/01 
     real(r8) :: pdel_crm2(nx,nzm) ! kg/m2/s-->kg/kg/s
     real(r8) :: precs_crm(nx,nzm)
     real(r8) :: dqdt_sum(nzm,2*(pcnst-num_moist))
     real(r8) :: dqdt_tmp(nx,nzm)
     real(r8) :: dqdt_tmp_crm(nx,ny,nzm,2*(pcnst-num_moist))
     real(r8) :: sol_facti_cloud_borne = 1._r8
     real(r8) :: f_act_conv_coarse(nx,nzm) ! similar but for coarse mode ! rce 2010/05/02

     real(r8) :: f_act_conv_coarse_dust, f_act_conv_coarse_nacl ! rce 2010/05/02
     real(r8) :: evapc(nx,nzm)     ! Evaporation rate of convective precipitation
     real(r8) :: cmfdqr(nx,nzm)    ! convective production of rain
     real(r8) :: conicw(nx,nzm)    ! convective in-cloud water
     real(r8) :: totcond(nx, nzm)  ! total condensate
     real(r8) :: cldvst(nx,nzm)    ! Stratiform precipitation area at the top interface of current layer 
     real(r8) :: dlf(nx,nzm)    !  Detrainment of convective condensate [kg/kg/s]
     real(r8) :: evaps(nx,nzm),    &! rate of evaporation of precip
         cwat(nx,nzm),     &! cloud water amount 
         cldt(nx,nzm),     &! total cloud fraction
         cldc(nx,nzm),     &! convective cloud fraction
         cldvcu(nx,nzm),     &
         cme(nx,nzm), &
         rainmr(nx, nzm), &        ! rain mixing ratio
         cldv(nx,nzm)       ! total cloud fraction


     real(r8) :: dry_volu, dry_mass, tmpa, tmp_num 
     integer ::  mam_prevap_resusp_optaa10, mam_prevap_resusp_optcc
     integer :: mmtoo,jgrow    
     integer :: jnummaswtr  ! indicates current aerosol species type (0 = number, 1 = dry mass, 2 = water)
    integer, parameter :: jaeronumb=0, jaeromass=1, jaerowater=2

     logical, parameter :: do_aero_water_removal = .false.
     logical :: do_hygro_sum_del, do_lphase1, do_lphase2
     logical :: sscav_tuning, convproc_do_aer
     character(len=100) :: msg
    

     tend_aero_wetdep=0.00 
     sscav_tuning=.false.   !CAM5 originally read from the namelist   
     convproc_do_aer =.false. !CAM5 orignially read from the namelist 
               ncol =nx

               dt_crm=dt

         f_act_conv =0.d0 
    ! calculate the dgnumwet
        fact_mass = 1.0_r8      ! kg/kgair, unchanged
                fact_leng = 1.0_r8      ! m, unchanged
                dry_mass_cut = 1.0e-29_r8   ! kg/kgair = 1.0e-20 ug/kgair
                dry_volu_cut = 1.0e-32_r8   ! m^3/kgair


    do j = 1,ny
       do i = 1,nx
         do k= 1, nzm
       !calc dry mass and dry volume mixing raions
        do mtmp =1, ntot_amode ! aerosol modes
           
          dry_volu=0.d0
          dry_mass=0.d0
          tmp_hygro=0.d0
          do n =1, nspec_amode(mtmp) ! aerosol components
            tmpa=tracer(i,j,k,(lmassptr_amode(n,mtmp)-num_moist)) 
            dry_mass=dry_mass+ tmpa
            dry_volu=dry_volu+ tmpa/specdens_amode(lspectype_amode(n,mtmp)) 
            tmp_hygro=tmp_hygro + (tmpa/specdens_amode(lspectype_amode(n,mtmp))*spechygro(lspectype_amode(n,mtmp)))
           end do
!               if negligible aerosol is present at this size and type, cycle
                if ((dry_mass < dry_mass_cut) .or. (dry_volu < dry_volu_cut)) then
                    ! BUT FIRST set dgn_dry/wet and chem_sub( ... water ... ) to default values
                    cycle
                end if
!               calc volume_mean dry diameter

                tmp_num = tracer(i,j,k,(numptr_amode(mtmp)-num_moist))
                 
                tmpb = exp( 1.5 * log(sigmag_amode(mtmp))**2 )
                dcen_sect(1, mtmp) =   dgnum_amode(mtmp)*tmpb
                dlo_sect( 1, mtmp) = dgnumlo_amode(mtmp)*tmpb
                dhi_sect( 1, mtmp) = dgnumhi_amode(mtmp)*tmpb

                volumlo_sect(1, mtmp) = pi/6.d0 * (dgnumlo_amode(mtmp)*tmpb)**3
                volumhi_sect(1, mtmp) = pi/6.d0 * (dgnumhi_amode(mtmp)*tmpb)**3  
   
                if (dry_volu <= tmp_num*volumlo_sect(1,mtmp)) then
                    dry_diam = dlo_sect(1,mtmp)
                else if (dry_volu >= tmp_num*volumhi_sect(1,mtmp)) then
                    dry_diam = dhi_sect(1,mtmp)
                else
                    dry_diam = (dry_volu/(tmp_num*pi/6.0d0))**onethird
                end if
!               calc volume-mean wet diameter
                tmp_hygro = tmp_hygro*fact_mass/dry_volu
                tmp_rh = max( 0.0_r8, min( 0.99_r8, rh(i,j,k) ) )
                tmp_rdry = dry_diam*0.5_r8*fact_leng   ! cm OR m --> m
                tmp_rwet = tmp_rdry

                rdry_in_mak(1) = tmp_rdry
                hygro_mak(1) = tmp_hygro
                s_mak(1) = tmp_rh
                rwet_out_mak(1) = tmp_rwet
                call modal_aero_kohler( rdry_in_mak, hygro_mak, s_mak, rwet_out_mak, 1)
                tmp_rwet = rwet_out_mak(1)

                wet_diam = tmp_rwet*2.0_r8/fact_leng   ! m --> cm OR m
                wet_diam = min( wet_diam, dry_diam*100.0_r8, 50.0e-6_r8/fact_leng )
                wet_diam = max( wet_diam, dry_diam )  
    
                wet_volu = dry_volu * (wet_diam/dry_diam)**3   ! cm^3/kgair
                watr_mass = max( 0.0_r8, (wet_volu-dry_volu) )   ! g/kgair, as rho_water = 1.0 g/cm^3
! *** eventually should store this in some array that can be used by cam3
!     for now, leave it alone
!               chem_tmpa(k,icc,jcls,ipp,waterptr_aer(m,n)) = watr_mass/fact_mass

                wet_dens = (dry_mass + watr_mass)/wet_volu
                dry_dens = dry_mass/dry_volu

!   compute impaction scavenging removal amount for volume
!               interpolate table values using log of (actual-wet-size)/(base-dry-size)

!   in the bcscavcoef_get routine, dgratio = dgnum_wet/dgnum_amode
!   BUT dgnum_wet/dgnum_amode = (b*dgnum_wet)/(b*dgnum_amode) = dvolmean_wet/dcen_sect
!       where b = exp( 1.5 * (log(sigmag)**2) )
!               dgratio = ((wet_volu/dry_volu)**onethird) * (dry_diam/dcen_sect(m,n))
                dgratio = wet_diam/dcen_sect(1,mtmp)

                if ((dgratio .ge. 0.99) .and. (dgratio .le. 1.01)) then
                    scavimpvol = scavimptblvol(0,1)
                    scavimpnum = scavimptblnum(0,1)
                else
                    xgrow = log( dgratio ) / dlndg_nimptblgrow
                    jgrow = int( xgrow )
                    if (xgrow .lt. 0.) jgrow = jgrow - 1
                    if (jgrow .lt. nimptblgrow_mind) then
                        jgrow = nimptblgrow_mind
                        xgrow = jgrow
                    else
                        jgrow = min( jgrow, nimptblgrow_maxd-1 )
                    end if


                    tmpfhi = xgrow - jgrow
                    tmpfhi = max( 0.0_r8, min( 1.0_r8, tmpfhi ) )
                    tmpflo = 1.0_r8 - tmpfhi
                    scavimpvol = tmpflo*scavimptblvol(jgrow,1) +   &
                                 tmpfhi*scavimptblvol(jgrow+1,1)
                    scavimpnum = tmpflo*scavimptblnum(jgrow,1) +   &
                                 tmpfhi*scavimptblnum(jgrow+1,1)
                end if

                
                !impaction scavenging removal amount for volume
                scavcoefnv_crm(i,j,k,mtmp,2) = exp( scavimpvol )
                !impaction scavenging removal amount to number
                scavcoefnv_crm(i,j,k,mtmp,1) = exp( scavimpnum )
             end do !mtmp
            end do !k
           end do !i


 
         scavcoefnv_crm(:,j,:,:,0) = 0.0_r8 ! below-cloud scavcoef = 0.0 for cloud-borne species
         
    if ( mam_prevap_resusp_optaa >= 20 ) then
       ! resuspension goes to a different phase or mode
       rtscavt_sv(:,:,:) = 0.0_r8
    endif

    ! calculate the mass-weighted sol_factic for coarse mode species
    ! sol_factic_coarse(:,:) = 0.30_r8 ! tuned 1/4
    f_act_conv_coarse(:,:) = 0.60_r8 ! rce 2010/05/02
    f_act_conv_coarse_dust = 0.40_r8 ! rce 2010/05/02
    f_act_conv_coarse_nacl = 0.80_r8 ! rce 2010/05/02



mmode_loop_aa: &
! REASTER 08/11/2015 BEGIN
    do mtmp = 1, ntot_amode ! main loop over aerosol modes
       m = mtmp
       if (ntot_amode == 4) then
          ! for mam4, do accum, aitken, pcarbon, then coarse 
          if (mtmp == modeptr_coarse) then
             m = ntot_amode
          else if (mtmp > modeptr_coarse) then
             m = mtmp - 1
          endif
       endif
! REASTER 08/11/2015 END

       !BSINGH: loop counters (strt_loop,end_loop and stride_loop) are selected based on whether
       ! convproc_do_aer is true or false in the aero_model_init subroutine above

lphase_loop_aa: &
       do lphase = 1, 2 ! loop over interstitial (1) and cloud-borne (2) forms


            if (lphase == 1) then ! interstial aerosol
               if (sscav_tuning) then
                sol_factb  = 0.03_r8   ! all below-cloud scav ON (0.1 "tuning factor")  ! tuned 1/6
             else
                sol_factb  = 0.1_r8    ! all below-cloud scav ON (0.1 "tuning factor")
             endif

             ! sol_factb = 0.03_r8 ! all below-cloud scav ON (0.1 "tuning factor") ! tuned 1/6

             sol_facti = 0.0_r8 ! strat in-cloud scav totally OFF for institial

             sol_factic = 0.4_r8 ! xl 2010/05/20

             if (m == modeptr_pcarbon) then
                ! sol_factic = 0.0_r8 ! conv in-cloud scav OFF (0.0 activation fraction)
                f_act_conv = 0.0_r8 ! rce 2010/05/02
             else if ((m == modeptr_finedust) .or. (m == modeptr_coardust)) then
                ! sol_factic = 0.2_r8 ! conv in-cloud scav ON (0.5 activation fraction) ! tuned 1/4
                f_act_conv = 0.4_r8 ! rce 2010/05/02
             else
                ! sol_factic = 0.4_r8 ! conv in-cloud scav ON (1.0 activation fraction) ! tuned 1/4
                if (sscav_tuning) then
                   f_act_conv = 0.4_r8   ! rce 2010/05/02
                else
                   f_act_conv = 0.8_r8   ! rce 2010/05/02
                endif

             end if
          
         else ! cloud-borne aerosol (borne by stratiform cloud drops)

             sol_factb  = 0.0_r8   ! all below-cloud scav OFF (anything cloud-borne is located in-cloud)
             if (sscav_tuning) then
                sol_facti  = min(0.6_r8, sol_facti_cloud_borne)  ! strat  in-cloud scav totallyoON for cloud-borne  ! tuned 1/6
             else
                sol_facti  = sol_facti_cloud_borne   ! strat  in-cloud scav cloud-borne tuning factor
             endif
             sol_factic = 0.0_r8   ! conv   in-cloud scav OFF (having this on would mean
                                   !        that conv precip collects strat droplets)
             f_act_conv = 0.0_r8   ! conv   in-cloud scav OFF (having this on would mean

        end if

             !
          ! rce 2010/05/03
          ! wetdepa has 6 "sol_fact" parameters:
          ! sol_facti, sol_factic, sol_factb for liquid cloud
          ! sol_factii, sol_factiic, sol_factbi for ice cloud
          ! the ice cloud parameters are optional, and if not provided, they default to
          ! one of the other sol_fact parameters (see subr. wetdepa about this)
          ! for now, we set the ice cloud parameters equal
          ! to their liquid cloud counterparts
          ! currently the ice parameters are not used in wetdepa as
          ! wetdepa sets "weight" (the ice cloud fraction) to 0.0
          ! if this changes, we will have to give more thought to
          ! the ice cloud parameter values
          !
          sol_factbi = sol_factb
          sol_factii = sol_facti
          sol_factiic = sol_factic(1,1)

   
! REASTER 08/12/2015 - changed ordering (mass then number) for prevap resuspend to coarse
lspec_loop_aa: &
          do lspec = 1, nspec_amode(m)+2 ! loop over number + chem constituents + water

             mmai = 0
             if (lspec <= nspec_amode(m)) then ! non-water mass
                jnummaswtr = jaeromass
                if (lphase == 1) then
                   mm = lmassptr_amode(lspec,m)
                   jnv = 2
                else
                   mm = lmassptrcw_amode(lspec,m)
                   mmai = lmassptr_amode(lspec,m)
                   jnv = 0
                endif
             else if (lspec == nspec_amode(m)+1) then ! number
                jnummaswtr = jaeronumb
                if (lphase == 1) then
                   mm = numptr_amode(m)
                   jnv = 1
                else
                   mm = numptrcw_amode(m)
                   mmai = numptr_amode(m)
                   jnv = 0
                                               
                endif
             else ! water mass
                ! bypass wet removal of aerosol water
                jnummaswtr = jaerowater
                if (convproc_do_aer) then
                   if ( .not. do_aero_water_removal ) cycle
                else
                   cycle
                endif
                if (lphase == 1) then
                   mm = 0
                   ! mm = lwaterptr_amode(m)
                   jnv = 2
                else
                   mm = 0
                   jnv = 0
                endif
             endif
             if (mm <= 0) cycle


             mam_prevap_resusp_optaa10 = mam_prevap_resusp_optaa/10

! mam_prevap_resusp_optcc values control the prevap_resusp calculations in wetdepa_v2:
!     0 = no resuspension
!     1 = linear resuspension of aerosol mass or number following original mam coding
!         and history_aero_prevap_resusp = .false.
!     2 = same as 1 but history_aero_prevap_resusp = .true.
!     3 = same as 2 but with some added "xxx = max( 0, xxx)" lines
!
!   130 = non-linear resuspension of aerosol mass   based on scavenged aerosol mass
!   230 = non-linear resuspension of aerosol number based on raindrop number
!   the 130 thru 230 all use the new prevap_resusp code block in subr wetdepa_v2
!       and all have history_aero_prevap_resusp = .true.
!
             mam_prevap_resusp_optcc = 0

             if ( mam_prevap_resusp_optaa == 0 ) then
                mam_prevap_resusp_optcc = 0
             else if ( mam_prevap_resusp_optaa == 10 ) then
                mam_prevap_resusp_optcc = 1
             else if ( mam_prevap_resusp_optaa == 11) then
                mam_prevap_resusp_optcc = 2

             else if ( mam_prevap_resusp_optaa == 20 ) then
                mam_prevap_resusp_optcc = 2
             else if ( mam_prevap_resusp_optaa == 21 ) then
                mam_prevap_resusp_optcc = 3

             else if ( mam_prevap_resusp_optaa == 30 ) then
                if ( jnummaswtr == jaeromass ) then
                   mam_prevap_resusp_optcc = 130
                else if ( jnummaswtr == jaeronumb .and. &
                          lphase == 1     .and. &
                          m == modeptr_coarse ) then
                   mam_prevap_resusp_optcc = 230
                endif

             endif

           if ( mam_prevap_resusp_optcc /=   0 .and. &
                  mam_prevap_resusp_optcc /=   1 .and. &
                  mam_prevap_resusp_optcc /=   2 .and. &
                  mam_prevap_resusp_optcc /=   3 .and. &
                  mam_prevap_resusp_optcc /= 130 .and. &
                  mam_prevap_resusp_optcc /= 230 ) then
                write(msg,'(a,2(1x,i10))') &
                   'aero_model_wetdep - bad mam_prevap_resusp_optaa & cc =', &
                   mam_prevap_resusp_optaa, mam_prevap_resusp_optcc
                call endrun( msg )
             endif

             ! set f_act_conv for interstitial (lphase=1) coarse mode species
             ! for the convective in-cloud, we conceptually treat the coarse dust and seasalt
             ! as being externally mixed, and apply f_act_conv = f_act_conv_coarse_dust/nacl to dust/seasalt
             ! number and sulfate are conceptually partitioned to the dust and seasalt
             ! on a mass basis, so the f_act_conv for number and sulfate are
             ! mass-weighted averages of the values used for dust/seasalt
             if ((lphase == 1) .and. (m == modeptr_coarse)) then
                ! sol_factic = sol_factic_coarse
                f_act_conv = f_act_conv_coarse ! rce 2010/05/02
!               if (lspec > 0) then
                if (jnummaswtr == jaeromass) then
                   if (lmassptr_amode(lspec,m) == lptr_dust_a_amode(m)) then
                      ! sol_factic = 0.2_r8 ! tuned 1/4
                      f_act_conv = f_act_conv_coarse_dust ! rce 2010/05/02
                   else if (lmassptr_amode(lspec,m) == lptr_nacl_a_amode(m)) then
                      ! sol_factic = 0.4_r8 ! tuned 1/6
                      f_act_conv = f_act_conv_coarse_nacl ! rce 2010/05/02
                   end if
                end if
             end if

          temp_crm(:,:)=tabs(:,j,:)
          q_crm(:,:) = micro_field(:,j,:,1)!kg/kg !total vapor, not used in wedepa_v2_crm! 
          cmfdqr=0.d0
          evapc=0.d0
          dlf=0.d0
          conicw=0.d0
          f_act_conv =0.d0  !because crm don't seperate convective precipitation from stratiform precipitaion 
          do k=1,nzm
             pdel_crm2(:,k)=(pdel_crm(k)) 
	     pres_crm(:,k)=pres(k)*100.d0 !(nzm) mb-->Pa
             !precs_crm(:,k)=precr(:,j,k) /(pdel_crm(k)/ggr) ! kg/m2/s-->kg/kg/s
             precs_crm(:,k)=prain(:,j,k)  ! kg/kg/s
          end do
          evaps(:,:)=evpr1(:,j,:) !kg/kg/s
          cwat(:,:)=qcl(:,j,:) + qci(:,j,:) !kg/kg
          !cwat(:,:)=qcl(:,j,:)  !kg/kg debug
          cldt(:,:)=1.0d0 !total cloud fraction, not needed thou? temporally set to 1
          cldc(:,:)=0.d0 ! convective cloud fraction
          !cldv(:,:)=1.0d0 ! diagnosed through subroutine clddiag, but temporally set to 1
          !cldvcu(:,:)=0.d0 !diagnosed
          !cldvst(:,:)=1.0d0 !diagnosed, but temporally set to 1
          scavcoefnv(:,:,:)=scavcoefnv_crm(:,j,:,mtmp,:)

          !Commented out currently as CME is NEVER used in wetscaging code
           cme(:,:)         = 0.0                                          !Net condensation rate (kg/kg/s)
           
          !OUTPUT- cldv, cldvcu, cldvst and rainmr 

          !!   fields needed for wet scavenging
          call clddiag_crm( temp_crm, pres_crm, pdel_crm2, cmfdqr, evapc, cldt, cldc, cldt, cme, evaps, precs_crm, &
               cldv, cldvcu, cldvst, rainmr, ncol )

lphase_jnmw_conditional: &
             if ((lphase == 1) .and. (jnummaswtr /= jaerowater)) then
!            if ((lphase == 1) .and. (lspec <= nspec_amode(m))) then
                dqdt_tmp(:,:) = 0.0_r8
                q_tmp(1:ncol,:) = tracer(1:ncol,j,:,mm-num_moist) 
                 qqcw_in(:,:) = tracer(:,j,:,(mm-num_moist+pcnst-num_moist))

             ! q_tmp=3.0d-9 !test Guangxing Lin 
               
               call wetdepa_v2_crm( &
                     ncol, dt_crm, &
                     temp_crm, pres_crm, q_crm, pdel_crm2, &
                     cmfdqr, evapc, dlf, conicw, &  
                     precs_crm, cldc, evaps, cwat, &
                     cldt, cldc,cldv, cldvcu, cldvst, &
                     sol_factb, sol_factbi, sol_facti, sol_factii, sol_factic, sol_factiic, &
                     mam_prevap_resusp_optcc, .false., scavcoefnv(:,:,jnv),  f_act_conv, &
                     q_tmp, qqcw_in(:,:), &
                     fracis(:,:), dqdt_tmp, iscavt, &
                     icscavt, isscavt, bcscavt, bsscavt, rcscavt, rsscavt )

! REASTER 08/12/2015 BEGIN
                if ( mam_prevap_resusp_optaa10 == 3 ) then
                   ! resuspension goes to coarse mode
                   ! first deduct the current resuspension from the dqdt_tmp of the current species
                   dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) - ( rcscavt(1:ncol,:) + rsscavt(1:ncol,:) )
                   ! then add the current resuspension to the rtscavt_sv of the appropriate coarse mode species
                   mmtoo = mmtoo_prevap_resusp(mm)
                   if (mmtoo > 0) rtscavt_sv(1:ncol,:,mmtoo) = rtscavt_sv(1:ncol,:,mmtoo) &
                                  + ( rcscavt(1:ncol,:) + rsscavt(1:ncol,:) )
                   ! then add the rtscavt_sv of the current species to the dqdt_tmp of the current species
                   ! note that for so4_a3 and mam3, the rtscavt_sv at this point will have resuspension contributions
                   !    from so4_a1/2/3 and so4c1/2/3
                   dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) + rtscavt_sv(1:ncol,:,mm)

                endif
! REASTER 08/12/2015 END

!               if (convproc_do_aer) then
                if ( mam_prevap_resusp_optaa10 == 2 ) then
                   ! add resuspension of cloudborne species to dqdt of interstitial species
!                  dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) + rtscavt_sv(1:ncol,:,lspec)  ! RCE 2012/01/12
                   dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) + rtscavt_sv(1:ncol,:,mm)  ! REASTER 08/12/2015
                endif

                do_hygro_sum_del = .false.
!               if ( lspec > 0 ) do_hygro_sum_del = .true. 
                if ( jnummaswtr == jaeromass ) do_hygro_sum_del = .true.
                if (convproc_do_aer) then
                   do_hygro_sum_del = .false.
!                  if ( (lspec > 0) .and. do_aero_water_removal ) then  !RCE 2012/01/12
                   if ( (jnummaswtr == jaeromass) .and. do_aero_water_removal ) then
                      do_hygro_sum_del = .true.
                   endif
                endif

             elseif (lphase == 2) then lphase_jnmw_conditional ! lphase == 2
                do_lphase2 = .true.
! REASTER 08/11/2015 start
! There is no cloud-borne aerosol water in the model, so the do_lphase2 code block
! should NEVER execute for lspec = nspec_amode(m)+1 (i.e., jnummaswtr = jaerowater).
! The code only worked because the "do lspec" loop cycles when lspec = nspec_amode(m)+1,
! but that does not make the code correct.
!               if (convproc_do_aer) then
!                  do_lphase2 = .false.
!                  if (lspec <= nspec_amode(m)) do_lphase2 = .true.
!               endif
                if (jnummaswtr == jaerowater) do_lphase2 = .false.
! REASTER 08/11/2015 end
do_lphase2_conditional: &
                if ( do_lphase2 ) then
                   dqdt_tmp(:,:) = 0.0_r8
                   if (convproc_do_aer) then
 !nothing
                   else
                      qqcw_tmp(:,:) = 0.0_r8 ! rce 2010/05/01
                      fldcw(:,:) = tracer(:,j,:,(mm-num_moist+pcnst-num_moist))
                      !fldcw=3.0d-9 !test Guangxing Lin
                   endif


               call wetdepa_v2_crm( &
                     ncol, dt_crm, &
                     temp_crm, pres_crm, q_crm, pdel_crm2, &
                     cmfdqr, evapc, dlf, conicw, &  
                     precs_crm, cldc, evaps, cwat, &
                     cldt, cldc,cldv, cldvcu, cldvst, &
                     sol_factb, sol_factbi, sol_facti, sol_factii, sol_factic, sol_factiic, &
                     mam_prevap_resusp_optcc, .true., scavcoefnv(:,:,jnv),  f_act_conv, &
                     fldcw, qqcw_tmp, &
                     fracis_cw, dqdt_tmp, iscavt, &
                     icscavt, isscavt, bcscavt, bsscavt, rcscavt, rsscavt )
! REASTER 08/12/2015 BEGIN
                if ( mam_prevap_resusp_optaa10 == 3 ) then
                   ! resuspension goes to coarse mode
                   ! first deduct the current resuspension from the dqdt_tmp of the current species
                   dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) - ( rcscavt(1:ncol,:) + rsscavt(1:ncol,:) )
                   ! then add the current resuspension to the rtscavt_sv of the appropriate coarse mode species
                   mmtoo = mmtoo_prevap_resusp(mm)
                   if (mmtoo > 0) rtscavt_sv(1:ncol,:,mmtoo) = rtscavt_sv(1:ncol,:,mmtoo) &
                                  + ( rcscavt(1:ncol,:) + rsscavt(1:ncol,:) )

                endif
! REASTER 08/12/2015 END

!                  if (convproc_do_aer) then
                   if ( mam_prevap_resusp_optaa10 == 2 ) then
                      ! the original wetdepa_v2 adds the resuspension of cloudborne aerosol species 
                      !    to the dqdt of cloudborne species (as a source)
                      ! when resus_fix=.true. and/or mam_prevap_resusp_optaa=20,21 ) then
                      !    > save resuspension of cloudborne species to rtscavt_sv
                      !    > deduct it from the tendency (dqdt_tmp) of the cloudborne   species
                      !    > add    it to   the tendency (dqdt_tmp) of the interstitial species (which is done above)
!                     rtscavt_sv(1:ncol,:,lspec) = rcscavt(1:ncol,:) + rsscavt(1:ncol,:)  ! RCE 2012/01/12
                      if ( 0 < mmai .and. mmai <= pcnst ) then
                         rtscavt_sv(1:ncol,:,mmai) = rcscavt(1:ncol,:) + rsscavt(1:ncol,:)  ! REASTER 08/11/2015
                      else
                         write(msg,'(a,3(1x,i5))') 'aero_model_wetdep - bad mmai - m, mm, mmai =', m, mm, mmai
                         call endrun( msg )
                      endif
!                     dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) - rtscavt_sv(1:ncol,:,lspec)  ! RCE 2012/01/12                     
                      dqdt_tmp(1:ncol,:) = dqdt_tmp(1:ncol,:) - rtscavt_sv(1:ncol,:,mmai)  ! REASTER 08/11/2015
                   endif

                   fldcw(1:ncol,:) = fldcw(1:ncol,:) + dqdt_tmp(1:ncol,:) * dt

                  
                endif do_lphase2_conditional

             endif lphase_jnmw_conditional
             if(lphase.eq.1) then
                dqdt_tmp_crm(:,j,:,mm-num_moist)=dqdt_tmp(:,:)
                tend_aero_wetdep(1:ncol,j,1:nzm,mm-num_moist)=(dqdt_tmp(1:ncol,1:nzm))*dt ! kg/kg
             else 
                dqdt_tmp_crm(:,j,:,(mm-num_moist+pcnst-num_moist))=dqdt_tmp(:,:)
                tend_aero_wetdep(1:ncol,j,1:nzm,(mm-num_moist+pcnst-num_moist))=(dqdt_tmp(1:ncol,1:nzm))*dt !kg/kg
             endif
          enddo lspec_loop_aa ! lspec = 1, nspec_amode(m)+2
       enddo lphase_loop_aa ! lphase = 1, 2
    enddo mmode_loop_aa ! m = 1, ntot_amode

   end do !j=1,ny

   dqdt_sum(:,:)=0.d0

   do j=1,ny
     do i=1,nx
        dqdt_sum(:,:)=dqdt_sum(:,:) + dqdt_tmp_crm(i,j,:,:)
     end do
   end do
      trphys(1:nzm,:)=dqdt_sum(1:nzm,:)/nx*ny

   endsubroutine do_aero_wetdep_crm  

end module ECEP_wetdep
