module crmtracers
 use grid
 use constituents,    only:  pcnst,cnst_name
 use modal_aero_data 
 use params, only: ntracers, num_moist

 use cam_abortutils,   only: endrun
! This module serves as a template for adding tracer transport in the model. The tracers can be 
! chemical tracers, or bin microphysics drop/ice categories, etc. 
! The number of tracers is set by the parameter ntracers which is set in domain.f90.
! Also, the logical flag dotracers should be set to .true. in namelist (default is .false.).
! The model will transport the tracers around automatically (advection and SGS diffusion).
! The user must supply the initialization in the subroutine tracers_init() in this module.
! By default, the surface flux of all tracers is zero. Nonzero values can be set in tracers_flux().
! The local sinks/sources of tracers should be supplied in tracers_physics().



 implicit none

 real  tracer  (dimx1_s:dimx2_s, dimy1_s:dimy2_s, nzm, ntracers) 
 real  fluxbtr (nx, ny, ntracers) ! surface flux of tracers
 real fluxttr (nx, ny, ntracers) ! top boundary flux of tracers
 real trwle(nz,ntracers)  ! resolved vertical flux 
 real  trwsb(nz,ntracers)  ! SGS vertical flux 
 real tradv(nz,ntracers)  ! tendency due to vertical advection 
 real trdiff(nz,ntracers)  ! tendency due to vertical diffusion 
 real trphys(nz,ntracers)  ! tendency due to physics 
 real*8 tend_cldchem(nx,ny,nz,ntracers)  ! tendency due to cloud chemistry 
 real tend_cldchem_sum(nx,ny,nz,ntracers)  ! tendency due to cloud chemistry 
 real*8 tend_rename(nx,ny,nz,ntracers)  ! tendency due to rename in cloud chemistry 
 real tend_rename_sum(nx,ny,nz,ntracers)  ! tendency due to rename in cloud chemistry 
 real*8 tend_gas_wetdep(nx,ny,nz,ntracers)  ! tendency due to gas wet deposition 
 real tend_gasdep_sum(nx,ny,nz,ntracers)  ! tendency due to gas wet deposition 
 real tend_aero_wetdep(nx,ny,nz,ntracers)  ! tendency due to aerosol wet deposition 
 real tend_aerdep_sum(nx,ny,nz,ntracers)  ! tendency due to aerosol wet deposition 
 real tend_activate(nx,ny,nz,ntracers)  ! tendency due to aerosol activation to cloud droplets 
 real tend_activate_sum(nx,ny,nz,ntracers)  ! tendency due to aerosol activation to cloud droplets 
 character *16 tracername(ntracers)
 character *10 tracerunits(ntracers)
 real cldfrac(nx,ny,nz)  ! cloud fraction 
 real cldfrac_old(nx,ny,nz)  ! cloud fraction at previous time step 
 real dchem_1_sum(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_2_sum(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_3_sum(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_4_sum(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_5_sum(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_1(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_2(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_3(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_4(nx,ny,nz,pcnst)  ! for debug only 
 real dchem_5(nx,ny,nz,pcnst)  ! for debug only 
 real ccn1_crm(nx,ny,nzm)  ! 
 real ccn2_crm(nx,ny,nzm)  ! 
 real ccn3_crm(nx,ny,nzm)  ! 
 real ccn4_crm(nx,ny,nzm)  ! 
 real ccn5_crm(nx,ny,nzm)  ! 
 real ccn6_crm(nx,ny,nzm)  ! 
 real*8 aqso4_h2o2(nx,ny,nzm)  ! 
 real*8 aqso4_o3(nx,ny,nzm)  ! 
 real*8 aqso4_h2o2_sum(nx,ny,nzm)  ! 
 real*8 aqso4_o3_sum(nx,ny,nzm)  ! 
 integer spe_class_aer(ntracers) !whether the species is aerosol  
 real tracertend(nzm,ntracers) !large scale tendency for tracer !ECEP 
 real q_trac0(nzm,ntracers) !tracer mixing ratio averaged over the CRM domain, serving for the large scale tendency !ECEP 
  
CONTAINS

 subroutine tracers_init()
  use microphysics, only : micro_field
  use vars, only: qcl, qci
  integer k,ntr, m,l, lspec
  character *2 ntrchar
  integer, external :: lenstr
   real, parameter :: thresh=1.0e-6
  integer ichem 
  character(len=16)   :: tmpname
  integer :: j,i
 !tracer = 1.0d-3
 fluxbtr = 0.
 fluxttr = 0.


  tend_rename =0.0
  tend_cldchem=0.0
  tend_cldchem_sum=0.0
  tend_rename_sum=0.0
  dchem_1_sum=0.0
  dchem_2_sum=0.0
  dchem_3_sum=0.0
  dchem_4_sum=0.0
  dchem_5_sum=0.0
  tend_gas_wetdep=0.0
  tend_gasdep_sum=0.0
  tend_aero_wetdep=0.0
  tend_aerdep_sum=0.0
  tend_activate=0.0
  tend_activate_sum=0.0
  tradv=0.0
  trdiff=0.0
  trphys=0.0

  aqso4_h2o2=0.d0
  aqso4_o3=0.d0
  aqso4_h2o2_sum=0.d0
  aqso4_o3_sum=0.d0

  cldfrac_old=0.0
  cldfrac=0.0 
  do j=1, ny
    do i=1, nx
      do k=1,nzm
       if((qcl(i,j,k)+qci(i,j,k)).gt.thresh) then
           cldfrac_old(i,j,k)=1.0
       endif
      enddo
    enddo
   enddo

         
! Add your initialization code here. Default is to set to 0 in setdata.f90.

 if(nrestart.eq.0) then

! here ....

 end if

! Specify te tracers' default names:

   ! Default names are TRACER01, TRACER02, etc:

   
    do ntr = 1,ntracers
      ichem=ntr+num_moist
       if (ichem.le.pcnst) then
          tmpname = cnst_name(ichem)
       else
          tmpname = cnst_name_cw(ntr-(pcnst-num_moist)+num_moist)
       end if
      
    ! write(ntrchar,'(i2)') ntr
    ! do k=1,3-lenstr(ntrchar)-1
    !    ntrchar(k:k)='0'
    ! end do
     tracername(ntr) = tmpname 
     tracerunits(ntr) = '[TR]'
  end do
    
  spe_class_aer =0 ! non-aerosol 
  do m = 1, ntot_amode
      do lspec = 0, nspec_amode(m)   ! loop over number + chem constituents 
        if (lspec == 0) then   ! number
   
          l = numptr_amode(m)-num_moist
          spe_class_aer(l)=1  !is aerosol 
          spe_class_aer(l+pcnst-num_moist)=1  !is aerosol
        else
          l = lmassptr_amode(lspec,m)-num_moist
          spe_class_aer(l)=1  !is aerosol 
          spe_class_aer(l+pcnst-num_moist)=1  !is aerosol
        end if
    end do
  end do 
        
!#ifdef MODAL_AERO
!    do m = 1, ntot_amode
!    do lphase = 1, 2
!    do lspec = 0, nspec_amode(m)+1   ! loop over number + chem constituents + water
!       unit = 'kg/m2/s'
!       if (lspec == 0) then   ! number
!          unit = '#/m2/s'
!          if (lphase == 1) then
!             l = numptr_amode(m)
!          else
!             l = numptrcw_amode(m)
!          endif
!       else if (lspec <= nspec_amode(m)) then   ! non-water mass
!          if (lphase == 1) then
!             l = lmassptr_amode(lspec,m)
!          else
!             l = lmassptrcw_amode(lspec,m)
!          endif
!       else   ! water mass
!!         if (lphase == 1) then
!!            l = lwaterptr_amode(m)
!!         else
!             cycle
!!         end if
!
!      end if
!       if (lphase == 1) then
!          tmpname = cnst_name(l)
!       else
!          tmpname = cnst_name_cw(l)
!       end if
!
!       tracername(ntr) = tmpname 
!       tracerunits(ntr) = '[TR]'
!
!    end do   ! lspec
!    end do   ! lphase
!    end do   ! m
!#endif


 end subroutine tracers_init



 subroutine tracers_flux()

! Set surface and top fluxes of tracers. Default is 0 set in setdata.f90

 end subroutine tracers_flux


 
 subroutine tracers_physics(pmid, pdel, tl, dtn, lchnk, icol, pbuf, latitude, t_phy_crm, w_crm, &
            qndrop3d_crm)
 use ECEP_wetdep, only: do_aero_wetdep_crm
 use physics_buffer, only: physics_buffer_desc 
 use ECEP_cldchem, only: crm_cldchem 
 use module_ECEP_gas_wetdep_driver, only: ECEP_gas_wetdep_driver
 use module_ECEP_mixactivate, only: ECEP_mixactivate
 use vars, only: qv,qcl, qci
 use cam_logfile,  only: iulog

 ! add here a call to a subroutine that does something to tracers besides advection and diffusion.
 ! The transport is done automatically.

 real*8, intent(in) :: pmid(:)
 real*8, intent(in) :: pdel(:)
 real*8, intent(in) :: tl(:)
 real*8, intent(in) :: dtn
 real*8, intent(in) :: latitude(nx,ny) 
 integer, intent(in) :: lchnk 
 integer, intent(in) :: icol
 type(physics_buffer_desc), pointer ::  pbuf(:)   ! physics buffer 
 real, intent(in) :: t_phy_crm(nx,ny,nzm) 
 real, intent(in) :: w_crm(nx,ny,nzm) 
 real, intent(inout) :: qndrop3d_crm(nx,ny,nzm) 

 real*8  tracer_db(dimx1_s:dimx2_s, dimy1_s:dimy2_s, nzm, ntracers) 
 real*8 trphys_db(nz,ntracers)  ! tendency due to physics 
  !trphys = 0. ! Default tendency due to physics. You code should compute this to output statistics.
 integer :: k, i,j, id
 
 real :: dz(nx,ny,nzm)

  do k=1,nzm
    dz(:,:,k)=dz_crm(k)
  end do
 
  tracer_db=dble(tracer)
  trphys_db=dble(trphys)
  do i=1,nx
   do j=1,ny
    do k=1,nzm
     do id=1,ntracers
    if(tracer_db(i,j,k,id).lt.0.0) then
       ! tracer(i,j,k,id)=1.0e-30
       write(0,*) 'tracers_physicsi--1: negative value ', i,j, k, id, tracer_db(i,j,k,id)
        call endrun('negative tracer error in tracers_physics--1') 
     endif
     end do
    end do
  end do
 end do
  call do_aero_wetdep_crm (tracer_db(1:nx,1:ny,1:nzm,:),trphys_db(1:nzm,:),dtn,tend_aero_wetdep(1:nx,1:ny,1:nzm,:))

  
       tracer=tracer_db
       
       tracer(1:nx,1:ny,1:nzm,:)=tracer(1:nx,1:ny,1:nzm,:) + (tend_aero_wetdep(1:nx,1:ny,1:nzm,:))
       
       tend_aerdep_sum(1:nx,1:ny,1:nzm,:)=tend_aerdep_sum(1:nx,1:ny,1:nzm,:) + (tend_aero_wetdep(1:nx,1:ny,1:nzm,:))
       
       tracer_db=dble(tracer)
  do i=1,nx
   do j=1,ny
    do k=1,nzm
     do id=1,ntracers
    if(tracer(i,j,k,id).lt.0.0) then
       ! tracer(i,j,k,id)=1.0e-30
       write(0,*) 'tracers_physicsi--2: negative value ', i,j, k, id, tracer(i,j,k,id)
        call endrun('negative tracer error in tracers_physics--2') 
     endif
     end do
    end do
  end do
 end do
  
  call ECEP_gas_wetdep_driver(latitude, tracer_db(1:nx,1:ny,1:nzm,:), tend_gas_wetdep(1:nx,1:ny,1:nzm,:), lchnk) 

    
     tracer=(tracer_db)
    
     tracer(1:nx,1:ny,1:nzm,:)=tracer(1:nx,1:ny,1:nzm,:) + tend_gas_wetdep(1:nx,1:ny,1:nzm,:)
     
     tend_gasdep_sum(1:nx,1:ny,1:nzm,:)=tend_gasdep_sum(1:nx,1:ny,1:nzm,:) + (tend_gas_wetdep(1:nx,1:ny,1:nzm,:))
    
      tracer_db=dble(tracer)
  do i=1,nx
   do j=1,ny
    do k=1,nzm
     do id=1,ntracers
    if(tracer_db(i,j,k,id).lt.0.0) then
    !    tracer(i,j,k,id)=1.0e-30
       write(0,*) 'tracers_physicsi--3: negative value ', i,j, k, id, tracer_db(i,j,k,id)
        call endrun('negative tracer error in tracers_physics--3') 
     endif
     end do
    end do
  end do
 end do

  call crm_cldchem(tracer_db(1:nx,1:ny,1:nzm,:), tend_cldchem(1:nx,1:ny,1:nzm,:), tend_rename(1:nx,1:ny,1:nzm,:), &
        pmid, pdel, tl, dtn, icol,lchnk, pbuf, aqso4_h2o2, aqso4_o3)

  tracer=(tracer_db)
  !trphys=real(trphys_db)

  
  aqso4_h2o2_sum(1:nx,1:ny,1:nzm)=aqso4_h2o2_sum(1:nx,1:ny,1:nzm) + aqso4_h2o2(1:nx,1:ny,1:nzm)  
  aqso4_o3_sum(1:nx,1:ny,1:nzm)=aqso4_o3_sum(1:nx,1:ny,1:nzm) + aqso4_o3(1:nx,1:ny,1:nzm)  
 
  tracer(1:nx,1:ny,1:nzm,:)=tracer(1:nx,1:ny,1:nzm,:) + (tend_cldchem(1:nx,1:ny,1:nzm,:))
  tend_cldchem_sum(1:nx,1:ny,1:nzm,:)=tend_cldchem_sum(1:nx,1:ny,1:nzm,:) + (tend_cldchem(1:nx,1:ny,1:nzm,:))

  tracer(1:nx,1:ny,1:nzm,:)=tracer(1:nx,1:ny,1:nzm,:) + (tend_rename(1:nx,1:ny,1:nzm,:))
  tend_rename_sum(1:nx,1:ny,1:nzm,:)=tend_rename_sum(1:nx,1:ny,1:nzm,:) + (tend_rename(1:nx,1:ny,1:nzm,:))

  call ECEP_mixactivate(tracer(1:nx,1:ny,1:nzm,:),qv, qcl,qci,t_phy_crm, w_crm,real(dtn), qndrop3d_crm, cldfrac, cldfrac_old,tend_activate(:,:,1:nzm,:),dchem_1(1:nx,1:ny,1:nzm,:),dchem_2(1:nx,1:ny,1:nzm,:),dchem_3(1:nx,1:ny,1:nzm,:),dchem_4(1:nx,1:ny,1:nzm,:),dchem_5(1:nx,1:ny,1:nzm,:), &
        ccn1_crm, ccn2_crm, ccn3_crm, ccn4_crm,ccn5_crm,ccn6_crm, icol,lchnk)

  tracer(1:nx,1:ny,1:nzm,:)=tracer(1:nx,1:ny,1:nzm,:) + tend_activate(1:nx,1:ny,1:nzm,:)
  tend_activate_sum(1:nx,1:ny,1:nzm,:)=tend_activate_sum(1:nx,1:ny,1:nzm,:) + tend_activate(1:nx,1:ny,1:nzm,:)

 dchem_1_sum(1:nx,1:ny,1:nzm,:)=dchem_1_sum(1:nx,1:ny,1:nzm,:) + dchem_1(1:nx,1:ny,1:nzm,:) !debug
 dchem_2_sum(1:nx,1:ny,1:nzm,:)=dchem_2_sum(1:nx,1:ny,1:nzm,:) + dchem_2(1:nx,1:ny,1:nzm,:) !debug
 dchem_3_sum(1:nx,1:ny,1:nzm,:)=dchem_3_sum(1:nx,1:ny,1:nzm,:) + dchem_3(1:nx,1:ny,1:nzm,:) !debug
 dchem_4_sum(1:nx,1:ny,1:nzm,:)=dchem_4_sum(1:nx,1:ny,1:nzm,:) + dchem_4(1:nx,1:ny,1:nzm,:) !debug
 dchem_5_sum(1:nx,1:ny,1:nzm,:)=dchem_5_sum(1:nx,1:ny,1:nzm,:) + dchem_5(1:nx,1:ny,1:nzm,:) !debug
 
  do i=1,nx
   do j=1,ny
    do k=1,nzm
     do id=1,ntracers
     if(tracer(i,j,k,id).lt.0.0) then
       write(0,*) 'tracers_physicsi--4: negative value ', i,j, k, id, tracer(i,j,k,id)
        call endrun('negative tracer error in tracers_physics--4') 
    !   tracer(i,j,k,id)=1.0e-30
     endif
     end do
    end do
  end do
 end do
 end subroutine tracers_physics



 subroutine tracers_hbuf_init(namelist,deflist,unitlist,status,average_type,count,trcount)

! Initialize the list of tracers statistics variables written in statistics.f90

   character(*) namelist(*), deflist(*), unitlist(*)
   integer status(*),average_type(*),count,trcount
   integer ntr


   do ntr=1,ntracers

     count = count + 1
     trcount = trcount + 1
     namelist(count) = trim(tracername(ntr))
     deflist(count) = trim(tracername(ntr))
     unitlist(count) = trim(tracerunits(ntr))
     status(count) = 1
     average_type(count) = 0		
     count = count + 1
     trcount = trcount + 1
     namelist(count) = trim(tracername(ntr))//'FLX'
     deflist(count) = 'Total flux of '//trim(tracername(ntr))
     unitlist(count) = trim(tracerunits(ntr))//' kg/m2/s'
     status(count) = 1
     average_type(count) = 0
     count = count + 1
     trcount = trcount + 1
     namelist(count) = trim(tracername(ntr))//'FLXS'
     deflist(count) = 'SGS flux of '//trim(tracername(ntr))
     unitlist(count) = trim(tracerunits(ntr))//' kg/m2/s'
     status(count) = 1
     average_type(count) = 0
     count = count + 1
     trcount = trcount + 1
     namelist(count) = trim(tracername(ntr))//'ADV'
     deflist(count) = 'Tendency of '//trim(tracername(ntr)//'due to vertical advection')
     unitlist(count) = trim(tracerunits(ntr))//'/day'
     status(count) = 1
     average_type(count) = 0
     count = count + 1
     trcount = trcount + 1
     namelist(count) = trim(tracername(ntr))//'DIFF'
     deflist(count) = 'Tendency of '//trim(tracername(ntr)//'due to vertical SGS transport')
     unitlist(count) = trim(tracername(ntr))//'/day'
     status(count) = 1
     average_type(count) = 0
     count = count + 1
     trcount = trcount + 1
     namelist(count) = trim(tracername(ntr))//'PHYS'
     deflist(count) = 'Tendency of '//trim(tracername(ntr)//'due to physics')
     unitlist(count) = trim(tracername(ntr))//'/day'
     status(count) = 1
     average_type(count) = 0
   end do

 end subroutine tracers_hbuf_init

end module crmtracers
