




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(820) = -(rxt(44)*y(2) + rxt(47)*y(3) + rxt(57)*y(15) + rxt(62)*y(12) &
                      + rxt(70)*y(13) + rxt(77)*y(5) + rxt(80)*y(6) + rxt(116)*y(23) &
                      + rxt(137)*y(35) + rxt(159)*y(55) + rxt(165)*y(56) + rxt(183) &
                      *y(52) + rxt(221)*y(65))
         mat(530) = -rxt(44)*y(1)
         mat(451) = -rxt(47)*y(1)
         mat(396) = -rxt(57)*y(1)
         mat(711) = -rxt(62)*y(1)
         mat(788) = -rxt(70)*y(1)
         mat(931) = -rxt(77)*y(1)
         mat(842) = -rxt(80)*y(1)
         mat(159) = -rxt(116)*y(1)
         mat(419) = -rxt(137)*y(1)
         mat(546) = -rxt(159)*y(1)
         mat(496) = -rxt(165)*y(1)
         mat(386) = -rxt(183)*y(1)
         mat(275) = -rxt(221)*y(1)

         mat(820) = mat(820) + .100_r8*rxt(183)*y(52) + .200_r8*rxt(159)*y(55) &
                      + .200_r8*rxt(165)*y(56)
         mat(788) = mat(788) + .250_r8*rxt(127)*y(33) + .250_r8*rxt(175)*y(59)
         mat(625) = .250_r8*rxt(127)*y(13)
         mat(386) = mat(386) + .100_r8*rxt(183)*y(1)
         mat(546) = mat(546) + .200_r8*rxt(159)*y(1)
         mat(496) = mat(496) + .200_r8*rxt(165)*y(1)
         mat(601) = .250_r8*rxt(175)*y(13)

         mat(526) = -(rxt(44)*y(1) + rxt(61)*y(12) + rxt(68)*y(11) + rxt(69)*y(13) &
                      + rxt(72)*y(14) + rxt(75)*y(5) + (rxt(78) + rxt(79)) * y(6) &
                      + rxt(86)*y(7) + rxt(97)*y(20))
         mat(811) = -rxt(44)*y(2)
         mat(702) = -rxt(61)*y(2)
         mat(281) = -rxt(68)*y(2)
         mat(779) = -rxt(69)*y(2)
         mat(91) = -rxt(72)*y(2)
         mat(922) = -rxt(75)*y(2)
         mat(836) = -(rxt(78) + rxt(79)) * y(2)
         mat(956) = -rxt(86)*y(2)
         mat(722) = -rxt(97)*y(2)

         mat(393) = rxt(60)*y(13)
         mat(702) = mat(702) + 2.000_r8*rxt(64)*y(12)
         mat(779) = mat(779) + rxt(60)*y(15)

         mat(446) = -(rxt(47)*y(1) + rxt(49)*y(11) + rxt(55)*y(116))
         mat(804) = -rxt(47)*y(3)
         mat(280) = -rxt(49)*y(3)
         mat(78) = -rxt(55)*y(3)

         mat(890) = -((rxt(93) + rxt(94)) * y(12))
         mat(714) = -(rxt(93) + rxt(94)) * y(17)

         mat(823) = .500_r8*rxt(116)*y(23) + .560_r8*rxt(137)*y(35) + .300_r8*rxt(183) &
                      *y(52) + .050_r8*rxt(159)*y(55) + .200_r8*rxt(165)*y(56)
         mat(533) = rxt(97)*y(20)
         mat(934) = .220_r8*rxt(166)*y(57) + .500_r8*rxt(201)*y(63)
         mat(968) = rxt(95)*y(20) + .220_r8*rxt(168)*y(57) + rxt(154)*y(62) &
                      + .500_r8*rxt(202)*y(63)
         mat(714) = mat(714) + rxt(96)*y(20) + rxt(153)*y(62) + rxt(132)*y(80) &
                      + .350_r8*rxt(109)*y(118)
         mat(878) = .110_r8*rxt(170)*y(57) + .200_r8*rxt(204)*y(63)
         mat(729) = rxt(97)*y(2) + rxt(95)*y(7) + rxt(96)*y(12)
         mat(160) = .500_r8*rxt(116)*y(1)
         mat(628) = .220_r8*rxt(171)*y(57) + .500_r8*rxt(205)*y(63)
         mat(422) = .560_r8*rxt(137)*y(1)
         mat(388) = .300_r8*rxt(183)*y(1)
         mat(549) = .050_r8*rxt(159)*y(1)
         mat(497) = .200_r8*rxt(165)*y(1)
         mat(567) = .220_r8*rxt(166)*y(5) + .220_r8*rxt(168)*y(7) + .110_r8*rxt(170) &
                      *y(18) + .220_r8*rxt(171)*y(33)
         mat(504) = rxt(154)*y(7) + rxt(153)*y(12)
         mat(519) = .500_r8*rxt(201)*y(5) + .500_r8*rxt(202)*y(7) + .200_r8*rxt(204) &
                      *y(18) + .500_r8*rxt(205)*y(33)
         mat(295) = rxt(132)*y(12)
         mat(72) = .350_r8*rxt(109)*y(12)

         mat(278) = -(rxt(49)*y(3) + rxt(66)*y(12) + rxt(68)*y(2))
         mat(444) = -rxt(49)*y(11)
         mat(678) = -rxt(66)*y(11)
         mat(523) = -rxt(68)*y(11)

         mat(390) = rxt(59)*y(13)
         mat(757) = rxt(59)*y(15)

         mat(77) = -(rxt(55)*y(3) + rxt(73)*y(12))
         mat(443) = -rxt(55)*y(116)
         mat(645) = -rxt(73)*y(116)

         mat(50) = -(rxt(74)*y(12))
         mat(639) = -rxt(74)*y(117)

         mat(391) = -(rxt(57)*y(1) + (rxt(58) + rxt(59) + rxt(60)) * y(13))
         mat(801) = -rxt(57)*y(15)
         mat(768) = -(rxt(58) + rxt(59) + rxt(60)) * y(15)

         mat(524) = rxt(68)*y(11) + rxt(61)*y(12)
         mat(445) = rxt(49)*y(11)
         mat(881) = rxt(93)*y(12)
         mat(279) = rxt(68)*y(2) + rxt(49)*y(3) + rxt(66)*y(12)
         mat(690) = rxt(61)*y(2) + rxt(93)*y(17) + rxt(66)*y(11) + rxt(96)*y(20)
         mat(720) = rxt(96)*y(12)

         mat(935) = -(rxt(75)*y(2) + rxt(76)*y(13) + rxt(77)*y(1) + rxt(85)*y(7) &
                      + rxt(99)*y(18) + rxt(107)*y(120) + rxt(112)*y(25) + rxt(118) &
                      *y(30) + rxt(125)*y(33) + rxt(139)*y(37) + rxt(144)*y(39) &
                      + rxt(148)*y(42) + rxt(157)*y(45) + rxt(161)*y(47) + (rxt(166) &
                      + rxt(167)) * y(57) + rxt(173)*y(59) + rxt(185)*y(53) + rxt(191) &
                      *y(84) + rxt(198)*y(50) + rxt(201)*y(63) + rxt(209)*y(70) &
                      + rxt(216)*y(73) + rxt(219)*y(76) + rxt(223)*y(66))
         mat(534) = -rxt(75)*y(5)
         mat(792) = -rxt(76)*y(5)
         mat(824) = -rxt(77)*y(5)
         mat(969) = -rxt(85)*y(5)
         mat(879) = -rxt(99)*y(5)
         mat(187) = -rxt(107)*y(5)
         mat(291) = -rxt(112)*y(5)
         mat(356) = -rxt(118)*y(5)
         mat(629) = -rxt(125)*y(5)
         mat(374) = -rxt(139)*y(5)
         mat(328) = -rxt(144)*y(5)
         mat(408) = -rxt(148)*y(5)
         mat(144) = -rxt(157)*y(5)
         mat(314) = -rxt(161)*y(5)
         mat(568) = -(rxt(166) + rxt(167)) * y(5)
         mat(605) = -rxt(173)*y(5)
         mat(589) = -rxt(185)*y(5)
         mat(465) = -rxt(191)*y(5)
         mat(345) = -rxt(198)*y(5)
         mat(520) = -rxt(201)*y(5)
         mat(250) = -rxt(209)*y(5)
         mat(176) = -rxt(216)*y(5)
         mat(215) = -rxt(219)*y(5)
         mat(481) = -rxt(223)*y(5)

         mat(534) = mat(534) + rxt(78)*y(6)
         mat(846) = rxt(78)*y(2)

         mat(843) = -((rxt(78) + rxt(79)) * y(2) + rxt(80)*y(1) + rxt(81)*y(7) + rxt(83) &
                      *y(12) + rxt(89)*y(13) + rxt(126)*y(33) + rxt(179)*y(59) + rxt(213) &
                      *y(78))
         mat(531) = -(rxt(78) + rxt(79)) * y(6)
         mat(821) = -rxt(80)*y(6)
         mat(966) = -rxt(81)*y(6)
         mat(712) = -rxt(83)*y(6)
         mat(789) = -rxt(89)*y(6)
         mat(626) = -rxt(126)*y(6)
         mat(602) = -rxt(179)*y(6)
         mat(76) = -rxt(213)*y(6)

         mat(821) = mat(821) + rxt(77)*y(5)
         mat(531) = mat(531) + rxt(75)*y(5) + rxt(86)*y(7)
         mat(932) = rxt(77)*y(1) + rxt(75)*y(2) + 2.000_r8*rxt(85)*y(7) + rxt(76) &
                      *y(13) + rxt(99)*y(18) + rxt(112)*y(25) + rxt(118)*y(30) &
                      + rxt(125)*y(33) + rxt(139)*y(37) + rxt(144)*y(39) + rxt(148) &
                      *y(42) + rxt(157)*y(45) + .900_r8*rxt(198)*y(50) + rxt(161) &
                      *y(47) + .920_r8*rxt(185)*y(53) + rxt(166)*y(57) + rxt(173) &
                      *y(59) + rxt(201)*y(63) + rxt(223)*y(66) + .900_r8*rxt(209) &
                      *y(70) + .900_r8*rxt(216)*y(73) + .900_r8*rxt(219)*y(76) &
                      + 1.206_r8*rxt(191)*y(84) + rxt(107)*y(120)
         mat(843) = mat(843) + .700_r8*rxt(213)*y(78)
         mat(966) = mat(966) + rxt(86)*y(2) + 2.000_r8*rxt(85)*y(5) + rxt(87)*y(12) &
                      + rxt(88)*y(13) + rxt(186)*y(53) + rxt(168)*y(57) + rxt(174) &
                      *y(59) + rxt(202)*y(63) + rxt(222)*y(65) + 1.206_r8*rxt(192) &
                      *y(84) + rxt(196)*y(85)
         mat(136) = rxt(90)*y(12)
         mat(712) = mat(712) + rxt(87)*y(7) + rxt(90)*y(9) + rxt(155)*y(82) &
                      + .400_r8*rxt(195)*y(85)
         mat(789) = mat(789) + rxt(76)*y(5) + rxt(88)*y(7) + .206_r8*rxt(193)*y(84)
         mat(876) = rxt(99)*y(5)
         mat(290) = rxt(112)*y(5)
         mat(354) = rxt(118)*y(5)
         mat(626) = mat(626) + rxt(125)*y(5)
         mat(372) = rxt(139)*y(5)
         mat(327) = rxt(144)*y(5)
         mat(406) = rxt(148)*y(5)
         mat(143) = rxt(157)*y(5)
         mat(343) = .900_r8*rxt(198)*y(5)
         mat(313) = rxt(161)*y(5)
         mat(586) = .920_r8*rxt(185)*y(5) + rxt(186)*y(7)
         mat(565) = rxt(166)*y(5) + rxt(168)*y(7)
         mat(602) = mat(602) + rxt(173)*y(5) + rxt(174)*y(7)
         mat(517) = rxt(201)*y(5) + rxt(202)*y(7)
         mat(276) = rxt(222)*y(7)
         mat(479) = rxt(223)*y(5)
         mat(249) = .900_r8*rxt(209)*y(5)
         mat(76) = mat(76) + .700_r8*rxt(213)*y(6)
         mat(175) = .900_r8*rxt(216)*y(5)
         mat(214) = .900_r8*rxt(219)*y(5)
         mat(180) = rxt(155)*y(12)
         mat(463) = 1.206_r8*rxt(191)*y(5) + 1.206_r8*rxt(192)*y(7) + .206_r8*rxt(193) &
                      *y(13)
         mat(440) = rxt(196)*y(7) + .400_r8*rxt(195)*y(12)
         mat(186) = rxt(107)*y(5)

         mat(970) = -(rxt(81)*y(6) + rxt(85)*y(5) + rxt(86)*y(2) + rxt(87)*y(12) &
                      + rxt(88)*y(13) + rxt(95)*y(20) + rxt(124)*y(32) + rxt(138) &
                      *y(35) + rxt(154)*y(62) + rxt(168)*y(57) + rxt(174)*y(59) &
                      + rxt(184)*y(52) + rxt(186)*y(53) + rxt(192)*y(84) + rxt(196) &
                      *y(85) + rxt(202)*y(63) + rxt(222)*y(65) + rxt(234)*y(101))
         mat(847) = -rxt(81)*y(7)
         mat(936) = -rxt(85)*y(7)
         mat(535) = -rxt(86)*y(7)
         mat(716) = -rxt(87)*y(7)
         mat(793) = -rxt(88)*y(7)
         mat(731) = -rxt(95)*y(7)
         mat(433) = -rxt(124)*y(7)
         mat(424) = -rxt(138)*y(7)
         mat(505) = -rxt(154)*y(7)
         mat(569) = -rxt(168)*y(7)
         mat(606) = -rxt(174)*y(7)
         mat(389) = -rxt(184)*y(7)
         mat(590) = -rxt(186)*y(7)
         mat(466) = -rxt(192)*y(7)
         mat(442) = -rxt(196)*y(7)
         mat(521) = -rxt(202)*y(7)
         mat(277) = -rxt(222)*y(7)
         mat(89) = -rxt(234)*y(7)

         mat(825) = rxt(80)*y(6)
         mat(535) = mat(535) + rxt(79)*y(6)
         mat(847) = mat(847) + rxt(80)*y(1) + rxt(79)*y(2)
         mat(226) = rxt(84)*y(12)
         mat(716) = mat(716) + rxt(84)*y(8) + rxt(135)*y(81) + .500_r8*rxt(181)*y(83)
         mat(222) = rxt(135)*y(12)
         mat(241) = .500_r8*rxt(181)*y(12)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(223) = -(rxt(84)*y(12))
         mat(670) = -rxt(84)*y(8)

         mat(830) = rxt(83)*y(12)
         mat(942) = rxt(95)*y(20) + rxt(124)*y(32) + rxt(154)*y(62) + rxt(234)*y(101)
         mat(670) = mat(670) + rxt(83)*y(6)
         mat(718) = rxt(95)*y(7)
         mat(425) = rxt(124)*y(7)
         mat(498) = rxt(154)*y(7)
         mat(86) = rxt(234)*y(7)

         mat(133) = -(rxt(90)*y(12))
         mat(655) = -rxt(90)*y(9)

         mat(828) = rxt(89)*y(13)
         mat(743) = rxt(89)*y(6)


         mat(827) = rxt(81)*y(7)
         mat(939) = rxt(81)*y(6)

         mat(708) = -(rxt(61)*y(2) + rxt(62)*y(1) + rxt(63)*y(13) + (4._r8*rxt(64) &
                      + 4._r8*rxt(65)) * y(12) + rxt(66)*y(11) + rxt(67)*y(14) + rxt(73) &
                      *y(116) + rxt(74)*y(117) + rxt(83)*y(6) + rxt(84)*y(8) + rxt(87) &
                      *y(7) + rxt(90)*y(9) + (rxt(93) + rxt(94)) * y(17) + rxt(96) &
                      *y(20) + rxt(103)*y(21) + rxt(104)*y(19) + rxt(105)*y(119) &
                      + rxt(109)*y(118) + rxt(110)*y(29) + rxt(111)*y(23) + rxt(117) &
                      *y(26) + rxt(122)*y(31) + rxt(123)*y(32) + rxt(130)*y(34) &
                      + rxt(131)*y(27) + rxt(132)*y(80) + rxt(133)*y(22) + rxt(135) &
                      *y(81) + rxt(136)*y(35) + rxt(142)*y(38) + rxt(143)*y(36) &
                      + rxt(146)*y(40) + rxt(147)*y(41) + rxt(151)*y(43) + rxt(152) &
                      *y(61) + rxt(153)*y(62) + rxt(155)*y(82) + rxt(156)*y(44) &
                      + rxt(158)*y(55) + rxt(160)*y(46) + rxt(163)*y(48) + rxt(164) &
                      *y(56) + rxt(172)*y(58) + rxt(181)*y(83) + rxt(182)*y(52) &
                      + rxt(188)*y(54) + rxt(194)*y(49) + rxt(195)*y(85) + rxt(197) &
                      *y(60) + rxt(200)*y(51) + rxt(206)*y(64) + rxt(208)*y(68) &
                      + rxt(211)*y(71) + rxt(212)*y(69) + rxt(214)*y(72) + rxt(217) &
                      *y(75) + rxt(220)*y(65) + rxt(225)*y(67) + rxt(231)*y(100) &
                      + (rxt(232) + rxt(233)) * y(101) + rxt(235)*y(103))
         mat(527) = -rxt(61)*y(12)
         mat(817) = -rxt(62)*y(12)
         mat(785) = -rxt(63)*y(12)
         mat(282) = -rxt(66)*y(12)
         mat(92) = -rxt(67)*y(12)
         mat(79) = -rxt(73)*y(12)
         mat(51) = -rxt(74)*y(12)
         mat(839) = -rxt(83)*y(12)
         mat(224) = -rxt(84)*y(12)
         mat(962) = -rxt(87)*y(12)
         mat(134) = -rxt(90)*y(12)
         mat(884) = -(rxt(93) + rxt(94)) * y(12)
         mat(723) = -rxt(96)*y(12)
         mat(266) = -rxt(103)*y(12)
         mat(147) = -rxt(104)*y(12)
         mat(151) = -rxt(105)*y(12)
         mat(70) = -rxt(109)*y(12)
         mat(34) = -rxt(110)*y(12)
         mat(156) = -rxt(111)*y(12)
         mat(199) = -rxt(117)*y(12)
         mat(131) = -rxt(122)*y(12)
         mat(428) = -rxt(123)*y(12)
         mat(195) = -rxt(130)*y(12)
         mat(359) = -rxt(131)*y(12)
         mat(293) = -rxt(132)*y(12)
         mat(96) = -rxt(133)*y(12)
         mat(218) = -rxt(135)*y(12)
         mat(416) = -rxt(136)*y(12)
         mat(126) = -rxt(142)*y(12)
         mat(37) = -rxt(143)*y(12)
         mat(231) = -rxt(146)*y(12)
         mat(318) = -rxt(147)*y(12)
         mat(121) = -rxt(151)*y(12)
         mat(485) = -rxt(152)*y(12)
         mat(501) = -rxt(153)*y(12)
         mat(179) = -rxt(155)*y(12)
         mat(40) = -rxt(156)*y(12)
         mat(543) = -rxt(158)*y(12)
         mat(192) = -rxt(160)*y(12)
         mat(112) = -rxt(163)*y(12)
         mat(493) = -rxt(164)*y(12)
         mat(116) = -rxt(172)*y(12)
         mat(237) = -rxt(181)*y(12)
         mat(383) = -rxt(182)*y(12)
         mat(262) = -rxt(188)*y(12)
         mat(43) = -rxt(194)*y(12)
         mat(437) = -rxt(195)*y(12)
         mat(163) = -rxt(197)*y(12)
         mat(304) = -rxt(200)*y(12)
         mat(83) = -rxt(206)*y(12)
         mat(59) = -rxt(208)*y(12)
         mat(169) = -rxt(211)*y(12)
         mat(63) = -rxt(212)*y(12)
         mat(46) = -rxt(214)*y(12)
         mat(49) = -rxt(217)*y(12)
         mat(273) = -rxt(220)*y(12)
         mat(206) = -rxt(225)*y(12)
         mat(55) = -rxt(231)*y(12)
         mat(87) = -(rxt(232) + rxt(233)) * y(12)
         mat(31) = -rxt(235)*y(12)

         mat(817) = mat(817) + rxt(57)*y(15) + rxt(70)*y(13) + .120_r8*rxt(116)*y(23) &
                      + .330_r8*rxt(137)*y(35) + .270_r8*rxt(183)*y(52) &
                      + .080_r8*rxt(159)*y(55) + .215_r8*rxt(165)*y(56) &
                      + .700_r8*rxt(221)*y(65)
         mat(527) = mat(527) + rxt(68)*y(11) + rxt(69)*y(13) + rxt(72)*y(14) + rxt(97) &
                      *y(20)
         mat(448) = rxt(49)*y(11) + rxt(55)*y(116)
         mat(282) = mat(282) + rxt(68)*y(2) + rxt(49)*y(3)
         mat(79) = mat(79) + rxt(55)*y(3)
         mat(394) = rxt(57)*y(1) + 2.000_r8*rxt(58)*y(13)
         mat(928) = rxt(76)*y(13)
         mat(962) = mat(962) + rxt(88)*y(13)
         mat(708) = mat(708) + .300_r8*rxt(104)*y(19) + .500_r8*rxt(122)*y(31) &
                      + .500_r8*rxt(146)*y(40) + .100_r8*rxt(172)*y(58) &
                      + .650_r8*rxt(109)*y(118)
         mat(785) = mat(785) + rxt(70)*y(1) + rxt(69)*y(2) + 2.000_r8*rxt(58)*y(15) &
                      + rxt(76)*y(5) + rxt(88)*y(7)
         mat(92) = mat(92) + rxt(72)*y(2)
         mat(147) = mat(147) + .300_r8*rxt(104)*y(12)
         mat(723) = mat(723) + rxt(97)*y(2)
         mat(156) = mat(156) + .120_r8*rxt(116)*y(1)
         mat(131) = mat(131) + .500_r8*rxt(122)*y(12)
         mat(416) = mat(416) + .330_r8*rxt(137)*y(1)
         mat(231) = mat(231) + .500_r8*rxt(146)*y(12)
         mat(383) = mat(383) + .270_r8*rxt(183)*y(1)
         mat(543) = mat(543) + .080_r8*rxt(159)*y(1)
         mat(493) = mat(493) + .215_r8*rxt(165)*y(1)
         mat(116) = mat(116) + .100_r8*rxt(172)*y(12)
         mat(273) = mat(273) + .700_r8*rxt(221)*y(1)
         mat(70) = mat(70) + .650_r8*rxt(109)*y(12)

         mat(787) = -((rxt(58) + rxt(59) + rxt(60)) * y(15) + rxt(63)*y(12) + rxt(69) &
                      *y(2) + rxt(70)*y(1) + 4._r8*rxt(71)*y(13) + rxt(76)*y(5) + rxt(88) &
                      *y(7) + rxt(89)*y(6) + rxt(98)*y(20) + rxt(100)*y(18) + rxt(108) &
                      *y(120) + rxt(113)*y(25) + rxt(119)*y(30) + rxt(127)*y(33) &
                      + rxt(140)*y(37) + rxt(145)*y(39) + rxt(149)*y(42) + rxt(162) &
                      *y(47) + rxt(169)*y(57) + rxt(175)*y(59) + rxt(187)*y(53) &
                      + rxt(193)*y(84) + rxt(199)*y(50) + rxt(203)*y(63) + rxt(210) &
                      *y(70) + rxt(215)*y(73) + rxt(218)*y(76) + rxt(224)*y(66))
         mat(395) = -(rxt(58) + rxt(59) + rxt(60)) * y(13)
         mat(710) = -rxt(63)*y(13)
         mat(529) = -rxt(69)*y(13)
         mat(819) = -rxt(70)*y(13)
         mat(930) = -rxt(76)*y(13)
         mat(964) = -rxt(88)*y(13)
         mat(841) = -rxt(89)*y(13)
         mat(725) = -rxt(98)*y(13)
         mat(874) = -rxt(100)*y(13)
         mat(185) = -rxt(108)*y(13)
         mat(289) = -rxt(113)*y(13)
         mat(353) = -rxt(119)*y(13)
         mat(624) = -rxt(127)*y(13)
         mat(371) = -rxt(140)*y(13)
         mat(326) = -rxt(145)*y(13)
         mat(405) = -rxt(149)*y(13)
         mat(312) = -rxt(162)*y(13)
         mat(564) = -rxt(169)*y(13)
         mat(600) = -rxt(175)*y(13)
         mat(584) = -rxt(187)*y(13)
         mat(462) = -rxt(193)*y(13)
         mat(342) = -rxt(199)*y(13)
         mat(516) = -rxt(203)*y(13)
         mat(248) = -rxt(210)*y(13)
         mat(174) = -rxt(215)*y(13)
         mat(213) = -rxt(218)*y(13)
         mat(478) = -rxt(224)*y(13)

         mat(819) = mat(819) + rxt(62)*y(12) + .120_r8*rxt(116)*y(23) &
                      + .190_r8*rxt(137)*y(35) + .060_r8*rxt(183)*y(52) &
                      + .060_r8*rxt(159)*y(55) + .275_r8*rxt(165)*y(56) + rxt(221) &
                      *y(65)
         mat(529) = mat(529) + rxt(72)*y(14) + rxt(97)*y(20)
         mat(886) = rxt(94)*y(12)
         mat(80) = rxt(73)*y(12)
         mat(52) = rxt(74)*y(12)
         mat(930) = mat(930) + rxt(99)*y(18) + .250_r8*rxt(112)*y(25) + rxt(118)*y(30) &
                      + rxt(139)*y(37) + rxt(144)*y(39) + rxt(157)*y(45) &
                      + .900_r8*rxt(198)*y(50) + rxt(185)*y(53) + .470_r8*rxt(166) &
                      *y(57) + rxt(201)*y(63) + rxt(223)*y(66) + .900_r8*rxt(209) &
                      *y(70) + .900_r8*rxt(216)*y(73) + .900_r8*rxt(219)*y(76) &
                      + .794_r8*rxt(191)*y(84) + rxt(107)*y(120)
         mat(841) = mat(841) + .700_r8*rxt(213)*y(78)
         mat(964) = mat(964) + rxt(87)*y(12) + rxt(95)*y(20) + rxt(186)*y(53) &
                      + .470_r8*rxt(168)*y(57) + rxt(202)*y(63) + .794_r8*rxt(192) &
                      *y(84) + rxt(196)*y(85)
         mat(710) = mat(710) + rxt(62)*y(1) + rxt(94)*y(17) + rxt(73)*y(116) + rxt(74) &
                      *y(117) + rxt(87)*y(7) + rxt(67)*y(14) + rxt(103)*y(21) &
                      + rxt(133)*y(22) + rxt(131)*y(27) + .200_r8*rxt(172)*y(58) &
                      + rxt(152)*y(61) + .250_r8*rxt(208)*y(68) + rxt(132)*y(80) &
                      + .500_r8*rxt(181)*y(83) + rxt(195)*y(85) + .500_r8*rxt(233) &
                      *y(101) + .350_r8*rxt(109)*y(118) + rxt(105)*y(119)
         mat(787) = mat(787) + .794_r8*rxt(193)*y(84)
         mat(93) = rxt(72)*y(2) + rxt(67)*y(12)
         mat(874) = mat(874) + rxt(99)*y(5) + 4.000_r8*rxt(101)*y(18) + rxt(120)*y(30) &
                      + .900_r8*rxt(128)*y(33) + rxt(141)*y(37) + .300_r8*rxt(150) &
                      *y(42) + rxt(189)*y(53) + .730_r8*rxt(170)*y(57) + rxt(176) &
                      *y(59) + .800_r8*rxt(204)*y(63)
         mat(725) = mat(725) + rxt(97)*y(2) + rxt(95)*y(7)
         mat(268) = rxt(103)*y(12)
         mat(97) = rxt(133)*y(12)
         mat(158) = .120_r8*rxt(116)*y(1)
         mat(289) = mat(289) + .250_r8*rxt(112)*y(5)
         mat(361) = rxt(131)*y(12)
         mat(353) = mat(353) + rxt(118)*y(5) + rxt(120)*y(18) + 2.400_r8*rxt(121) &
                      *y(30)
         mat(624) = mat(624) + .900_r8*rxt(128)*y(18) + rxt(190)*y(53) &
                      + .470_r8*rxt(171)*y(57) + rxt(205)*y(63)
         mat(418) = .190_r8*rxt(137)*y(1)
         mat(371) = mat(371) + rxt(139)*y(5) + rxt(141)*y(18)
         mat(326) = mat(326) + rxt(144)*y(5)
         mat(405) = mat(405) + .300_r8*rxt(150)*y(18)
         mat(142) = rxt(157)*y(5)
         mat(342) = mat(342) + .900_r8*rxt(198)*y(5)
         mat(385) = .060_r8*rxt(183)*y(1)
         mat(584) = mat(584) + rxt(185)*y(5) + rxt(186)*y(7) + rxt(189)*y(18) &
                      + rxt(190)*y(33)
         mat(545) = .060_r8*rxt(159)*y(1)
         mat(495) = .275_r8*rxt(165)*y(1)
         mat(564) = mat(564) + .470_r8*rxt(166)*y(5) + .470_r8*rxt(168)*y(7) &
                      + .730_r8*rxt(170)*y(18) + .470_r8*rxt(171)*y(33)
         mat(117) = .200_r8*rxt(172)*y(12)
         mat(600) = mat(600) + rxt(176)*y(18)
         mat(487) = rxt(152)*y(12)
         mat(516) = mat(516) + rxt(201)*y(5) + rxt(202)*y(7) + .800_r8*rxt(204)*y(18) &
                      + rxt(205)*y(33)
         mat(274) = rxt(221)*y(1)
         mat(478) = mat(478) + rxt(223)*y(5)
         mat(60) = .250_r8*rxt(208)*y(12)
         mat(248) = mat(248) + .900_r8*rxt(209)*y(5)
         mat(75) = .700_r8*rxt(213)*y(6)
         mat(294) = rxt(132)*y(12)
         mat(174) = mat(174) + .900_r8*rxt(216)*y(5)
         mat(213) = mat(213) + .900_r8*rxt(219)*y(5)
         mat(239) = .500_r8*rxt(181)*y(12)
         mat(462) = mat(462) + .794_r8*rxt(191)*y(5) + .794_r8*rxt(192)*y(7) &
                      + .794_r8*rxt(193)*y(13)
         mat(439) = rxt(196)*y(7) + rxt(195)*y(12)
         mat(88) = .500_r8*rxt(233)*y(12)
         mat(71) = .350_r8*rxt(109)*y(12)
         mat(152) = rxt(105)*y(12)
         mat(185) = mat(185) + rxt(107)*y(5)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(90) = -(rxt(67)*y(12) + rxt(72)*y(2))
         mat(648) = -rxt(67)*y(14)
         mat(522) = -rxt(72)*y(14)

         mat(648) = mat(648) + 2.000_r8*rxt(65)*y(12)
         mat(736) = 2.000_r8*rxt(71)*y(13)

         mat(877) = -(rxt(99)*y(5) + rxt(100)*y(13) + (4._r8*rxt(101) + 4._r8*rxt(102) &
                      ) * y(18) + rxt(120)*y(30) + rxt(128)*y(33) + rxt(141)*y(37) &
                      + rxt(150)*y(42) + rxt(170)*y(57) + rxt(176)*y(59) + rxt(189) &
                      *y(53) + rxt(204)*y(63))
         mat(933) = -rxt(99)*y(18)
         mat(790) = -rxt(100)*y(18)
         mat(355) = -rxt(120)*y(18)
         mat(627) = -rxt(128)*y(18)
         mat(373) = -rxt(141)*y(18)
         mat(407) = -rxt(150)*y(18)
         mat(566) = -rxt(170)*y(18)
         mat(603) = -rxt(176)*y(18)
         mat(587) = -rxt(189)*y(18)
         mat(518) = -rxt(204)*y(18)

         mat(822) = .310_r8*rxt(137)*y(35)
         mat(933) = mat(933) + rxt(125)*y(33)
         mat(713) = .700_r8*rxt(104)*y(19) + rxt(117)*y(26)
         mat(877) = mat(877) + .900_r8*rxt(128)*y(33)
         mat(149) = .700_r8*rxt(104)*y(12)
         mat(200) = rxt(117)*y(12)
         mat(627) = mat(627) + rxt(125)*y(5) + .900_r8*rxt(128)*y(18) &
                      + 4.000_r8*rxt(129)*y(33) + rxt(190)*y(53) + rxt(171)*y(57) &
                      + rxt(177)*y(59) + rxt(205)*y(63)
         mat(421) = .310_r8*rxt(137)*y(1)
         mat(587) = mat(587) + rxt(190)*y(33)
         mat(566) = mat(566) + rxt(171)*y(33)
         mat(603) = mat(603) + rxt(177)*y(33)
         mat(518) = mat(518) + rxt(205)*y(33)

         mat(145) = -(rxt(104)*y(12))
         mat(657) = -rxt(104)*y(19)

         mat(744) = rxt(100)*y(18)
         mat(849) = rxt(100)*y(13)

         mat(724) = -(rxt(95)*y(7) + rxt(96)*y(12) + rxt(97)*y(2) + rxt(98)*y(13))
         mat(963) = -rxt(95)*y(20)
         mat(709) = -rxt(96)*y(20)
         mat(528) = -rxt(97)*y(20)
         mat(786) = -rxt(98)*y(20)

         mat(818) = rxt(116)*y(23) + .540_r8*rxt(137)*y(35) + .600_r8*rxt(183)*y(52) &
                      + .800_r8*rxt(159)*y(55) + .700_r8*rxt(165)*y(56)
         mat(929) = rxt(99)*y(18) + .500_r8*rxt(112)*y(25) + rxt(144)*y(39) + rxt(148) &
                      *y(42) + .500_r8*rxt(157)*y(45) + .100_r8*rxt(198)*y(50) &
                      + .510_r8*rxt(185)*y(53) + .250_r8*rxt(166)*y(57) + rxt(173) &
                      *y(59) + .072_r8*rxt(191)*y(84)
         mat(963) = mat(963) + .600_r8*rxt(186)*y(53) + .250_r8*rxt(168)*y(57) &
                      + rxt(174)*y(59) + .072_r8*rxt(192)*y(84)
         mat(709) = mat(709) + .300_r8*rxt(104)*y(19) + rxt(103)*y(21) &
                      + .800_r8*rxt(131)*y(27) + .500_r8*rxt(130)*y(34) + rxt(135) &
                      *y(81) + .500_r8*rxt(181)*y(83)
         mat(786) = mat(786) + .008_r8*rxt(193)*y(84)
         mat(873) = rxt(99)*y(5) + (4.000_r8*rxt(101)+2.000_r8*rxt(102))*y(18) &
                      + .700_r8*rxt(120)*y(30) + rxt(128)*y(33) + rxt(141)*y(37) &
                      + .800_r8*rxt(150)*y(42) + 1.200_r8*rxt(189)*y(53) &
                      + .880_r8*rxt(170)*y(57) + 2.000_r8*rxt(176)*y(59) &
                      + .700_r8*rxt(204)*y(63)
         mat(148) = .300_r8*rxt(104)*y(12)
         mat(267) = rxt(103)*y(12)
         mat(157) = rxt(116)*y(1)
         mat(288) = .500_r8*rxt(112)*y(5)
         mat(360) = .800_r8*rxt(131)*y(12)
         mat(352) = .700_r8*rxt(120)*y(18)
         mat(623) = rxt(128)*y(18) + .600_r8*rxt(190)*y(53) + .250_r8*rxt(171)*y(57) &
                      + rxt(177)*y(59)
         mat(196) = .500_r8*rxt(130)*y(12)
         mat(417) = .540_r8*rxt(137)*y(1)
         mat(370) = rxt(141)*y(18)
         mat(325) = rxt(144)*y(5)
         mat(404) = rxt(148)*y(5) + .800_r8*rxt(150)*y(18)
         mat(141) = .500_r8*rxt(157)*y(5)
         mat(341) = .100_r8*rxt(198)*y(5)
         mat(384) = .600_r8*rxt(183)*y(1)
         mat(583) = .510_r8*rxt(185)*y(5) + .600_r8*rxt(186)*y(7) + 1.200_r8*rxt(189) &
                      *y(18) + .600_r8*rxt(190)*y(33)
         mat(544) = .800_r8*rxt(159)*y(1)
         mat(494) = .700_r8*rxt(165)*y(1)
         mat(563) = .250_r8*rxt(166)*y(5) + .250_r8*rxt(168)*y(7) + .880_r8*rxt(170) &
                      *y(18) + .250_r8*rxt(171)*y(33)
         mat(599) = rxt(173)*y(5) + rxt(174)*y(7) + 2.000_r8*rxt(176)*y(18) + rxt(177) &
                      *y(33) + 4.000_r8*rxt(178)*y(59)
         mat(515) = .700_r8*rxt(204)*y(18)
         mat(219) = rxt(135)*y(12)
         mat(238) = .500_r8*rxt(181)*y(12)
         mat(461) = .072_r8*rxt(191)*y(5) + .072_r8*rxt(192)*y(7) + .008_r8*rxt(193) &
                      *y(13)

         mat(265) = -(rxt(103)*y(12))
         mat(676) = -rxt(103)*y(21)

         mat(852) = 2.000_r8*rxt(102)*y(18) + .300_r8*rxt(120)*y(30) &
                      + .500_r8*rxt(150)*y(42) + .250_r8*rxt(189)*y(53) &
                      + .250_r8*rxt(170)*y(57) + .300_r8*rxt(204)*y(63)
         mat(348) = .300_r8*rxt(120)*y(18)
         mat(398) = .500_r8*rxt(150)*y(18)
         mat(572) = .250_r8*rxt(189)*y(18)
         mat(553) = .250_r8*rxt(170)*y(18)
         mat(507) = .300_r8*rxt(204)*y(18)

         mat(94) = -(rxt(133)*y(12))
         mat(649) = -rxt(133)*y(22)

         mat(848) = .200_r8*rxt(120)*y(30)
         mat(346) = .200_r8*rxt(120)*y(18) + .800_r8*rxt(121)*y(30)


         mat(734) = rxt(113)*y(25)
         mat(283) = rxt(113)*y(13)

         mat(154) = -(rxt(111)*y(12) + rxt(116)*y(1))
         mat(659) = -rxt(111)*y(23)
         mat(795) = -rxt(116)*y(23)


         mat(893) = .750_r8*rxt(112)*y(25)
         mat(284) = .750_r8*rxt(112)*y(5)

         mat(285) = -(rxt(112)*y(5) + rxt(113)*y(13))
         mat(904) = -rxt(112)*y(25)
         mat(758) = -rxt(113)*y(25)

         mat(679) = rxt(111)*y(23)
         mat(155) = rxt(111)*y(12)

         mat(198) = -(rxt(117)*y(12))
         mat(666) = -rxt(117)*y(26)

         mat(796) = .250_r8*rxt(137)*y(35) + .200_r8*rxt(183)*y(52)
         mat(750) = .250_r8*rxt(127)*y(33) + .250_r8*rxt(175)*y(59)
         mat(851) = .100_r8*rxt(128)*y(33)
         mat(609) = .250_r8*rxt(127)*y(13) + .100_r8*rxt(128)*y(18)
         mat(410) = .250_r8*rxt(137)*y(1)
         mat(375) = .200_r8*rxt(183)*y(1)
         mat(592) = .250_r8*rxt(175)*y(13)

         mat(358) = -(rxt(131)*y(12))
         mat(687) = -rxt(131)*y(27)

         mat(911) = .530_r8*rxt(166)*y(57) + .250_r8*rxt(201)*y(63)
         mat(945) = .530_r8*rxt(168)*y(57) + .250_r8*rxt(202)*y(63)
         mat(856) = .260_r8*rxt(170)*y(57) + .100_r8*rxt(204)*y(63)
         mat(612) = .530_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(554) = .530_r8*rxt(166)*y(5) + .530_r8*rxt(168)*y(7) + .260_r8*rxt(170) &
                      *y(18) + .530_r8*rxt(171)*y(33)
         mat(509) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)

         mat(32) = -(rxt(110)*y(12))
         mat(633) = -rxt(110)*y(29)

         mat(349) = -(rxt(118)*y(5) + rxt(119)*y(13) + rxt(120)*y(18) + 4._r8*rxt(121) &
                      *y(30))
         mat(910) = -rxt(118)*y(30)
         mat(765) = -rxt(119)*y(30)
         mat(855) = -rxt(120)*y(30)

         mat(686) = rxt(110)*y(29) + .500_r8*rxt(122)*y(31)
         mat(33) = rxt(110)*y(12)
         mat(129) = .500_r8*rxt(122)*y(12)

         mat(128) = -(rxt(122)*y(12))
         mat(654) = -rxt(122)*y(31)

         mat(742) = rxt(119)*y(30)
         mat(347) = rxt(119)*y(13)

         mat(426) = -(rxt(123)*y(12) + rxt(124)*y(7))
         mat(693) = -rxt(123)*y(32)
         mat(948) = -rxt(124)*y(32)

         mat(803) = .500_r8*rxt(137)*y(35) + .040_r8*rxt(159)*y(55)
         mat(914) = rxt(118)*y(30) + .270_r8*rxt(139)*y(37) + rxt(144)*y(39) &
                      + rxt(157)*y(45) + .400_r8*rxt(198)*y(50) + rxt(161)*y(47)
         mat(693) = mat(693) + rxt(133)*y(22) + .500_r8*rxt(122)*y(31)
         mat(860) = .800_r8*rxt(120)*y(30)
         mat(95) = rxt(133)*y(12)
         mat(350) = rxt(118)*y(5) + .800_r8*rxt(120)*y(18) + 3.200_r8*rxt(121)*y(30)
         mat(130) = .500_r8*rxt(122)*y(12)
         mat(413) = .500_r8*rxt(137)*y(1)
         mat(367) = .270_r8*rxt(139)*y(5)
         mat(322) = rxt(144)*y(5)
         mat(140) = rxt(157)*y(5)
         mat(337) = .400_r8*rxt(198)*y(5)
         mat(309) = rxt(161)*y(5)
         mat(537) = .040_r8*rxt(159)*y(1)

         mat(621) = -(rxt(125)*y(5) + rxt(126)*y(6) + rxt(127)*y(13) + rxt(128)*y(18) &
                      + 4._r8*rxt(129)*y(33) + rxt(171)*y(57) + rxt(190)*y(53) + rxt(205) &
                      *y(63))
         mat(927) = -rxt(125)*y(33)
         mat(838) = -rxt(126)*y(33)
         mat(784) = -rxt(127)*y(33)
         mat(871) = -rxt(128)*y(33)
         mat(561) = -rxt(171)*y(33)
         mat(581) = -rxt(190)*y(33)
         mat(513) = -rxt(205)*y(33)

         mat(927) = mat(927) + rxt(148)*y(42) + rxt(161)*y(47) + .530_r8*rxt(166) &
                      *y(57) + rxt(173)*y(59)
         mat(961) = rxt(124)*y(32) + .530_r8*rxt(168)*y(57) + rxt(174)*y(59) &
                      + rxt(154)*y(62)
         mat(707) = rxt(123)*y(32) + .500_r8*rxt(130)*y(34) + rxt(153)*y(62)
         mat(871) = mat(871) + .300_r8*rxt(150)*y(42) + .260_r8*rxt(170)*y(57) &
                      + rxt(176)*y(59)
         mat(427) = rxt(124)*y(7) + rxt(123)*y(12)
         mat(621) = mat(621) + .530_r8*rxt(171)*y(57)
         mat(194) = .500_r8*rxt(130)*y(12)
         mat(402) = rxt(148)*y(5) + .300_r8*rxt(150)*y(18)
         mat(310) = rxt(161)*y(5)
         mat(561) = mat(561) + .530_r8*rxt(166)*y(5) + .530_r8*rxt(168)*y(7) &
                      + .260_r8*rxt(170)*y(18) + .530_r8*rxt(171)*y(33)
         mat(597) = rxt(173)*y(5) + rxt(174)*y(7) + rxt(176)*y(18) + 4.000_r8*rxt(178) &
                      *y(59)
         mat(500) = rxt(154)*y(7) + rxt(153)*y(12)

         mat(193) = -(rxt(130)*y(12))
         mat(665) = -rxt(130)*y(34)

         mat(749) = .750_r8*rxt(127)*y(33) + .750_r8*rxt(175)*y(59)
         mat(608) = .750_r8*rxt(127)*y(13)
         mat(591) = .750_r8*rxt(175)*y(13)

         mat(412) = -(rxt(136)*y(12) + rxt(137)*y(1) + rxt(138)*y(7))
         mat(692) = -rxt(136)*y(35)
         mat(802) = -rxt(137)*y(35)
         mat(947) = -rxt(138)*y(35)

         mat(802) = mat(802) + .070_r8*rxt(183)*y(52)
         mat(377) = .070_r8*rxt(183)*y(1)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(35) = -(rxt(143)*y(12))
         mat(634) = -rxt(143)*y(36)

         mat(365) = -(rxt(139)*y(5) + rxt(140)*y(13) + rxt(141)*y(18))
         mat(912) = -rxt(139)*y(37)
         mat(767) = -rxt(140)*y(37)
         mat(857) = -rxt(141)*y(37)

         mat(688) = rxt(143)*y(36) + rxt(142)*y(38)
         mat(36) = rxt(143)*y(12)
         mat(125) = rxt(142)*y(12)

         mat(123) = -(rxt(142)*y(12))
         mat(653) = -rxt(142)*y(38)

         mat(741) = rxt(140)*y(37)
         mat(363) = rxt(140)*y(13)

         mat(321) = -(rxt(144)*y(5) + rxt(145)*y(13))
         mat(908) = -rxt(144)*y(39)
         mat(763) = -rxt(145)*y(39)

         mat(684) = rxt(136)*y(35) + .500_r8*rxt(146)*y(40)
         mat(411) = rxt(136)*y(12)
         mat(228) = .500_r8*rxt(146)*y(12)

         mat(227) = -(rxt(146)*y(12))
         mat(671) = -rxt(146)*y(40)

         mat(753) = rxt(145)*y(39)
         mat(320) = rxt(145)*y(13)

         mat(315) = -(rxt(147)*y(12))
         mat(683) = -rxt(147)*y(41)

         mat(907) = .820_r8*rxt(139)*y(37) + .500_r8*rxt(157)*y(45) + .250_r8*rxt(198) &
                      *y(50) + .100_r8*rxt(223)*y(66)
         mat(854) = .820_r8*rxt(141)*y(37)
         mat(364) = .820_r8*rxt(139)*y(5) + .820_r8*rxt(141)*y(18)
         mat(139) = .500_r8*rxt(157)*y(5)
         mat(333) = .250_r8*rxt(198)*y(5)
         mat(468) = .100_r8*rxt(223)*y(5)

         mat(399) = -(rxt(148)*y(5) + rxt(149)*y(13) + rxt(150)*y(18))
         mat(913) = -rxt(148)*y(42)
         mat(769) = -rxt(149)*y(42)
         mat(859) = -rxt(150)*y(42)

         mat(691) = rxt(147)*y(41) + rxt(151)*y(43)
         mat(316) = rxt(147)*y(12)
         mat(119) = rxt(151)*y(12)

         mat(118) = -(rxt(151)*y(12))
         mat(652) = -rxt(151)*y(43)

         mat(740) = rxt(149)*y(42)
         mat(397) = rxt(149)*y(13)

         mat(38) = -(rxt(156)*y(12))
         mat(635) = -rxt(156)*y(44)

         mat(138) = -(rxt(157)*y(5))
         mat(894) = -rxt(157)*y(45)

         mat(656) = rxt(156)*y(44)
         mat(39) = rxt(156)*y(12)

         mat(41) = -(rxt(194)*y(12))
         mat(636) = -rxt(194)*y(49)

         mat(334) = -(rxt(198)*y(5) + rxt(199)*y(13))
         mat(909) = -rxt(198)*y(50)
         mat(764) = -rxt(199)*y(50)

         mat(685) = rxt(194)*y(49) + rxt(200)*y(51)
         mat(42) = rxt(194)*y(12)
         mat(300) = rxt(200)*y(12)

         mat(297) = -(rxt(200)*y(12))
         mat(681) = -rxt(200)*y(51)

         mat(760) = rxt(199)*y(50)
         mat(331) = rxt(199)*y(13)

         mat(188) = -(rxt(160)*y(12))
         mat(664) = -rxt(160)*y(46)

         mat(900) = .800_r8*rxt(198)*y(50)
         mat(330) = .800_r8*rxt(198)*y(5)

         mat(308) = -(rxt(161)*y(5) + rxt(162)*y(13))
         mat(906) = -rxt(161)*y(47)
         mat(761) = -rxt(162)*y(47)

         mat(682) = rxt(160)*y(46) + rxt(163)*y(48)
         mat(189) = rxt(160)*y(12)
         mat(109) = rxt(163)*y(12)

         mat(108) = -(rxt(163)*y(12))
         mat(650) = -rxt(163)*y(48)

         mat(738) = rxt(162)*y(47)
         mat(307) = rxt(162)*y(13)

         mat(376) = -(rxt(182)*y(12) + rxt(183)*y(1) + rxt(184)*y(7))
         mat(689) = -rxt(182)*y(52)
         mat(800) = -rxt(183)*y(52)
         mat(946) = -rxt(184)*y(52)

         mat(579) = -(rxt(185)*y(5) + rxt(186)*y(7) + rxt(187)*y(13) + rxt(189)*y(18) &
                      + rxt(190)*y(33))
         mat(925) = -rxt(185)*y(53)
         mat(959) = -rxt(186)*y(53)
         mat(782) = -rxt(187)*y(53)
         mat(869) = -rxt(189)*y(53)
         mat(619) = -rxt(190)*y(53)

         mat(705) = rxt(182)*y(52) + .200_r8*rxt(188)*y(54)
         mat(381) = rxt(182)*y(12)
         mat(261) = .200_r8*rxt(188)*y(12)

         mat(257) = -(rxt(188)*y(12))
         mat(675) = -rxt(188)*y(54)

         mat(756) = rxt(187)*y(53)
         mat(571) = rxt(187)*y(13)

         mat(540) = -(rxt(158)*y(12) + rxt(159)*y(1))
         mat(703) = -rxt(158)*y(55)
         mat(812) = -rxt(159)*y(55)

         mat(812) = mat(812) + .200_r8*rxt(183)*y(52) + rxt(221)*y(65)
         mat(923) = .320_r8*rxt(185)*y(53) + rxt(223)*y(66) + .039_r8*rxt(191)*y(84)
         mat(957) = .350_r8*rxt(186)*y(53) + .039_r8*rxt(192)*y(84)
         mat(780) = .039_r8*rxt(193)*y(84)
         mat(867) = .260_r8*rxt(189)*y(53)
         mat(617) = .350_r8*rxt(190)*y(53)
         mat(380) = .200_r8*rxt(183)*y(1)
         mat(577) = .320_r8*rxt(185)*y(5) + .350_r8*rxt(186)*y(7) + .260_r8*rxt(189) &
                      *y(18) + .350_r8*rxt(190)*y(33)
         mat(272) = rxt(221)*y(1)
         mat(474) = rxt(223)*y(5)
         mat(459) = .039_r8*rxt(191)*y(5) + .039_r8*rxt(192)*y(7) + .039_r8*rxt(193) &
                      *y(13)

         mat(488) = -(rxt(164)*y(12) + rxt(165)*y(1))
         mat(699) = -rxt(164)*y(56)
         mat(808) = -rxt(165)*y(56)

         mat(808) = mat(808) + .400_r8*rxt(183)*y(52) + rxt(221)*y(65)
         mat(919) = .230_r8*rxt(185)*y(53) + rxt(223)*y(66) + .167_r8*rxt(191)*y(84)
         mat(953) = .250_r8*rxt(186)*y(53) + .167_r8*rxt(192)*y(84)
         mat(776) = .167_r8*rxt(193)*y(84)
         mat(863) = .190_r8*rxt(189)*y(53)
         mat(614) = .250_r8*rxt(190)*y(53)
         mat(379) = .400_r8*rxt(183)*y(1)
         mat(574) = .230_r8*rxt(185)*y(5) + .250_r8*rxt(186)*y(7) + .190_r8*rxt(189) &
                      *y(18) + .250_r8*rxt(190)*y(33)
         mat(271) = rxt(221)*y(1)
         mat(472) = rxt(223)*y(5)
         mat(457) = .167_r8*rxt(191)*y(5) + .167_r8*rxt(192)*y(7) + .167_r8*rxt(193) &
                      *y(13)

         mat(559) = -((rxt(166) + rxt(167)) * y(5) + rxt(168)*y(7) + rxt(169)*y(13) &
                      + rxt(170)*y(18) + rxt(171)*y(33))
         mat(924) = -(rxt(166) + rxt(167)) * y(57)
         mat(958) = -rxt(168)*y(57)
         mat(781) = -rxt(169)*y(57)
         mat(868) = -rxt(170)*y(57)
         mat(618) = -rxt(171)*y(57)

         mat(704) = rxt(158)*y(55) + .500_r8*rxt(164)*y(56) + .200_r8*rxt(172)*y(58)
         mat(541) = rxt(158)*y(12)
         mat(490) = .500_r8*rxt(164)*y(12)
         mat(114) = .200_r8*rxt(172)*y(12)

         mat(113) = -(rxt(172)*y(12))
         mat(651) = -rxt(172)*y(58)

         mat(739) = rxt(169)*y(57)
         mat(552) = rxt(169)*y(13)

         mat(596) = -(rxt(173)*y(5) + rxt(174)*y(7) + rxt(175)*y(13) + rxt(176)*y(18) &
                      + rxt(177)*y(33) + 4._r8*rxt(178)*y(59) + rxt(179)*y(6))
         mat(926) = -rxt(173)*y(59)
         mat(960) = -rxt(174)*y(59)
         mat(783) = -rxt(175)*y(59)
         mat(870) = -rxt(176)*y(59)
         mat(620) = -rxt(177)*y(59)
         mat(837) = -rxt(179)*y(59)

         mat(815) = .200_r8*rxt(183)*y(52)
         mat(706) = .500_r8*rxt(164)*y(56) + .500_r8*rxt(172)*y(58)
         mat(382) = .200_r8*rxt(183)*y(1)
         mat(491) = .500_r8*rxt(164)*y(12)
         mat(115) = .500_r8*rxt(172)*y(12)

         mat(161) = -(rxt(197)*y(12))
         mat(660) = -rxt(197)*y(60)

         mat(896) = .370_r8*rxt(185)*y(53)
         mat(940) = .400_r8*rxt(186)*y(53) + rxt(196)*y(85)
         mat(660) = mat(660) + rxt(195)*y(85)
         mat(850) = .300_r8*rxt(189)*y(53)
         mat(607) = .400_r8*rxt(190)*y(53)
         mat(570) = .370_r8*rxt(185)*y(5) + .400_r8*rxt(186)*y(7) + .300_r8*rxt(189) &
                      *y(18) + .400_r8*rxt(190)*y(33)
         mat(434) = rxt(196)*y(7) + rxt(195)*y(12)

         mat(482) = -(rxt(152)*y(12))
         mat(698) = -rxt(152)*y(61)

         mat(918) = .220_r8*rxt(166)*y(57) + .250_r8*rxt(201)*y(63)
         mat(952) = .220_r8*rxt(168)*y(57) + .250_r8*rxt(202)*y(63)
         mat(698) = mat(698) + .500_r8*rxt(146)*y(40) + .500_r8*rxt(181)*y(83)
         mat(862) = .200_r8*rxt(150)*y(42) + .230_r8*rxt(170)*y(57) + .100_r8*rxt(204) &
                      *y(63)
         mat(613) = .220_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(230) = .500_r8*rxt(146)*y(12)
         mat(400) = .200_r8*rxt(150)*y(18)
         mat(556) = .220_r8*rxt(166)*y(5) + .220_r8*rxt(168)*y(7) + .230_r8*rxt(170) &
                      *y(18) + .220_r8*rxt(171)*y(33)
         mat(510) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)
         mat(235) = .500_r8*rxt(181)*y(12)

         mat(499) = -(rxt(153)*y(12) + rxt(154)*y(7))
         mat(700) = -rxt(153)*y(62)
         mat(954) = -rxt(154)*y(62)

         mat(809) = .950_r8*rxt(159)*y(55) + .800_r8*rxt(165)*y(56)
         mat(920) = .250_r8*rxt(166)*y(57) + .250_r8*rxt(201)*y(63) + .450_r8*rxt(209) &
                      *y(70) + .540_r8*rxt(219)*y(76)
         mat(954) = mat(954) + .250_r8*rxt(168)*y(57) + .250_r8*rxt(202)*y(63)
         mat(700) = mat(700) + rxt(152)*y(61) + rxt(155)*y(82)
         mat(864) = .500_r8*rxt(150)*y(42) + .240_r8*rxt(170)*y(57) + .100_r8*rxt(204) &
                      *y(63)
         mat(615) = .250_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(401) = .500_r8*rxt(150)*y(18)
         mat(539) = .950_r8*rxt(159)*y(1)
         mat(489) = .800_r8*rxt(165)*y(1)
         mat(557) = .250_r8*rxt(166)*y(5) + .250_r8*rxt(168)*y(7) + .240_r8*rxt(170) &
                      *y(18) + .250_r8*rxt(171)*y(33)
         mat(483) = rxt(152)*y(12)
         mat(511) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)
         mat(246) = .450_r8*rxt(209)*y(5)
         mat(212) = .540_r8*rxt(219)*y(5)
         mat(178) = rxt(155)*y(12)

         mat(512) = -(rxt(201)*y(5) + rxt(202)*y(7) + rxt(203)*y(13) + rxt(204)*y(18) &
                      + rxt(205)*y(33))
         mat(921) = -rxt(201)*y(63)
         mat(955) = -rxt(202)*y(63)
         mat(778) = -rxt(203)*y(63)
         mat(865) = -rxt(204)*y(63)
         mat(616) = -rxt(205)*y(63)

         mat(701) = .800_r8*rxt(188)*y(54) + rxt(197)*y(60) + rxt(206)*y(64)
         mat(259) = .800_r8*rxt(188)*y(12)
         mat(162) = rxt(197)*y(12)
         mat(82) = rxt(206)*y(12)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(81) = -((rxt(206) + rxt(207)) * y(12))
         mat(646) = -(rxt(206) + rxt(207)) * y(64)

         mat(735) = rxt(203)*y(63) + rxt(193)*y(84)
         mat(506) = rxt(203)*y(13)
         mat(454) = rxt(193)*y(13)

         mat(269) = -(rxt(220)*y(12) + rxt(221)*y(1) + rxt(222)*y(7))
         mat(677) = -rxt(220)*y(65)
         mat(797) = -rxt(221)*y(65)
         mat(943) = -rxt(222)*y(65)

         mat(470) = -(rxt(223)*y(5) + rxt(224)*y(13))
         mat(917) = -rxt(223)*y(66)
         mat(774) = -rxt(224)*y(66)

         mat(951) = rxt(222)*y(65)
         mat(697) = rxt(220)*y(65) + rxt(225)*y(67)
         mat(270) = rxt(222)*y(7) + rxt(220)*y(12)
         mat(203) = rxt(225)*y(12)

         mat(201) = -(rxt(225)*y(12))
         mat(667) = -rxt(225)*y(67)

         mat(751) = rxt(224)*y(66)
         mat(467) = rxt(224)*y(13)

         mat(56) = -(rxt(208)*y(12))
         mat(641) = -rxt(208)*y(68)

         mat(61) = -(rxt(212)*y(12))
         mat(642) = -rxt(212)*y(69)

         mat(642) = mat(642) + .250_r8*rxt(208)*y(68)
         mat(57) = .250_r8*rxt(208)*y(12)

         mat(243) = -(rxt(209)*y(5) + rxt(210)*y(13))
         mat(902) = -rxt(209)*y(70)
         mat(754) = -rxt(210)*y(70)

         mat(673) = .700_r8*rxt(208)*y(68) + rxt(211)*y(71)
         mat(58) = .700_r8*rxt(208)*y(12)
         mat(165) = rxt(211)*y(12)

         mat(164) = -(rxt(211)*y(12))
         mat(661) = -rxt(211)*y(71)

         mat(746) = rxt(210)*y(70)
         mat(242) = rxt(210)*y(13)

         mat(73) = -(rxt(213)*y(6))
         mat(826) = -rxt(213)*y(78)

         mat(644) = rxt(212)*y(69)
         mat(62) = rxt(212)*y(12)


         mat(903) = .900_r8*rxt(209)*y(70) + .900_r8*rxt(216)*y(73) + .620_r8*rxt(219) &
                      *y(76)
         mat(832) = .700_r8*rxt(213)*y(78)
         mat(244) = .900_r8*rxt(209)*y(5)
         mat(74) = .700_r8*rxt(213)*y(6)
         mat(172) = .900_r8*rxt(216)*y(5)
         mat(210) = .620_r8*rxt(219)*y(5)

         mat(292) = -(rxt(132)*y(12))
         mat(680) = -rxt(132)*y(80)

         mat(905) = .250_r8*rxt(201)*y(63) + .450_r8*rxt(209)*y(70) + .900_r8*rxt(216) &
                      *y(73) + .340_r8*rxt(219)*y(76)
         mat(944) = .250_r8*rxt(202)*y(63)
         mat(680) = mat(680) + .200_r8*rxt(131)*y(27) + .650_r8*rxt(109)*y(118)
         mat(853) = .100_r8*rxt(204)*y(63)
         mat(357) = .200_r8*rxt(131)*y(12)
         mat(611) = .250_r8*rxt(205)*y(63)
         mat(508) = .250_r8*rxt(201)*y(5) + .250_r8*rxt(202)*y(7) + .100_r8*rxt(204) &
                      *y(18) + .250_r8*rxt(205)*y(33)
         mat(245) = .450_r8*rxt(209)*y(5)
         mat(173) = .900_r8*rxt(216)*y(5)
         mat(211) = .340_r8*rxt(219)*y(5)
         mat(69) = .650_r8*rxt(109)*y(12)

         mat(44) = -(rxt(214)*y(12))
         mat(637) = -rxt(214)*y(72)

         mat(171) = -(rxt(215)*y(13) + rxt(216)*y(5))
         mat(747) = -rxt(215)*y(73)
         mat(897) = -rxt(216)*y(73)

         mat(662) = rxt(214)*y(72)
         mat(45) = rxt(214)*y(12)


         mat(732) = rxt(215)*y(73)
         mat(170) = rxt(215)*y(13)

         mat(47) = -(rxt(217)*y(12))
         mat(638) = -rxt(217)*y(75)

         mat(209) = -(rxt(218)*y(13) + rxt(219)*y(5))
         mat(752) = -rxt(218)*y(76)
         mat(901) = -rxt(219)*y(76)

         mat(668) = rxt(217)*y(75)
         mat(48) = rxt(217)*y(12)


         mat(733) = rxt(218)*y(76)
         mat(208) = rxt(218)*y(13)

         mat(216) = -(rxt(135)*y(12))
         mat(669) = -rxt(135)*y(81)

         mat(829) = rxt(126)*y(33)
         mat(610) = rxt(126)*y(6)

         mat(177) = -(rxt(155)*y(12))
         mat(663) = -rxt(155)*y(82)

         mat(898) = .100_r8*rxt(198)*y(50)
         mat(941) = rxt(138)*y(35)
         mat(409) = rxt(138)*y(7)
         mat(329) = .100_r8*rxt(198)*y(5)

         mat(234) = -(rxt(181)*y(12))
         mat(672) = -rxt(181)*y(83)

         mat(831) = rxt(179)*y(59)
         mat(593) = rxt(179)*y(6)

         mat(456) = -(rxt(191)*y(5) + rxt(192)*y(7) + rxt(193)*y(13))
         mat(916) = -rxt(191)*y(84)
         mat(950) = -rxt(192)*y(84)
         mat(773) = -rxt(193)*y(84)

         mat(950) = mat(950) + rxt(184)*y(52)
         mat(378) = rxt(184)*y(7)

         mat(435) = -(rxt(195)*y(12) + rxt(196)*y(7))
         mat(694) = -rxt(195)*y(85)
         mat(949) = -rxt(196)*y(85)

         mat(915) = .080_r8*rxt(185)*y(53) + .800_r8*rxt(167)*y(57) + .794_r8*rxt(191) &
                      *y(84)
         mat(949) = mat(949) + .794_r8*rxt(192)*y(84)
         mat(771) = .794_r8*rxt(193)*y(84)
         mat(573) = .080_r8*rxt(185)*y(5)
         mat(555) = .800_r8*rxt(167)*y(5)
         mat(455) = .794_r8*rxt(191)*y(5) + .794_r8*rxt(192)*y(7) + .794_r8*rxt(193) &
                      *y(13)

         mat(54) = -(rxt(231)*y(12))
         mat(640) = -rxt(231)*y(100)

         mat(937) = rxt(234)*y(101)
         mat(640) = mat(640) + (rxt(232)+.500_r8*rxt(233))*y(101)
         mat(84) = rxt(234)*y(7) + (rxt(232)+.500_r8*rxt(233))*y(12)

         mat(85) = -((rxt(232) + rxt(233)) * y(12) + rxt(234)*y(7))
         mat(647) = -(rxt(232) + rxt(233)) * y(101)
         mat(938) = -rxt(234)*y(101)


         mat(631) = rxt(231)*y(100)
         mat(53) = rxt(231)*y(12)

         mat(30) = -(rxt(235)*y(12))
         mat(632) = -rxt(235)*y(103)
         mat(67) = -(rxt(109)*y(12))
         mat(643) = -rxt(109)*y(118)
         mat(150) = -(rxt(105)*y(12))
         mat(658) = -rxt(105)*y(119)
         mat(794) = .500_r8*rxt(116)*y(23)
         mat(895) = rxt(107)*y(120)
         mat(658) = mat(658) + .350_r8*rxt(109)*y(118)
         mat(745) = rxt(108)*y(120)
         mat(153) = .500_r8*rxt(116)*y(1)
         mat(68) = .350_r8*rxt(109)*y(12)
         mat(181) = rxt(107)*y(5) + rxt(108)*y(13)
         mat(182) = -(rxt(107)*y(5) + rxt(108)*y(13))
         mat(899) = -rxt(107)*y(120)
         mat(748) = -rxt(108)*y(120)
         mat(748) = mat(748) + rxt(98)*y(20)
         mat(717) = rxt(98)*y(13)
      end subroutine nlnmat05
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = mat( 30) + lmat( 30)
         mat( 32) = mat( 32) + lmat( 32)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 38) = mat( 38) + lmat( 38)
         mat( 41) = mat( 41) + lmat( 41)
         mat( 44) = mat( 44) + lmat( 44)
         mat( 47) = mat( 47) + lmat( 47)
         mat( 50) = mat( 50) + lmat( 50)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 64) = lmat( 64)
         mat( 65) = lmat( 65)
         mat( 66) = lmat( 66)
         mat( 67) = mat( 67) + lmat( 67)
         mat( 73) = mat( 73) + lmat( 73)
         mat( 77) = mat( 77) + lmat( 77)
         mat( 81) = mat( 81) + lmat( 81)
         mat( 83) = mat( 83) + lmat( 83)
         mat( 85) = mat( 85) + lmat( 85)
         mat( 90) = mat( 90) + lmat( 90)
         mat( 92) = mat( 92) + lmat( 92)
         mat( 94) = mat( 94) + lmat( 94)
         mat( 98) = lmat( 98)
         mat( 99) = lmat( 99)
         mat( 100) = lmat( 100)
         mat( 101) = lmat( 101)
         mat( 102) = lmat( 102)
         mat( 103) = lmat( 103)
         mat( 104) = lmat( 104)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = mat( 108) + lmat( 108)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = mat( 112) + lmat( 112)
         mat( 113) = mat( 113) + lmat( 113)
         mat( 118) = mat( 118) + lmat( 118)
         mat( 120) = lmat( 120)
         mat( 121) = mat( 121) + lmat( 121)
         mat( 122) = lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 124) = lmat( 124)
         mat( 126) = mat( 126) + lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = mat( 128) + lmat( 128)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 135) = lmat( 135)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 137) = lmat( 137)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 146) = lmat( 146)
         mat( 147) = mat( 147) + lmat( 147)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 150) = mat( 150) + lmat( 150)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 161) = mat( 161) + lmat( 161)
         mat( 164) = mat( 164) + lmat( 164)
         mat( 166) = lmat( 166)
         mat( 167) = lmat( 167)
         mat( 168) = lmat( 168)
         mat( 169) = mat( 169) + lmat( 169)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 177) = mat( 177) + lmat( 177)
         mat( 182) = mat( 182) + lmat( 182)
         mat( 184) = lmat( 184)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 188) = mat( 188) + lmat( 188)
         mat( 190) = lmat( 190)
         mat( 191) = lmat( 191)
         mat( 193) = mat( 193) + lmat( 193)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 197) = lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 202) = lmat( 202)
         mat( 204) = lmat( 204)
         mat( 205) = lmat( 205)
         mat( 206) = mat( 206) + lmat( 206)
         mat( 207) = lmat( 207)
         mat( 209) = mat( 209) + lmat( 209)
         mat( 216) = mat( 216) + lmat( 216)
         mat( 217) = lmat( 217)
         mat( 220) = lmat( 220)
         mat( 221) = lmat( 221)
         mat( 222) = mat( 222) + lmat( 222)
         mat( 223) = mat( 223) + lmat( 223)
         mat( 224) = mat( 224) + lmat( 224)
         mat( 225) = lmat( 225)
         mat( 227) = mat( 227) + lmat( 227)
         mat( 229) = lmat( 229)
         mat( 231) = mat( 231) + lmat( 231)
         mat( 232) = lmat( 232)
         mat( 233) = lmat( 233)
         mat( 234) = mat( 234) + lmat( 234)
         mat( 236) = lmat( 236)
         mat( 240) = lmat( 240)
         mat( 243) = mat( 243) + lmat( 243)
         mat( 251) = lmat( 251)
         mat( 252) = lmat( 252)
         mat( 253) = lmat( 253)
         mat( 254) = lmat( 254)
         mat( 255) = lmat( 255)
         mat( 256) = lmat( 256)
         mat( 257) = mat( 257) + lmat( 257)
         mat( 258) = lmat( 258)
         mat( 260) = lmat( 260)
         mat( 263) = lmat( 263)
         mat( 264) = lmat( 264)
         mat( 265) = mat( 265) + lmat( 265)
         mat( 269) = mat( 269) + lmat( 269)
         mat( 278) = mat( 278) + lmat( 278)
         mat( 285) = mat( 285) + lmat( 285)
         mat( 292) = mat( 292) + lmat( 292)
         mat( 294) = mat( 294) + lmat( 294)
         mat( 295) = mat( 295) + lmat( 295)
         mat( 296) = lmat( 296)
         mat( 297) = mat( 297) + lmat( 297)
         mat( 299) = lmat( 299)
         mat( 302) = lmat( 302)
         mat( 304) = mat( 304) + lmat( 304)
         mat( 305) = lmat( 305)
         mat( 306) = lmat( 306)
         mat( 308) = mat( 308) + lmat( 308)
         mat( 315) = mat( 315) + lmat( 315)
         mat( 317) = lmat( 317)
         mat( 319) = lmat( 319)
         mat( 321) = mat( 321) + lmat( 321)
         mat( 334) = mat( 334) + lmat( 334)
         mat( 349) = mat( 349) + lmat( 349)
         mat( 358) = mat( 358) + lmat( 358)
         mat( 360) = mat( 360) + lmat( 360)
         mat( 361) = mat( 361) + lmat( 361)
         mat( 362) = lmat( 362)
         mat( 365) = mat( 365) + lmat( 365)
         mat( 376) = mat( 376) + lmat( 376)
         mat( 391) = mat( 391) + lmat( 391)
         mat( 395) = mat( 395) + lmat( 395)
         mat( 399) = mat( 399) + lmat( 399)
         mat( 412) = mat( 412) + lmat( 412)
         mat( 426) = mat( 426) + lmat( 426)
         mat( 429) = lmat( 429)
         mat( 431) = lmat( 431)
         mat( 432) = lmat( 432)
         mat( 435) = mat( 435) + lmat( 435)
         mat( 438) = lmat( 438)
         mat( 439) = mat( 439) + lmat( 439)
         mat( 440) = mat( 440) + lmat( 440)
         mat( 441) = lmat( 441)
         mat( 444) = mat( 444) + lmat( 444)
         mat( 445) = mat( 445) + lmat( 445)
         mat( 446) = mat( 446) + lmat( 446)
         mat( 447) = lmat( 447)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 449) = lmat( 449)
         mat( 450) = lmat( 450)
         mat( 452) = lmat( 452)
         mat( 453) = lmat( 453)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 470) = mat( 470) + lmat( 470)
         mat( 482) = mat( 482) + lmat( 482)
         mat( 484) = lmat( 484)
         mat( 486) = lmat( 486)
         mat( 487) = mat( 487) + lmat( 487)
         mat( 488) = mat( 488) + lmat( 488)
         mat( 491) = mat( 491) + lmat( 491)
         mat( 492) = lmat( 492)
         mat( 494) = mat( 494) + lmat( 494)
         mat( 495) = mat( 495) + lmat( 495)
         mat( 497) = mat( 497) + lmat( 497)
         mat( 499) = mat( 499) + lmat( 499)
         mat( 500) = mat( 500) + lmat( 500)
         mat( 502) = lmat( 502)
         mat( 504) = mat( 504) + lmat( 504)
         mat( 512) = mat( 512) + lmat( 512)
         mat( 526) = mat( 526) + lmat( 526)
         mat( 530) = mat( 530) + lmat( 530)
         mat( 536) = lmat( 536)
         mat( 540) = mat( 540) + lmat( 540)
         mat( 542) = lmat( 542)
         mat( 548) = lmat( 548)
         mat( 549) = mat( 549) + lmat( 549)
         mat( 559) = mat( 559) + lmat( 559)
         mat( 579) = mat( 579) + lmat( 579)
         mat( 596) = mat( 596) + lmat( 596)
         mat( 621) = mat( 621) + lmat( 621)
         mat( 708) = mat( 708) + lmat( 708)
         mat( 713) = mat( 713) + lmat( 713)
         mat( 719) = lmat( 719)
         mat( 724) = mat( 724) + lmat( 724)
         mat( 729) = mat( 729) + lmat( 729)
         mat( 736) = mat( 736) + lmat( 736)
         mat( 787) = mat( 787) + lmat( 787)
         mat( 804) = mat( 804) + lmat( 804)
         mat( 811) = mat( 811) + lmat( 811)
         mat( 820) = mat( 820) + lmat( 820)
         mat( 830) = mat( 830) + lmat( 830)
         mat( 836) = mat( 836) + lmat( 836)
         mat( 839) = mat( 839) + lmat( 839)
         mat( 843) = mat( 843) + lmat( 843)
         mat( 846) = mat( 846) + lmat( 846)
         mat( 877) = mat( 877) + lmat( 877)
         mat( 890) = mat( 890) + lmat( 890)
         mat( 935) = mat( 935) + lmat( 935)
         mat( 942) = mat( 942) + lmat( 942)
         mat( 956) = mat( 956) + lmat( 956)
         mat( 966) = mat( 966) + lmat( 966)
         mat( 969) = mat( 969) + lmat( 969)
         mat( 970) = mat( 970) + lmat( 970)
         mat( 183) = 0._r8
         mat( 247) = 0._r8
         mat( 286) = 0._r8
         mat( 287) = 0._r8
         mat( 298) = 0._r8
         mat( 301) = 0._r8
         mat( 303) = 0._r8
         mat( 311) = 0._r8
         mat( 323) = 0._r8
         mat( 324) = 0._r8
         mat( 332) = 0._r8
         mat( 335) = 0._r8
         mat( 336) = 0._r8
         mat( 338) = 0._r8
         mat( 339) = 0._r8
         mat( 340) = 0._r8
         mat( 344) = 0._r8
         mat( 351) = 0._r8
         mat( 366) = 0._r8
         mat( 368) = 0._r8
         mat( 369) = 0._r8
         mat( 387) = 0._r8
         mat( 392) = 0._r8
         mat( 403) = 0._r8
         mat( 414) = 0._r8
         mat( 415) = 0._r8
         mat( 420) = 0._r8
         mat( 423) = 0._r8
         mat( 430) = 0._r8
         mat( 436) = 0._r8
         mat( 458) = 0._r8
         mat( 460) = 0._r8
         mat( 464) = 0._r8
         mat( 469) = 0._r8
         mat( 471) = 0._r8
         mat( 473) = 0._r8
         mat( 475) = 0._r8
         mat( 476) = 0._r8
         mat( 477) = 0._r8
         mat( 480) = 0._r8
         mat( 503) = 0._r8
         mat( 514) = 0._r8
         mat( 525) = 0._r8
         mat( 532) = 0._r8
         mat( 538) = 0._r8
         mat( 547) = 0._r8
         mat( 550) = 0._r8
         mat( 551) = 0._r8
         mat( 558) = 0._r8
         mat( 560) = 0._r8
         mat( 562) = 0._r8
         mat( 575) = 0._r8
         mat( 576) = 0._r8
         mat( 578) = 0._r8
         mat( 580) = 0._r8
         mat( 582) = 0._r8
         mat( 585) = 0._r8
         mat( 588) = 0._r8
         mat( 594) = 0._r8
         mat( 595) = 0._r8
         mat( 598) = 0._r8
         mat( 604) = 0._r8
         mat( 622) = 0._r8
         mat( 630) = 0._r8
         mat( 674) = 0._r8
         mat( 695) = 0._r8
         mat( 696) = 0._r8
         mat( 715) = 0._r8
         mat( 721) = 0._r8
         mat( 726) = 0._r8
         mat( 727) = 0._r8
         mat( 728) = 0._r8
         mat( 730) = 0._r8
         mat( 737) = 0._r8
         mat( 755) = 0._r8
         mat( 759) = 0._r8
         mat( 762) = 0._r8
         mat( 766) = 0._r8
         mat( 770) = 0._r8
         mat( 772) = 0._r8
         mat( 775) = 0._r8
         mat( 777) = 0._r8
         mat( 791) = 0._r8
         mat( 798) = 0._r8
         mat( 799) = 0._r8
         mat( 805) = 0._r8
         mat( 806) = 0._r8
         mat( 807) = 0._r8
         mat( 810) = 0._r8
         mat( 813) = 0._r8
         mat( 814) = 0._r8
         mat( 816) = 0._r8
         mat( 833) = 0._r8
         mat( 834) = 0._r8
         mat( 835) = 0._r8
         mat( 840) = 0._r8
         mat( 844) = 0._r8
         mat( 845) = 0._r8
         mat( 858) = 0._r8
         mat( 861) = 0._r8
         mat( 866) = 0._r8
         mat( 872) = 0._r8
         mat( 875) = 0._r8
         mat( 880) = 0._r8
         mat( 882) = 0._r8
         mat( 883) = 0._r8
         mat( 885) = 0._r8
         mat( 887) = 0._r8
         mat( 888) = 0._r8
         mat( 889) = 0._r8
         mat( 891) = 0._r8
         mat( 892) = 0._r8
         mat( 965) = 0._r8
         mat( 967) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 32) = mat( 32) - dti
         mat( 35) = mat( 35) - dti
         mat( 38) = mat( 38) - dti
         mat( 41) = mat( 41) - dti
         mat( 44) = mat( 44) - dti
         mat( 47) = mat( 47) - dti
         mat( 50) = mat( 50) - dti
         mat( 54) = mat( 54) - dti
         mat( 56) = mat( 56) - dti
         mat( 61) = mat( 61) - dti
         mat( 64) = mat( 64) - dti
         mat( 67) = mat( 67) - dti
         mat( 73) = mat( 73) - dti
         mat( 77) = mat( 77) - dti
         mat( 81) = mat( 81) - dti
         mat( 85) = mat( 85) - dti
         mat( 90) = mat( 90) - dti
         mat( 94) = mat( 94) - dti
         mat( 98) = mat( 98) - dti
         mat( 102) = mat( 102) - dti
         mat( 108) = mat( 108) - dti
         mat( 113) = mat( 113) - dti
         mat( 118) = mat( 118) - dti
         mat( 123) = mat( 123) - dti
         mat( 128) = mat( 128) - dti
         mat( 133) = mat( 133) - dti
         mat( 138) = mat( 138) - dti
         mat( 145) = mat( 145) - dti
         mat( 150) = mat( 150) - dti
         mat( 154) = mat( 154) - dti
         mat( 161) = mat( 161) - dti
         mat( 164) = mat( 164) - dti
         mat( 171) = mat( 171) - dti
         mat( 177) = mat( 177) - dti
         mat( 182) = mat( 182) - dti
         mat( 188) = mat( 188) - dti
         mat( 193) = mat( 193) - dti
         mat( 198) = mat( 198) - dti
         mat( 201) = mat( 201) - dti
         mat( 209) = mat( 209) - dti
         mat( 216) = mat( 216) - dti
         mat( 223) = mat( 223) - dti
         mat( 227) = mat( 227) - dti
         mat( 234) = mat( 234) - dti
         mat( 243) = mat( 243) - dti
         mat( 251) = mat( 251) - dti
         mat( 257) = mat( 257) - dti
         mat( 265) = mat( 265) - dti
         mat( 269) = mat( 269) - dti
         mat( 278) = mat( 278) - dti
         mat( 285) = mat( 285) - dti
         mat( 292) = mat( 292) - dti
         mat( 297) = mat( 297) - dti
         mat( 308) = mat( 308) - dti
         mat( 315) = mat( 315) - dti
         mat( 321) = mat( 321) - dti
         mat( 334) = mat( 334) - dti
         mat( 349) = mat( 349) - dti
         mat( 358) = mat( 358) - dti
         mat( 365) = mat( 365) - dti
         mat( 376) = mat( 376) - dti
         mat( 391) = mat( 391) - dti
         mat( 399) = mat( 399) - dti
         mat( 412) = mat( 412) - dti
         mat( 426) = mat( 426) - dti
         mat( 435) = mat( 435) - dti
         mat( 446) = mat( 446) - dti
         mat( 456) = mat( 456) - dti
         mat( 470) = mat( 470) - dti
         mat( 482) = mat( 482) - dti
         mat( 488) = mat( 488) - dti
         mat( 499) = mat( 499) - dti
         mat( 512) = mat( 512) - dti
         mat( 526) = mat( 526) - dti
         mat( 540) = mat( 540) - dti
         mat( 559) = mat( 559) - dti
         mat( 579) = mat( 579) - dti
         mat( 596) = mat( 596) - dti
         mat( 621) = mat( 621) - dti
         mat( 708) = mat( 708) - dti
         mat( 724) = mat( 724) - dti
         mat( 787) = mat( 787) - dti
         mat( 820) = mat( 820) - dti
         mat( 843) = mat( 843) - dti
         mat( 877) = mat( 877) - dti
         mat( 890) = mat( 890) - dti
         mat( 935) = mat( 935) - dti
         mat( 970) = mat( 970) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
