module mo_rxt_rates_conv
  use shr_kind_mod, only : r8 => shr_kind_r8
  implicit none
  private
  public :: set_rates
contains
   subroutine set_rates( rxt_rates, sol, ncol )
      real(r8), intent(inout) :: rxt_rates(:,:,:)
      real(r8), intent(in) :: sol(:,:,:)
      integer, intent(in) :: ncol
                                                                                                                               ! rate_const*O2
      rxt_rates(:ncol,:,     2) = rxt_rates(:ncol,:,     2)*sol(:ncol,:,     1)                                                ! rate_const*O3
      rxt_rates(:ncol,:,     3) = rxt_rates(:ncol,:,     3)*sol(:ncol,:,     1)                                                ! rate_const*O3
      rxt_rates(:ncol,:,     4) = rxt_rates(:ncol,:,     4)*sol(:ncol,:,     4)                                                ! rate_const*N2O
      rxt_rates(:ncol,:,     5) = rxt_rates(:ncol,:,     5)*sol(:ncol,:,     6)                                                ! rate_const*NO2
      rxt_rates(:ncol,:,     6) = rxt_rates(:ncol,:,     6)*sol(:ncol,:,    10)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,     7) = rxt_rates(:ncol,:,     7)*sol(:ncol,:,    10)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,     8) = rxt_rates(:ncol,:,     8)*sol(:ncol,:,     8)                                                ! rate_const*HNO3
      rxt_rates(:ncol,:,     9) = rxt_rates(:ncol,:,     9)*sol(:ncol,:,     7)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,    10) = rxt_rates(:ncol,:,    10)*sol(:ncol,:,     7)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,    11) = rxt_rates(:ncol,:,    11)*sol(:ncol,:,     9)                                                ! rate_const*HO2NO2
      rxt_rates(:ncol,:,    12) = rxt_rates(:ncol,:,    12)*sol(:ncol,:,     9)                                                ! rate_const*HO2NO2
      rxt_rates(:ncol,:,    13) = rxt_rates(:ncol,:,    13)*sol(:ncol,:,    19)                                                ! rate_const*CH3OOH
      rxt_rates(:ncol,:,    14) = rxt_rates(:ncol,:,    14)*sol(:ncol,:,    20)                                                ! rate_const*CH2O
      rxt_rates(:ncol,:,    15) = rxt_rates(:ncol,:,    15)*sol(:ncol,:,    20)                                                ! rate_const*CH2O
      rxt_rates(:ncol,:,    16) = rxt_rates(:ncol,:,    16)*sol(:ncol,:,    14)                                                ! rate_const*H2O2
      rxt_rates(:ncol,:,    17) = rxt_rates(:ncol,:,    17)*sol(:ncol,:,    32)                                                ! rate_const*CH3CHO
      rxt_rates(:ncol,:,    18) = rxt_rates(:ncol,:,    18)*sol(:ncol,:,    40)                                                ! rate_const*POOH
      rxt_rates(:ncol,:,    19) = rxt_rates(:ncol,:,    19)*sol(:ncol,:,    34)                                                ! rate_const*CH3COOOH
      rxt_rates(:ncol,:,    20) = rxt_rates(:ncol,:,    20)*sol(:ncol,:,    81)                                                ! rate_const*PAN
      rxt_rates(:ncol,:,    21) = rxt_rates(:ncol,:,    21)*sol(:ncol,:,    83)                                                ! rate_const*MPAN
      rxt_rates(:ncol,:,    22) = rxt_rates(:ncol,:,    22)*sol(:ncol,:,    56)                                                ! rate_const*MACR
      rxt_rates(:ncol,:,    23) = rxt_rates(:ncol,:,    23)*sol(:ncol,:,    56)                                                ! rate_const*MACR
      rxt_rates(:ncol,:,    24) = rxt_rates(:ncol,:,    24)*sol(:ncol,:,    55)                                                ! rate_const*MVK
      rxt_rates(:ncol,:,    25) = rxt_rates(:ncol,:,    25)*sol(:ncol,:,    31)                                                ! rate_const*C2H5OOH
      rxt_rates(:ncol,:,    26) = rxt_rates(:ncol,:,    26)*sol(:ncol,:,    28)                                                ! rate_const*EOOH
      rxt_rates(:ncol,:,    27) = rxt_rates(:ncol,:,    27)*sol(:ncol,:,    38)                                                ! rate_const*C3H7OOH
      rxt_rates(:ncol,:,    28) = rxt_rates(:ncol,:,    28)*sol(:ncol,:,    43)                                                ! rate_const*ROOH
      rxt_rates(:ncol,:,    29) = rxt_rates(:ncol,:,    29)*sol(:ncol,:,    41)                                                ! rate_const*CH3COCH3
      rxt_rates(:ncol,:,    30) = rxt_rates(:ncol,:,    30)*sol(:ncol,:,    62)                                                ! rate_const*CH3COCHO
      rxt_rates(:ncol,:,    31) = rxt_rates(:ncol,:,    31)*sol(:ncol,:,    64)                                                ! rate_const*XOOH
      rxt_rates(:ncol,:,    32) = rxt_rates(:ncol,:,    32)*sol(:ncol,:,    85)                                                ! rate_const*ONITR
      rxt_rates(:ncol,:,    33) = rxt_rates(:ncol,:,    33)*sol(:ncol,:,    54)                                                ! rate_const*ISOPOOH
      rxt_rates(:ncol,:,    34) = rxt_rates(:ncol,:,    34)*sol(:ncol,:,    61)                                                ! rate_const*HYAC
      rxt_rates(:ncol,:,    35) = rxt_rates(:ncol,:,    35)*sol(:ncol,:,    27)                                                ! rate_const*GLYALD
      rxt_rates(:ncol,:,    36) = rxt_rates(:ncol,:,    36)*sol(:ncol,:,    46)                                                ! rate_const*MEK
      rxt_rates(:ncol,:,    37) = rxt_rates(:ncol,:,    37)*sol(:ncol,:,    79)                                                ! rate_const*BIGALD
      rxt_rates(:ncol,:,    38) = rxt_rates(:ncol,:,    38)*sol(:ncol,:,    80)                                                ! rate_const*GLYOXAL
      rxt_rates(:ncol,:,    39) = rxt_rates(:ncol,:,    39)*sol(:ncol,:,    51)                                                ! rate_const*ALKOOH
      rxt_rates(:ncol,:,    40) = rxt_rates(:ncol,:,    40)*sol(:ncol,:,    48)                                                ! rate_const*MEKOOH
      rxt_rates(:ncol,:,    41) = rxt_rates(:ncol,:,    41)*sol(:ncol,:,    71)                                                ! rate_const*TOLOOH
      rxt_rates(:ncol,:,    42) = rxt_rates(:ncol,:,    42)*sol(:ncol,:,    67)                                                ! rate_const*TERPOOH
      rxt_rates(:ncol,:,    43) = rxt_rates(:ncol,:,    43)*sol(:ncol,:,     2)                                                ! rate_const*O2*M*O
      rxt_rates(:ncol,:,    44) = rxt_rates(:ncol,:,    44)*sol(:ncol,:,     2)*sol(:ncol,:,     1)                            ! rate_const*O*O3
      rxt_rates(:ncol,:,    45) = rxt_rates(:ncol,:,    45)*sol(:ncol,:,     3)                                                ! rate_const*N2*O1D
      rxt_rates(:ncol,:,    46) = rxt_rates(:ncol,:,    46)*sol(:ncol,:,     3)                                                ! rate_const*O2*O1D
      rxt_rates(:ncol,:,    47) = rxt_rates(:ncol,:,    47)*sol(:ncol,:,     3)*sol(:ncol,:,     1)                            ! rate_const*O1D*O3
      rxt_rates(:ncol,:,    48) = rxt_rates(:ncol,:,    48)*sol(:ncol,:,     3)                                                ! rate_const*H2O*O1D
      rxt_rates(:ncol,:,    49) = rxt_rates(:ncol,:,    49)*sol(:ncol,:,     3)*sol(:ncol,:,    11)                            ! rate_const*O1D*H2
      rxt_rates(:ncol,:,    50) = rxt_rates(:ncol,:,    50)*sol(:ncol,:,     3)*sol(:ncol,:,     4)                            ! rate_const*O1D*N2O
      rxt_rates(:ncol,:,    51) = rxt_rates(:ncol,:,    51)*sol(:ncol,:,     3)*sol(:ncol,:,     4)                            ! rate_const*O1D*N2O
      rxt_rates(:ncol,:,    52) = rxt_rates(:ncol,:,    52)*sol(:ncol,:,     3)*sol(:ncol,:,    16)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,    53) = rxt_rates(:ncol,:,    53)*sol(:ncol,:,     3)*sol(:ncol,:,    16)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,    54) = rxt_rates(:ncol,:,    54)*sol(:ncol,:,     3)*sol(:ncol,:,    16)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,    55) = rxt_rates(:ncol,:,    55)*sol(:ncol,:,     3)*sol(:ncol,:,   116)                            ! rate_const*O1D*HCN
      rxt_rates(:ncol,:,    56) = rxt_rates(:ncol,:,    56)*sol(:ncol,:,    15)                                                ! rate_const*O2*M*H
      rxt_rates(:ncol,:,    57) = rxt_rates(:ncol,:,    57)*sol(:ncol,:,    15)*sol(:ncol,:,     1)                            ! rate_const*H*O3
      rxt_rates(:ncol,:,    58) = rxt_rates(:ncol,:,    58)*sol(:ncol,:,    15)*sol(:ncol,:,    13)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,    59) = rxt_rates(:ncol,:,    59)*sol(:ncol,:,    15)*sol(:ncol,:,    13)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,    60) = rxt_rates(:ncol,:,    60)*sol(:ncol,:,    15)*sol(:ncol,:,    13)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,    61) = rxt_rates(:ncol,:,    61)*sol(:ncol,:,    12)*sol(:ncol,:,     2)                            ! rate_const*OH*O
      rxt_rates(:ncol,:,    62) = rxt_rates(:ncol,:,    62)*sol(:ncol,:,    12)*sol(:ncol,:,     1)                            ! rate_const*OH*O3
      rxt_rates(:ncol,:,    63) = rxt_rates(:ncol,:,    63)*sol(:ncol,:,    12)*sol(:ncol,:,    13)                            ! rate_const*OH*HO2
      rxt_rates(:ncol,:,    64) = rxt_rates(:ncol,:,    64)*sol(:ncol,:,    12)*sol(:ncol,:,    12)                            ! rate_const*OH*OH
      rxt_rates(:ncol,:,    65) = rxt_rates(:ncol,:,    65)*sol(:ncol,:,    12)*sol(:ncol,:,    12)                            ! rate_const*M*OH*OH
      rxt_rates(:ncol,:,    66) = rxt_rates(:ncol,:,    66)*sol(:ncol,:,    12)*sol(:ncol,:,    11)                            ! rate_const*OH*H2
      rxt_rates(:ncol,:,    67) = rxt_rates(:ncol,:,    67)*sol(:ncol,:,    12)*sol(:ncol,:,    14)                            ! rate_const*OH*H2O2
      rxt_rates(:ncol,:,    68) = rxt_rates(:ncol,:,    68)*sol(:ncol,:,    11)*sol(:ncol,:,     2)                            ! rate_const*H2*O
      rxt_rates(:ncol,:,    69) = rxt_rates(:ncol,:,    69)*sol(:ncol,:,    13)*sol(:ncol,:,     2)                            ! rate_const*HO2*O
      rxt_rates(:ncol,:,    70) = rxt_rates(:ncol,:,    70)*sol(:ncol,:,    13)*sol(:ncol,:,     1)                            ! rate_const*HO2*O3
      rxt_rates(:ncol,:,    71) = rxt_rates(:ncol,:,    71)*sol(:ncol,:,    13)*sol(:ncol,:,    13)                            ! rate_const*HO2*HO2
      rxt_rates(:ncol,:,    72) = rxt_rates(:ncol,:,    72)*sol(:ncol,:,    14)*sol(:ncol,:,     2)                            ! rate_const*H2O2*O
      rxt_rates(:ncol,:,    73) = rxt_rates(:ncol,:,    73)*sol(:ncol,:,   116)*sol(:ncol,:,    12)                            ! rate_const*M*HCN*OH
      rxt_rates(:ncol,:,    74) = rxt_rates(:ncol,:,    74)*sol(:ncol,:,   117)*sol(:ncol,:,    12)                            ! rate_const*CH3CN*OH
      rxt_rates(:ncol,:,    75) = rxt_rates(:ncol,:,    75)*sol(:ncol,:,     5)*sol(:ncol,:,     2)                            ! rate_const*M*NO*O
      rxt_rates(:ncol,:,    76) = rxt_rates(:ncol,:,    76)*sol(:ncol,:,     5)*sol(:ncol,:,    13)                            ! rate_const*NO*HO2
      rxt_rates(:ncol,:,    77) = rxt_rates(:ncol,:,    77)*sol(:ncol,:,     5)*sol(:ncol,:,     1)                            ! rate_const*NO*O3
      rxt_rates(:ncol,:,    78) = rxt_rates(:ncol,:,    78)*sol(:ncol,:,     6)*sol(:ncol,:,     2)                            ! rate_const*NO2*O
      rxt_rates(:ncol,:,    79) = rxt_rates(:ncol,:,    79)*sol(:ncol,:,     6)*sol(:ncol,:,     2)                            ! rate_const*M*NO2*O
      rxt_rates(:ncol,:,    80) = rxt_rates(:ncol,:,    80)*sol(:ncol,:,     6)*sol(:ncol,:,     1)                            ! rate_const*NO2*O3
      rxt_rates(:ncol,:,    81) = rxt_rates(:ncol,:,    81)*sol(:ncol,:,     6)*sol(:ncol,:,     7)                            ! rate_const*M*NO2*NO3
      rxt_rates(:ncol,:,    82) = rxt_rates(:ncol,:,    82)*sol(:ncol,:,    10)                                                ! rate_const*M*N2O5
      rxt_rates(:ncol,:,    83) = rxt_rates(:ncol,:,    83)*sol(:ncol,:,     6)*sol(:ncol,:,    12)                            ! rate_const*M*NO2*OH
      rxt_rates(:ncol,:,    84) = rxt_rates(:ncol,:,    84)*sol(:ncol,:,     8)*sol(:ncol,:,    12)                            ! rate_const*HNO3*OH
      rxt_rates(:ncol,:,    85) = rxt_rates(:ncol,:,    85)*sol(:ncol,:,     7)*sol(:ncol,:,     5)                            ! rate_const*NO3*NO
      rxt_rates(:ncol,:,    86) = rxt_rates(:ncol,:,    86)*sol(:ncol,:,     7)*sol(:ncol,:,     2)                            ! rate_const*NO3*O
      rxt_rates(:ncol,:,    87) = rxt_rates(:ncol,:,    87)*sol(:ncol,:,     7)*sol(:ncol,:,    12)                            ! rate_const*NO3*OH
      rxt_rates(:ncol,:,    88) = rxt_rates(:ncol,:,    88)*sol(:ncol,:,     7)*sol(:ncol,:,    13)                            ! rate_const*NO3*HO2
      rxt_rates(:ncol,:,    89) = rxt_rates(:ncol,:,    89)*sol(:ncol,:,     6)*sol(:ncol,:,    13)                            ! rate_const*M*NO2*HO2
      rxt_rates(:ncol,:,    90) = rxt_rates(:ncol,:,    90)*sol(:ncol,:,     9)*sol(:ncol,:,    12)                            ! rate_const*HO2NO2*OH
      rxt_rates(:ncol,:,    91) = rxt_rates(:ncol,:,    91)*sol(:ncol,:,     9)                                                ! rate_const*M*HO2NO2
      rxt_rates(:ncol,:,    92) = rxt_rates(:ncol,:,    92)*sol(:ncol,:,    16)*sol(:ncol,:,    12)                            ! rate_const*CH4*OH
      rxt_rates(:ncol,:,    93) = rxt_rates(:ncol,:,    93)*sol(:ncol,:,    17)*sol(:ncol,:,    12)                            ! rate_const*CO*OH
      rxt_rates(:ncol,:,    94) = rxt_rates(:ncol,:,    94)*sol(:ncol,:,    17)*sol(:ncol,:,    12)                            ! rate_const*M*CO*OH
      rxt_rates(:ncol,:,    95) = rxt_rates(:ncol,:,    95)*sol(:ncol,:,    20)*sol(:ncol,:,     7)                            ! rate_const*CH2O*NO3
      rxt_rates(:ncol,:,    96) = rxt_rates(:ncol,:,    96)*sol(:ncol,:,    20)*sol(:ncol,:,    12)                            ! rate_const*CH2O*OH
      rxt_rates(:ncol,:,    97) = rxt_rates(:ncol,:,    97)*sol(:ncol,:,    20)*sol(:ncol,:,     2)                            ! rate_const*CH2O*O
      rxt_rates(:ncol,:,    98) = rxt_rates(:ncol,:,    98)*sol(:ncol,:,    20)*sol(:ncol,:,    13)                            ! rate_const*CH2O*HO2
      rxt_rates(:ncol,:,    99) = rxt_rates(:ncol,:,    99)*sol(:ncol,:,    18)*sol(:ncol,:,     5)                            ! rate_const*CH3O2*NO
      rxt_rates(:ncol,:,   100) = rxt_rates(:ncol,:,   100)*sol(:ncol,:,    18)*sol(:ncol,:,    13)                            ! rate_const*CH3O2*HO2
      rxt_rates(:ncol,:,   101) = rxt_rates(:ncol,:,   101)*sol(:ncol,:,    18)*sol(:ncol,:,    18)                            ! rate_const*CH3O2*CH3O2
      rxt_rates(:ncol,:,   102) = rxt_rates(:ncol,:,   102)*sol(:ncol,:,    18)*sol(:ncol,:,    18)                            ! rate_const*CH3O2*CH3O2
      rxt_rates(:ncol,:,   103) = rxt_rates(:ncol,:,   103)*sol(:ncol,:,    21)*sol(:ncol,:,    12)                            ! rate_const*CH3OH*OH
      rxt_rates(:ncol,:,   104) = rxt_rates(:ncol,:,   104)*sol(:ncol,:,    19)*sol(:ncol,:,    12)                            ! rate_const*CH3OOH*OH
      rxt_rates(:ncol,:,   105) = rxt_rates(:ncol,:,   105)*sol(:ncol,:,   119)*sol(:ncol,:,    12)                            ! rate_const*HCOOH*OH
      rxt_rates(:ncol,:,   106) = rxt_rates(:ncol,:,   106)*sol(:ncol,:,   120)                                                ! rate_const*HOCH2OO
      rxt_rates(:ncol,:,   107) = rxt_rates(:ncol,:,   107)*sol(:ncol,:,   120)*sol(:ncol,:,     5)                            ! rate_const*HOCH2OO*NO
      rxt_rates(:ncol,:,   108) = rxt_rates(:ncol,:,   108)*sol(:ncol,:,   120)*sol(:ncol,:,    13)                            ! rate_const*HOCH2OO*HO2
      rxt_rates(:ncol,:,   109) = rxt_rates(:ncol,:,   109)*sol(:ncol,:,   118)*sol(:ncol,:,    12)                            ! rate_const*M*C2H2*OH
      rxt_rates(:ncol,:,   110) = rxt_rates(:ncol,:,   110)*sol(:ncol,:,    29)*sol(:ncol,:,    12)                            ! rate_const*C2H6*OH
      rxt_rates(:ncol,:,   111) = rxt_rates(:ncol,:,   111)*sol(:ncol,:,    23)*sol(:ncol,:,    12)                            ! rate_const*M*C2H4*OH
      rxt_rates(:ncol,:,   112) = rxt_rates(:ncol,:,   112)*sol(:ncol,:,    25)*sol(:ncol,:,     5)                            ! rate_const*EO2*NO
      rxt_rates(:ncol,:,   113) = rxt_rates(:ncol,:,   113)*sol(:ncol,:,    25)*sol(:ncol,:,    13)                            ! rate_const*EO2*HO2
      rxt_rates(:ncol,:,   114) = rxt_rates(:ncol,:,   114)*sol(:ncol,:,    24)                                                ! rate_const*O2*EO
      rxt_rates(:ncol,:,   115) = rxt_rates(:ncol,:,   115)*sol(:ncol,:,    24)                                                ! rate_const*EO
      rxt_rates(:ncol,:,   116) = rxt_rates(:ncol,:,   116)*sol(:ncol,:,    23)*sol(:ncol,:,     1)                            ! rate_const*C2H4*O3
      rxt_rates(:ncol,:,   117) = rxt_rates(:ncol,:,   117)*sol(:ncol,:,    26)*sol(:ncol,:,    12)                            ! rate_const*CH3COOH*OH
      rxt_rates(:ncol,:,   118) = rxt_rates(:ncol,:,   118)*sol(:ncol,:,    30)*sol(:ncol,:,     5)                            ! rate_const*C2H5O2*NO
      rxt_rates(:ncol,:,   119) = rxt_rates(:ncol,:,   119)*sol(:ncol,:,    30)*sol(:ncol,:,    13)                            ! rate_const*C2H5O2*HO2
      rxt_rates(:ncol,:,   120) = rxt_rates(:ncol,:,   120)*sol(:ncol,:,    30)*sol(:ncol,:,    18)                            ! rate_const*C2H5O2*CH3O2
      rxt_rates(:ncol,:,   121) = rxt_rates(:ncol,:,   121)*sol(:ncol,:,    30)*sol(:ncol,:,    30)                            ! rate_const*C2H5O2*C2H5O2
      rxt_rates(:ncol,:,   122) = rxt_rates(:ncol,:,   122)*sol(:ncol,:,    31)*sol(:ncol,:,    12)                            ! rate_const*C2H5OOH*OH
      rxt_rates(:ncol,:,   123) = rxt_rates(:ncol,:,   123)*sol(:ncol,:,    32)*sol(:ncol,:,    12)                            ! rate_const*CH3CHO*OH
      rxt_rates(:ncol,:,   124) = rxt_rates(:ncol,:,   124)*sol(:ncol,:,    32)*sol(:ncol,:,     7)                            ! rate_const*CH3CHO*NO3
      rxt_rates(:ncol,:,   125) = rxt_rates(:ncol,:,   125)*sol(:ncol,:,    33)*sol(:ncol,:,     5)                            ! rate_const*CH3CO3*NO
      rxt_rates(:ncol,:,   126) = rxt_rates(:ncol,:,   126)*sol(:ncol,:,    33)*sol(:ncol,:,     6)                            ! rate_const*M*CH3CO3*NO2
      rxt_rates(:ncol,:,   127) = rxt_rates(:ncol,:,   127)*sol(:ncol,:,    33)*sol(:ncol,:,    13)                            ! rate_const*CH3CO3*HO2
      rxt_rates(:ncol,:,   128) = rxt_rates(:ncol,:,   128)*sol(:ncol,:,    33)*sol(:ncol,:,    18)                            ! rate_const*CH3CO3*CH3O2
      rxt_rates(:ncol,:,   129) = rxt_rates(:ncol,:,   129)*sol(:ncol,:,    33)*sol(:ncol,:,    33)                            ! rate_const*CH3CO3*CH3CO3
      rxt_rates(:ncol,:,   130) = rxt_rates(:ncol,:,   130)*sol(:ncol,:,    34)*sol(:ncol,:,    12)                            ! rate_const*CH3COOOH*OH
      rxt_rates(:ncol,:,   131) = rxt_rates(:ncol,:,   131)*sol(:ncol,:,    27)*sol(:ncol,:,    12)                            ! rate_const*GLYALD*OH
      rxt_rates(:ncol,:,   132) = rxt_rates(:ncol,:,   132)*sol(:ncol,:,    80)*sol(:ncol,:,    12)                            ! rate_const*GLYOXAL*OH
      rxt_rates(:ncol,:,   133) = rxt_rates(:ncol,:,   133)*sol(:ncol,:,    22)*sol(:ncol,:,    12)                            ! rate_const*C2H5OH*OH
      rxt_rates(:ncol,:,   134) = rxt_rates(:ncol,:,   134)*sol(:ncol,:,    81)                                                ! rate_const*M*PAN
      rxt_rates(:ncol,:,   135) = rxt_rates(:ncol,:,   135)*sol(:ncol,:,    81)*sol(:ncol,:,    12)                            ! rate_const*PAN*OH
      rxt_rates(:ncol,:,   136) = rxt_rates(:ncol,:,   136)*sol(:ncol,:,    35)*sol(:ncol,:,    12)                            ! rate_const*M*C3H6*OH
      rxt_rates(:ncol,:,   137) = rxt_rates(:ncol,:,   137)*sol(:ncol,:,    35)*sol(:ncol,:,     1)                            ! rate_const*C3H6*O3
      rxt_rates(:ncol,:,   138) = rxt_rates(:ncol,:,   138)*sol(:ncol,:,    35)*sol(:ncol,:,     7)                            ! rate_const*C3H6*NO3
      rxt_rates(:ncol,:,   139) = rxt_rates(:ncol,:,   139)*sol(:ncol,:,    37)*sol(:ncol,:,     5)                            ! rate_const*C3H7O2*NO
      rxt_rates(:ncol,:,   140) = rxt_rates(:ncol,:,   140)*sol(:ncol,:,    37)*sol(:ncol,:,    13)                            ! rate_const*C3H7O2*HO2
      rxt_rates(:ncol,:,   141) = rxt_rates(:ncol,:,   141)*sol(:ncol,:,    37)*sol(:ncol,:,    18)                            ! rate_const*C3H7O2*CH3O2
      rxt_rates(:ncol,:,   142) = rxt_rates(:ncol,:,   142)*sol(:ncol,:,    38)*sol(:ncol,:,    12)                            ! rate_const*C3H7OOH*OH
      rxt_rates(:ncol,:,   143) = rxt_rates(:ncol,:,   143)*sol(:ncol,:,    36)*sol(:ncol,:,    12)                            ! rate_const*C3H8*OH
      rxt_rates(:ncol,:,   144) = rxt_rates(:ncol,:,   144)*sol(:ncol,:,    39)*sol(:ncol,:,     5)                            ! rate_const*PO2*NO
      rxt_rates(:ncol,:,   145) = rxt_rates(:ncol,:,   145)*sol(:ncol,:,    39)*sol(:ncol,:,    13)                            ! rate_const*PO2*HO2
      rxt_rates(:ncol,:,   146) = rxt_rates(:ncol,:,   146)*sol(:ncol,:,    40)*sol(:ncol,:,    12)                            ! rate_const*POOH*OH
      rxt_rates(:ncol,:,   147) = rxt_rates(:ncol,:,   147)*sol(:ncol,:,    41)*sol(:ncol,:,    12)                            ! rate_const*CH3COCH3*OH
      rxt_rates(:ncol,:,   148) = rxt_rates(:ncol,:,   148)*sol(:ncol,:,    42)*sol(:ncol,:,     5)                            ! rate_const*RO2*NO
      rxt_rates(:ncol,:,   149) = rxt_rates(:ncol,:,   149)*sol(:ncol,:,    42)*sol(:ncol,:,    13)                            ! rate_const*RO2*HO2
      rxt_rates(:ncol,:,   150) = rxt_rates(:ncol,:,   150)*sol(:ncol,:,    42)*sol(:ncol,:,    18)                            ! rate_const*RO2*CH3O2
      rxt_rates(:ncol,:,   151) = rxt_rates(:ncol,:,   151)*sol(:ncol,:,    43)*sol(:ncol,:,    12)                            ! rate_const*ROOH*OH
      rxt_rates(:ncol,:,   152) = rxt_rates(:ncol,:,   152)*sol(:ncol,:,    61)*sol(:ncol,:,    12)                            ! rate_const*HYAC*OH
      rxt_rates(:ncol,:,   153) = rxt_rates(:ncol,:,   153)*sol(:ncol,:,    62)*sol(:ncol,:,    12)                            ! rate_const*CH3COCHO*OH
      rxt_rates(:ncol,:,   154) = rxt_rates(:ncol,:,   154)*sol(:ncol,:,    62)*sol(:ncol,:,     7)                            ! rate_const*CH3COCHO*NO3
      rxt_rates(:ncol,:,   155) = rxt_rates(:ncol,:,   155)*sol(:ncol,:,    82)*sol(:ncol,:,    12)                            ! rate_const*ONIT*OH
      rxt_rates(:ncol,:,   156) = rxt_rates(:ncol,:,   156)*sol(:ncol,:,    44)*sol(:ncol,:,    12)                            ! rate_const*BIGENE*OH
      rxt_rates(:ncol,:,   157) = rxt_rates(:ncol,:,   157)*sol(:ncol,:,    45)*sol(:ncol,:,     5)                            ! rate_const*ENEO2*NO
      rxt_rates(:ncol,:,   158) = rxt_rates(:ncol,:,   158)*sol(:ncol,:,    55)*sol(:ncol,:,    12)                            ! rate_const*MVK*OH
      rxt_rates(:ncol,:,   159) = rxt_rates(:ncol,:,   159)*sol(:ncol,:,    55)*sol(:ncol,:,     1)                            ! rate_const*MVK*O3
      rxt_rates(:ncol,:,   160) = rxt_rates(:ncol,:,   160)*sol(:ncol,:,    46)*sol(:ncol,:,    12)                            ! rate_const*MEK*OH
      rxt_rates(:ncol,:,   161) = rxt_rates(:ncol,:,   161)*sol(:ncol,:,    47)*sol(:ncol,:,     5)                            ! rate_const*MEKO2*NO
      rxt_rates(:ncol,:,   162) = rxt_rates(:ncol,:,   162)*sol(:ncol,:,    47)*sol(:ncol,:,    13)                            ! rate_const*MEKO2*HO2
      rxt_rates(:ncol,:,   163) = rxt_rates(:ncol,:,   163)*sol(:ncol,:,    48)*sol(:ncol,:,    12)                            ! rate_const*MEKOOH*OH
      rxt_rates(:ncol,:,   164) = rxt_rates(:ncol,:,   164)*sol(:ncol,:,    56)*sol(:ncol,:,    12)                            ! rate_const*MACR*OH
      rxt_rates(:ncol,:,   165) = rxt_rates(:ncol,:,   165)*sol(:ncol,:,    56)*sol(:ncol,:,     1)                            ! rate_const*MACR*O3
      rxt_rates(:ncol,:,   166) = rxt_rates(:ncol,:,   166)*sol(:ncol,:,    57)*sol(:ncol,:,     5)                            ! rate_const*MACRO2*NO
      rxt_rates(:ncol,:,   167) = rxt_rates(:ncol,:,   167)*sol(:ncol,:,    57)*sol(:ncol,:,     5)                            ! rate_const*MACRO2*NO
      rxt_rates(:ncol,:,   168) = rxt_rates(:ncol,:,   168)*sol(:ncol,:,    57)*sol(:ncol,:,     7)                            ! rate_const*MACRO2*NO3
      rxt_rates(:ncol,:,   169) = rxt_rates(:ncol,:,   169)*sol(:ncol,:,    57)*sol(:ncol,:,    13)                            ! rate_const*MACRO2*HO2
      rxt_rates(:ncol,:,   170) = rxt_rates(:ncol,:,   170)*sol(:ncol,:,    57)*sol(:ncol,:,    18)                            ! rate_const*MACRO2*CH3O2
      rxt_rates(:ncol,:,   171) = rxt_rates(:ncol,:,   171)*sol(:ncol,:,    57)*sol(:ncol,:,    33)                            ! rate_const*MACRO2*CH3CO3
      rxt_rates(:ncol,:,   172) = rxt_rates(:ncol,:,   172)*sol(:ncol,:,    58)*sol(:ncol,:,    12)                            ! rate_const*MACROOH*OH
      rxt_rates(:ncol,:,   173) = rxt_rates(:ncol,:,   173)*sol(:ncol,:,    59)*sol(:ncol,:,     5)                            ! rate_const*MCO3*NO
      rxt_rates(:ncol,:,   174) = rxt_rates(:ncol,:,   174)*sol(:ncol,:,    59)*sol(:ncol,:,     7)                            ! rate_const*MCO3*NO3
      rxt_rates(:ncol,:,   175) = rxt_rates(:ncol,:,   175)*sol(:ncol,:,    59)*sol(:ncol,:,    13)                            ! rate_const*MCO3*HO2
      rxt_rates(:ncol,:,   176) = rxt_rates(:ncol,:,   176)*sol(:ncol,:,    59)*sol(:ncol,:,    18)                            ! rate_const*MCO3*CH3O2
      rxt_rates(:ncol,:,   177) = rxt_rates(:ncol,:,   177)*sol(:ncol,:,    59)*sol(:ncol,:,    33)                            ! rate_const*MCO3*CH3CO3
      rxt_rates(:ncol,:,   178) = rxt_rates(:ncol,:,   178)*sol(:ncol,:,    59)*sol(:ncol,:,    59)                            ! rate_const*MCO3*MCO3
      rxt_rates(:ncol,:,   179) = rxt_rates(:ncol,:,   179)*sol(:ncol,:,    59)*sol(:ncol,:,     6)                            ! rate_const*M*MCO3*NO2
      rxt_rates(:ncol,:,   180) = rxt_rates(:ncol,:,   180)*sol(:ncol,:,    83)                                                ! rate_const*M*MPAN
      rxt_rates(:ncol,:,   181) = rxt_rates(:ncol,:,   181)*sol(:ncol,:,    83)*sol(:ncol,:,    12)                            ! rate_const*M*MPAN*OH
      rxt_rates(:ncol,:,   182) = rxt_rates(:ncol,:,   182)*sol(:ncol,:,    52)*sol(:ncol,:,    12)                            ! rate_const*ISOP*OH
      rxt_rates(:ncol,:,   183) = rxt_rates(:ncol,:,   183)*sol(:ncol,:,    52)*sol(:ncol,:,     1)                            ! rate_const*ISOP*O3
      rxt_rates(:ncol,:,   184) = rxt_rates(:ncol,:,   184)*sol(:ncol,:,    52)*sol(:ncol,:,     7)                            ! rate_const*ISOP*NO3
      rxt_rates(:ncol,:,   185) = rxt_rates(:ncol,:,   185)*sol(:ncol,:,    53)*sol(:ncol,:,     5)                            ! rate_const*ISOPO2*NO
      rxt_rates(:ncol,:,   186) = rxt_rates(:ncol,:,   186)*sol(:ncol,:,    53)*sol(:ncol,:,     7)                            ! rate_const*ISOPO2*NO3
      rxt_rates(:ncol,:,   187) = rxt_rates(:ncol,:,   187)*sol(:ncol,:,    53)*sol(:ncol,:,    13)                            ! rate_const*ISOPO2*HO2
      rxt_rates(:ncol,:,   188) = rxt_rates(:ncol,:,   188)*sol(:ncol,:,    54)*sol(:ncol,:,    12)                            ! rate_const*ISOPOOH*OH
      rxt_rates(:ncol,:,   189) = rxt_rates(:ncol,:,   189)*sol(:ncol,:,    53)*sol(:ncol,:,    18)                            ! rate_const*ISOPO2*CH3O2
      rxt_rates(:ncol,:,   190) = rxt_rates(:ncol,:,   190)*sol(:ncol,:,    53)*sol(:ncol,:,    33)                            ! rate_const*ISOPO2*CH3CO3
      rxt_rates(:ncol,:,   191) = rxt_rates(:ncol,:,   191)*sol(:ncol,:,    84)*sol(:ncol,:,     5)                            ! rate_const*ISOPNO3*NO
      rxt_rates(:ncol,:,   192) = rxt_rates(:ncol,:,   192)*sol(:ncol,:,    84)*sol(:ncol,:,     7)                            ! rate_const*ISOPNO3*NO3
      rxt_rates(:ncol,:,   193) = rxt_rates(:ncol,:,   193)*sol(:ncol,:,    84)*sol(:ncol,:,    13)                            ! rate_const*ISOPNO3*HO2
      rxt_rates(:ncol,:,   194) = rxt_rates(:ncol,:,   194)*sol(:ncol,:,    49)*sol(:ncol,:,    12)                            ! rate_const*BIGALK*OH
      rxt_rates(:ncol,:,   195) = rxt_rates(:ncol,:,   195)*sol(:ncol,:,    85)*sol(:ncol,:,    12)                            ! rate_const*ONITR*OH
      rxt_rates(:ncol,:,   196) = rxt_rates(:ncol,:,   196)*sol(:ncol,:,    85)*sol(:ncol,:,     7)                            ! rate_const*ONITR*NO3
      rxt_rates(:ncol,:,   197) = rxt_rates(:ncol,:,   197)*sol(:ncol,:,    60)*sol(:ncol,:,    12)                            ! rate_const*HYDRALD*OH
      rxt_rates(:ncol,:,   198) = rxt_rates(:ncol,:,   198)*sol(:ncol,:,    50)*sol(:ncol,:,     5)                            ! rate_const*ALKO2*NO
      rxt_rates(:ncol,:,   199) = rxt_rates(:ncol,:,   199)*sol(:ncol,:,    50)*sol(:ncol,:,    13)                            ! rate_const*ALKO2*HO2
      rxt_rates(:ncol,:,   200) = rxt_rates(:ncol,:,   200)*sol(:ncol,:,    51)*sol(:ncol,:,    12)                            ! rate_const*ALKOOH*OH
      rxt_rates(:ncol,:,   201) = rxt_rates(:ncol,:,   201)*sol(:ncol,:,    63)*sol(:ncol,:,     5)                            ! rate_const*XO2*NO
      rxt_rates(:ncol,:,   202) = rxt_rates(:ncol,:,   202)*sol(:ncol,:,    63)*sol(:ncol,:,     7)                            ! rate_const*XO2*NO3
      rxt_rates(:ncol,:,   203) = rxt_rates(:ncol,:,   203)*sol(:ncol,:,    63)*sol(:ncol,:,    13)                            ! rate_const*XO2*HO2
      rxt_rates(:ncol,:,   204) = rxt_rates(:ncol,:,   204)*sol(:ncol,:,    63)*sol(:ncol,:,    18)                            ! rate_const*XO2*CH3O2
      rxt_rates(:ncol,:,   205) = rxt_rates(:ncol,:,   205)*sol(:ncol,:,    63)*sol(:ncol,:,    33)                            ! rate_const*XO2*CH3CO3
      rxt_rates(:ncol,:,   206) = rxt_rates(:ncol,:,   206)*sol(:ncol,:,    64)*sol(:ncol,:,    12)                            ! rate_const*XOOH*OH
      rxt_rates(:ncol,:,   207) = rxt_rates(:ncol,:,   207)*sol(:ncol,:,    64)*sol(:ncol,:,    12)                            ! rate_const*XOOH*OH
      rxt_rates(:ncol,:,   208) = rxt_rates(:ncol,:,   208)*sol(:ncol,:,    68)*sol(:ncol,:,    12)                            ! rate_const*TOLUENE*OH
      rxt_rates(:ncol,:,   209) = rxt_rates(:ncol,:,   209)*sol(:ncol,:,    70)*sol(:ncol,:,     5)                            ! rate_const*TOLO2*NO
      rxt_rates(:ncol,:,   210) = rxt_rates(:ncol,:,   210)*sol(:ncol,:,    70)*sol(:ncol,:,    13)                            ! rate_const*TOLO2*HO2
      rxt_rates(:ncol,:,   211) = rxt_rates(:ncol,:,   211)*sol(:ncol,:,    71)*sol(:ncol,:,    12)                            ! rate_const*TOLOOH*OH
      rxt_rates(:ncol,:,   212) = rxt_rates(:ncol,:,   212)*sol(:ncol,:,    69)*sol(:ncol,:,    12)                            ! rate_const*CRESOL*OH
      rxt_rates(:ncol,:,   213) = rxt_rates(:ncol,:,   213)*sol(:ncol,:,    78)*sol(:ncol,:,     6)                            ! rate_const*XOH*NO2
      rxt_rates(:ncol,:,   214) = rxt_rates(:ncol,:,   214)*sol(:ncol,:,    72)*sol(:ncol,:,    12)                            ! rate_const*BENZENE*OH
      rxt_rates(:ncol,:,   215) = rxt_rates(:ncol,:,   215)*sol(:ncol,:,    73)*sol(:ncol,:,    13)                            ! rate_const*BENO2*HO2
      rxt_rates(:ncol,:,   216) = rxt_rates(:ncol,:,   216)*sol(:ncol,:,    73)*sol(:ncol,:,     5)                            ! rate_const*BENO2*NO
      rxt_rates(:ncol,:,   217) = rxt_rates(:ncol,:,   217)*sol(:ncol,:,    75)*sol(:ncol,:,    12)                            ! rate_const*XYLENE*OH
      rxt_rates(:ncol,:,   218) = rxt_rates(:ncol,:,   218)*sol(:ncol,:,    76)*sol(:ncol,:,    13)                            ! rate_const*XYLO2*HO2
      rxt_rates(:ncol,:,   219) = rxt_rates(:ncol,:,   219)*sol(:ncol,:,    76)*sol(:ncol,:,     5)                            ! rate_const*XYLO2*NO
      rxt_rates(:ncol,:,   220) = rxt_rates(:ncol,:,   220)*sol(:ncol,:,    65)*sol(:ncol,:,    12)                            ! rate_const*C10H16*OH
      rxt_rates(:ncol,:,   221) = rxt_rates(:ncol,:,   221)*sol(:ncol,:,    65)*sol(:ncol,:,     1)                            ! rate_const*C10H16*O3
      rxt_rates(:ncol,:,   222) = rxt_rates(:ncol,:,   222)*sol(:ncol,:,    65)*sol(:ncol,:,     7)                            ! rate_const*C10H16*NO3
      rxt_rates(:ncol,:,   223) = rxt_rates(:ncol,:,   223)*sol(:ncol,:,    66)*sol(:ncol,:,     5)                            ! rate_const*TERPO2*NO
      rxt_rates(:ncol,:,   224) = rxt_rates(:ncol,:,   224)*sol(:ncol,:,    66)*sol(:ncol,:,    13)                            ! rate_const*TERPO2*HO2
      rxt_rates(:ncol,:,   225) = rxt_rates(:ncol,:,   225)*sol(:ncol,:,    67)*sol(:ncol,:,    12)                            ! rate_const*TERPOOH*OH
      rxt_rates(:ncol,:,   226) = rxt_rates(:ncol,:,   226)*sol(:ncol,:,   114)                                                ! rate_const*Rn
      rxt_rates(:ncol,:,   227) = rxt_rates(:ncol,:,   227)*sol(:ncol,:,    10)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   228) = rxt_rates(:ncol,:,   228)*sol(:ncol,:,     7)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,   229) = rxt_rates(:ncol,:,   229)*sol(:ncol,:,     6)                                                ! rate_const*NO2
      rxt_rates(:ncol,:,   230) = rxt_rates(:ncol,:,   230)*sol(:ncol,:,    86)                                                ! rate_const*CB1
      rxt_rates(:ncol,:,   231) = rxt_rates(:ncol,:,   231)*sol(:ncol,:,   100)*sol(:ncol,:,    12)                            ! rate_const*SO2*OH
      rxt_rates(:ncol,:,   232) = rxt_rates(:ncol,:,   232)*sol(:ncol,:,   101)*sol(:ncol,:,    12)                            ! rate_const*DMS*OH
      rxt_rates(:ncol,:,   233) = rxt_rates(:ncol,:,   233)*sol(:ncol,:,   101)*sol(:ncol,:,    12)                            ! rate_const*DMS*OH
      rxt_rates(:ncol,:,   234) = rxt_rates(:ncol,:,   234)*sol(:ncol,:,   101)*sol(:ncol,:,     7)                            ! rate_const*DMS*NO3
      rxt_rates(:ncol,:,   235) = rxt_rates(:ncol,:,   235)*sol(:ncol,:,   103)*sol(:ncol,:,    12)                            ! rate_const*NH3*OH
      rxt_rates(:ncol,:,   236) = rxt_rates(:ncol,:,   236)*sol(:ncol,:,    88)                                                ! rate_const*OC1
      rxt_rates(:ncol,:,   237) = rxt_rates(:ncol,:,   237)*sol(:ncol,:,    13)                                                ! rate_const*HO2
  end subroutine set_rates
end module mo_rxt_rates_conv
