!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!                                                             
!   nan_mod.F90 - part of the Glimmer Community Ice Sheet Model (Glimmer-CISM)  
!                                                              
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!   Copyright (C) 2005-2013
!   Glimmer-CISM contributors - see AUTHORS file for list of contributors
!
!   This file is part of Glimmer-CISM.
!
!   Glimmer-CISM is free software: you can redistribute it and/or modify it
!   under the terms of the Lesser GNU General Public License as published
!   by the Free Software Foundation, either version 3 of the License, or
!   (at your option) any later version.
!
!   Glimmer-CISM is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   Lesser GNU General Public License for more details.
!
!   You should have received a copy of the Lesser GNU General Public License
!   along with Glimmer-CISM. If not, see <http://www.gnu.org/licenses/>.
!
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

module nan_mod

! Set parameter for the floating point flag "nan" not-a-number
!
! Based on the similar module in CESM's CLM & CAM
!
  use glimmer_global, only : dp

  implicit none
  save

#ifdef __PGI
! quiet nan for portland group compilers
  real(dp), parameter :: NaN = O'0777700000000000000000'
#else
! signaling nan otherwise
  !real(dp), parameter :: NaN = O'0777610000000000000000'
  integer(dp), parameter :: NaN = O'0777610000000000000000' !BSINGH - NAG need it to be an integer
#endif

end module nan_mod
