find_file(CPRNC_BINARY
          NAMES cprnc
          PATHS ${CPRNC_DIR} ${Homme_CPRNC_DIR}
          NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH)

IF(${CPRNC_BINARY} STREQUAL "CPRNC_BINARY-NOTFOUND")
  SET (CPRNC_FOUND FALSE) 
  MESSAGE(FATAL_ERROR "Did not find cprnc required for testing")
ELSE ()
  SET (CPRNC_FOUND TRUE) 
  MESSAGE(STATUS "Found cprnc at ${CPRNC_BINARY}")
ENDIF ()

find_path(NETCDF_RESULTS_DIR
          NAMES baroclinic1.nc
          PATHS ${HOMME_NC_RESULTS_DIR} ${Homme_NC_RESULTS_DIR}
          PATH_SUFFIXES baro1a
          NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH)


IF(${NETCDF_RESULTS_DIR} STREQUAL NETCDF_RESULTS_DIR-NOTFOUND)
  SET (NETCDF_RESULTS_FOUND FALSE) 
  MESSAGE(FATAL_ERROR "Did not find the Netcdf result directory, cannot use cprnc to diff results. Please set HOMME_NC_RESULTS_DIR")
ELSE ()
  SET (NETCDF_RESULTS_FOUND TRUE) 
  GET_FILENAME_COMPONENT(NETCDF_RESULTS_DIR "${NETCDF_RESULTS_DIR}/.." ABSOLUTE)
  MESSAGE(STATUS "Found Netcdf results at ${NETCDF_RESULTS_DIR}")
ENDIF ()

