#!/bin/bash

# CMake sets this variable
HOMME_DIR=@Homme_Build_DIR@

# Source the following file to get the rest of the cmake variables
source ${HOMME_DIR}/tests/cmake_variables.sh

# A list (generated by CMake) of all of the tests
source ${HOMME_TESTING_DIR}/test_list.sh

# Functions used to generate the run scripts 
source ${HOMME_TESTING_DIR}/testing-utils.sh

# Determine if we are creating the baseline
if [ "$1" == baseline ] ; then
  CREATE_BASELINE=true
  # The location of all of the submission scripts generated here
  subListFile=${HOMME_DEFAULT_BASELINE_DIR}/submission-list.sh
else
  CREATE_BASELINE=false
  # The location of all of the submission scripts generated here
  subListFile=${HOMME_TESTING_DIR}/submission-list.sh
fi

if [ "$1" == all -o "${CREATE_BASELINE}" == true ] ; then

  createAllRunScripts

else

  THIS_TEST_FILE=$1

  createRunScript

fi

exit 0
